/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSFontManager;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.NSValue;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;

public abstract class Device
implements Drawable {
    public static boolean DEBUG;
    boolean debug = DEBUG;
    boolean tracking = DEBUG;
    Error[] errors;
    Object[] objects;
    Object trackingLock;
    boolean disposed;
    boolean warnings;
    Color COLOR_BLACK;
    Color COLOR_DARK_RED;
    Color COLOR_DARK_GREEN;
    Color COLOR_DARK_YELLOW;
    Color COLOR_DARK_BLUE;
    Color COLOR_DARK_MAGENTA;
    Color COLOR_DARK_CYAN;
    Color COLOR_GRAY;
    Color COLOR_DARK_GRAY;
    Color COLOR_RED;
    Color COLOR_GREEN;
    Color COLOR_YELLOW;
    Color COLOR_BLUE;
    Color COLOR_MAGENTA;
    Color COLOR_CYAN;
    Color COLOR_WHITE;
    Font systemFont;
    NSMutableParagraphStyle paragraphStyle;
    Point dpi;
    protected static Device CurrentDevice;
    protected static Runnable DeviceFinder;

    static synchronized Device getDevice() {
        if (DeviceFinder != null) {
            DeviceFinder.run();
        }
        Device device = CurrentDevice;
        CurrentDevice = null;
        return device;
    }

    public Device() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device(DeviceData deviceData) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (deviceData != null) {
                this.debug = deviceData.debug;
                this.tracking = deviceData.tracking;
            }
            if (this.tracking) {
                this.errors = new Error[128];
                this.objects = new Object[128];
                this.trackingLock = new Object();
            }
            if (NSThread.isMainThread()) {
                NSString nSString;
                NSAutoreleasePool nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                NSThread nSThread = NSThread.currentThread();
                NSMutableDictionary nSMutableDictionary = nSThread.threadDictionary();
                id id2 = nSMutableDictionary.objectForKey(nSString = NSString.stringWith("SWT_NSAutoreleasePool"));
                if (id2 == null) {
                    NSNumber nSNumber = NSNumber.numberWithInteger(nSAutoreleasePool.id);
                    nSMutableDictionary.setObject(nSNumber, nSString);
                } else {
                    nSAutoreleasePool.release();
                }
            }
            this.create(deviceData);
            this.init();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void checkDevice() {
        if (this.disposed) {
            SWT.error(45);
        }
    }

    protected void create(DeviceData deviceData) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.checkDevice();
            this.release();
            this.destroy();
            this.disposed = true;
            if (this.tracking) {
                Object object = this.trackingLock;
                synchronized (object) {
                    this.printErrors();
                    this.objects = null;
                    this.errors = null;
                    this.trackingLock = null;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            for (int i = 0; i < this.objects.length; ++i) {
                if (this.objects[i] != object) continue;
                this.objects[i] = null;
                this.errors[i] = null;
                return;
            }
        }
    }

    protected void destroy() {
    }

    public Rectangle getBounds() {
        this.checkDevice();
        NSScreen nSScreen = this.getPrimaryScreen();
        NSRect nSRect = nSScreen.frame();
        double d = nSScreen.userSpaceScaleFactor();
        nSRect.x /= d;
        nSRect.y /= d;
        nSRect.width /= d;
        nSRect.height /= d;
        return new Rectangle((int)nSRect.x, (int)nSRect.y, (int)nSRect.width, (int)nSRect.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceData getDeviceData() {
        this.checkDevice();
        DeviceData deviceData = new DeviceData();
        deviceData.debug = this.debug;
        deviceData.tracking = this.tracking;
        if (this.tracking) {
            Object object = this.trackingLock;
            synchronized (object) {
                int n;
                int n2 = 0;
                int n3 = this.objects.length;
                for (n = 0; n < n3; ++n) {
                    if (this.objects[n] == null) continue;
                    ++n2;
                }
                n = 0;
                deviceData.objects = new Object[n2];
                deviceData.errors = new Error[n2];
                for (int i = 0; i < n3; ++i) {
                    if (this.objects[i] == null) continue;
                    deviceData.objects[n] = this.objects[i];
                    deviceData.errors[n] = this.errors[i];
                    ++n;
                }
            }
        } else {
            deviceData.objects = new Object[0];
            deviceData.errors = new Error[0];
        }
        return deviceData;
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        return this.getBounds();
    }

    public int getDepth() {
        this.checkDevice();
        return (int)OS.NSBitsPerPixelFromDepth(this.getPrimaryScreen().depth());
    }

    public Point getDPI() {
        this.checkDevice();
        return this.getScreenDPI();
    }

    NSScreen getPrimaryScreen() {
        NSArray nSArray = NSScreen.screens();
        return new NSScreen(nSArray.objectAtIndex(0L));
    }

    public FontData[] getFontList(String string, boolean bl) {
        this.checkDevice();
        if (!bl) {
            return new FontData[0];
        }
        String string2 = this.systemFont.getFontData()[0].getName();
        boolean bl2 = false;
        int n = 0;
        NSArray nSArray = NSFontManager.sharedFontManager().availableFontFamilies();
        FontData[] fontDataArray = new FontData[100];
        if (nSArray != null) {
            long l = nSArray.count();
            int n2 = 0;
            while ((long)n2 < l) {
                NSString nSString = new NSString(nSArray.objectAtIndex(n2));
                String string3 = nSString.getString();
                NSArray nSArray2 = NSFontManager.sharedFontManager().availableMembersOfFontFamily(nSString);
                if (nSArray2 != null) {
                    int n3 = (int)nSArray2.count();
                    for (int i = 0; i < n3; ++i) {
                        NSArray nSArray3 = new NSArray(nSArray2.objectAtIndex(i));
                        String string4 = new NSString(nSArray3.objectAtIndex(0L)).getString();
                        long l2 = new NSNumber(nSArray3.objectAtIndex(2L)).integerValue();
                        long l3 = new NSNumber(nSArray3.objectAtIndex(3L)).integerValue();
                        int n4 = 0;
                        if ((l3 & 1L) != 0L) {
                            n4 |= 2;
                        }
                        if (l2 == 9L) {
                            n4 |= 1;
                        }
                        if (string != null && !Compatibility.equalsIgnoreCase(string, string3)) continue;
                        FontData fontData = new FontData(string3, 0, n4);
                        fontData.nsName = string4;
                        if (Compatibility.equalsIgnoreCase(string2, string3)) {
                            bl2 = true;
                        }
                        if (n == fontDataArray.length) {
                            FontData[] fontDataArray2 = new FontData[fontDataArray.length + 100];
                            System.arraycopy(fontDataArray, 0, fontDataArray2, 0, fontDataArray.length);
                            fontDataArray = fontDataArray2;
                        }
                        fontDataArray[n++] = fontData;
                    }
                }
                ++n2;
            }
        }
        if (!bl2 && (string == null || Compatibility.equalsIgnoreCase(string, string2))) {
            if (n == fontDataArray.length) {
                FontData[] fontDataArray3 = new FontData[fontDataArray.length + 1];
                System.arraycopy(fontDataArray, 0, fontDataArray3, 0, fontDataArray.length);
                fontDataArray = fontDataArray3;
            }
            fontDataArray[n++] = this.systemFont.getFontData()[0];
        }
        if (n == fontDataArray.length) {
            return fontDataArray;
        }
        FontData[] fontDataArray4 = new FontData[n];
        System.arraycopy(fontDataArray, 0, fontDataArray4, 0, n);
        return fontDataArray4;
    }

    Point getScreenDPI() {
        NSScreen nSScreen = this.getPrimaryScreen();
        NSDictionary nSDictionary = nSScreen.deviceDescription();
        NSValue nSValue = new NSValue(nSDictionary.objectForKey((id)new id((long)OS.NSDeviceResolution())).id);
        NSSize nSSize = nSValue.sizeValue();
        double d = 1.0;
        if (OS.VERSION >= 4208) {
            d = nSScreen.backingScaleFactor();
        }
        return new Point((int)(nSSize.width / d), (int)(nSSize.height / d));
    }

    public Color getSystemColor(int n) {
        this.checkDevice();
        switch (n) {
            case 2: {
                return this.COLOR_BLACK;
            }
            case 4: {
                return this.COLOR_DARK_RED;
            }
            case 6: {
                return this.COLOR_DARK_GREEN;
            }
            case 8: {
                return this.COLOR_DARK_YELLOW;
            }
            case 10: {
                return this.COLOR_DARK_BLUE;
            }
            case 12: {
                return this.COLOR_DARK_MAGENTA;
            }
            case 14: {
                return this.COLOR_DARK_CYAN;
            }
            case 15: {
                return this.COLOR_GRAY;
            }
            case 16: {
                return this.COLOR_DARK_GRAY;
            }
            case 3: {
                return this.COLOR_RED;
            }
            case 5: {
                return this.COLOR_GREEN;
            }
            case 7: {
                return this.COLOR_YELLOW;
            }
            case 9: {
                return this.COLOR_BLUE;
            }
            case 11: {
                return this.COLOR_MAGENTA;
            }
            case 13: {
                return this.COLOR_CYAN;
            }
            case 1: {
                return this.COLOR_WHITE;
            }
        }
        return this.COLOR_BLACK;
    }

    public Font getSystemFont() {
        this.checkDevice();
        return this.systemFont;
    }

    public boolean getWarnings() {
        this.checkDevice();
        return this.warnings;
    }

    protected void init() {
        this.COLOR_BLACK = new Color(this, 0, 0, 0);
        this.COLOR_DARK_RED = new Color(this, 128, 0, 0);
        this.COLOR_DARK_GREEN = new Color(this, 0, 128, 0);
        this.COLOR_DARK_YELLOW = new Color(this, 128, 128, 0);
        this.COLOR_DARK_BLUE = new Color(this, 0, 0, 128);
        this.COLOR_DARK_MAGENTA = new Color(this, 128, 0, 128);
        this.COLOR_DARK_CYAN = new Color(this, 0, 128, 128);
        this.COLOR_GRAY = new Color(this, 192, 192, 192);
        this.COLOR_DARK_GRAY = new Color(this, 128, 128, 128);
        this.COLOR_RED = new Color(this, 255, 0, 0);
        this.COLOR_GREEN = new Color(this, 0, 255, 0);
        this.COLOR_YELLOW = new Color(this, 255, 255, 0);
        this.COLOR_BLUE = new Color(this, 0, 0, 255);
        this.COLOR_MAGENTA = new Color(this, 255, 0, 255);
        this.COLOR_CYAN = new Color(this, 0, 255, 255);
        this.COLOR_WHITE = new Color(this, 255, 255, 255);
        this.paragraphStyle = (NSMutableParagraphStyle)new NSMutableParagraphStyle().alloc().init();
        this.paragraphStyle.setAlignment(0L);
        this.paragraphStyle.setLineBreakMode(2L);
        NSArray nSArray = new NSArray(new NSArray().alloc().init());
        this.paragraphStyle.setTabStops(nSArray);
        nSArray.release();
        boolean bl = System.getProperty("org.eclipse.swt.internal.carbon.smallFonts") != null;
        double d = bl ? NSFont.smallSystemFontSize() : NSFont.systemFontSize();
        Point point = this.dpi = this.getDPI();
        Point point2 = this.getScreenDPI();
        NSFont nSFont = NSFont.systemFontOfSize(d * (double)point.y / (double)point2.y);
        nSFont.retain();
        this.systemFont = Font.cocoa_new(this, nSFont);
    }

    public abstract long internal_new_GC(GCData var1);

    public abstract void internal_dispose_GC(long var1, GCData var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.disposed;
        }
    }

    public boolean loadFont(String string) {
        boolean[] blArray;
        byte[] byArray;
        this.checkDevice();
        if (string == null) {
            SWT.error(4);
        }
        boolean bl = false;
        NSString nSString = NSString.stringWith(string);
        long l = nSString.fileSystemRepresentation();
        if (l != 0L && OS.FSPathMakeRef(l, byArray = new byte[80], blArray = new boolean[1]) == 0) {
            bl = OS.ATSFontActivateFromFileReference(byArray, 2, 0, 0L, 0, null) == 0;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void new_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            for (int i = 0; i < this.objects.length; ++i) {
                if (this.objects[i] != null) continue;
                this.objects[i] = object;
                this.errors[i] = new Error();
                return;
            }
            Object[] objectArray = new Object[this.objects.length + 128];
            System.arraycopy(this.objects, 0, objectArray, 0, this.objects.length);
            objectArray[this.objects.length] = object;
            this.objects = objectArray;
            Error[] errorArray = new Error[this.errors.length + 128];
            System.arraycopy(this.errors, 0, errorArray, 0, this.errors.length);
            errorArray[this.errors.length] = new Error();
            this.errors = errorArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printErrors() {
        if (!DEBUG) {
            return;
        }
        if (this.tracking) {
            Object object = this.trackingLock;
            synchronized (object) {
                if (this.objects == null || this.errors == null) {
                    return;
                }
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                for (int i = 0; i < this.objects.length; ++i) {
                    Object object2 = this.objects[i];
                    if (object2 == null) continue;
                    ++n;
                    if (object2 instanceof Color) {
                        ++n2;
                    }
                    if (object2 instanceof Cursor) {
                        ++n3;
                    }
                    if (object2 instanceof Font) {
                        ++n4;
                    }
                    if (object2 instanceof GC) {
                        ++n5;
                    }
                    if (object2 instanceof Image) {
                        ++n6;
                    }
                    if (object2 instanceof Path) {
                        ++n7;
                    }
                    if (object2 instanceof Pattern) {
                        ++n8;
                    }
                    if (object2 instanceof Region) {
                        ++n9;
                    }
                    if (object2 instanceof TextLayout) {
                        ++n10;
                    }
                    if (!(object2 instanceof Transform)) continue;
                    ++n11;
                }
                if (n != 0) {
                    String string = "Summary: ";
                    if (n2 != 0) {
                        string = string + n2 + " Color(s), ";
                    }
                    if (n3 != 0) {
                        string = string + n3 + " Cursor(s), ";
                    }
                    if (n4 != 0) {
                        string = string + n4 + " Font(s), ";
                    }
                    if (n5 != 0) {
                        string = string + n5 + " GC(s), ";
                    }
                    if (n6 != 0) {
                        string = string + n6 + " Image(s), ";
                    }
                    if (n7 != 0) {
                        string = string + n7 + " Path(s), ";
                    }
                    if (n8 != 0) {
                        string = string + n8 + " Pattern(s), ";
                    }
                    if (n9 != 0) {
                        string = string + n9 + " Region(s), ";
                    }
                    if (n10 != 0) {
                        string = string + n10 + " TextLayout(s), ";
                    }
                    if (n11 != 0) {
                        string = string + n11 + " Transforms(s), ";
                    }
                    if (string.length() != 0) {
                        string = string.substring(0, string.length() - 2);
                        System.out.println(string);
                    }
                    for (int i = 0; i < this.errors.length; ++i) {
                        if (this.errors[i] == null) continue;
                        this.errors[i].printStackTrace(System.out);
                    }
                }
            }
        }
    }

    protected void release() {
        if (this.paragraphStyle != null) {
            this.paragraphStyle.release();
        }
        this.paragraphStyle = null;
        if (this.systemFont != null) {
            this.systemFont.dispose();
        }
        this.systemFont = null;
        if (this.COLOR_BLACK != null) {
            this.COLOR_BLACK.dispose();
        }
        if (this.COLOR_DARK_RED != null) {
            this.COLOR_DARK_RED.dispose();
        }
        if (this.COLOR_DARK_GREEN != null) {
            this.COLOR_DARK_GREEN.dispose();
        }
        if (this.COLOR_DARK_YELLOW != null) {
            this.COLOR_DARK_YELLOW.dispose();
        }
        if (this.COLOR_DARK_BLUE != null) {
            this.COLOR_DARK_BLUE.dispose();
        }
        if (this.COLOR_DARK_MAGENTA != null) {
            this.COLOR_DARK_MAGENTA.dispose();
        }
        if (this.COLOR_DARK_CYAN != null) {
            this.COLOR_DARK_CYAN.dispose();
        }
        if (this.COLOR_GRAY != null) {
            this.COLOR_GRAY.dispose();
        }
        if (this.COLOR_DARK_GRAY != null) {
            this.COLOR_DARK_GRAY.dispose();
        }
        if (this.COLOR_RED != null) {
            this.COLOR_RED.dispose();
        }
        if (this.COLOR_GREEN != null) {
            this.COLOR_GREEN.dispose();
        }
        if (this.COLOR_YELLOW != null) {
            this.COLOR_YELLOW.dispose();
        }
        if (this.COLOR_BLUE != null) {
            this.COLOR_BLUE.dispose();
        }
        if (this.COLOR_MAGENTA != null) {
            this.COLOR_MAGENTA.dispose();
        }
        if (this.COLOR_CYAN != null) {
            this.COLOR_CYAN.dispose();
        }
        if (this.COLOR_WHITE != null) {
            this.COLOR_WHITE.dispose();
        }
        this.COLOR_WHITE = null;
        this.COLOR_CYAN = null;
        this.COLOR_MAGENTA = null;
        this.COLOR_BLUE = null;
        this.COLOR_YELLOW = null;
        this.COLOR_GREEN = null;
        this.COLOR_RED = null;
        this.COLOR_DARK_GRAY = null;
        this.COLOR_GRAY = null;
        this.COLOR_DARK_CYAN = null;
        this.COLOR_DARK_MAGENTA = null;
        this.COLOR_DARK_BLUE = null;
        this.COLOR_DARK_YELLOW = null;
        this.COLOR_DARK_GREEN = null;
        this.COLOR_DARK_RED = null;
        this.COLOR_BLACK = null;
    }

    public void setWarnings(boolean bl) {
        this.checkDevice();
        this.warnings = bl;
    }

    static {
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

