/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.plugins.util.PluginRegistry;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.apache.logging.log4j.core.util.ClassLoaderResourceLoader;
import org.apache.logging.log4j.core.util.Closer;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.core.util.ResourceLoader;
import org.apache.logging.log4j.status.StatusLogger;

public class PluginManager {
    private static final PluginRegistry<PluginType<?>> REGISTRY = new PluginRegistry();
    private static final Logger LOGGER = StatusLogger.getLogger();
    private Map<String, PluginType<?>> plugins = new HashMap();
    private final String category;

    public PluginManager(String category) {
        this.category = category;
    }

    @Deprecated
    public static void main(String[] args) {
        System.err.println("WARNING: this tool is superseded by the annotation processor included in log4j-core.");
        System.exit(-1);
    }

    @Deprecated
    public static void addPackage(String p) {
    }

    public PluginType<?> getPluginType(String name) {
        return this.plugins.get(name.toLowerCase());
    }

    public Map<String, PluginType<?>> getPlugins() {
        return this.plugins;
    }

    public void collectPlugins() {
        this.collectPlugins(true);
    }

    public void collectPlugins(boolean preLoad) {
        if (REGISTRY.hasCategory(this.category)) {
            this.plugins = REGISTRY.getCategory(this.category);
            preLoad = false;
        }
        if (preLoad) {
            ClassLoaderResourceLoader loader = new ClassLoaderResourceLoader(Loader.getClassLoader());
            PluginManager.loadPlugins(loader);
        }
        this.plugins = REGISTRY.getCategory(this.category);
    }

    public static void loadPlugins(ResourceLoader loader) {
        PluginRegistry<PluginType<?>> registry = PluginManager.decode(loader);
        if (registry != null) {
            for (Map.Entry<String, ConcurrentMap<String, PluginType<?>>> entry : registry.getCategories()) {
                REGISTRY.getCategory(entry.getKey()).putAll((Map)entry.getValue());
            }
        } else {
            LOGGER.info("Plugin preloads not available from class loader {}", loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PluginRegistry<PluginType<?>> decode(ResourceLoader loader) {
        Enumeration<URL> resources;
        try {
            resources = loader.getResources("META-INF/org/apache/logging/log4j/core/config/plugins/Log4j2Plugins.dat");
            if (resources == null) {
                return null;
            }
        }
        catch (IOException ioe) {
            LOGGER.warn("Unable to preload plugins", (Throwable)ioe);
            return null;
        }
        PluginRegistry map = new PluginRegistry();
        while (resources.hasMoreElements()) {
            InputStream is;
            URL url = resources.nextElement();
            LOGGER.debug("Found Plugin Map at {}", url.toExternalForm());
            try {
                is = url.openStream();
            }
            catch (IOException e) {
                LOGGER.warn("Unable to open {}", url.toExternalForm(), e);
                continue;
            }
            DataInputStream dis = new DataInputStream(new BufferedInputStream(is));
            try {
                int count = dis.readInt();
                for (int j = 0; j < count; ++j) {
                    String category = dis.readUTF();
                    int entries = dis.readInt();
                    ConcurrentMap<String, PluginType<?>> types = map.getCategory(category);
                    for (int i = 0; i < entries; ++i) {
                        String key = dis.readUTF();
                        String className = dis.readUTF();
                        String name = dis.readUTF();
                        boolean printable = dis.readBoolean();
                        boolean defer = dis.readBoolean();
                        try {
                            Class<?> clazz = loader.loadClass(className);
                            PluginType pluginType = new PluginType(clazz, name, printable, defer);
                            types.put(key, pluginType);
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            LOGGER.info("Plugin [{}] could not be loaded due to missing classes.", className, e);
                        }
                    }
                }
            }
            catch (IOException ex) {
                LOGGER.warn("Unable to preload plugins", (Throwable)ex);
            }
            finally {
                Closer.closeSilently(dis);
            }
        }
        return map.isEmpty() ? null : map;
    }
}

