/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.ContentProvider;
import org.tizen.manager.core.config.ConfigFile;
import org.tizen.manager.core.model.AlternativeInformation;
import org.tizen.manager.core.model.AlternativeRoot;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.util.DownloadProgressMonitor;
import org.tizen.manager.util.Downloader;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.NetworkUtil;
import org.tizen.manager.util.PathUtil;

public class AlternativeManager {
    private static final Logger logger = Log.getLogger(AlternativeManager.class);
    private static final String LOCAL_XML_FILE_NAME = "alternative-info.xml";
    private static String LOCAL_XML_FILE_PATH;
    private ArrayList<AlternativeInformation> alternatives;
    private ContentProvider contentProvier;

    public AlternativeManager(ContentProvider contentProvier) {
        this.contentProvier = contentProvier;
        this.alternatives = new ArrayList();
    }

    public void init(boolean ignoreError) throws UMException {
        block2: {
            LOCAL_XML_FILE_PATH = PathUtil.getFromInstalledPath(this.contentProvier.getSDKInfo(), ".info", LOCAL_XML_FILE_NAME);
            this.alternatives = new ArrayList();
            try {
                this.loadAlternativeInfo(null);
            }
            catch (UMException e) {
                logger.error(e);
                if (ignoreError) break block2;
                throw e;
            }
        }
    }

    public ArrayList<AlternativeInformation> getAlternatives() {
        return this.alternatives;
    }

    private void loadAlternativeInfo(String repoURL) throws UMException {
        String repository = null;
        if (repoURL == null) {
            ConfigFile configFile = this.contentProvier.getConfig().getConfigFile();
            assert (configFile != null);
            repository = NetworkUtil.getURL(configFile.getRepository(), configFile.getDistribution());
        } else {
            repository = NetworkUtil.getURL(repoURL);
        }
        File localCache = new File(LOCAL_XML_FILE_PATH);
        assert (localCache == null);
        File temp = this.downloadXmlFromRemote(repository);
        ArrayList<Object> alterInfos = new ArrayList();
        if (temp != null) {
            PathUtil.remove(localCache);
            PathUtil.move(temp, localCache);
        }
        alterInfos = this.xmlToObject(localCache);
        for (AlternativeInformation alternativeInformation : alterInfos) {
            alternativeInformation.setRepository(NetworkUtil.normalizeURL(alternativeInformation.getRepository()));
        }
        this.alternatives.addAll(alterInfos);
    }

    private File downloadXmlFromRemote(String repoBaseURL) {
        File temp = null;
        try {
            temp = File.createTempFile("alternative-info", ".xml");
        }
        catch (IOException e) {
            logger.throwing(e);
            return null;
        }
        URL alterInfoFileUrl = this.getAlterXmlFileURL(repoBaseURL);
        if (alterInfoFileUrl == null) {
            return null;
        }
        try {
            Downloader downloader = new Downloader(this.contentProvier.getConfig(), alterInfoFileUrl);
            long size = downloader.download(temp.getAbsolutePath(), new DownloadProgressMonitor());
            if (size < 0L) {
                logger.error((Object)ErrorController.ErrorCode.CANNOT_DOWNLOAD_FILE);
                return null;
            }
        }
        catch (UMException e) {
            logger.error("[" + repoBaseURL + "] " + e.getMessage());
            return null;
        }
        return temp;
    }

    private URL getAlterXmlFileURL(String repoBaseURL) {
        String alterXmlFilePath = NetworkUtil.getURL(repoBaseURL, "alternative_info.xml");
        try {
            return new URL(alterXmlFilePath);
        }
        catch (MalformedURLException e) {
            logger.error("Cannot connect alternative information xml file in repository(" + alterXmlFilePath + ")");
            return null;
        }
    }

    private ArrayList<AlternativeInformation> xmlToObject(File xmlFile) throws UMException {
        ArrayList<AlternativeInformation> alterInfos = new ArrayList();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{AlternativeRoot.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            AlternativeRoot alterRoot = (AlternativeRoot)jaxbUnmarshaller.unmarshal(xmlFile);
            alterInfos = alterRoot.getAlternatives();
        }
        catch (JAXBException e) {
            logger.error((Object)e);
            throw new UMException(ErrorController.ErrorCode.INVALID_ALTER_INFO_XML_FILE, (Throwable)e);
        }
        return alterInfos;
    }
}

