/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.processor;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.core.config.plugins.processor.PluginEntry;
import org.apache.logging.log4j.core.config.plugins.util.PluginRegistry;

public class PluginCache {
    private final transient PluginRegistry<PluginEntry> pluginCategories = new PluginRegistry();

    public ConcurrentMap<String, PluginEntry> getCategory(String category) {
        return this.pluginCategories.getCategory(category);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCache(OutputStream os) throws IOException {
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(os));
        try {
            out.writeInt(this.pluginCategories.getCategoryCount());
            for (Map.Entry<String, ConcurrentMap<String, PluginEntry>> category : this.pluginCategories.getCategories()) {
                out.writeUTF(category.getKey());
                Map m = category.getValue();
                out.writeInt(m.size());
                for (Map.Entry entry : m.entrySet()) {
                    PluginEntry plugin = (PluginEntry)entry.getValue();
                    out.writeUTF(plugin.getKey());
                    out.writeUTF(plugin.getClassName());
                    out.writeUTF(plugin.getName());
                    out.writeBoolean(plugin.isPrintable());
                    out.writeBoolean(plugin.isDefer());
                }
            }
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCacheFiles(Enumeration<URL> resources) throws IOException {
        this.pluginCategories.clear();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            DataInputStream in = new DataInputStream(new BufferedInputStream(url.openStream()));
            try {
                int count = in.readInt();
                for (int i = 0; i < count; ++i) {
                    String category = in.readUTF();
                    ConcurrentMap<String, PluginEntry> m = this.pluginCategories.getCategory(category);
                    int entries = in.readInt();
                    for (int j = 0; j < entries; ++j) {
                        PluginEntry entry = new PluginEntry();
                        entry.setKey(in.readUTF());
                        entry.setClassName(in.readUTF());
                        entry.setName(in.readUTF());
                        entry.setPrintable(in.readBoolean());
                        entry.setDefer(in.readBoolean());
                        entry.setCategory(category);
                        m.putIfAbsent(entry.getKey(), entry);
                    }
                }
            }
            finally {
                in.close();
            }
        }
    }

    public int size() {
        return this.pluginCategories.getCategoryCount();
    }
}

