/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.ContentProvider;
import org.tizen.manager.core.ExtRepositoryManager;
import org.tizen.manager.core.config.Config;
import org.tizen.manager.core.config.PropertyParser;
import org.tizen.manager.core.model.ExtensionInformation;
import org.tizen.manager.core.model.ExtensionRoot;
import org.tizen.manager.core.model.Property;
import org.tizen.manager.core.model.PropertySection;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.pkg.Package;
import org.tizen.manager.pkg.PackageSet;
import org.tizen.manager.pkg.PackageVersion;
import org.tizen.manager.util.DownloadProgressMonitor;
import org.tizen.manager.util.Downloader;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PathUtil;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.manager.util.ZipLibrary;

public class CompatController {
    private static final Logger logger = Log.getLogger(CompatController.class);
    private ArrayList<Property> mProperties;
    private final String INFO_PATH = ".info";
    private final String INSTALL_MANAGER_CONFIG_DIRECTORY = ".installmanager_2.4";
    private final String SDK_INSTALLED_FLAG_FILE = "shortcut.info";
    private final String OLD_SDK_INSTALLED_FLAG_FILE = "tizensdkpath";
    private final String PROXY_CONF_ORIGIN_FILE = "repository.info";
    private final String PROXY_CONF_ORIGIN_PATH;
    private final String PROXY_CONF_FILE = "proxy.conf";
    private final String PROXY_CONF_PATH;
    private final String REPO_HISTORY_FILE_OLD = "repo.history";
    private final String REPO_HISTORY_PATH_OLD;
    private final String REPO_HISTORY_FILE_NEW = ".repo-history";
    private final String REPO_HISTORY_PATH_NEW;
    private final String EXT_REPO_INFO_FILE_OLD = "CacheInformation.txt";
    private final String EXT_REPO_INFO_PATH_OLD;
    private final String EXT_REPO_INFO_FILE_NEW = "ext-repo-info.xml";
    private final String EXT_REPO_INFO_PATH_NEW;
    private final String PACKAGE_FILE_LIST_PATH;
    private final String UNINSTLLER = "uninstaller";
    private final String UNINSTALLER_DIR_PATH;
    private LinkedHashMap<String, String> extensionRepositories;
    private ArrayList<ExtensionInformation> extensionList;
    private ContentProvider contentProvider;

    public CompatController(ContentProvider contentProvider) {
        this.contentProvider = contentProvider;
        this.mProperties = new ArrayList();
        this.extensionRepositories = new LinkedHashMap();
        this.extensionList = new ArrayList();
        this.PROXY_CONF_ORIGIN_PATH = this.getProxyOriginPath();
        this.PROXY_CONF_PATH = this.getProxyConfPath();
        this.REPO_HISTORY_PATH_OLD = this.getOldRepoHistoryPath();
        this.REPO_HISTORY_PATH_NEW = this.getNewRepoHistoryPath();
        this.EXT_REPO_INFO_PATH_OLD = this.getOldExtRepoInfoPath();
        this.EXT_REPO_INFO_PATH_NEW = this.getNewExtRepoInfoPath();
        this.PACKAGE_FILE_LIST_PATH = this.getPackageFileListPath();
        this.UNINSTALLER_DIR_PATH = this.getUninstallerDirPath();
    }

    public void compatamize() {
        try {
            this.makeProxyConf();
            this.makeRepoHistory();
            this.makeExtRepoInfo();
            this.cleanLegacy();
        }
        catch (UMException e) {
            logger.error("Fail to work for compatibility.");
            logger.throwing(e);
        }
    }

    private String getPatchResourcePath() {
        String basePath = "/res/patches/tizen_2.4_filelist_patch";
        switch (PlatformUtil.CURRENT_PLATFORM) {
            case 1: {
                return PathUtil.get(basePath, "ubuntu-32");
            }
            case 4: {
                return PathUtil.get(basePath, "ubuntu-64");
            }
            case 8: {
                return PathUtil.get(basePath, "windows-32");
            }
            case 16: {
                return PathUtil.get(basePath, "windows-64");
            }
            case 64: {
                return PathUtil.get(basePath, "macos-64");
            }
        }
        logger.warn("Cannot get patch resource path because not support platform.");
        return null;
    }

    public void applyPatches() {
        this.patchTizen24FileList();
    }

    private void patchTizen24FileList() {
        PackageSet installedPkgs = this.contentProvider.getPkgMgr().getInstalledPackages();
        switch (PlatformUtil.CURRENT_PLATFORM) {
            case 1: {
                Package pkg = installedPkgs.getPackageByName("mobile-webapp-ext-eplugin");
                if (pkg != null && pkg.getVersion().toString().equals("1.0.7")) {
                    this.writeToPatch(pkg.getPackageName());
                }
                if ((pkg = installedPkgs.getPackageByName("new-web-cli")) == null || !pkg.getVersion().toString().equals("2.1.130")) break;
                this.writeToPatch(pkg.getPackageName());
                break;
            }
            case 4: {
                Package pkg = installedPkgs.getPackageByName("base-ide-product");
                if (pkg != null && pkg.getVersion().toString().equals("2.3.32")) {
                    this.writeToPatch(pkg.getPackageName());
                }
                if ((pkg = installedPkgs.getPackageByName("sdk-manager")) == null || !pkg.getVersion().toString().equals("0.0.8")) break;
                this.writeToPatch(pkg.getPackageName());
                break;
            }
            case 8: {
                break;
            }
            case 16: {
                break;
            }
            case 64: {
                Package pkg = installedPkgs.getPackageByName("dynamic-analysis-ide-web-eplugin");
                if (pkg != null && pkg.getVersion().toString().equals("2.2.29")) {
                    this.writeToPatch(pkg.getPackageName());
                }
                if ((pkg = installedPkgs.getPackageByName("base-ide-product")) == null || !pkg.getVersion().toString().equals("2.3.32")) break;
                this.writeToScript(pkg.getPackageName());
                break;
            }
            default: {
                logger.warn("Cannot get patch resource path because not support platform.");
            }
        }
    }

    private void writeToScript(String needToPatch) {
        logger.trace("Patch .list file => [" + needToPatch + "]");
        String installedFile = PathUtil.get(this.PACKAGE_FILE_LIST_PATH, needToPatch, "remove.sh");
        String patchRsrc = PathUtil.get(this.getPatchResourcePath(), "remove.sh");
        try {
            String listText;
            if (new File(installedFile).exists()) {
                PathUtil.remove(installedFile);
            }
            if ((listText = PathUtil.readAllTextFromResource(patchRsrc)) != null) {
                PathUtil.writeFileFromString(installedFile, listText);
            } else {
                logger.warn("Cannot read .list resource. => " + patchRsrc);
            }
        }
        catch (UMException e) {
            logger.warn("Failed to patch .list file for installed package. ignore it. => " + patchRsrc);
            logger.throwing(e);
        }
    }

    private void writeToPatch(String needToPatch) {
        logger.trace("Patch .list file => [" + needToPatch + "]");
        String installedFile = PathUtil.get(this.PACKAGE_FILE_LIST_PATH, needToPatch, needToPatch + ".list");
        String patchRsrc = PathUtil.get(this.getPatchResourcePath(), needToPatch + ".list");
        try {
            String listText;
            if (new File(installedFile).exists()) {
                PathUtil.remove(installedFile);
            }
            if ((listText = PathUtil.readAllTextFromResource(patchRsrc)) != null) {
                PathUtil.writeFileFromString(installedFile, listText);
            } else {
                logger.warn("Cannot read .list resource. => " + patchRsrc);
            }
        }
        catch (UMException e) {
            logger.warn("Failed to patch .list file for installed package. ignore it. => " + patchRsrc);
            logger.throwing(e);
        }
    }

    public boolean compatUninstaller() throws UMException {
        boolean returnValue = false;
        try {
            Package packageManagerPkg = this.contentProvider.getPkgMgr().getInstalledPackages().getPackageByName("package-manager");
            PackageVersion version = packageManagerPkg.getVersion();
            PackageVersion newVersion = new PackageVersion("0.2.0");
            returnValue = version.compareTo(newVersion) < 0;
        }
        catch (Exception e) {
            returnValue = false;
        }
        return returnValue;
    }

    public void workUninstallerForCompat() throws UMException {
        logger.trace("\tUser want to get uninstaller.");
        Package pkg = this.contentProvider.getPkgMgr().getPackageByName("uninstaller");
        if (pkg == null) {
            throw new UMException(ErrorController.ErrorCode.NO_UNINSTALLER);
        }
        this.installToTemporaryDirectory(pkg);
        this.runUninstaller(pkg);
    }

    private void installToTemporaryDirectory(Package pkg) throws UMException {
        this.cleanTempDirForSelfUpdate();
        String downloadFilePath = this.downloadToTemporaryDirectory(pkg);
        this.extractToTemporaryDirectory(downloadFilePath);
        logger.trace("\tSuccess to extract updatable Package Manager.");
    }

    private boolean cleanTempDirForSelfUpdate() {
        File[] binariesAfter;
        int cnt = 0;
        File uninstallerBinary = null;
        uninstallerBinary = PlatformUtil.isWindows() ? new File(PathUtil.get(this.UNINSTALLER_DIR_PATH, "binary")) : (PlatformUtil.isLinux() || PlatformUtil.isMacOS() ? new File(this.UNINSTALLER_DIR_PATH) : new File(PathUtil.get(this.UNINSTALLER_DIR_PATH, "binary")));
        File[] binariesBefore = uninstallerBinary.listFiles();
        if (binariesBefore != null) {
            for (File binary : binariesBefore) {
                if (!binary.getName().startsWith("uninstaller") || PathUtil.remove(binary)) continue;
                logger.error("Cannot delete " + binary.getAbsolutePath());
            }
        }
        if ((binariesAfter = uninstallerBinary.listFiles()) != null) {
            for (File rest : binariesAfter) {
                if (!rest.getName().startsWith("uninstaller")) continue;
                ++cnt;
            }
        }
        if (cnt == 0) {
            logger.trace("\tSuccess to clean up temporary downloaded uninstaller. => " + uninstallerBinary.getAbsolutePath());
            return true;
        }
        logger.error("Fail to clean up temporary downloaded uninstaller. => " + uninstallerBinary.getAbsolutePath());
        return false;
    }

    private String downloadToTemporaryDirectory(Package pkg) throws UMException {
        Downloader downloader;
        long size;
        if (pkg == null) {
            logger.error("Cannot get uninstaller package from repository.");
            throw new UMException(ErrorController.ErrorCode.CANNOT_DOWNLOAD_UNINSTALLER, "Invalid arguments -pkg is null");
        }
        String packageName = pkg.getFileName();
        if (packageName == null) {
            logger.error("Cannot get uninstaller package from repository.");
            throw new UMException(ErrorController.ErrorCode.CANNOT_DOWNLOAD_UNINSTALLER, "Invalid arguments -pkg name is null");
        }
        String downloadFilePath = PathUtil.get(this.UNINSTALLER_DIR_PATH, PathUtil.getFileName(packageName));
        File downloadFile = new File(downloadFilePath);
        if (downloadFile.exists() && !PathUtil.remove(downloadFilePath)) {
            logger.error("Cannot remove uninstaller. => " + downloadFilePath);
        }
        if ((size = (downloader = new Downloader(this.contentProvider.getConfig(), pkg.getURL())).download(downloadFilePath, new DownloadProgressMonitor())) <= 0L) {
            new UMException(ErrorController.ErrorCode.CANNOT_DOWNLOAD_UNINSTALLER, "Downloaded size is zero.");
        }
        return downloadFilePath;
    }

    private void extractToTemporaryDirectory(String filePath) throws UMException {
        this.removeUninstallerBinaryInTemp();
        ZipLibrary zipLibrary = new ZipLibrary(filePath, null);
        long size = 0L;
        try {
            size = zipLibrary.unzip(this.UNINSTALLER_DIR_PATH, null);
        }
        catch (Exception e) {
            throw new UMException(ErrorController.ErrorCode.CANNOT_UNPACK_UNINSTALLER, "Size is zero!");
        }
        if (size <= 0L) {
            throw new UMException(ErrorController.ErrorCode.CANNOT_UNPACK_UNINSTALLER, "Size is zero!");
        }
    }

    private void removeUninstallerBinaryInTemp() {
        File tempDirFile = new File(this.UNINSTALLER_DIR_PATH);
        File uninstallerDir = new File(PathUtil.get(this.UNINSTALLER_DIR_PATH, "data", "uninstaller"));
        if (uninstallerDir.exists() && !PathUtil.remove(uninstallerDir)) {
            logger.error("Cannot delete " + uninstallerDir.getAbsolutePath());
        }
        if (tempDirFile.exists()) {
            File[] fileList = tempDirFile.listFiles();
            assert (fileList != null);
            for (File childFile : fileList) {
                if (!this.isUninstallerBinary(childFile.getName()) || childFile.delete()) continue;
                logger.error("Cannot delete " + childFile.getAbsolutePath());
            }
        }
    }

    private boolean isUninstallerBinary(String fileName) {
        return fileName.equals("PackageManagerV2-uninstaller.jar");
    }

    private void runUninstaller(Package pkg) throws UMException {
        File tempUninstallerJarFile = new File(PathUtil.get(this.UNINSTALLER_DIR_PATH, "data", "package-manager", "PackageManagerV2-uninstaller.jar"));
        logger.info("Uninstaller will start. => " + tempUninstallerJarFile.getAbsolutePath());
        if (!tempUninstallerJarFile.exists()) {
            throw new UMException(ErrorController.ErrorCode.CANNOT_EXECUTE_UNINSTALLER, "The downloaded Uninstaller does not exists.");
        }
        try {
            ArrayList<String> commands = new ArrayList<String>();
            String javaHome = System.getProperty("java.home");
            File java = null;
            java = PlatformUtil.isLinux() || PlatformUtil.isMacOS() ? new File(PathUtil.get(javaHome, "bin", "java")) : (PlatformUtil.isWindows() ? new File(PathUtil.get(javaHome, "bin", "java.exe")) : new File(PathUtil.get(javaHome, "bin", "java")));
            String forceBitOption = "-d" + System.getProperty("sun.arch.data.model");
            String jarPath = PathUtil.get(tempUninstallerJarFile.getAbsolutePath());
            if (java != null) {
                if (java.exists()) {
                    commands.add(java.getAbsolutePath());
                } else {
                    commands.add("java");
                }
            }
            if (PlatformUtil.isMacOS()) {
                commands.add("-XstartOnFirstThread");
            }
            commands.add(forceBitOption);
            commands.add("-jar");
            commands.add(jarPath);
            if (Config.executablePath != null) {
                commands.add("-path");
                commands.add(Config.executablePath);
            }
            commands.add("-noJavaVersionCheck");
            logger.trace("\tUninstaller commands => " + commands);
            ProcessBuilder pb = new ProcessBuilder(commands);
            pb.directory(tempUninstallerJarFile.getParentFile());
            pb.start();
        }
        catch (IOException e) {
            logger.throwing(e);
            throw new UMException(ErrorController.ErrorCode.CANNOT_EXECUTE_UNINSTALLER, (Throwable)e);
        }
    }

    public boolean needCompatibility() {
        File flag = new File(PathUtil.get(this.contentProvider.getSDKInfo().getInstalledPath(), ".info", "shortcut.info"));
        File oldflag = new File(PathUtil.get(this.getInstConfigHome(), "tizensdkpath"));
        if (!flag.exists() && oldflag.exists()) {
            String oldInstallPath = null;
            try {
                oldInstallPath = this.contentProvider.getSDKInfo().readInstallPathFromSdkInfo(oldflag.getAbsolutePath());
                if (oldInstallPath.equals(this.contentProvider.getSDKInfo().getInstalledPath())) {
                    logger.trace("Need compatibility.");
                    return true;
                }
                return false;
            }
            catch (UMException e) {
                logger.throwing(e);
                return false;
            }
        }
        logger.trace("Do not need compatibility.");
        return false;
    }

    private void makeProxyConf() throws UMException {
        File proxyOrigin = new File(this.PROXY_CONF_ORIGIN_PATH);
        if (proxyOrigin.exists()) {
            this.loadOldConfiguration(proxyOrigin);
            this.writeToFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile() {
        logger.trace("Write and make proxy setting configuration file. => " + this.PROXY_CONF_PATH);
        File proxyConf = new File(this.PROXY_CONF_PATH);
        BufferedWriter writer = null;
        try {
            if (proxyConf.exists()) {
                proxyConf.delete();
            }
            proxyConf.createNewFile();
            writer = new BufferedWriter(new FileWriter(proxyConf));
            for (int i = 0; i < this.mProperties.size(); ++i) {
                if (!this.mProperties.get(i).getName().equals("Proxy-Type") && !this.mProperties.get(i).getName().equals("Proxy-Server") && !this.mProperties.get(i).getName().equals("Proxy-Port")) continue;
                writer.write(this.mProperties.get(i).getName() + ": " + this.mProperties.get(i).getValue() + "\n");
            }
        }
        catch (IOException e) {
            logger.error("Cannot write config file");
            logger.throwing(e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                logger.error("close fileoutput fail");
            }
        }
    }

    private void loadOldConfiguration(File proxyOrigin) throws UMException {
        logger.trace("Load the installmanager configuration file. => " + this.PROXY_CONF_ORIGIN_PATH);
        List<PropertySection> propertySections = null;
        PropertyParser parser = new PropertyParser();
        propertySections = parser.readFromFile(proxyOrigin);
        if (propertySections == null || propertySections.size() == 0) {
            throw new UMException(ErrorController.ErrorCode.FAILED_TO_LOAD_CONFIG_FILE, this.PROXY_CONF_ORIGIN_PATH);
        }
        this.setProperties(propertySections.get(0).getProperties());
    }

    private void setProperties(ArrayList<Property> properties) {
        this.mProperties = properties;
    }

    private void makeRepoHistory() {
        File oldHistory = new File(this.REPO_HISTORY_PATH_OLD);
        if (oldHistory.exists()) {
            if (PathUtil.moveFile(oldHistory, new File(this.REPO_HISTORY_PATH_NEW))) {
                logger.trace("Success to move repository history for compatibility.");
            } else {
                logger.trace("Fail to move repository history for compatibility.");
            }
        }
    }

    private void makeExtRepoInfo() {
        File xmlFile = new File(this.EXT_REPO_INFO_PATH_NEW);
        File oldFile = new File(this.EXT_REPO_INFO_PATH_OLD);
        if (!xmlFile.exists() && oldFile.exists()) {
            this.extensionRepositories = this.parseLocationInformationToMap(new File(this.EXT_REPO_INFO_PATH_OLD));
            Set<String> keySet = this.extensionRepositories.keySet();
            for (String key : keySet) {
                String repoId = UUID.randomUUID().toString();
                String repoName = this.extensionRepositories.get(key);
                String repoURL = key;
                this.extensionList.add(ExtRepositoryManager.createNewRepository(repoId, repoName, repoURL, true, null));
            }
            this.writeToFile(this.extensionList);
        } else {
            logger.trace("Local extension xml file already exists. so, skip compatability process.");
        }
    }

    private void writeToFile(ArrayList<ExtensionInformation> extensions) {
        ExtensionRoot extRoot = ExtensionRoot.getInstance();
        extRoot.setExtensions(extensions);
        this.objectToXml(extRoot);
    }

    private void objectToXml(ExtensionRoot extRoot) {
        File xmlFile = null;
        try {
            if (this.EXT_REPO_INFO_PATH_NEW != null && !this.EXT_REPO_INFO_PATH_NEW.isEmpty()) {
                xmlFile = new File(this.EXT_REPO_INFO_PATH_NEW);
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ExtensionRoot.class});
                Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
                jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
                jaxbMarshaller.marshal((Object)extRoot, xmlFile);
            }
        }
        catch (JAXBException e) {
            xmlFile.delete();
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedHashMap<String, String> parseLocationInformationToMap(File extraCache) {
        LinkedHashMap<String, String> linkedHashMap = null;
        if (extraCache.exists()) {
            FileInputStream is = null;
            BufferedReader in = null;
            try {
                is = new FileInputStream(extraCache);
                in = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
                linkedHashMap = new LinkedHashMap<String, String>();
                String strLicense = null;
                while ((strLicense = in.readLine()) != null) {
                    String[] split;
                    if (!strLicense.contains("=") || (split = strLicense.split("=")).length != 2) continue;
                    linkedHashMap.put(split[0], split[1]);
                }
            }
            catch (IOException e) {
                logger.error("Cannot parse extra caching file. => " + extraCache.getAbsolutePath());
                logger.throwing(e);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    logger.throwing(e);
                }
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException e) {
                    logger.throwing(e);
                }
            }
        }
        return linkedHashMap;
    }

    private String getProxyOriginPath() {
        String path = PathUtil.get(this.contentProvider.getSDKInfo().getInstalledPath(), ".info", "repository.info");
        return path;
    }

    private String getProxyConfPath() {
        String path = PathUtil.get(this.contentProvider.getSDKInfo().getInstalledPath(), ".info", "proxy.conf");
        return path;
    }

    private String getOldRepoHistoryPath() {
        String path = PathUtil.get(this.getInstConfigHome(), "repo.history");
        return path;
    }

    private String getNewRepoHistoryPath() {
        String path = PathUtil.get(this.contentProvider.getSDKInfo().getInstalledPath(), ".info", ".repo-history");
        return path;
    }

    private String getOldExtRepoInfoPath() {
        String path = PathUtil.get(this.getInstConfigHome(), "extra", "CacheInformation.txt");
        return path;
    }

    private String getNewExtRepoInfoPath() {
        String path = PathUtil.get(this.contentProvider.getSDKInfo().getInstalledPath(), ".info", "ext-repo-info.xml");
        return path;
    }

    private String getPackageFileListPath() {
        String path = PathUtil.get(this.contentProvider.getSDKInfo().getInstalledPath(), ".info");
        return path;
    }

    private String getUninstallerDirPath() {
        String path = PathUtil.get(Config.getManagerConfigHome(), "uninstaller", Long.toString((long)this.contentProvider.getSDKInfo().getInstalledPath().hashCode() & 0xFFFFFFFFL));
        return path;
    }

    private String getInstConfigHome() {
        if (PlatformUtil.isLinux() || PlatformUtil.isMacOS()) {
            return PathUtil.getFromHome(".installmanager_2.4");
        }
        if (PlatformUtil.isWindows()) {
            return PathUtil.getFromAppData(".installmanager_2.4");
        }
        return null;
    }

    private void cleanLegacy() {
        File[] legacies;
        logger.trace("\tClean legacy files because they are useless.");
        File legacyConfDir = new File(this.getInstConfigHome());
        for (File legacy : legacies = legacyConfDir.listFiles()) {
            if (legacy.getName().equals("install-log")) continue;
            if (PathUtil.remove(legacy)) {
                logger.trace("\tSuccess to remove. : " + legacy.getAbsolutePath());
                continue;
            }
            logger.warn("\tFail to remove. : " + legacy.getAbsolutePath());
        }
    }
}

