/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.uninstaller.ui.wizard;

import java.util.List;
import org.apache.logging.log4j.Logger;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.tizen.manager.core.ContentProvider;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.util.Log;
import org.tizen.packagemanager.ui.util.UIUtil;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;
import org.tizen.uninstaller.ui.dialog.CustomCheckBoxButton;
import org.tizen.uninstaller.ui.dialog.CustomMessageBoxDialog;
import org.tizen.uninstaller.ui.wizard.TextUtil;
import org.tizen.uninstaller.ui.wizard.WizardCommonPage;
import org.tizen.uninstaller.ui.wizard.WizardPageMaster;
import org.tizen.uninstaller.ui.wizard.WizardUninstallerWindow;

public class WizardReadyPage
extends WizardCommonPage {
    private static final Logger logger = Log.getLogger(WizardReadyPage.class);
    private StyledText uninstallationLocation;
    private StyledText dataLocation;
    private ContentProvider contentProvider;

    public WizardReadyPage(ContentProvider contentProvider, Composite parentComposite, WizardUIResourceHandler uiResource, int swtOption, WizardPageMaster pageMaster) throws UMException {
        super(contentProvider, parentComposite, swtOption, uiResource, pageMaster);
        this.contentProvider = contentProvider;
        this.createCenterContainer();
        this.handleBottomEvent();
    }

    private void createCenterContainer() {
        Composite leftContainer = new Composite(this.centerContainer, 0x20000000);
        Rectangle bounds = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_INSTALL_IC_SDK);
        Rectangle strokeSize = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_INSTALL_IC_STROKE);
        FormData formData = new FormData();
        formData.left = new FormAttachment(this.centerContainer, bounds.x, 0x1000000);
        formData.top = new FormAttachment(this.centerContainer, bounds.y, 0x1000000);
        formData.width = bounds.width;
        formData.height = bounds.height;
        leftContainer.setLayoutData(formData);
        leftContainer.setLayout(new FillLayout(256));
        this.uiResource.handleInstallingForWizardProgress(leftContainer, 0L, bounds.width, bounds.height, bounds.width - (strokeSize.width + strokeSize.height), 1);
        int SWT_OPTION = 0x20000000;
        Rectangle uninstallLocationBounds = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_UNINSTALLATION_LOCATION);
        Composite uninstallationLocationContainer = new Composite(this.centerContainer, SWT_OPTION);
        FormData uninstallationLocationContainerFormData = new FormData();
        uninstallationLocationContainerFormData.left = new FormAttachment(this.centerContainer, uninstallLocationBounds.x, 0x1000000);
        uninstallationLocationContainerFormData.top = new FormAttachment(this.centerContainer, uninstallLocationBounds.y, 0x1000000);
        uninstallationLocationContainerFormData.width = uninstallLocationBounds.width;
        uninstallationLocationContainerFormData.height = uninstallLocationBounds.height;
        uninstallationLocationContainer.setLayoutData(uninstallationLocationContainerFormData);
        uninstallationLocationContainer.setLayout(new FillLayout(256));
        Rectangle uninstallSelectComponentBounds = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_UNINSTALLATION_SELECT_COMPONENT);
        Composite uninstallSelectComponentContainer = new Composite(this.centerContainer, SWT_OPTION);
        FormData uninstallSelectComponentContainerFormData = new FormData();
        uninstallSelectComponentContainerFormData.left = new FormAttachment(this.centerContainer, uninstallSelectComponentBounds.x, 0x1000000);
        uninstallSelectComponentContainerFormData.top = new FormAttachment(this.centerContainer, uninstallSelectComponentBounds.y, 0x1000000);
        uninstallSelectComponentContainerFormData.width = uninstallSelectComponentBounds.width;
        uninstallSelectComponentContainerFormData.height = uninstallSelectComponentBounds.height;
        uninstallSelectComponentContainer.setLayoutData(uninstallSelectComponentContainerFormData);
        uninstallSelectComponentContainer.setLayout(new FillLayout(256));
        this.createUninstallLocationInfoComposites(uninstallationLocationContainer);
        this.createUninstallSelectComponentComposites(uninstallSelectComponentContainer);
    }

    private void createUninstallLocationInfoComposites(Composite locationContainer) {
        Composite mainContainer = this.createLocationCompositeLayout(locationContainer);
        this.createUninstallationLocationComposites(mainContainer);
        this.createDataLocationComposites(mainContainer);
    }

    private Composite createLocationCompositeLayout(Composite locationContainer) {
        Composite mainContainer = new Composite(locationContainer, 0);
        FormData formData = new FormData();
        formData.left = new FormAttachment(locationContainer, 0, 0x1000000);
        formData.top = new FormAttachment(locationContainer, 0, 0x1000000);
        formData.width = locationContainer.getBounds().width;
        formData.height = locationContainer.getBounds().height;
        mainContainer.setLayoutData(formData);
        GridLayout layout = new GridLayout(3, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        mainContainer.setLayout(layout);
        return mainContainer;
    }

    private void createUninstallationLocationComposites(Composite parent) {
        Label uninstallationLocationLabel = new Label(parent, 0);
        uninstallationLocationLabel.setText("SDK location");
        uninstallationLocationLabel.setFont(this.uiResource.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1));
        uninstallationLocationLabel.setForeground(this.uiResource.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33));
        Rectangle labelBounds = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_UNINSTALLATION_LOCATION_LABEL);
        GridData gd = new GridData(labelBounds.width, labelBounds.height);
        uninstallationLocationLabel.setLayoutData(gd);
        Rectangle emptyBounds = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_UNINSTALLATION_LOCATION_EMPTY_SPACE);
        Composite dummy = new Composite(parent, 0);
        gd = new GridData(emptyBounds.width, emptyBounds.height);
        dummy.setLayoutData(gd);
        Rectangle valueBounds = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_UNINSTALLATION_LOCATION_VALUE);
        this.uninstallationLocation = new StyledText(parent, 16384);
        this.uninstallationLocation.setFont(this.uiResource.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.uninstallationLocation.setForeground(this.uiResource.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_PURE_BLUE));
        gd = new GridData(valueBounds.width, valueBounds.height);
        this.uninstallationLocation.setLayoutData(gd);
        this.uninstallationLocation.setEditable(false);
        this.uninstallationLocation.setCaret(null);
        String dirString = this.contentProvider.getConfig().getTargetDir();
        this.uninstallationLocation.setToolTipText(dirString);
        String leftAlignedTextWithEllipsis = TextUtil.getLeftAlignedTextWithEllipsis(dirString, this.uninstallationLocation, valueBounds.width);
        this.uninstallationLocation.setText(leftAlignedTextWithEllipsis);
        this.uninstallationLocation.setLayoutData(gd);
    }

    private void createDataLocationComposites(Composite parent) {
        Label uninstallationDataLocationLabel = new Label(parent, 0);
        uninstallationDataLocationLabel.setText("Data location");
        uninstallationDataLocationLabel.setFont(this.uiResource.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1));
        uninstallationDataLocationLabel.setForeground(this.uiResource.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33));
        Rectangle labelBounds = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_UNINSTALLATION_LOCATION_LABEL);
        GridData gd = new GridData(labelBounds.width, labelBounds.height);
        uninstallationDataLocationLabel.setLayoutData(gd);
        Rectangle emptyBounds = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_UNINSTALLATION_LOCATION_EMPTY_SPACE);
        Composite dummy = new Composite(parent, 0);
        gd = new GridData(emptyBounds.width, emptyBounds.height);
        dummy.setLayoutData(gd);
        Rectangle valueBounds = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_UNINSTALLATION_LOCATION_VALUE);
        this.dataLocation = new StyledText(parent, 16384);
        this.dataLocation.setFont(this.uiResource.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.dataLocation.setForeground(this.uiResource.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_PURE_BLUE));
        gd = new GridData(valueBounds.width, valueBounds.height);
        this.dataLocation.setLayoutData(gd);
        this.dataLocation.setEditable(false);
        this.dataLocation.setCaret(null);
        String sdkDataDir = this.contentProvider.getConfig().getSdkDataDir();
        this.dataLocation.setToolTipText(sdkDataDir);
        String leftAlignedTextWithEllipsis = TextUtil.getLeftAlignedTextWithEllipsis(sdkDataDir, this.dataLocation, valueBounds.width);
        this.dataLocation.setText(leftAlignedTextWithEllipsis);
        this.dataLocation.setLayoutData(gd);
    }

    private void createUninstallSelectComponentComposites(Composite selectComponentContainer) {
        Composite mainContainer = this.createSelectComponentCompositeLayout(selectComponentContainer);
        this.createUninstallSelectComponentLabel(mainContainer);
        this.createUninstallSelectComponentContent(mainContainer);
    }

    private Composite createSelectComponentCompositeLayout(Composite selectComponentContainer) {
        Composite mainContainer = new Composite(selectComponentContainer, 0);
        FormData formData = new FormData();
        formData.left = new FormAttachment(selectComponentContainer, 0, 0x1000000);
        formData.top = new FormAttachment(selectComponentContainer, 0, 0x1000000);
        formData.width = selectComponentContainer.getBounds().width;
        formData.height = selectComponentContainer.getBounds().height;
        mainContainer.setLayoutData(formData);
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        mainContainer.setLayout(layout);
        return mainContainer;
    }

    private void createUninstallSelectComponentLabel(Composite parent) {
        Label selectComponentLabel = new Label(parent, 0);
        selectComponentLabel.setText("Select components to uninstall");
        selectComponentLabel.setFont(this.uiResource.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1));
        selectComponentLabel.setForeground(this.uiResource.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33));
        GridData gd = new GridData(4, 1, false, false, 1, 0);
        selectComponentLabel.setLayoutData(gd);
    }

    private void createUninstallSelectComponentContent(Composite parent) {
        Composite contentContainer = this.createSelectComponentContentLayout(parent);
        this.createUninstallSelectComponentSDKData(contentContainer);
        if (uninstallContext.isKeystoreExist().booleanValue()) {
            this.createUninstallSelectComponentKeyStore(contentContainer);
        }
    }

    private Composite createSelectComponentContentLayout(Composite parent) {
        Composite contentContainer = new Composite(parent, 0);
        GridData gd = new GridData();
        contentContainer.setLayoutData(gd);
        GridLayout layout = new GridLayout(1, false);
        Rectangle contentMarginBounds = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_UNINSTALLATION_SELECT_COMPONENT_MARGIN);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = contentMarginBounds.height;
        contentContainer.setLayout(layout);
        return contentContainer;
    }

    private void createUninstallSelectComponentSDKData(Composite parent) {
        uninstallContext.setDeleteSDKData(true);
        Image checkedImage = this.uiResource.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_CHECK_SEL);
        Image unCheckedImage = this.uiResource.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_CHECK_NORMAL);
        Rectangle checkBoxBounds = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_UNINSTALLATION_SELECT_COMPONENT_CHECKBOX);
        CustomCheckBoxButton sdkDataCheckBox = new CustomCheckBoxButton(parent, 0x20000000, true, checkedImage, unCheckedImage, "SDK data", checkBoxBounds.x, this.uiResource.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1), this.uiResource.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33));
        GridData gd = new GridData(16384, 1, true, false, 1, 2);
        gd.widthHint = checkBoxBounds.width;
        gd.heightHint = checkBoxBounds.height;
        sdkDataCheckBox.setLayoutData(gd);
        StyledText sdkDataDesc = new StyledText(parent, 66);
        sdkDataDesc.setText("SDK data includes the user's emulator images, log files, and user settings.");
        sdkDataDesc.setFont(this.uiResource.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        sdkDataDesc.setAlignment(16384);
        sdkDataDesc.setCaret(null);
        Rectangle descMarginBounds = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_UNINSTALLATION_SELECT_COMPONENT_DESC_MARGIN);
        sdkDataDesc.setLeftMargin(descMarginBounds.x);
        sdkDataDesc.setTopMargin(descMarginBounds.y);
        sdkDataDesc.setBottomMargin(descMarginBounds.height);
        sdkDataDesc.setForeground(this.uiResource.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_READYPAGE_WARN_MESSAGE));
        gd = new GridData(16384, 1, true, false, 1, 1);
        Rectangle descBounds = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_UNINSTALLATION_SELECT_COMPONENT_DESC);
        gd.widthHint = descBounds.width;
        sdkDataDesc.setLayoutData(gd);
        sdkDataCheckBox.addMouseListener(new MouseListener(){

            @Override
            public void mouseUp(MouseEvent event) {
                CustomCheckBoxButton checkBox = (CustomCheckBoxButton)event.getSource();
                WizardCommonPage.uninstallContext.setDeleteSDKData(checkBox.isChecked());
                logger.trace("User clicked SDK Data check box, now: " + WizardCommonPage.uninstallContext.shouldDeleteSDKData());
            }

            @Override
            public void mouseDown(MouseEvent arg0) {
            }

            @Override
            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
    }

    private void createUninstallSelectComponentKeyStore(Composite parent) {
        uninstallContext.setDeleteKeystore(false);
        Image checkedImage = this.uiResource.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_CHECK_SEL);
        Image unCheckedImage = this.uiResource.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_CHECK_NORMAL);
        Rectangle checkBoxBounds = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_UNINSTALLATION_SELECT_COMPONENT_CHECKBOX);
        CustomCheckBoxButton keystoreCheckBox = new CustomCheckBoxButton(parent, 0x20000000, uninstallContext.shouldDeleteKeystore(), checkedImage, unCheckedImage, "KeyStore", checkBoxBounds.x, this.uiResource.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1), this.uiResource.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33));
        GridData gd = new GridData(16384, 1, true, false, 1, 2);
        gd.widthHint = checkBoxBounds.width;
        gd.heightHint = checkBoxBounds.height;
        keystoreCheckBox.setLayoutData(gd);
        StyledText sdkDataDesc = new StyledText(parent, 66);
        sdkDataDesc.setText("The keystore directory includes the Tizen seller site author and distributor certificate files.");
        sdkDataDesc.setFont(this.uiResource.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        sdkDataDesc.setAlignment(16384);
        sdkDataDesc.setCaret(null);
        sdkDataDesc.setForeground(this.uiResource.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_READYPAGE_WARN_MESSAGE));
        Rectangle descMarginBounds = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_UNINSTALLATION_SELECT_COMPONENT_DESC_MARGIN);
        sdkDataDesc.setLeftMargin(descMarginBounds.x);
        sdkDataDesc.setTopMargin(descMarginBounds.y);
        sdkDataDesc.setBottomMargin(descMarginBounds.height);
        gd = new GridData(16384, 1, true, false, 1, 1);
        Rectangle descBounds = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_UNINSTALLATION_SELECT_COMPONENT_DESC);
        gd.widthHint = descBounds.width;
        sdkDataDesc.setLayoutData(gd);
        keystoreCheckBox.addMouseListener(new MouseListener(){

            @Override
            public void mouseUp(MouseEvent event) {
                CustomCheckBoxButton checkBox = (CustomCheckBoxButton)event.getSource();
                WizardReadyPage.this.keystoreCheckProcess(checkBox);
            }

            @Override
            public void mouseDown(MouseEvent arg0) {
            }

            @Override
            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
    }

    private void keystoreCheckProcess(CustomCheckBoxButton keystoreCheckBox) {
        if (keystoreCheckBox.isChecked()) {
            String message = String.format("Your Tizen authorization files (author and distributor certificates) are located in the %s directory.\nIf you delete the authorization files, you can no longer update your application on the Tizen seller site.\nAre you sure you want to delete the directory?", uninstallContext.getKeystorePath());
            CustomMessageBoxDialog dialog = new CustomMessageBoxDialog(this.getShell(), this.uiResource, "Uninstaller", message, CustomMessageBoxDialog.DialogType.WARNING, false);
            int deletePopupConfirm = dialog.open();
            if (deletePopupConfirm == 0) {
                logger.trace("User confirmed delete Keystore directory");
                uninstallContext.setDeleteKeystore(true);
                keystoreCheckBox.setIsChecked(true);
            } else if (deletePopupConfirm == 1) {
                logger.trace("User didn't confirm delete Keystore directory");
                uninstallContext.setDeleteKeystore(false);
                keystoreCheckBox.setIsChecked(false);
            }
        } else {
            uninstallContext.setDeleteKeystore(false);
        }
    }

    private void handleBottomEvent() {
        this.firstButton.setText("Uninstall");
        this.secondButton.setText("Cancel");
        this.firstButton.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                logger.trace("User click uninstall button mouseUp event => " + arg0);
                CustomMessageBoxDialog dialog = new CustomMessageBoxDialog(WizardReadyPage.this.getShell(), WizardReadyPage.this.uiResource, "Uninstaller", "Are you sure you want to permanently delete the selected directory?", CustomMessageBoxDialog.DialogType.NOTIFY_YES, false);
                int deletePopupConfirm = dialog.open();
                if (deletePopupConfirm == 0) {
                    logger.trace("User confirmed to proceed uninstall");
                    List<String> findRunningProcess = UIUtil.findRunningProcessOnUninstaller(WizardReadyPage.this.contentProvider.getSDKInfo(), WizardReadyPage.this.getShell());
                    if (!findRunningProcess.isEmpty()) {
                        return;
                    }
                    WizardReadyPage.this.wizardPageMaster.enablePages(WizardUninstallerWindow.UNINSTALLER_PAGES.UNINSTALLING_PAGE);
                } else if (deletePopupConfirm == 1) {
                    logger.trace("User didn't confirm to proceed uninstall");
                    return;
                }
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent arg0) {
                logger.trace(arg0);
            }
        });
        this.secondButton.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                logger.trace("User click quit button widgetSelected => " + arg0);
                CustomMessageBoxDialog dialog = new CustomMessageBoxDialog(WizardReadyPage.this.getShell(), WizardReadyPage.this.uiResource, "Uninstaller", "Are you sure you want to exit the Uninstaller?", CustomMessageBoxDialog.DialogType.QESTION, false);
                int ret = dialog.open();
                if (ret != 0) {
                    return;
                }
                WizardReadyPage.this.getShell().close();
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent arg0) {
                logger.trace(arg0);
            }
        });
    }

    public boolean workEventClose() {
        return true;
    }
}

