/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.WebKit;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.webkit.IWebError;
import org.eclipse.swt.internal.webkit.IWebPolicyDecisionListener;
import org.eclipse.swt.internal.webkit.IWebPreferences;
import org.eclipse.swt.internal.webkit.IWebURLRequest;
import org.eclipse.swt.internal.webkit.IWebView;
import org.eclipse.swt.internal.webkit.WebKit_win32;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.widgets.MessageBox;

class WebPolicyDelegate {
    COMObject iWebPolicyDelegate;
    int refCount = 0;
    Browser browser;

    WebPolicyDelegate(Browser browser) {
        this.createCOMInterfaces();
        this.browser = browser;
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        this.iWebPolicyDelegate = new COMObject(new int[]{2, 0, 0, 5, 5, 5, 3}){

            public long method0(long[] lArray) {
                return WebPolicyDelegate.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return WebPolicyDelegate.this.AddRef();
            }

            public long method2(long[] lArray) {
                return WebPolicyDelegate.this.Release();
            }

            public long method3(long[] lArray) {
                return WebPolicyDelegate.this.decidePolicyForNavigationAction(lArray[0], lArray[1], lArray[2], lArray[3], lArray[4]);
            }

            public long method4(long[] lArray) {
                return WebPolicyDelegate.this.decidePolicyForNewWindowAction(lArray[0], lArray[1], lArray[2], lArray[3], lArray[4]);
            }

            public long method5(long[] lArray) {
                return WebPolicyDelegate.this.decidePolicyForMIMEType(lArray[0], lArray[1], lArray[2], lArray[3], lArray[4]);
            }

            public long method6(long[] lArray) {
                return WebPolicyDelegate.this.unableToImplementPolicyWithError(lArray[0], lArray[1], lArray[2]);
            }
        };
    }

    int decidePolicyForMIMEType(long l, long l2, long l3, long l4, long l5) {
        IWebView iWebView = new IWebView(l);
        int[] nArray = new int[1];
        iWebView.canShowMIMEType(l2, nArray);
        IWebPolicyDecisionListener iWebPolicyDecisionListener = new IWebPolicyDecisionListener(l5);
        if (nArray[0] != 0) {
            iWebPolicyDecisionListener.use();
        } else {
            iWebPolicyDecisionListener.download();
        }
        return 0;
    }

    int decidePolicyForNavigationAction(long l, long l2, long l3, long l4, long l5) {
        IWebURLRequest iWebURLRequest = new IWebURLRequest(l3);
        long[] lArray = new long[1];
        int n = iWebURLRequest.URL(lArray);
        if (n != 0 || lArray[0] == 0L) {
            return 0;
        }
        String string = WebKit.extractBSTR(lArray[0]);
        COM.SysFreeString(lArray[0]);
        IWebPolicyDecisionListener iWebPolicyDecisionListener = new IWebPolicyDecisionListener(l5);
        WebKit webKit = (WebKit)this.browser.webBrowser;
        if (webKit.loadingText) {
            iWebPolicyDecisionListener.use();
            return 0;
        }
        if (string.length() == 0) {
            iWebPolicyDecisionListener.ignore();
            return 0;
        }
        if (string.startsWith("file://") && webKit.getUrl().startsWith("about:blank") && webKit.untrustedText) {
            iWebPolicyDecisionListener.ignore();
            return 0;
        }
        if (string.equals("file:///")) {
            string = "about:blank";
        } else {
            int n2 = "file:///".length();
            if (string.startsWith("file:///") && string.charAt(n2) == '#') {
                string = "about:blank" + string.substring(n2);
            }
        }
        LocationEvent locationEvent = new LocationEvent(this.browser);
        locationEvent.display = this.browser.getDisplay();
        locationEvent.widget = this.browser;
        locationEvent.location = string;
        locationEvent.doit = true;
        LocationListener[] locationListenerArray = webKit.locationListeners;
        if (locationListenerArray != null) {
            for (int i = 0; i < locationListenerArray.length; ++i) {
                locationListenerArray[i].changing(locationEvent);
            }
        }
        if (locationEvent.doit) {
            if (webKit.jsEnabled != webKit.jsEnabledOnNextPage) {
                webKit.jsEnabled = webKit.jsEnabledOnNextPage;
                IWebView iWebView = new IWebView(l);
                lArray[0] = 0L;
                n = iWebView.preferences(lArray);
                if (n == 0 && lArray[0] != 0L) {
                    IWebPreferences iWebPreferences = new IWebPreferences(lArray[0]);
                    n = iWebPreferences.setJavaScriptEnabled(webKit.jsEnabled ? 1 : 0);
                    iWebView.setPreferences(iWebPreferences.getAddress());
                    iWebPreferences.Release();
                }
            }
            iWebPolicyDecisionListener.use();
            webKit.lastNavigateURL = string;
        } else {
            iWebPolicyDecisionListener.ignore();
        }
        return 0;
    }

    int decidePolicyForNewWindowAction(long l, long l2, long l3, long l4, long l5) {
        IWebPolicyDecisionListener iWebPolicyDecisionListener = new IWebPolicyDecisionListener(l5);
        iWebPolicyDecisionListener.use();
        return 0;
    }

    protected void disposeCOMInterfaces() {
        if (this.iWebPolicyDelegate != null) {
            this.iWebPolicyDelegate.dispose();
            this.iWebPolicyDelegate = null;
        }
    }

    long getAddress() {
        return this.iWebPolicyDelegate.getAddress();
    }

    int QueryInterface(long l, long l2) {
        if (l == 0L || l2 == 0L) {
            return -2147024809;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, l, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown)) {
            COM.MoveMemory(l2, new long[]{this.iWebPolicyDelegate.getAddress()}, OS.PTR_SIZEOF);
            new IUnknown(this.iWebPolicyDelegate.getAddress()).AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, WebKit_win32.IID_IWebPolicyDelegate)) {
            COM.MoveMemory(l2, new long[]{this.iWebPolicyDelegate.getAddress()}, OS.PTR_SIZEOF);
            new IUnknown(this.iWebPolicyDelegate.getAddress()).AddRef();
            return 0;
        }
        COM.MoveMemory(l2, new long[]{0L}, OS.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int unableToImplementPolicyWithError(long l, long l2, long l3) {
        if (this.browser.isDisposed()) {
            return 0;
        }
        IWebError iWebError = new IWebError(l2);
        String string = null;
        long[] lArray = new long[1];
        int n = iWebError.failingURL(lArray);
        if (n == 0 && lArray[0] != 0L) {
            string = WebKit.extractBSTR(lArray[0]);
            COM.SysFreeString(lArray[0]);
        }
        lArray[0] = 0L;
        n = iWebError.localizedDescription(lArray);
        if (n != 0 || lArray[0] == 0L) {
            return 0;
        }
        String string2 = WebKit.extractBSTR(lArray[0]);
        COM.SysFreeString(lArray[0]);
        String string3 = string != null ? string + "\n\n" : "";
        string3 = string3 + Compatibility.getMessage("SWT_Page_Load_Failed", new Object[]{string2});
        MessageBox messageBox = new MessageBox(this.browser.getShell(), 33);
        messageBox.setMessage(string3);
        messageBox.open();
        return 0;
    }
}

