/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.pkg;

import org.apache.logging.log4j.Logger;
import org.tizen.manager.util.Log;

public class PackageVersion {
    private static final Logger logger = Log.getLogger(PackageVersion.class);
    private static final int EQ = 0;
    private static final int LT = -1;
    private static final int GT = 1;
    private String[] dividedVersion = null;

    public PackageVersion(String version) {
        if (version.endsWith(".")) {
            logger.error("Invalid package version format : " + version);
        }
        this.dividedVersion = version.split("\\.");
    }

    public static int compareTo(PackageVersion v1, PackageVersion v2) {
        return PackageVersion.compareTo(v1.dividedVersion, v2.dividedVersion);
    }

    private static int compareTo(String[] v1, String[] v2) {
        int result = 0;
        int v1Length = v1.length;
        int v2Length = v2.length;
        int repeat = 0;
        String[] fixedVersion = null;
        if (v1Length != v2Length) {
            logger.trace("\tVersion lengths are different.");
            PackageVersion.versionLogging(v1, "Version 1 : ");
            PackageVersion.versionLogging(v2, "Version 2 : ");
            if (v1Length > v2Length) {
                fixedVersion = PackageVersion.setVersionFrame(v2, v1Length);
                repeat = v1Length;
                for (int i = 0; i < repeat; ++i) {
                    int v1ToInt = -1;
                    int fixedVersionToInt = -1;
                    try {
                        v1ToInt = Integer.parseInt(v1[i]);
                    }
                    catch (NumberFormatException e) {
                        PackageVersion.versionLogging(v1, "Cannot convert to integer(Version 1) : ");
                        logger.throwing(e);
                    }
                    try {
                        fixedVersionToInt = Integer.parseInt(fixedVersion[i]);
                    }
                    catch (NumberFormatException e) {
                        PackageVersion.versionLogging(v2, "Cannot convert to integer(fixedVersion) : ");
                        logger.throwing(e);
                    }
                    result = PackageVersion.compareVersionComponent(v1ToInt, fixedVersionToInt);
                    if (result == 0) {
                        continue;
                    }
                    break;
                }
            } else {
                fixedVersion = PackageVersion.setVersionFrame(v1, v2Length);
                repeat = v2Length;
                for (int i = 0; i < repeat && (result = PackageVersion.compareVersionComponent(Integer.parseInt(fixedVersion[i]), Integer.parseInt(v2[i]))) == 0; ++i) {
                }
            }
        } else {
            repeat = v1Length;
            for (int i = 0; i < repeat && (result = PackageVersion.compareVersionComponent(Integer.parseInt(v1[i]), Integer.parseInt(v2[i]))) == 0; ++i) {
            }
        }
        return result;
    }

    private static void versionLogging(String[] version, String comment) {
        String tmp = "";
        int length = version.length;
        for (int i = 0; i < length; ++i) {
            tmp = i == length - 1 ? tmp + version[i] : tmp + version[i] + ".";
        }
        logger.trace("\t" + comment + tmp);
    }

    private static String[] setVersionFrame(String[] version, int size) {
        String[] fixedVersion = new String[size];
        int vLength = version.length;
        for (int i = 0; i < size; ++i) {
            fixedVersion[i] = i < vLength ? version[i] : "0";
        }
        return fixedVersion;
    }

    public int compareTo(PackageVersion version) {
        return PackageVersion.compareTo(this.dividedVersion, version.dividedVersion);
    }

    private static int compareVersionComponent(Integer vc1, Integer vc2) {
        if (vc1 == null) {
            if (vc2 == null) {
                return 0;
            }
            return -1;
        }
        if (vc2 == null) {
            return 1;
        }
        if (vc1 > vc2) {
            return 1;
        }
        if (vc1 < vc2) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        String version = "";
        int len = this.dividedVersion.length;
        for (int i = 0; i < len; ++i) {
            version = i != len - 1 ? version + this.dividedVersion[i] + "." : version + this.dividedVersion[i];
        }
        return version;
    }
}

