/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core.config;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.config.PropertyParser;
import org.tizen.manager.core.model.Property;
import org.tizen.manager.core.model.PropertySection;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.NetworkUtil;

public class ProxyConfigFile
implements Cloneable {
    private static final String FIELD_PROXY_TYPE = "Proxy-Type";
    private static final String FIELD_PROXY_SERVER = "Proxy-Server";
    private static final String FIELD_PROXY_PORT = "Proxy-Port";
    private ArrayList<Property> mProperties = new ArrayList();
    private static final Logger logger = Log.getLogger(ProxyConfigFile.class);

    public ProxyConfigFile() {
        this.setProxyType("auto");
        this.setProxyServer("");
        this.setProxyPort("");
    }

    public Object clone() throws CloneNotSupportedException {
        ProxyConfigFile proxyConfigFile = (ProxyConfigFile)super.clone();
        proxyConfigFile.mProperties = new ArrayList();
        for (int i = 0; i < this.mProperties.size(); ++i) {
            proxyConfigFile.mProperties.add(i, (Property)this.mProperties.get(i).clone());
        }
        return proxyConfigFile;
    }

    public void load(String confPath) {
        boolean result;
        List<PropertySection> propertySections = null;
        File proxyConfFile = new File(confPath);
        if (proxyConfFile.exists()) {
            PropertyParser parser = new PropertyParser();
            propertySections = parser.readFromFile(proxyConfFile);
        }
        if (!(result = this.loadFromProperties(propertySections))) {
            logger.info("Fail to load proxy config file in this path : " + confPath);
        } else {
            logger.info("Success to load proxy config file in this path : " + confPath);
        }
    }

    private boolean loadFromProperties(List<PropertySection> propertySections) {
        if (propertySections == null || propertySections.size() == 0) {
            logger.trace("\t(propertySections == null) || (propertySections.size() == 0)");
            return false;
        }
        this.mProperties = propertySections.get(0).getProperties();
        return true;
    }

    private String getValue(String key) {
        Property property = this.getProperty(key);
        if (property != null) {
            return property.getValue();
        }
        return "";
    }

    private Property getProperty(String key) {
        if (this.mProperties != null && key != null) {
            for (int i = 0; i < this.mProperties.size(); ++i) {
                if (key.compareTo(this.mProperties.get(i).getName()) != 0) continue;
                return this.mProperties.get(i);
            }
        }
        return null;
    }

    public String getProxyType() {
        return this.getValue(FIELD_PROXY_TYPE);
    }

    public void setProxyType(String type) {
        Property property = this.getProperty(FIELD_PROXY_TYPE);
        if (property != null) {
            property.setValue(type);
        } else {
            property = new Property();
            property.setName(FIELD_PROXY_TYPE);
            property.setValue(type);
            this.mProperties.add(property);
        }
    }

    public String getProxyHost() {
        return this.getValue(FIELD_PROXY_SERVER);
    }

    public void setProxyServer(String proxyServer) {
        Property property = this.getProperty(FIELD_PROXY_SERVER);
        if (property != null) {
            property.setValue(proxyServer);
        } else {
            property = new Property();
            property.setName(FIELD_PROXY_SERVER);
            property.setValue(proxyServer);
            this.mProperties.add(property);
        }
    }

    public int getProxyPort() {
        String proxyPortStr = this.getValue(FIELD_PROXY_PORT);
        try {
            if (!proxyPortStr.isEmpty()) {
                return Integer.parseInt(proxyPortStr);
            }
            return -1;
        }
        catch (NumberFormatException e) {
            logger.trace("\tInvalid proxy port");
            return -1;
        }
    }

    public void setProxyPort(String proxyPort) {
        Property property = this.getProperty(FIELD_PROXY_PORT);
        if (property != null) {
            property.setValue(proxyPort);
        } else {
            property = new Property();
            property.setName(FIELD_PROXY_PORT);
            property.setValue(proxyPort);
            this.mProperties.add(property);
        }
    }

    public void saveProxyConfig(String configFilePath) throws UMException {
        File parentDir;
        logger.trace("\tProxy configuration save config start => " + configFilePath);
        if (configFilePath == null || configFilePath.equals("")) {
            logger.error("Invalid proxy config file path");
            return;
        }
        File configFile = new File(configFilePath);
        if (configFile.exists()) {
            if (configFile.delete()) {
                logger.trace("\tSuccess to delete proxy configuration file ==> " + configFile);
            } else {
                logger.error("Fail to delete proxy configuration file ==> " + configFile);
            }
        }
        if ((parentDir = configFile.getParentFile()) != null && !parentDir.exists()) {
            if (parentDir.mkdirs()) {
                logger.trace("\tSuccess to create parent directory of proxy configuration file ==> " + parentDir);
            } else {
                logger.error("Fail to create parent directory of proxy configuration file ==> " + parentDir);
            }
        }
        try {
            configFile.createNewFile();
        }
        catch (IOException e1) {
            logger.error("Cannot create config file => " + configFilePath);
            throw new UMException(ErrorController.ErrorCode.FAILED_TO_SAVE_CONFIG_FILE);
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(configFile));
            ArrayList<Property> properties = this.mProperties;
            for (int i = 0; i < properties.size(); ++i) {
                writer.write(properties.get(i).getName() + ": " + properties.get(i).getValue() + "\n");
            }
            writer.write("\n");
        }
        catch (IOException e) {
            logger.error("Cannot write config file");
            throw new UMException(ErrorController.ErrorCode.FAILED_TO_SAVE_CONFIG_FILE);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                logger.error("close fileoutput fail");
            }
        }
        logger.trace("\tConfig save proxy config end");
    }

    public boolean hasManualProxyInfo() {
        String server = this.getProxyHost();
        int port = this.getProxyPort();
        return server != null && !server.equals("") && port >= 0;
    }

    public URLConnection connectWithConfiguration(URL url, long skipBytes, int connectTimeout, int readTimeout) throws UMException {
        try {
            if (url.getProtocol().startsWith("file")) {
                return this.connectWithNoProxy(url, skipBytes, connectTimeout, readTimeout);
            }
            String proxyType = this.getProxyType();
            if (proxyType.equalsIgnoreCase("")) {
                proxyType = ProxyType.AUTOMATIC.toString();
            }
            if (proxyType.equalsIgnoreCase(ProxyType.DIRECT.toString())) {
                return this.connectWithNoProxy(url, skipBytes, connectTimeout, readTimeout);
            }
            if (proxyType.equalsIgnoreCase(ProxyType.AUTOMATIC.toString())) {
                return this.connectWithSystemProxy(url, skipBytes, connectTimeout, readTimeout);
            }
            if (proxyType.equalsIgnoreCase(ProxyType.MANUAL.toString()) && this.hasManualProxyInfo()) {
                return this.connectWithManualProxy(url, skipBytes, connectTimeout, readTimeout);
            }
            return this.connectWithSystemProxy(url, skipBytes, connectTimeout, readTimeout);
        }
        catch (UMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UMException(ErrorController.ErrorCode.CANNOT_CONNECT_TO_DOWNLOAD_URL, (Throwable)e);
        }
    }

    private URLConnection connectWithNoProxy(URL url, long skipBytes, int connectTimeout, int readTimeout) throws IOException {
        logger.trace("\tConnect with no proxy .=> " + url);
        return NetworkUtil.connectToURL(url, Proxy.NO_PROXY, skipBytes, connectTimeout, readTimeout);
    }

    private URLConnection connectWithSystemProxy(URL url, long skipBytes, int connectTimeout, int readTimeout) throws IOException {
        Proxy proxy;
        logger.trace("\tConnect with system proxy.=> " + url);
        List<Proxy> proxyList = NetworkUtil.getSystemProxyList(url);
        URLConnection conn = null;
        Iterator<Proxy> iterator = proxyList.iterator();
        while (iterator.hasNext() && (conn = NetworkUtil.connectToURL(url, proxy = iterator.next(), skipBytes, connectTimeout, readTimeout)) == null) {
        }
        return conn;
    }

    private URLConnection connectWithManualProxy(URL url, long skipBytes, int connectTimeout, int readTimeout) throws UMException, IOException {
        logger.trace("\tConnect with manual proxy. => " + url);
        logger.trace("\tUse proxy specified in .conf file: " + this.getProxyHost() + ":" + this.getProxyPort());
        Proxy manualProxy = null;
        try {
            manualProxy = NetworkUtil.getManualProxy(this.getProxyHost(), this.getProxyPort());
        }
        catch (UnknownHostException e) {
            logger.throwing(e);
            throw new UMException(ErrorController.ErrorCode.FAILED_TO_CONNECT_BY_MANUAL_PROXY, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            logger.throwing(e);
            throw new UMException(ErrorController.ErrorCode.FAILED_TO_CONNECT_BY_MANUAL_PROXY, (Throwable)e);
        }
        catch (SecurityException e) {
            logger.throwing(e);
            throw new UMException(ErrorController.ErrorCode.FAILED_TO_CONNECT_BY_MANUAL_PROXY, (Throwable)e);
        }
        return NetworkUtil.connectToURL(url, manualProxy, skipBytes, connectTimeout, readTimeout);
    }

    public static enum ProxyType {
        DIRECT("direct"),
        AUTOMATIC("auto"),
        MANUAL("manual");

        private String proxyType = "";

        private ProxyType(String proxyType) {
            this.proxyType = proxyType;
        }

        public String toString() {
            return this.proxyType;
        }
    }
}

