/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.jms;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.net.jms.AbstractJmsManager;

public class JmsQueueManager
extends AbstractJmsManager {
    private static final JMSQueueManagerFactory FACTORY = new JMSQueueManagerFactory();
    private QueueInfo info;
    private final String factoryBindingName;
    private final String queueBindingName;
    private final String userName;
    private final String password;
    private final Context context;

    protected JmsQueueManager(String name, Context context, String factoryBindingName, String queueBindingName, String userName, String password, QueueInfo info) {
        super(name);
        this.context = context;
        this.factoryBindingName = factoryBindingName;
        this.queueBindingName = queueBindingName;
        this.userName = userName;
        this.password = password;
        this.info = info;
    }

    public static JmsQueueManager getJmsQueueManager(String factoryName, String providerURL, String urlPkgPrefixes, String securityPrincipalName, String securityCredentials, String factoryBindingName, String queueBindingName, String userName, String password) {
        if (factoryBindingName == null) {
            LOGGER.error("No factory name provided for JmsQueueManager");
            return null;
        }
        if (queueBindingName == null) {
            LOGGER.error("No topic name provided for JmsQueueManager");
            return null;
        }
        String name = "JMSQueue:" + factoryBindingName + '.' + queueBindingName;
        return JmsQueueManager.getManager(name, FACTORY, new FactoryData(factoryName, providerURL, urlPkgPrefixes, securityPrincipalName, securityCredentials, factoryBindingName, queueBindingName, userName, password));
    }

    @Override
    public synchronized void send(Serializable object) throws Exception {
        if (this.info == null) {
            this.info = JmsQueueManager.connect(this.context, this.factoryBindingName, this.queueBindingName, this.userName, this.password, false);
        }
        try {
            super.send(object, (Session)this.info.session, (MessageProducer)this.info.sender);
        }
        catch (Exception ex) {
            this.cleanup(true);
            throw ex;
        }
    }

    @Override
    public void releaseSub() {
        if (this.info != null) {
            this.cleanup(false);
        }
    }

    private void cleanup(boolean quiet) {
        block5: {
            block4: {
                try {
                    this.info.session.close();
                }
                catch (Exception e) {
                    if (quiet) break block4;
                    LOGGER.error("Error closing session for " + this.getName(), (Throwable)e);
                }
            }
            try {
                this.info.conn.close();
            }
            catch (Exception e) {
                if (quiet) break block5;
                LOGGER.error("Error closing connection for " + this.getName(), (Throwable)e);
            }
        }
        this.info = null;
    }

    private static QueueInfo connect(Context context, String factoryBindingName, String queueBindingName, String userName, String password, boolean suppress) throws Exception {
        block4: {
            try {
                QueueConnectionFactory factory = (QueueConnectionFactory)JmsQueueManager.lookup(context, factoryBindingName);
                QueueConnection conn = userName != null ? factory.createQueueConnection(userName, password) : factory.createQueueConnection();
                QueueSession sess = conn.createQueueSession(false, 1);
                Queue queue = (Queue)JmsQueueManager.lookup(context, queueBindingName);
                QueueSender sender = sess.createSender(queue);
                conn.start();
                return new QueueInfo(conn, sess, sender);
            }
            catch (NamingException ex) {
                LOGGER.warn("Unable to locate connection factory " + factoryBindingName, (Throwable)ex);
                if (!suppress) {
                    throw ex;
                }
            }
            catch (JMSException ex) {
                LOGGER.warn("Unable to create connection to queue " + queueBindingName, (Throwable)ex);
                if (suppress) break block4;
                throw ex;
            }
        }
        return null;
    }

    private static class JMSQueueManagerFactory
    implements ManagerFactory<JmsQueueManager, FactoryData> {
        private JMSQueueManagerFactory() {
        }

        @Override
        public JmsQueueManager createManager(String name, FactoryData data) {
            try {
                Context ctx = AbstractJmsManager.createContext(data.factoryName, data.providerURL, data.urlPkgPrefixes, data.securityPrincipalName, data.securityCredentials);
                QueueInfo info = JmsQueueManager.connect(ctx, data.factoryBindingName, data.queueBindingName, data.userName, data.password, true);
                return new JmsQueueManager(name, ctx, data.factoryBindingName, data.queueBindingName, data.userName, data.password, info);
            }
            catch (NamingException ex) {
                LOGGER.error("Unable to locate resource", (Throwable)ex);
            }
            catch (Exception ex) {
                LOGGER.error("Unable to connect", (Throwable)ex);
            }
            return null;
        }
    }

    private static class QueueInfo {
        private final QueueConnection conn;
        private final QueueSession session;
        private final QueueSender sender;

        public QueueInfo(QueueConnection conn, QueueSession session, QueueSender sender) {
            this.conn = conn;
            this.session = session;
            this.sender = sender;
        }
    }

    private static class FactoryData {
        private final String factoryName;
        private final String providerURL;
        private final String urlPkgPrefixes;
        private final String securityPrincipalName;
        private final String securityCredentials;
        private final String factoryBindingName;
        private final String queueBindingName;
        private final String userName;
        private final String password;

        public FactoryData(String factoryName, String providerURL, String urlPkgPrefixes, String securityPrincipalName, String securityCredentials, String factoryBindingName, String queueBindingName, String userName, String password) {
            this.factoryName = factoryName;
            this.providerURL = providerURL;
            this.urlPkgPrefixes = urlPkgPrefixes;
            this.securityPrincipalName = securityPrincipalName;
            this.securityCredentials = securityCredentials;
            this.factoryBindingName = factoryBindingName;
            this.queueBindingName = queueBindingName;
            this.userName = userName;
            this.password = password;
        }
    }
}

