/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.exception;

public class ErrorController {
    private static ErrorCode mErrorCode = null;
    private static String errorMsg = "";

    public static void setError(ErrorCode errorCode) {
        mErrorCode = errorCode;
    }

    public static String getErrorMessage() {
        if (mErrorCode != null) {
            return mErrorCode.getErrorMessage();
        }
        return errorMsg;
    }

    public static void setErrorMessage(String msg) {
        mErrorCode = null;
        errorMsg = msg;
    }

    public static void setInfoCode(InfoCode info) {
    }

    public static enum InfoCode {
        RESTART_THE_COMPUTER("Some Tizen Studio components may not work yet.\nPlease restart your computer before using Tizen Studio.");

        private String infoMessage = "";

        private InfoCode(String arg) {
            this.infoMessage = arg;
        }

        public String getInfoMessage() {
            return this.infoMessage;
        }
    }

    public static enum ErrorCode {
        CANNOT_FIND_SHORTCUT("Cannot find the SDK shortcut in Start menu or Launch-Pad.", "- The installation of the SDK package with the shortcut is not successful.\n- The shortcut menu is not updated after the installation.", "- Try to uninstall the SDK package and install again. And check the shortcut again.\n- Try to log out your system and log in again. And check the shortcut again.", true),
        CRASH_DOWN_OF_MANAGER("The Package Manager has unexpectedly quit.", "- The libdbus-1.so, which is used by JVM in Ubuntu\u00ae, is not installed.\n- The version of the Installed JVM is earlier than 7. The SDK needs JVM 7 or later in Windows\u00ae 64bit.", "- On Ubuntu\u00ae, install the latest 'libdbus-java' package by using 'apt-get' command.\n- On Windows\u00ae 64bit, install updates by using Windows Update.", true),
        INTERNAL_ERROR("An internal Error occurred."),
        INITIALIZING_FAILED("Cannot initialize the Package Manager.", "- The configuration file for initialization fails to be loaded.", "- Check if the SDK is removed or is broken by other commands.", true),
        INVALID_OPTION_USED("Some option you specified is not valid. Check the options."),
        EXECUTABLE_PATH_REQUIRED("An argument for option '-path' is not specified.", "- If you run Package Manager by using JAR, specify the target directory where Package Manager is installed as an argument behind the option '-path'."),
        EXECUTABLE_PATH_INVALID("The execution path of Package Manager cannot be resolved.", "- Check if the SDK installation folder exists."),
        FAILTED_TO_LOAD_SDK_INFO_FILE("Cannot load SDK install information."),
        CONFIG_FILE_NOT_FOUND("The configuration file does not exist."),
        FAILED_TO_CREATE_CONFIG_FILE("Cannot create the configuration file."),
        FAILED_TO_LOAD_CONFIG_FILE("Cannot load the configuration file."),
        INVALID_REPO_URL_FORMAT("The format of repository URL is not valid."),
        FAILED_TO_DOWNLOAD_REPO_CONFIG_FILE("The repository configuration file cannot be downloaded."),
        FAILED_TO_LOAD_REPO_CONFIG_FILE("Cannot load the repository configuration file."),
        FAILED_TO_LOAD_PACKAGE_INFO_FILE("Cannot load the package information file."),
        FAILED_TO_CREATE_SHORTCUT_SCRIPT_FILE("Cannot create a shortcut script file."),
        FAILED_TO_NETWORK_CONNECT("Network disconnected"),
        FAILED_TO_SAVE_CONFIG_FILE("Cannot save the configuration file."),
        FAILED_TO_SAVE_INSTALLED_PACKAGE_INFO_FILE("Cannot save the installed package list file."),
        CANNOT_CONNECT_REPOSITORY("Cannot connect the repository server.", "- Network is not available now.\n- Connectiong to the repository server requires the proxy setting.\n- The repository server is not available.\n- The target snapshot does not exist any more when 'Auto Update' option is turned off.", "- Check if your network connection is OK.\n- Check if the proxy setting in the 'Configuration' dialog is correct.\n- Check if the repository URL information in the 'Configuration' dialog is correct.\n- Try to connect the above URL using Web browser manually. If the connection is OK, try to use the proxy setting of Web browser in the 'Configuration'.\n- If you use a remote repository URL, use the SDK image instead which can be downloaded on the Tizen Web site.\n- Select 'Auto Update' option of 'Install Option' view in the 'Configuration' dialog'.", true),
        FAILED_TO_INSTALL("Cannot install the Tizen Studio package.", "- To try it again, click Retry.\n- If the installation fails again, report the bug and send the SDK installation log file with the bug report.\n The log file is located at:\n  Windows\u00ae : %LOCALAPPDATA%\\.package-manager\\install-log\\package-manager\\*\n  Ubuntu\u00ae, MacOS\u00ae: $HOME/.package-manager/install-log/package-manager/*"),
        INSTALLATION_CANCELED_BY_USER("You have canceled the installation.", "- To try it again, click Retry."),
        INSTALLATION_CANCELED_BY_FAILURE("The installation was canceled by other failure.", "- To try it again, click Retry."),
        INSTALLATION_PAUSE_BY_USER("You have pause the installation.", "- To resume the installation, click Cancel."),
        FAILED_TO_UPDATE("Cannot install updates.", "- To try it again, click Retry.\n- If the installation fails again, report the bug and send the SDK installation log file with the bug report.\n The log file is located at:\n  Windows\u00ae : %LOCALAPPDATA%\\.package-manager\\install-log\\package-manager\\*\n  Ubuntu\u00ae, MacOS\u00ae: $HOME/.package-manager/install-log/package-manager/*"),
        UPDATING_CANCELED_BY_USER("You have canceled installing the package updates.", "- To try it again, click Retry."),
        UPDATING_CANCELED_BY_FAILURE("Updating the package was canceled by other failure.", "- To try it again, click Retry."),
        SAVING_REMOVE_SCRIPT_FAILED("Cannot save the remove-script."),
        FAILED_TO_UNINSTALL("Cannot uninstall the SDK package.", "- To try it again, click Retry.\n- If the uninstallation fails again, report the bug and send the SDK installation log file with the bug report.\n The log file is located at:\n  Windows\u00ae : %LOCALAPPDATA%\\.package-manager\\install-log\\package-manager\\*\n  Ubuntu\u00ae, MacOS\u00ae: $HOME/.package-manager/install-log/package-manager/*"),
        UNINSTALLATION_CANCELED_BY_USER("You have canceled the uninstallation.", "- To try it again, click Retry."),
        UNINSTALLATION_CANCELED_BY_FAILURE("The uninstallation was canceled by other failure.", "- To try it again, click Retry."),
        UNINSTALLATION_PAUSE_BY_USER("You have pause the uninstallation.", "- To resume the uninstallation, click Cancel."),
        DEPENDENT_PKGS_NOT_INSTALLED("The installation was stopped by failure of dependent packages."),
        CANCELED_DOWNLOADING_PACKAGE_FILE("Downloading the package file was canceled."),
        FAILED_TO_DOWNLOAD_PACKAGE_FILE("Cannot download the package file."),
        FAILED_TO_UNPACK_PACKAGE_FILE("Cannot unpack the package zip File."),
        FAILED_TO_INSTALL_FILES_TO_TARGET_FOLDER("Cannot install the file in the package to the target folder."),
        PACKAGE_INSTALL_LIST_FILE_NOT_FOUND("The file for the installed file list of the package does not exist."),
        FAILED_TO_READ_PACKAGE_INSTALL_LIST_FILE("Cannot read the file for the installed file list of the package."),
        FAILED_TO_WRITE_PACKAGE_INSTALL_LIST_FILE("Cannot write the file for the installed file list of the package."),
        MISSING_FILES_WHICH_ARE_NOT_INSTALLED_FOUND("Some files are missed while installing the package."),
        REMOVE_SCRIPT_ERROR("The error occurred while executing the remove script."),
        INSTALL_SCRIPT_ERROR("The error occurred while executing the install script."),
        DOWNLOADED_PACKAGE_FILE_SIZE_NOT_MATCHED("The downloaded size of the package file is not same as the actual size of it."),
        FAILED_TO_MBCS_PATH("The Tizen Studio from the specified as an argument does not support directory paths with multibyte characters."),
        SDK_IMAGE_FILE_NOT_FOUND("The SDK image file does not exist.", "- Please check if the SDK image file exists in the location."),
        NO_MANAGER("Cannot find the Package Manager package."),
        CANNOT_DOWNLOAD_MANAGER("Cannot download the Package Manager."),
        CANNOT_UNPACK_MANAGER("Cannot unpack the Package Manager."),
        CANNOT_EXECUTE_MANAGER("Cannot execute the Package Manager."),
        NO_UNINSTALLER("Cannot find the Uninstaller package."),
        CANNOT_DOWNLOAD_UNINSTALLER("Cannot download the Uninstaller."),
        CANNOT_UNPACK_UNINSTALLER("Cannot unpack the Uninstaller."),
        CANNOT_EXECUTE_UNINSTALLER("Cannot execute the Uninstaller."),
        PARTIAL_DOWNLOADED_FILE_NOT_FOUND("Cannot find the partially downloaded file."),
        FAILED_TO_MERGE_PARTIAL_DOWNLOADED_FILES("Failed to merge the partial downloaded files."),
        DOWNLOADED_FILE_NOT_FOUND("Cannot find the downloaded file."),
        DUPLICATED_DOWNLOADED_FILE_FOUND("There is already a downloaded file with the same name in this location. Change the file name."),
        CANNOT_CONNECT_TO_DOWNLOAD_URL("Cannot connect the download URL of the target."),
        CANNOT_DOWNLOAD_FILE("Cannot download the file."),
        CANCELED_DOWNLOADING_FILE("Downloading the file was canceled."),
        DOWNLOAD_FILE_SIZE_MISMATCH("The downloaded size of the file is not same as the actual size of it."),
        DOWNLOAD_CONNECTION_TIMEOUT("Download connection timed out."),
        CANNOT_CREATE_DOWNLOAD_FILE("Cannot create the download file."),
        FAILED_TO_UNPACK_FILE("Cannot unpack the zip File."),
        CANCELED_UNPACKING_FILE("Unpacking the file was canceled."),
        FAILED_TO_CONNECT_BY_MANUAL_PROXY("Cannot connect to the proxy server.", "Please check if the proxy information in 'Configuration' dialog is correct."),
        INVALID_PROXY_CONFIG_FOUND("Proxy value is not correct."),
        NO_ERROR("An error occurred in the Package Manager. Send Log file to Tizen Studio team."),
        SCRIPT_FAILED_BY_ERROR("An error occurred while executing the post script."),
        CANNOT_CREATE_FILE("Cannot create a file."),
        CANNOT_CREATE_TEMP_FILE("Cannot create a temporary file."),
        CANNOT_WRITE_FILE("Cannot write text to a file."),
        CANNOT_READ_TEXT_FILE("Cannot read a text file."),
        CANNOT_READ_RESOURCE("Cannot read the resource."),
        CANNOT_FIND_INSTALLED_SDK("Cannot find installed SDK. Check if the SDK is installed correctly."),
        DISTRIBUTION_NOT_FOUND("Cannot find the distribution in the repository. Please check if the distribution exists or is deleted."),
        FAIL_TO_LOAD_DISTRIBUTON_INFORMATION("Distribution information is not valid."),
        FAIL_TO_EXTRACT_SDK_IMAGE_FILE("Cannot extract Tizen Studio image file."),
        FAIL_TO_EXTRACT_EXTENSION_FILE("Cannot extract extension zip file."),
        INVALID_IMAGE_FILE_EXTENSION("The extension of SDK image file should be '.zip'."),
        INVALID_IMAGE_FILE("The SDK image file location is incorrect."),
        INVALID_IMAGE_FILE_VERSION("The SDK image has previous version of the installed packages."),
        INVALID_REPOSITORY_VERSION("The repository has previous version of the installed packages."),
        DIFFERENT_REPOSITORY_USED("The repository is not same as installed."),
        INVALID_INPUT_URL_FORMAT("Format of input URL is not valid."),
        INVALID_PORT_NUMBER("Input port number must be numeric."),
        UNAVAILABLE_INPUT_URL("Input URL is not available."),
        SPACE_IN_REPOSITORY_NAME("The repository name must not contain spaces."),
        REPOSITORY_NAME_IS_EMPTY("You have to specify the repository name."),
        HANGUL_IN_REPOSITORY_NAME("The repository name must not contain multi-bytes characters."),
        REPOSITORY_URL_IS_EMPTY("Please specify the repository URL."),
        DUPLICATED_EXTENSION_REPOSITORY("An extension repository with the same URL already exists.\nEnter a different URL."),
        DUPLICATED_EXTENSION_REPOSITORY_NAME("An extension repository with the same name already exists.\nEnter a different name."),
        DUPLICATED_EXTENSION_PACKAGE("An extension package with the same name already exists.\nCheck your extension server."),
        INVALID_EXTENSION_PACKAGE("There are invalid extension packages in extension server.\nCheck your extension server."),
        NOT_EXISTS_EXTENSION_PACKAGE("The packages are not exists in any package server(repository and extension).\nCheck your extension server."),
        JAVA_IS_NOT_VALID("Installed JDK is earlier than 8. Please install JDK 8 or higher version."),
        JAVA_PATH_IS_NOT_VALID("The environment variables for your default Java Development Kit (JDK) are not properly set to run Tizen Studio."),
        JAVA_JDK_NOT_VALID("OpenJDK is installed. Please install JDK 8 or higher version."),
        UNAVAILABLE_EXT_REP_URL("The extension repository URL is not available."),
        INVALID_EXT_REPO_FILE("The extension image file is not valid or deleted."),
        INVALID_EXT_INFO_XML_FILE("The extension information XML file is not valid or deleted."),
        INVALID_EXT_REPO_TYPE("The extension repository type is not valid. Select the repository type in 'server' or 'file'."),
        INVALID_EXT_REPO_CACHE("The extension repository cache is not valid."),
        INVALID_ALTER_INFO_XML_FILE("Cannot find the alternative information XML file because it does not exist or deleted."),
        CANNOT_DELETE_FILE("Cannot delete file."),
        CANNOT_DELETE_INSTALLED_DIRECTORY("Cannot remove installed location.", null, "- Check the files are being in used by another program.\n- Check permissions of the files.\n- After than delete the files by yourself.", true);

        private String errorMessage = "";
        private String actionMessage = null;
        private String causeMessage = null;
        private boolean isTroubleShootingCategory = false;

        private ErrorCode(String error) {
            this.errorMessage = error;
            this.actionMessage = null;
        }

        private ErrorCode(String error, String solution) {
            this.errorMessage = error;
            this.actionMessage = solution;
        }

        private ErrorCode(String error, String causeMsg, String actionMsg, boolean isTroubleShooting) {
            this.errorMessage = error;
            this.causeMessage = causeMsg;
            this.actionMessage = actionMsg;
            this.isTroubleShootingCategory = isTroubleShooting;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getCauseMessage() {
            return this.causeMessage;
        }

        public String getActionMessage() {
            return this.actionMessage;
        }

        public boolean isTroubleShootingCategory() {
            return this.isTroubleShootingCategory;
        }
    }
}

