/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.win;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.manager.util.ShellParser;
import org.tizen.manager.win.ProcessInformation;

class WindowsShellRunningProgramParser
extends ShellParser {
    private List<ProcessInformation> processList = new ArrayList<ProcessInformation>();
    private static final Logger logger = Log.getLogger(WindowsShellRunningProgramParser.class);

    WindowsShellRunningProgramParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void parseStdOut(InputStream input, String packageName) {
        BufferedReader br = null;
        try {
            String line;
            InputStreamReader isr = new InputStreamReader(input, PlatformUtil.CURRENT_CHARSET);
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                ProcessInformation pInfo = this.parseProcessInfoLine(line);
                if (pInfo == null) continue;
                this.processList.add(pInfo);
            }
        }
        catch (IOException e) {
            logger.throwing(e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    logger.error("WindowsShellRunningProgramParser fail to close output stream");
                    logger.throwing(e);
                }
            }
        }
    }

    private ProcessInformation parseProcessInfoLine(String line) {
        String[] infos = line.split("@@");
        if (infos.length < 3) {
            return null;
        }
        try {
            String[] processInfos = new String[3];
            Integer.parseInt(infos[0]);
            processInfos[0] = infos[0];
            processInfos[1] = infos[1];
            processInfos[2] = infos[2];
            return new ProcessInformation(processInfos);
        }
        catch (NumberFormatException e) {
            logger.throwing(e);
            return null;
        }
    }

    public List<ProcessInformation> getProcessInformation() {
        return this.processList;
    }
}

