/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.uninstaller.ui.wizard;

import java.io.File;
import java.util.Arrays;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tizen.manager.core.ContentProvider;
import org.tizen.manager.core.Performance;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.mac.CocoaUtil;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PathUtil;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.packagemanager.exception.ui.InsideTroubleShootingDialog;
import org.tizen.packagemanager.ui.page.custom.CallableWithMonitor;
import org.tizen.packagemanager.ui.page.custom.CustomProgressDialog;
import org.tizen.packagemanager.ui.util.UIUtil;
import org.tizen.uninstaller.ui.wizard.WizardUIMainOptions;
import org.tizen.uninstaller.ui.wizard.WizardUninstallerWindow;

public class WizardUIMain {
    private static Logger logger = null;
    private static ContentProvider contentProvider;
    private static boolean isInitialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
            }
        });
        Performance.setIMStartTime();
        Log.open();
        Log.logTitle("Manager start");
        Log.logInfo(PlatformUtil.getPlatformInfo());
        Log.logInfo("Directory of running Installer : " + PathUtil.getCurrentDir());
        logger = Log.getLogger(WizardUIMain.class);
        WizardUIMain.initializeDisplay();
        int exitCode = 0;
        try {
            logger.trace("Command line options => " + Arrays.toString(args));
            WizardUIMainOptions.loadCmdArgs(args);
            if (!WizardUIMainOptions.noJavaVersionCheck && !UIUtil.checkJavaRuntime(true)) {
                return;
            }
            if (PlatformUtil.isMacOS()) {
                logger.trace("Initializing MAC Application...");
                WizardUIMain.initializeAppForMacOS();
            }
            WizardUIMain.initialize();
            isInitialized = true;
            WizardUninstallerWindow window = new WizardUninstallerWindow(contentProvider);
            window.run();
            Shell shell = window.getShell();
            shell.pack();
            shell.open();
            while (!shell.isDisposed()) {
                try {
                    if (shell.getDisplay().readAndDispatch()) continue;
                    shell.getDisplay().sleep();
                }
                catch (Throwable e) {
                    logger.throwing(e);
                }
            }
            logger.info("after install manager window init");
        }
        catch (Throwable e) {
            logger.throwing(e);
            if (e instanceof Exception) {
                InsideTroubleShootingDialog.open(new Shell(Display.getDefault()), (Exception)e);
            } else {
                UIUtil.showErrorMessage(e.getMessage());
            }
            exitCode = 4;
        }
        finally {
            Performance.summarize();
            WizardUIMain.finalizeUIMain();
            UIUtil.disposeDisplay();
            Log.logTitle("Tizen Studio Uninstaller was terminated!");
            System.exit(exitCode);
        }
    }

    private static void initializeAppForMacOS() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Uninstaller");
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                new CocoaUtil().hidePreferencesAndAboutMenuItems();
            }
        });
    }

    private static void initializeDisplay() {
        Display display = new Display();
        display.close();
    }

    private static boolean initialize() throws UMException {
        logger.info("Start to initialize package-manager...");
        boolean isSelfUpdateNeeded = false;
        Shell initShell = new Shell(Display.getDefault());
        try {
            final CustomProgressDialog progressBar = new CustomProgressDialog(initShell, "Uninstaller", true);
            isSelfUpdateNeeded = progressBar.run(new CallableWithMonitor<Boolean>(){

                @Override
                public Boolean call(IProgressMonitor monitor) throws Exception {
                    boolean isSelfUpdateNeeded = false;
                    try {
                        monitor.beginTask("Initializing...", -1);
                        contentProvider = new ContentProvider();
                        logger.trace("Loading SDK installation information...");
                        monitor.subTask("Loading SDK installation information...");
                        contentProvider.getSDKInfo().init();
                        contentProvider.getSDKInfo().save(true);
                        logger.trace("Cleaning up temporay files and diretories...");
                        monitor.subTask("Cleaning up temporary files...");
                        PathUtil.cleanUpTempFilesAndDirectory(contentProvider.getSDKInfo());
                        logger.trace("Initializing core controller...");
                        WizardUIMain.initializeCoreControllers(progressBar);
                        logger.trace("Initializing core controller done...");
                    }
                    catch (UMException e) {
                        throw new UMException(ErrorController.ErrorCode.INITIALIZING_FAILED, (Throwable)e);
                    }
                    finally {
                        monitor.done();
                    }
                    return isSelfUpdateNeeded;
                }
            });
        }
        catch (UMException e) {
            throw e;
        }
        finally {
            initShell.close();
        }
        logger.info("Finished initializing package-manager.");
        return isSelfUpdateNeeded;
    }

    private static void finalizeUIMain() {
        if (isInitialized) {
            if (!contentProvider.getExtRepoMgr().getCurrentExtensions().isEmpty() && new File(PathUtil.getFromInstalledPath(contentProvider.getSDKInfo(), ".info")).exists()) {
                contentProvider.getExtRepoMgr().writeToFile();
            }
            PathUtil.cleanUpTempDownloadDirectory(contentProvider.getSDKInfo());
            contentProvider.getInstController().threadForceShutdown();
        }
        Performance.setIMEndTime();
        Performance.printToLogFile();
    }

    public static void initializeCoreControllers(IProgressMonitor monitor) throws UMException {
        monitor.subTask("Loading configuration...");
        logger.trace("\tInitializing configuration file.");
        contentProvider.getConfig().init();
        monitor.subTask("Loading package information...");
        logger.trace("\tInitializing package manager.");
        contentProvider.getPkgMgr().init(false);
        contentProvider.getCompMgr().init();
        logger.trace("\tInitializing install controller.");
        contentProvider.getInstController().init();
    }

    static {
        isInitialized = false;
    }
}

