/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.util;

import java.util.List;
import org.tizen.manager.core.config.SDKInfo;
import org.tizen.manager.linux.LinuxProgramController;
import org.tizen.manager.mac.MacProgramController;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.manager.win.WindowsProgramController;

public abstract class ProgramController {
    public static String PROG_NAME_IDE = "Tizen Studio";
    public static String PROG_NAME_WEB_SIM = "Web Simulator";
    public static String PROG_NAME_EMUL_MGR = "Emulator Manager";
    public static String PROG_NAME_EMUL = "Emulator";
    public static String PROG_NAME_DA = "Dynamic Analyzer";
    public static String PROG_NAME_MANAGER = "Package Manager";
    public static String PROG_NAME_MANAGER_CLI = "Package Manager CLI";
    public static String PROG_NAME_UNINSTALLER = "Tizen Studio Uninstaller";
    public static String JAR_NAME_MANAGER = "PackageManagerV2.jar";
    public static String JAR_NAME_MANAGER_CLI = "PackageManagerV2-cli.jar";
    public static String JAR_NAME_EMUL_MGR = "emulator-manager.jar";
    public static String JAR_NAME_UNINSTALLER = "PackageManagerV2-uninstaller.jar";
    private static LinuxProgramController linuxController = null;
    private static WindowsProgramController windowsController = null;
    private static MacProgramController macController = null;

    public abstract List<String> getSDKProcessList();

    public abstract List<String> getPkgMgrProcessList();

    public static ProgramController createProgramController(SDKInfo sdkInfo) {
        if (PlatformUtil.CURRENT_PLATFORM == 1 || PlatformUtil.CURRENT_PLATFORM == 4) {
            if (linuxController == null) {
                linuxController = new LinuxProgramController(sdkInfo);
            }
            return linuxController;
        }
        if (PlatformUtil.CURRENT_PLATFORM == 8 || PlatformUtil.CURRENT_PLATFORM == 16) {
            if (windowsController == null) {
                windowsController = new WindowsProgramController(sdkInfo);
            }
            return windowsController;
        }
        if (PlatformUtil.CURRENT_PLATFORM == 64) {
            if (macController == null) {
                macController = new MacProgramController(sdkInfo);
            }
            return macController;
        }
        if (linuxController == null) {
            linuxController = new LinuxProgramController(sdkInfo);
        }
        return linuxController;
    }

    public static boolean isIgnoreProcess(String processString) {
        return (processString = processString.toLowerCase().trim()).contains("sdb");
    }
}

