/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.model.Property;
import org.tizen.manager.core.model.PropertySection;
import org.tizen.manager.util.Log;

public class PropertyParser {
    private static final Logger logger = Log.getLogger(PropertyParser.class);
    private static final String DEFAULT_SECTION_SEPARATOR = "";
    private static final String DEFAULT_NAMEVALUE_SEPARATOR = ":";
    private String mSectionSeparator = "";
    private String mNamevalueSeparator = ":";

    public void setSectionSeparator(String separator) {
        this.mSectionSeparator = separator;
    }

    public void setNamevalueSeparator(String separator) {
        this.mNamevalueSeparator = separator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PropertySection> readFromFile(String propertyFilePath, boolean displayLog) {
        logger.info("begin parsing the config file. => " + propertyFilePath);
        File file = new File(propertyFilePath);
        if (!file.exists()) {
            logger.trace("\tFail to parse the config file");
            return null;
        }
        ArrayList<PropertySection> pSectionReturn = null;
        PropertySection pSection = null;
        ArrayList<Property> pFieldList = null;
        Property pField = null;
        BufferedReader bReader = null;
        String sReadData = null;
        FileInputStream fis = null;
        InputStreamReader isr = null;
        try {
            pFieldList = new ArrayList<Property>();
            pSectionReturn = new ArrayList<PropertySection>();
            fis = new FileInputStream(propertyFilePath);
            isr = new InputStreamReader((InputStream)fis, "UTF-8");
            bReader = new BufferedReader(isr);
            while (true) {
                sReadData = bReader.readLine();
                if (!propertyFilePath.endsWith(".info") && displayLog) {
                    logger.trace("\t" + sReadData);
                }
                if (sReadData == null) {
                    if (pFieldList.size() > 0) {
                        pSection = new PropertySection();
                        pSection.setProperties(pFieldList);
                        pSectionReturn.add(pSection);
                    }
                    break;
                }
                if (!sReadData.startsWith(" ")) {
                    sReadData = sReadData.trim();
                }
                if (this.mSectionSeparator.equals(sReadData)) {
                    if (pFieldList.size() <= 0) continue;
                    pSection = new PropertySection();
                    pSection.setProperties(pFieldList);
                    pSectionReturn.add(pSection);
                    pFieldList = new ArrayList();
                    continue;
                }
                Property tempProperty = this.parseNameValue(sReadData);
                if (tempProperty != null) {
                    if (null != tempProperty.getName()) {
                        pFieldList.add(tempProperty);
                        pField = tempProperty;
                        continue;
                    }
                    if (pField == null) continue;
                    if (sReadData.equalsIgnoreCase(" .")) {
                        pField.setValue(pField.getValue() + '\n');
                        continue;
                    }
                    pField.setValue(pField.getValue() + '\n' + sReadData.trim());
                    continue;
                }
                logger.error("Cannot parse name and value from repository.info. (read line => " + sReadData + ")");
            }
        }
        catch (Throwable e) {
            logger.error(e.getMessage());
            pSectionReturn = null;
        }
        finally {
            try {
                if (bReader != null) {
                    bReader.close();
                }
                if (isr != null) {
                    isr.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
        }
        logger.info("finish parsing the config file. == > " + propertyFilePath);
        return pSectionReturn;
    }

    private Property parseNameValue(String nameAndValue) {
        Property property = new Property();
        String sBeforeSetperation = null;
        String sAfterSetperation = null;
        int iSetperationCount = nameAndValue.indexOf(this.mNamevalueSeparator);
        int isKeyValueLength = nameAndValue.length();
        if (" ".equals(nameAndValue.substring(0, 1))) {
            property.setValue(nameAndValue.trim());
        } else if (iSetperationCount == -1) {
            property.setValue(nameAndValue.trim());
        } else if (iSetperationCount == isKeyValueLength) {
            property.setName(nameAndValue.substring(0, isKeyValueLength - 1).trim());
        } else if (iSetperationCount == 0) {
            property.setValue(nameAndValue.substring(1, isKeyValueLength).trim());
        } else {
            sBeforeSetperation = nameAndValue.substring(0, iSetperationCount).trim();
            sAfterSetperation = nameAndValue.substring(iSetperationCount + this.mNamevalueSeparator.length(), nameAndValue.length()).trim();
            property.setName(sBeforeSetperation);
            property.setValue(sAfterSetperation);
        }
        return property;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeToFile(List<PropertySection> properties, String targetPath) throws IOException {
        if (properties == null || targetPath == null || targetPath.isEmpty()) {
            return false;
        }
        boolean bReturn = false;
        BufferedWriter fWriter = null;
        ArrayList<Property> pList = null;
        Property pField = null;
        String sLine = "\n";
        String sSpace = " ";
        String sTemp = null;
        String sPrintTemp = null;
        File targetFile = new File(targetPath);
        File parentDir = targetFile.getParentFile();
        if (parentDir != null && !parentDir.exists()) {
            if (parentDir.mkdirs()) {
                logger.trace("\tSuccess to create parent directory ==> " + parentDir);
            } else {
                logger.error("Fail to create parent directory ==> " + parentDir);
            }
        }
        if (!targetFile.exists()) {
            targetFile.createNewFile();
        }
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        try {
            if (properties.size() == 0) {
                if (targetFile.delete()) {
                    logger.trace("\tSuccess to remove file ==> " + targetFile);
                } else {
                    logger.error("Fail to remove file ==> " + targetFile);
                }
                if (parentDir != null && parentDir.getName().equals(".sdkconfig") && !parentDir.delete()) {
                    logger.error("Fail to delete file ==> " + parentDir);
                }
            } else {
                targetFile.setWritable(true);
                targetFile.setReadable(true);
                fos = new FileOutputStream(targetPath);
                osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                fWriter = new BufferedWriter(osw);
                for (int i = 0; i < properties.size(); ++i) {
                    pList = properties.get(i).getProperties();
                    for (int j = 0; j < pList.size(); ++j) {
                        pField = pList.get(j);
                        if (pField.getValue().indexOf(sLine) > -1) {
                            fWriter.write(pField.getName());
                            fWriter.write(this.mNamevalueSeparator);
                            sTemp = pField.getValue();
                            while (sTemp.indexOf(sLine) > -1) {
                                sPrintTemp = sTemp.substring(0, sTemp.indexOf(sLine) + 1);
                                if (sPrintTemp != null && sPrintTemp.equals(sLine)) {
                                    fWriter.write(" .\n");
                                } else {
                                    fWriter.write(sSpace + sPrintTemp);
                                }
                                sTemp = sTemp.substring(sTemp.indexOf(sLine) + 1, sTemp.length());
                            }
                            fWriter.write(sSpace + sTemp);
                            fWriter.write(sLine);
                            continue;
                        }
                        fWriter.write(pField.getName());
                        fWriter.write(this.mNamevalueSeparator);
                        fWriter.write(sSpace + pField.getValue());
                        fWriter.write(sLine);
                    }
                    fWriter.write(sLine);
                    fWriter.flush();
                }
            }
        }
        finally {
            if (fWriter != null) {
                fWriter.close();
            }
            if (osw != null) {
                osw.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
        return bReturn;
    }

    public List<PropertySection> readFromFile(File installed) {
        return this.readFromFile(installed.getAbsolutePath(), true);
    }

    public List<PropertySection> readFromFile(File installed, boolean displayLog) {
        return this.readFromFile(installed.getAbsolutePath(), displayLog);
    }
}

