/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.uninstaller.ui.wizard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.tizen.manager.core.ContentProvider;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.util.Log;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;
import org.tizen.uninstaller.ui.wizard.WizardCompletePage;
import org.tizen.uninstaller.ui.wizard.WizardReadyPage;
import org.tizen.uninstaller.ui.wizard.WizardUninstallerWindow;
import org.tizen.uninstaller.ui.wizard.WizardUninstallingPage;

public class WizardPageMaster {
    private StackLayout stackLayout;
    private Composite readyPage;
    private Composite uninstallingPage;
    private Composite completedPage;
    private WizardUninstallerWindow.UNINSTALLER_PAGES currentPageType;
    private static final Logger logger = Log.getLogger(WizardPageMaster.class);
    HashMap<String, String> errorMap = new HashMap();
    private List<Composite> pageLists = new ArrayList<Composite>();

    public WizardPageMaster(ContentProvider contenProvider, Composite mainComposite, StackLayout stackLayout, WizardUIResourceHandler uiResource) throws UMException {
        logger.trace("Page Master constructor is called.");
        this.stackLayout = stackLayout;
        this.readyPage = new WizardReadyPage(contenProvider, mainComposite, uiResource, 0, this);
        this.pageLists.add(this.readyPage);
        this.uninstallingPage = new WizardUninstallingPage(contenProvider, mainComposite, uiResource, 0, this);
        this.pageLists.add(this.uninstallingPage);
        this.completedPage = new WizardCompletePage(contenProvider, mainComposite, uiResource, 0, this);
        this.pageLists.add(this.completedPage);
        logger.trace("Page Master constructor is end.");
    }

    public void enablePages(WizardUninstallerWindow.UNINSTALLER_PAGES targetPages) {
        logger.trace("enablePages start => " + targetPages.name());
        this.currentPageType = targetPages;
        switch (targetPages) {
            case READY_PAGE: {
                this.enablePageAndDisableOthers(this.readyPage);
                break;
            }
            case UNINSTALLING_PAGE: {
                this.enablePageAndDisableOthers(this.uninstallingPage);
                break;
            }
            case COMPLETED_PAGE: {
                this.enablePageAndDisableOthers(this.completedPage);
                break;
            }
        }
        logger.trace("enablePages end => " + targetPages.name());
    }

    private void enablePageAndDisableOthers(Composite exceptPages) {
        this.stackLayout.topControl = exceptPages;
        for (Composite item : this.pageLists) {
            if (item.equals(exceptPages)) continue;
            item.setEnabled(false);
            item.setVisible(false);
        }
        exceptPages.setEnabled(true);
        exceptPages.setVisible(true);
        exceptPages.setFocus();
    }

    public boolean sendCloseEvent() {
        boolean result = true;
        switch (this.currentPageType) {
            case READY_PAGE: {
                result = ((WizardReadyPage)this.readyPage).workEventClose();
                break;
            }
            case UNINSTALLING_PAGE: {
                result = ((WizardUninstallingPage)this.uninstallingPage).workEventClose();
                break;
            }
            case COMPLETED_PAGE: {
                result = ((WizardCompletePage)this.completedPage).workEventClose();
                break;
            }
        }
        return result;
    }

    public void addError(String packageName, String value) {
        this.errorMap.put(packageName, value);
    }

    public void removeError(String packageName) {
        this.errorMap.remove(packageName);
    }

    public HashMap<String, String> getErrorMap() {
        return this.errorMap;
    }
}

