/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.util;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tizen.manager.core.CompatController;
import org.tizen.manager.core.ContentProvider;
import org.tizen.manager.core.ExtRepositoryManager;
import org.tizen.manager.core.config.SDKInfo;
import org.tizen.manager.core.model.ExtensionInformation;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.pkg.Component;
import org.tizen.manager.pkg.Package;
import org.tizen.manager.pkg.PackageManager;
import org.tizen.manager.pkg.PackageSet;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.manager.util.ProgramController;
import org.tizen.packagemanager.ui.UIMainOptions;
import org.tizen.packagemanager.ui.UseUninstallerDialog;
import org.tizen.packagemanager.ui.page.custom.CustomMessageDialog;

public class UIUtil {
    private static final String SDK_NAME = "Tizen Studio";
    private static Logger logger = Log.getLogger(UIUtil.class);

    public static List<String> findRunningProcess(SDKInfo sdkInfo, Shell shell) {
        ProgramController controller = ProgramController.createProgramController(sdkInfo);
        List<String> sdkProcessList = controller.getSDKProcessList();
        ArrayList<String> conflictProcesses = new ArrayList<String>();
        for (String progName : sdkProcessList) {
            if (progName.equals(ProgramController.PROG_NAME_MANAGER)) continue;
            conflictProcesses.add(progName);
        }
        if (!conflictProcesses.isEmpty()) {
            String msg = "";
            for (String processString : conflictProcesses) {
                msg = msg + "\t" + processString + "\n";
            }
            CustomMessageDialog.showDlg(shell, "Warning", String.format("SDK programs are running under installed location.\n%sClose the running programs.", msg), CustomMessageDialog.DialogType.WARNING, true);
            if (UIMainOptions.automaticInstallation) {
                return UIUtil.findRunningProcess(sdkInfo, shell);
            }
            return conflictProcesses;
        }
        return conflictProcesses;
    }

    public static List<String> findRunningProcessOnUninstaller(SDKInfo sdkInfo, Shell shell) {
        ProgramController controller = ProgramController.createProgramController(sdkInfo);
        List<String> sdkProcessList = controller.getSDKProcessList();
        ArrayList<String> conflictProcesses = new ArrayList<String>();
        for (String progName : sdkProcessList) {
            if (progName.equals(ProgramController.PROG_NAME_UNINSTALLER)) continue;
            conflictProcesses.add(progName);
        }
        if (!conflictProcesses.isEmpty()) {
            String msg = "";
            for (String processString : conflictProcesses) {
                msg = msg + "\t" + processString + "\n";
            }
            CustomMessageDialog.showDlg(shell, "Warning", String.format("SDK programs are running under installed location.\n%sClose the running programs.", msg), CustomMessageDialog.DialogType.WARNING, true);
            return conflictProcesses;
        }
        return conflictProcesses;
    }

    public static boolean checkJavaRuntime(boolean isUninstaller) {
        Shell shell;
        Shell shell2;
        int ret;
        String correctJavaSystemPath;
        logger.trace("Checking java");
        boolean result = false;
        if (!isUninstaller && !(correctJavaSystemPath = PlatformUtil.isCorrectJavaSystemPath()).isEmpty() && (ret = CustomMessageDialog.showDlg(shell2 = new Shell(Display.getDefault(), 16384), SDK_NAME, correctJavaSystemPath + "Do you want to continue?", CustomMessageDialog.DialogType.CONFIRM, false)) == 128) {
            return false;
        }
        if (!isUninstaller && PlatformUtil.isInstalledOpenJDK()) {
            logger.trace("OpenJDK is installed.");
            if (PlatformUtil.isAvailOpenJDK()) {
                logger.trace("OpenJDK available.");
                result = true;
            } else {
                logger.trace("Do not using OpenJDK.");
                shell = new Shell(Display.getDefault(), 16384);
                int ret2 = CustomMessageDialog.showDlg(shell, SDK_NAME, "OpenJDK is installed. The Package Manager and Tizen Studio do not support the OpenJDK on current OS version. You must install the Oracle JDK 8 or later.\nPlease go to 'http://www.oracle.com/technetwork/java/javase/downloads' and download a JDK.\nDo you want to visit?", CustomMessageDialog.DialogType.CONFIRM, false);
                if (ret2 == 128) {
                    logger.trace("OpenJDK is installed. - User select stop to install.");
                    result = false;
                } else {
                    logger.trace("OpenJDK is installed. - User select continue to install.");
                    if (Desktop.isDesktopSupported()) {
                        try {
                            Desktop.getDesktop().browse(new URI("http://www.oracle.com/technetwork/java/javase/downloads"));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        catch (URISyntaxException e) {
                            e.printStackTrace();
                        }
                    }
                    result = false;
                }
                shell.dispose();
                if (!result) {
                    return result;
                }
            }
        } else {
            logger.trace("Current java is working java - not open jdk");
            result = true;
        }
        if (PlatformUtil.isUnderJava8()) {
            logger.trace("Installed java version is under 1.7.");
            shell = new Shell(Display.getDefault(), 16384);
            int ret3 = CustomMessageDialog.showDlg(shell, SDK_NAME, "The installed JDK is lower than 8.\nTo use the Tizen SDK, you need to install the JDK 8 or later.\nPlease go to 'http://www.oracle.com/technetwork/java/javase/downloads' and download a JDK.\nDo you want to visit?", CustomMessageDialog.DialogType.CONFIRM, false);
            if (ret3 == 128) {
                logger.trace("Installed java version is under 1.8. - User select stop to run.");
                result = false;
            } else {
                logger.trace("Installed java version is under 1.8. - User move download url.");
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(new URI("http://www.oracle.com/technetwork/java/javase/downloads"));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                }
                result = false;
            }
            shell.dispose();
            if (!result) {
                return result;
            }
        } else {
            logger.trace("Current java is working java version - not java 1.6");
            result = true;
        }
        return result;
    }

    public static void showErrorMessage(String msg) {
        Shell shell = new Shell(Display.getDefault());
        CustomMessageDialog.showDlg(shell, SDK_NAME, msg, CustomMessageDialog.DialogType.ERROR, true);
        shell.dispose();
    }

    public static void disposeDisplay() {
        Display display = Display.getDefault();
        if (display != null && !display.isDisposed()) {
            display.dispose();
        }
    }

    public static boolean checkIfRepositoryIsOutdated(Shell shell, PackageManager pkgmgr) {
        if (pkgmgr.areRepoPackagesOutdated()) {
            CustomMessageDialog.showDlg(shell, "Warning", "You are trying to install a previous version of the installed packages. It is not allowed to install previous version of packages.", CustomMessageDialog.DialogType.WARNING, true);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compatUninstaller(ContentProvider contentProvider) throws UMException {
        CompatController compatController = new CompatController(contentProvider);
        if (compatController.compatUninstaller()) {
            Shell shell = new Shell(Display.getDefault());
            try {
                UseUninstallerDialog dlg = new UseUninstallerDialog(shell);
                int ret = dlg.open();
                if (ret == 0) {
                    if (dlg.getSelectionResult()) {
                        compatController.workUninstallerForCompat();
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                shell.dispose();
            }
        }
        return false;
    }

    public static boolean checkExtensionStatusOfInstallable(ContentProvider contentProvider, Shell shell, ArrayList<Component> component) {
        for (Component testComponent : component) {
            if (UIUtil.checkExtensionStatusOfInstallable(contentProvider, shell, testComponent)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkExtensionStatusOfInstallable(ContentProvider contentProvider, Shell shell, Component component) {
        boolean checkResult = true;
        if (!contentProvider.getRepoMgr().isNetworkOK()) {
            int result = 64;
            String msg = "Main repository is not available.\nSDK will not work properly.\nDo you want to continue?";
            result = CustomMessageDialog.showDlg(shell, "Package Manager", msg, CustomMessageDialog.DialogType.WARNING, false);
            if (result == 128) {
                return false;
            }
        }
        PackageSet installedPackages = contentProvider.getPkgMgr().getInstalledPackages();
        for (Object package1 : installedPackages) {
            Package packageByName;
            if (!((Package)package1).isExtensionPackage() || (packageByName = contentProvider.getPkgMgr().getRepoPackages().getPackageByName(((Package)package1).getPackageName())) == null) continue;
            String msg = "Duplicated components are already installed in \"Extras\".\nSDK will not work properly.\nPlease remove installed extension component.\nComponent : [" + ((Package)package1).getPackageName() + "].";
            CustomMessageDialog.showDlg(shell, "Package Manager", msg, CustomMessageDialog.DialogType.ERROR, false);
            return false;
        }
        if (component.isVirtual() && "Extras".equals(component.getDisplayName())) {
            if (component.hasChildren()) {
                ArrayList<Component> children = component.getChildren();
                for (Component childComponent : children) {
                    int result;
                    Package recentPackage = childComponent.getRecentPackage();
                    if (!recentPackage.isExtensionPackage() || (result = UIUtil.checkExtensionPackageServerAvaliable(contentProvider, shell, recentPackage)) != 128) continue;
                    return false;
                }
            }
        } else {
            int result;
            Package recentPackage = component.getRecentPackage();
            if (recentPackage.isExtensionPackage() && (result = UIUtil.checkExtensionPackageServerAvaliable(contentProvider, shell, recentPackage)) == 128) {
                return false;
            }
        }
        return checkResult;
    }

    private static int checkExtensionPackageServerAvaliable(ContentProvider contenProvider, Shell shell, Package recentPackage) {
        int result = 64;
        ArrayList<Package> notExistPackageList = UIUtil.getNotExistPackageList(contenProvider, recentPackage);
        if (notExistPackageList.size() > 0) {
            String msg = "Extension repository is not available for under packages.\n" + notExistPackageList + "\n" + "If you continue to install or update, SDK will not work properly.\n" + "Do you want to continue?";
            result = CustomMessageDialog.showDlg(shell, "Package Manager", msg, CustomMessageDialog.DialogType.WARNING, false);
        }
        return result;
    }

    private static ArrayList<Package> getNotExistPackageList(ContentProvider contenProvider, Package recentPackage) {
        ArrayList<Package> returnList = new ArrayList<Package>();
        Collection<String> dependentPackageNames = recentPackage.getDependentPackageNames();
        for (String depName : dependentPackageNames) {
            Package depPkg = contenProvider.getPkgMgr().getPackageByName(depName);
            if (depPkg == null || !depPkg.isExtensionPackage() || UIUtil.checkExistsInOtherExtra(contenProvider.getExtRepoMgr(), depPkg)) continue;
            returnList.add(depPkg);
        }
        return returnList;
    }

    private static boolean checkExistsInOtherExtra(ExtRepositoryManager extRepo, Package packageByName) {
        ArrayList<ExtensionInformation> currentExtensions = extRepo.getCurrentExtensions();
        if (currentExtensions != null) {
            for (ExtensionInformation extensionInformation : currentExtensions) {
                PackageSet extPackageSet;
                if (!extensionInformation.getActivateStatus() || (extPackageSet = extensionInformation.getExtPackageSet()) == null || !extPackageSet.contains(packageByName)) continue;
                return true;
            }
        }
        return false;
    }
}

