/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.win32.OS;

public final class Color
extends Resource {
    public int handle;

    Color(Device device) {
        super(device);
    }

    public Color(Device device, int n, int n2, int n3) {
        super(device);
        this.init(n, n2, n3);
        this.init();
    }

    public Color(Device device, RGB rGB) {
        super(device);
        if (rGB == null) {
            SWT.error(4);
        }
        this.init(rGB.red, rGB.green, rGB.blue);
        this.init();
    }

    void destroy() {
        int n;
        int[] nArray;
        int n2 = this.device.hPalette;
        if (n2 != 0 && (nArray = this.device.colorRefCount)[n = OS.GetNearestPaletteIndex(n2, this.handle)] > 0) {
            int n3 = n;
            nArray[n3] = nArray[n3] - 1;
        }
        this.handle = -1;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Color)) {
            return false;
        }
        Color color = (Color)object;
        return this.device == color.device && (this.handle & 0xFFFFFF) == (color.handle & 0xFFFFFF);
    }

    public int getBlue() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (this.handle & 0xFF0000) >> 16;
    }

    public int getGreen() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (this.handle & 0xFF00) >> 8;
    }

    public int getRed() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle & 0xFF;
    }

    public RGB getRGB() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGB(this.handle & 0xFF, (this.handle & 0xFF00) >> 8, (this.handle & 0xFF0000) >> 16);
    }

    public int hashCode() {
        return this.handle;
    }

    void init(int n, int n2, int n3) {
        int n4;
        if (n > 255 || n < 0 || n2 > 255 || n2 < 0 || n3 > 255 || n3 < 0) {
            SWT.error(5);
        }
        this.handle = n & 0xFF | (n2 & 0xFF) << 8 | (n3 & 0xFF) << 16;
        int n5 = this.device.hPalette;
        if (n5 == 0) {
            return;
        }
        int[] nArray = this.device.colorRefCount;
        int n6 = OS.GetNearestPaletteIndex(n5, this.handle);
        byte[] byArray = new byte[4];
        OS.GetPaletteEntries(n5, n6, 1, byArray);
        if (byArray[0] == (byte)n && byArray[1] == (byte)n2 && byArray[2] == (byte)n3) {
            int n7 = n6;
            nArray[n7] = nArray[n7] + 1;
            return;
        }
        for (n4 = 0; n4 < nArray.length; ++n4) {
            if (nArray[n4] != 0) continue;
            n6 = n4;
            break;
        }
        if (n4 == nArray.length) {
            this.handle = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16;
        } else {
            byArray = new byte[]{(byte)(n & 0xFF), (byte)(n2 & 0xFF), (byte)(n3 & 0xFF), 0};
            OS.SetPaletteEntries(n5, n6, 1, byArray);
        }
        int n8 = n6;
        nArray[n8] = nArray[n8] + 1;
    }

    public boolean isDisposed() {
        return this.handle == -1;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Color {*DISPOSED*}";
        }
        return "Color {" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + "}";
    }

    public static Color win32_new(Device device, int n) {
        Color color = new Color(device);
        color.handle = n;
        return color;
    }
}

