/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.uninstaller.ui.wizard;

import java.io.File;
import java.util.HashMap;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.tizen.manager.core.ContentProvider;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.IMShellCommandFail;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PathUtil;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.manager.util.ShellParser;
import org.tizen.manager.util.ShellUtil;
import org.tizen.packagemanager.exception.ui.InsideTroubleShootingDialog;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;
import org.tizen.uninstaller.ui.wizard.WizardCommonPage;
import org.tizen.uninstaller.ui.wizard.WizardPageMaster;

public class WizardCompletePage
extends WizardCommonPage {
    private static final Logger logger = Log.getLogger(WizardCompletePage.class);
    private StackLayout stackLayout = null;
    private Composite messageContainer = null;
    private Composite keystoreComosite = null;
    private Composite normalComosite = null;
    private ContentProvider contentProvider;
    boolean isResetMessage = false;

    public WizardCompletePage(ContentProvider contentProvider, Composite parentComposite, WizardUIResourceHandler uiResource, int swtOption, WizardPageMaster pageMaster) throws UMException {
        super(contentProvider, parentComposite, swtOption, uiResource, pageMaster);
        this.contentProvider = contentProvider;
        this.infoLabel.setText("Uninstallation complete");
        this.createCenterContainer();
        this.handleCompositeEvent();
        this.handleBottomEvent();
    }

    private void createCenterContainer() {
        Rectangle messageBounds = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_CENTER);
        this.messageContainer = new Composite(this.centerContainer, 0x20000000);
        FormData messageContainerFormData = new FormData();
        messageContainerFormData.left = new FormAttachment(this.centerContainer, messageBounds.x, 0x1000000);
        messageContainerFormData.top = new FormAttachment(this.centerContainer, messageBounds.y, 0x1000000);
        messageContainerFormData.width = messageBounds.width;
        messageContainerFormData.height = messageBounds.height;
        this.messageContainer.setLayoutData(messageContainerFormData);
        this.stackLayout = new StackLayout();
        this.messageContainer.setLayout(this.stackLayout);
        this.createMessageComposites(this.messageContainer);
    }

    private void createMessageComposites(Composite container) {
        this.createKeystoreMessageComposites(container);
        this.createNormalMessageComposites(container);
    }

    private Composite createKeystoreMessageComposites(Composite container) {
        this.keystoreComosite = new Composite(container, 0);
        Rectangle messageBounds = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_CENTER);
        FormData formData = new FormData();
        formData.left = new FormAttachment(container, messageBounds.x, 0x1000000);
        formData.top = new FormAttachment(container, messageBounds.y, 0x1000000);
        formData.width = messageBounds.width;
        formData.height = messageBounds.height;
        this.keystoreComosite.setLayoutData(formData);
        this.keystoreComosite.setLayout(new GridLayout());
        Composite containerComp = new Composite(this.keystoreComosite, 0);
        GridData gd = new GridData(0x1000000, 0x1000000, true, true);
        Rectangle rect = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_COMPLETE_CONFIRM_MESSAGE);
        gd.widthHint = rect.width;
        containerComp.setLayoutData(gd);
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = rect.y;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        containerComp.setLayout(layout);
        Label thkMsgLabel = new Label(containerComp, 64);
        thkMsgLabel.setFont(this.uiResource.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1));
        thkMsgLabel.setForeground(this.uiResource.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33));
        thkMsgLabel.setText("Thank you for using the Tizen Studio");
        gd = new GridData(0x1000000, 0x1000000, true, false);
        thkMsgLabel.setLayoutData(gd);
        String certMessage = String.format("Your Tizen authorization files (author and distributor certificates) are still located in the %s directory.", uninstallContext.getKeystorePath());
        StyledText certiMsgText = new StyledText(containerComp, 66);
        certiMsgText.setFont(this.uiResource.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        certiMsgText.setAlignment(0x1000000);
        certiMsgText.setCaret(null);
        gd = new GridData(0x1000000, 0x1000000, true, false);
        gd.widthHint = rect.width;
        certiMsgText.setLayoutData(gd);
        certiMsgText.setText(certMessage);
        return this.keystoreComosite;
    }

    private Composite createNormalMessageComposites(Composite container) {
        this.normalComosite = new Composite(container, 0);
        Rectangle messageBounds = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_CENTER);
        FormData formData = new FormData();
        formData.left = new FormAttachment(container, messageBounds.x, 0x1000000);
        formData.top = new FormAttachment(container, messageBounds.y, 0x1000000);
        formData.width = messageBounds.width;
        formData.height = messageBounds.height;
        this.normalComosite.setLayoutData(formData);
        this.normalComosite.setLayout(new GridLayout());
        Composite containerComp = new Composite(this.normalComosite, 0);
        GridData gd = new GridData(0x1000000, 0x1000000, true, true);
        Rectangle rect = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_COMPLETE_CONFIRM_MESSAGE);
        gd.widthHint = rect.width;
        containerComp.setLayoutData(gd);
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = rect.height;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        containerComp.setLayout(layout);
        Image tizenIconImage = this.uiResource.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_INSTALL_IC_SDK);
        Label tizenIconLabel = new Label(containerComp, 0);
        gd = new GridData(0x1000000, 0x1000000, true, false);
        gd.widthHint = tizenIconImage.getBounds().width;
        gd.heightHint = tizenIconImage.getBounds().height;
        tizenIconLabel.setLayoutData(gd);
        tizenIconLabel.setImage(tizenIconImage);
        Label thkMsgLabel = new Label(containerComp, 64);
        thkMsgLabel.setFont(this.uiResource.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1));
        thkMsgLabel.setForeground(this.uiResource.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33));
        thkMsgLabel.setText("Thank you for using the Tizen Studio");
        gd = new GridData(0x1000000, 0x1000000, true, false);
        thkMsgLabel.setLayoutData(gd);
        return this.normalComosite;
    }

    private void handleCompositeEvent() {
        this.messageContainer.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent arg0) {
                logger.trace(arg0);
                if (!WizardCompletePage.this.isResetMessage) {
                    WizardCompletePage.this.keystoreComosite.setVisible(false);
                    WizardCompletePage.this.keystoreComosite.setEnabled(false);
                    if (!WizardCommonPage.uninstallContext.shouldDeleteKeystore().booleanValue() && WizardCommonPage.uninstallContext.isKeystoreExist().booleanValue()) {
                        ((WizardCompletePage)WizardCompletePage.this).stackLayout.topControl = WizardCompletePage.this.keystoreComosite;
                        WizardCompletePage.this.normalComosite.setVisible(false);
                        WizardCompletePage.this.normalComosite.setEnabled(false);
                        WizardCompletePage.this.keystoreComosite.setVisible(true);
                        WizardCompletePage.this.keystoreComosite.setEnabled(true);
                    } else {
                        ((WizardCompletePage)WizardCompletePage.this).stackLayout.topControl = WizardCompletePage.this.normalComosite;
                        WizardCompletePage.this.normalComosite.setVisible(true);
                        WizardCompletePage.this.normalComosite.setEnabled(true);
                        WizardCompletePage.this.keystoreComosite.setVisible(false);
                        WizardCompletePage.this.keystoreComosite.setEnabled(false);
                    }
                    WizardCompletePage.this.isResetMessage = true;
                }
            }
        });
    }

    private void handleBottomEvent() {
        this.firstButton.setEnabled(false);
        this.firstButton.setVisible(false);
        this.secondButton.setText("Finish");
        this.handleSecondButtonEvent(this.secondButton);
    }

    private void handleSecondButtonEvent(Button quitButton) {
        quitButton.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                logger.trace("User click done button widgetSelected => " + arg0);
                String targetDir = WizardCompletePage.this.contentProvider.getConfig().getTargetDir();
                File installedDir = new File(targetDir);
                if (installedDir.exists() && installedDir.isDirectory()) {
                    HashMap<String, String> errorMap = WizardCompletePage.this.wizardPageMaster.getErrorMap();
                    String errorMsg = "";
                    Set<String> keySet = errorMap.keySet();
                    for (String key : keySet) {
                        errorMsg = errorMsg + String.format("[%s] :  %s", key, errorMap.get(key));
                    }
                    UMException umException = new UMException(ErrorController.ErrorCode.CANNOT_DELETE_INSTALLED_DIRECTORY, errorMsg);
                    InsideTroubleShootingDialog.open(WizardCompletePage.this.parent.getShell(), umException);
                }
                if (PlatformUtil.isWindows()) {
                    try {
                        String[] cmd = new String[]{"cmd", "/c", "rmdir", "/s", "/q", installedDir.getAbsolutePath()};
                        ShellUtil.execute(cmd, new ShellParser());
                    }
                    catch (IMShellCommandFail e) {
                        logger.throwing(e);
                    }
                } else {
                    logger.trace("Begin to remove installed SDK");
                    PathUtil.remove(installedDir.getAbsolutePath());
                }
                if (WizardCommonPage.uninstallContext.shouldDeleteSDKData().booleanValue()) {
                    if (WizardCommonPage.uninstallContext.shouldDeleteKeystore().booleanValue()) {
                        logger.trace("Begin to remove SDK Data with Keystore directory");
                        PathUtil.remove(WizardCompletePage.this.contentProvider.getSDKInfo().getSdkDataPath());
                    } else {
                        logger.trace("Begin to remove SDK data without Keystore directory");
                        PathUtil.removeExceptDirectory(WizardCompletePage.this.contentProvider.getSDKInfo().getSdkDataPath(), "keystore");
                    }
                } else if (WizardCommonPage.uninstallContext.shouldDeleteKeystore().booleanValue()) {
                    logger.trace("Begin to remove only Keystore directory");
                    PathUtil.remove(WizardCompletePage.this.contentProvider.getSDKInfo().getSdkDataPath() + File.separator + "keystore");
                } else {
                    logger.trace("Do not remove SDK Data and Keystore directory");
                }
                logger.trace("remove shortcut menu");
                WizardCompletePage.this.contentProvider.getInstController().removeShortcutMenu();
                WizardCompletePage.this.getShell().close();
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent arg0) {
                logger.trace(arg0);
            }
        });
    }

    public boolean workEventClose() {
        return true;
    }
}

