/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui;

import org.apache.logging.log4j.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.tizen.manager.util.Log;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

public class UseUninstallerDialog
extends Dialog {
    private WizardUIResourceHandler uiRsrcHandler = WizardUIResourceHandler.getInstance();
    private Button okButton;
    private boolean useUninstaller = false;
    private static final Logger logger = Log.getLogger(UseUninstallerDialog.class);

    public UseUninstallerDialog(Shell parentShell) {
        this(parentShell, 67616);
    }

    public UseUninstallerDialog(Shell parentShell, int type) {
        super(parentShell);
        this.setShellStyle(type);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        composite.setLayout(gridLayout);
        this.setTitle();
        this.createInfoArea(composite);
        this.createDummyArea(composite, 5);
        this.createRadioButtons(composite);
        this.createDummyArea(composite, 20);
        this.createOKButton(composite);
        this.createDummyArea(composite, 3);
        return composite;
    }

    private void setTitle() {
        this.getShell().setText("Package Manager Information");
    }

    @Override
    protected Control createButtonBar(Composite parent) {
        return null;
    }

    @Override
    protected boolean canHandleShellCloseEvent() {
        return false;
    }

    private void createInfoArea(Composite composite) {
        GridData gd = new GridData(4, 4, true, false);
        gd.widthHint = 380;
        Label infoLabel = new Label(composite, 64);
        infoLabel.setText("With the new Package Manager, you cannot uninstall the SDK because it doesn't support the SDK uninstallation.\n If you want to uninstall the SDK, select 'SDK Uninstaller' from the following list. If not, select 'Package Manager'.");
        infoLabel.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_MIDDLE));
        infoLabel.setLayoutData(gd);
    }

    private void createDummyArea(Composite parent, int height) {
        Composite dummy = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = height;
        dummy.setLayoutData(gd);
    }

    private void createRadioButtons(Composite composite) {
        GridData gd = new GridData(4, 4, true, false);
        Button runManagerBtn = new Button(composite, 16);
        runManagerBtn.setText("Package Manager");
        runManagerBtn.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_MIDDLE));
        runManagerBtn.setSelection(true);
        runManagerBtn.setEnabled(true);
        runManagerBtn.setLayoutData(gd);
        runManagerBtn.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                logger.trace("User select running Package Manager.");
                UseUninstallerDialog.this.useUninstaller = false;
                UseUninstallerDialog.this.okButton.setEnabled(true);
            }
        });
        gd = new GridData(4, 4, true, false);
        Button runUninstallerBtn = new Button(composite, 16);
        runUninstallerBtn.setText("SDK Uninstaller");
        runUninstallerBtn.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_MIDDLE));
        runUninstallerBtn.setSelection(false);
        runUninstallerBtn.setEnabled(true);
        runUninstallerBtn.setLayoutData(gd);
        runUninstallerBtn.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                logger.trace("User select running uninstaller");
                UseUninstallerDialog.this.useUninstaller = true;
                UseUninstallerDialog.this.okButton.setEnabled(true);
            }
        });
    }

    private void createOKButton(Composite composite) {
        GridData gd = new GridData(131072, 4, false, false);
        gd.widthHint = 120;
        gd.heightHint = 25;
        this.okButton = new Button(composite, 8);
        this.okButton.setText("Continue");
        this.okButton.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_MIDDLE));
        this.okButton.setLayoutData(gd);
        this.okButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                UseUninstallerDialog.this.okPressed();
            }
        });
    }

    public boolean getSelectionResult() {
        return this.useUninstaller;
    }
}

