/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.util;

import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.Logger;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PathUtil;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.packagemanager.ui.util.CircularGroupAnimationGraph;
import org.tizen.packagemanager.ui.util.IMCircularGraph2;

public class WizardUIResourceHandler {
    private Properties prop;
    private static final WizardUIResourceHandler handler = new WizardUIResourceHandler();
    private static final Logger logger = Log.getLogger(WizardUIResourceHandler.class);
    private Point POINT_MAIN_WINDOW;
    private Point POINT_UNINSTALLER_BASE_WINDOW;
    private Color COLOR_BACKGROUND = null;
    private HashMap<UIFont, org.eclipse.swt.graphics.Font> fontMap = new HashMap();
    private HashMap<UIColor, Color> colorMap = new HashMap();
    private HashMap<UISize, Rectangle> rectMap = new HashMap();
    private HashMap<Enum<?>, Image> imageMap = new HashMap();
    private boolean isUninstaller = false;

    private WizardUIResourceHandler() {
        InputStream is = null;
        this.prop = new Properties();
        try {
            is = this.getClass().getResourceAsStream("/res/properties/ImageResources-properties.xml");
            this.prop.loadFromXML(is);
        }
        catch (Exception exception) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            this.POINT_MAIN_WINDOW = this.getPointFromString(this.getUIResources(UISize.WIZARD_SIZE_MANAGER_BASIC));
            this.POINT_UNINSTALLER_BASE_WINDOW = this.getPointFromString(this.getUIResources(UISize.SIZE_UNINSTALLER_BASE_WINDOW));
        }
    }

    public ArrayList<Image> getAnimatingImages(UIAnimatingImage image) {
        ArrayList<Image> result;
        block4: {
            result = new ArrayList<Image>();
            String strImageFiles = this.getUIResources(image);
            String[] split = strImageFiles.split(",");
            if (split == null) break block4;
            if (split[0].equals("custom")) {
                String baseFolder = split[1];
                String baseName = split[2];
                int size = Integer.parseInt(split[3]);
                String extension = split[4];
                for (int i = 0; i < size; ++i) {
                    result.add(new Image((Device)Display.getDefault(), PathUtil.getResourceAsStream(String.format("%s%s%02d%s", baseFolder, baseName, i + 1, extension))));
                }
            } else {
                for (String imgFile : strImageFiles.split(",")) {
                    result.add(new Image((Device)Display.getDefault(), PathUtil.getResourceAsStream(imgFile)));
                }
            }
        }
        return result;
    }

    public static WizardUIResourceHandler getInstance() {
        return handler;
    }

    public Point getWindowSize() {
        return this.POINT_MAIN_WINDOW;
    }

    public Point getUninstallerWindowSize() {
        return this.POINT_UNINSTALLER_BASE_WINDOW;
    }

    public Color getBackGroundColor() {
        if (this.COLOR_BACKGROUND == null) {
            this.COLOR_BACKGROUND = this.getColor(UIColor.WIZARD_COLOR_WHITE_F8);
        }
        return this.COLOR_BACKGROUND;
    }

    public String getStringFromResource(Enum<?> option) {
        String returnString = "";
        if (option instanceof UITerms) {
            returnString = this.getUIResources(option);
        }
        return returnString;
    }

    public Image getImage(Enum<?> imageName) {
        Image returnImage = this.imageMap.get(imageName);
        if (returnImage == null && (imageName instanceof UIImage || imageName instanceof UIIcon)) {
            returnImage = new Image((Device)Display.getDefault(), PathUtil.getResourceAsStream(this.getUIResources(imageName)));
            this.imageMap.put(imageName, returnImage);
        }
        return returnImage;
    }

    public Rectangle getRect(UISize option) {
        Rectangle returnRect = this.rectMap.get((Object)option);
        if (returnRect == null) {
            String value = this.getUIResources(option);
            returnRect = this.getRectancleFromString(value);
            this.rectMap.put(option, returnRect);
        }
        return returnRect;
    }

    public Point getPointFromResource(UISize option) {
        String value = this.getUIResources(option);
        Point returnPoint = this.getPointFromString(value);
        return returnPoint;
    }

    public org.eclipse.swt.graphics.Font getFontBySize(UIFontSize fontSize, FontType ft, int swtoption) {
        org.eclipse.swt.graphics.Font font = null;
        if (font == null) {
            int size = fontSize.getValue();
            double macFixed = PlatformUtil.isMacOS() ? 0.9 : 1.0;
            size = (int)((double)size * 0.75 * 96.0 * macFixed / (double)Display.getDefault().getDPI().y);
            String fontName = "";
            if (ft != null) {
                if (!PlatformUtil.isWindows()) {
                    try {
                        String name = this.getUIResources(ft);
                        File tempFile = PathUtil.getTempFileFromResource(name, "local_" + System.currentTimeMillis() / 1000L, ".ttf");
                        if (tempFile != null) {
                            Font tempFont = Font.createFont(0, tempFile);
                            fontName = tempFont.getFontName();
                            Display.getDefault().loadFont(tempFile.getAbsolutePath());
                            tempFile.deleteOnExit();
                        }
                    }
                    catch (Exception name) {
                        // empty catch block
                    }
                    fontName = fontName.split(" ")[0].trim();
                } else {
                    fontName = "Arial";
                }
            } else {
                FontData[] fD = Display.getDefault().getSystemFont().getFontData();
                fontName = fD[0].getName();
            }
            font = new org.eclipse.swt.graphics.Font((Device)Display.getDefault(), new FontData(fontName, size, 0 | swtoption));
        }
        return font;
    }

    public org.eclipse.swt.graphics.Font getFontBySize(UIFontSize fontSize, boolean useCustomFont, int swtoption) {
        return this.getFontBySize(fontSize, null, swtoption);
    }

    public org.eclipse.swt.graphics.Font getFont(UIFont targetFont) {
        org.eclipse.swt.graphics.Font font = this.fontMap.get((Object)targetFont);
        if (font == null) {
            int fontSize = 0;
            if (PlatformUtil.isWindows()) {
                switch (targetFont) {
                    case FONT_SIZE_SMALL: 
                    case FONT_SIZE_SMALL_BOLD: {
                        fontSize = 8;
                        break;
                    }
                    case FONT_SIZE_MIDDLE: 
                    case FONT_SIZE_MIDDLE_BOLD: {
                        fontSize = 10;
                        break;
                    }
                    case FONT_SIZE_LARGE: 
                    case FONT_SIZE_LARGE_BOLD: {
                        fontSize = 14;
                        break;
                    }
                    default: {
                        fontSize = 8;
                    }
                }
                fontSize = (int)((double)fontSize * 96.0 / (double)Display.getDefault().getDPI().y);
                if (Display.getDefault().getDPI().y > 96) {
                    ++fontSize;
                }
            } else if (PlatformUtil.isMacOS()) {
                switch (targetFont) {
                    case FONT_SIZE_SMALL: 
                    case FONT_SIZE_SMALL_BOLD: {
                        fontSize = 10;
                        break;
                    }
                    case FONT_SIZE_MIDDLE: 
                    case FONT_SIZE_MIDDLE_BOLD: {
                        fontSize = 12;
                        break;
                    }
                    case FONT_SIZE_LARGE: 
                    case FONT_SIZE_LARGE_BOLD: {
                        fontSize = 18;
                        break;
                    }
                    default: {
                        fontSize = 10;
                    }
                }
                fontSize = (int)((double)fontSize * 72.0 / (double)Display.getDefault().getDPI().y);
                if (Display.getDefault().getDPI().y > 72) {
                    ++fontSize;
                }
            } else {
                switch (targetFont) {
                    case FONT_SIZE_SMALL: 
                    case FONT_SIZE_SMALL_BOLD: {
                        fontSize = 8;
                        break;
                    }
                    case FONT_SIZE_MIDDLE: 
                    case FONT_SIZE_MIDDLE_BOLD: {
                        fontSize = 10;
                        break;
                    }
                    case FONT_SIZE_LARGE: 
                    case FONT_SIZE_LARGE_BOLD: {
                        fontSize = 15;
                        break;
                    }
                    default: {
                        fontSize = 8;
                    }
                }
                fontSize = (int)((double)fontSize * 96.0 / (double)Display.getDefault().getDPI().y);
                if (Display.getDefault().getDPI().y > 96) {
                    ++fontSize;
                }
            }
            FontData[] fD = Display.getDefault().getSystemFont().getFontData();
            int swtOption = 0;
            if (targetFont.name().contains("BOLD")) {
                swtOption |= 1;
            }
            font = new org.eclipse.swt.graphics.Font((Device)Display.getDefault(), new FontData(fD[0].getName(), fontSize, swtOption));
            this.fontMap.put(targetFont, font);
        }
        return font;
    }

    public Color getColor(UIColor option) {
        Color result = this.colorMap.get((Object)option);
        if (result == null) {
            result = new Color(null, this.getRGBFromString(this.getUIResources(option)));
            this.colorMap.put(option, result);
        }
        return result;
    }

    private RGB getRGBFromString(String value) {
        String[] split = value.split(",");
        int arg0 = Integer.parseInt(split[0].trim());
        int arg1 = Integer.parseInt(split[1].trim());
        int arg2 = Integer.parseInt(split[2].trim());
        RGB returnValue = new RGB(arg0, arg1, arg2);
        return returnValue;
    }

    private Point getPointFromString(String value) {
        String[] split = value.split(",");
        int arg0 = Integer.parseInt(split[0].trim());
        int arg1 = Integer.parseInt(split[1].trim());
        Point returnValue = new Point(arg0, arg1);
        return returnValue;
    }

    private Rectangle getRectancleFromString(String value) {
        String[] split = value.split(",");
        int x = Integer.parseInt(split[0].trim());
        int y = Integer.parseInt(split[1].trim());
        int width = Integer.parseInt(split[2].trim());
        int height = Integer.parseInt(split[3].trim());
        Rectangle returnRect = new Rectangle(x, y, width, height);
        return returnRect;
    }

    public int getSingleSize(UISingleSize value) {
        String returnValue = this.getUIResources(value);
        if (!returnValue.isEmpty()) {
            return Integer.parseInt(returnValue);
        }
        return 0;
    }

    private String getUIResources(Enum<?> option) {
        String returnValue = this.prop.getProperty(option.name());
        return returnValue;
    }

    public IMCircularGraph2 handleInstallingForWizardProgress(Composite composite, long defaultValue, int width, int height, int center, int type) {
        Rectangle point = new Rectangle(0, 0, width, height);
        IMCircularGraph2 imc = new IMCircularGraph2(composite, 0, type, point, center);
        imc.setBackgroundImage(this.getImage(UIImage.WIZARD_IMAGE_ROTATE_BG));
        if (type == 0) {
            imc.setValueFont(this.getFontBySize(UIFontSize.FONT_SIZE_40PX, false, 1));
            imc.setMeasureFont(this.getFontBySize(UIFontSize.FONT_SIZE_25PX, false, 1));
        }
        if (type == 21) {
            imc.setProgressImage(this.getImage(UIImage.WIZARD_IMAGE_ROTATE));
        }
        imc.setCenterColor(this.getColor(UIColor.WIZARD_COLOR_WHITE));
        imc.setGraphColor(this.getColor(UIColor.WIZARD_COLOR_PURE_BLUE));
        imc.setCenterImage(this.getImage(UIImage.WIZARD_IMAGE_INSTALL_IC_SDK));
        imc.setVisible(true);
        imc.update(defaultValue);
        return imc;
    }

    public CircularGroupAnimationGraph handleGroupUninstallingForWizardProgress(Composite composite, long defaultValue, int width, int height, int center, int type) {
        Rectangle point = new Rectangle(0, 0, width, height);
        CircularGroupAnimationGraph imc = new CircularGroupAnimationGraph(composite, 0, type, point, center);
        imc.setBackgroundImage(this.getImage(UIImage.WIZARD_IMAGE_ROTATE_BG));
        if (type == 0) {
            imc.setValueFont(this.getFontBySize(UIFontSize.FONT_SIZE_40PX, false, 1));
            imc.setMeasureFont(this.getFontBySize(UIFontSize.FONT_SIZE_25PX, false, 1));
        }
        if (type == 21) {
            imc.setProgressImage(this.getImage(UIImage.WIZARD_IMAGE_ROTATE));
            imc.setProgressGroupImage(this.getGroupImages());
        }
        imc.setCenterColor(this.getColor(UIColor.WIZARD_COLOR_WHITE));
        imc.setGraphColor(this.getColor(UIColor.WIZARD_COLOR_PURE_BLUE));
        imc.setCenterImage(this.getImage(UIImage.WIZARD_IMAGE_INSTALL_IC_SDK));
        imc.setVisible(true);
        imc.update(defaultValue);
        return imc;
    }

    private List<Image> getGroupImages() {
        String format;
        int i;
        ArrayList<Image> returnImages = new ArrayList<Image>();
        ArrayList<String> list = new ArrayList<String>();
        String uiResources = this.getUIResources(UIImage.WIZARD_IMAGE_ROTATE_GROUP);
        String[] split = uiResources.split(",");
        String url = split[0].trim() + "half_1/";
        String defaultName = "half_1_000";
        String extension = split[2].trim();
        int endNum = Integer.valueOf(split[4].trim());
        for (i = 1; i <= endNum; ++i) {
            format = String.format("%s%s%02d%s", url, defaultName, i, extension);
            list.add(format);
        }
        url = split[0].trim() + "half_2/";
        defaultName = "half_2_000";
        for (i = 1; i <= endNum; ++i) {
            format = String.format("%s%s%02d%s", url, defaultName, i, extension);
            list.add(format);
        }
        Collections.sort(list);
        for (String name : list) {
            returnImages.add(new Image((Device)Display.getDefault(), PathUtil.getResourceAsStream(name)));
        }
        return returnImages;
    }

    public boolean isUninstaller() {
        return this.isUninstaller;
    }

    public void setUninstaller(boolean isUninstaller) {
        this.isUninstaller = isUninstaller;
    }

    public static enum UISingleSize {
        WIZARD_SINGLE_SIZE_TREE_VIEW_WIDTH,
        WIZARD_SINGLE_SIZE_TREE_SCROLLBAR_WIDTH,
        WIZARD_SINGLE_SIZE_TREE_COLUMN_LICENSE_WIDTH,
        WIZARD_SINGLE_SIZE_TREE_COLUMN_LICENSE_ACCEPT_WIDTH,
        WIZARD_SINGLE_SIZE_TREE_COLUMN_UPDATE_WIDTH,
        WIZARD_SINGLE_SIZE_TREE_COLUMN_INSTALL_WIDTH,
        WIZARD_SINGLE_SIZE_TREE_COLUMN_UPDATABLE_WIDTH,
        WIZARD_SINGLE_SIZE_TREE_COLUMN_ACTION_STATUS_WIDTH,
        WIZARD_SINGLE_SIZE_TREE_COLUMN_ACTION_BUTTON_WIDTH;

    }

    public static enum UIAnimatingImage {
        IMAGE_ANIMATION_INSTALLING,
        IMAGE_ANIMATION_UPDATING,
        IMAGE_ANIMATION_REMOVING,
        IMAGE_ANIMATION_CANCELING,
        IMAGE_ANIMATION_LOADING,
        IMAGE_ANIMATION_LOADING_NEW,
        IMAGE_ANIMATION_BTN_TAB_PROGRESS_NORMAL,
        IMAGE_ANIMATION_BTN_TAB_PROGRESS_SELECTED,
        WIZARD_IMAGE_MANAGER_ANIMATION_PROGRESS,
        WIZARD_IMAGE_MANAGER_ANIMATION_PROGRESS_GIF_1,
        WIZARD_IMAGE_MANAGER_ANIMATION_PROGRESS_GIF_2,
        WIZARD_IMAGE_MANAGER_ANIMATION_PROGRESS_HALF_1,
        WIZARD_IMAGE_MANAGER_ANIMATION_PROGRESS_HALF_2;

    }

    public static enum FontType {
        OS,
        WIZARD_FONT_TYPE_REGULAR,
        WIZARD_FONT_TYPE_MEDIUM,
        WIZARD_FONT_TYPE_BOLD;

    }

    public static enum UIFontSize {
        FONT_SIZE_46PX(46),
        FONT_SIZE_40PX(40),
        FONT_SIZE_36PX(36),
        FONT_SIZE_34PX(34),
        FONT_SIZE_30PX(30),
        FONT_SIZE_25PX(25),
        FONT_SIZE_23PX(23),
        FONT_SIZE_20PX(20),
        FONT_SIZE_18PX(18),
        FONT_SIZE_17PX(17),
        FONT_SIZE_16PX(16),
        FONT_SIZE_15PX(15),
        FONT_SIZE_13PX(13),
        FONT_SIZE_12PX(12),
        FONT_SIZE_11PX(11),
        FONT_SIZE_10PX(10);

        private int value = 0;

        private UIFontSize(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum UIFont {
        FONT_SIZE_LARGE,
        FONT_SIZE_MIDDLE,
        FONT_SIZE_SMALL,
        FONT_SIZE_LARGE_BOLD,
        FONT_SIZE_MIDDLE_BOLD,
        FONT_SIZE_SMALL_BOLD;

    }

    public static enum UIColor {
        WINDOW_RGB_BACKGROUND,
        COLOR_ALL_UPDATE_BUTTON,
        COLOR_PROGRESS_TAB_TEXT,
        COLOR_TOP_TREE_ROW,
        COLOR_ODD_TREE_ROW,
        COLOR_SELECTED_TREE_ROW,
        COLOR_TABLE_TREE_COMPONENT,
        COLOR_COFIGURATION_BUTTON,
        COLOR_UNINSTALL_ALL_BUTTON_FG,
        COLOR_UNINSTALL_ALL_BUTTON_BG,
        COLOR_CLOSE_BUTTON,
        COLOR_MENU_BACKGROUND,
        COLOR_TOAST_TITLE_FOREGROUND,
        COLOR_TOAST_TEXT_FOREGROUND,
        COLOR_TOAST_BG_TOP_GRADIENT,
        COLOR_TOAST_BG_BOTTOM_GRADIENT,
        COLOR_TOAST_BORDER,
        COLOR_PROGRESSBAR_BORDER,
        COLOR_PROGRESSBAR_TOTAL,
        COLOR_PROGRESSBAR_INSTALL,
        COLOR_PROGRESSBAR_UNINSTALL,
        COLOR_PROGRESSBAR_ERROR,
        COLOR_PROGRESS_BG_ACTIVE,
        COLOR_PROGRESS_BG_INACTIVE,
        COLOR_PROGRESS_TEXT_ACTIVE,
        COLOR_PROGRESS_TEXT_INACTIVE,
        COLOR_ERROR_LOG,
        COLOR_UNINSTALLER_PROGRESS_CIRCLE_BACKGROUND,
        COLOR_UNINSTALLER_PROGRESS_CIRCLE,
        COLOR_UNINSTALLER_PROGRESS_CIRCLE_CENTER,
        COLOR_UNINSTALLER_PROGRESS_CIRCLE_ERROR,
        WIZARD_COLOR_WHITE,
        WIZARD_COLOR_WHITE_F8,
        WIZARD_COLOR_WHITE_F5,
        WIZARD_COLOR_WHITE_F4,
        WIZARD_COLOR_GRAY_D1,
        WIZARD_COLOR_GRAY_9F,
        WIZARD_COLOR_LINE_SPLITTER,
        WIZARD_COLOR_LICENSE_STROKE,
        WIZARD_COLOR_LICENSE_TEXT,
        WIZARD_COLOR_VERY_DARK_GRAY_33,
        WIZARD_COLOR_VERY_DARK_GRAY_46,
        WIZARD_COLOR_VERY_DARK_GRAY_58,
        WIZARD_COLOR_VERY_DARK_GRAY_72,
        WIZARD_COLOR_PURE_BLUE,
        WIZARD_COLOR_PURE_SKY_BLUE,
        WIZARD_COLOR_DARK_BLUE,
        WIZARD_COLOR_READYPAGE_DIRECTORY_ERROR,
        WIZARD_COLOR_READYPAGE_WARN_MESSAGE,
        WIZARD_COLOR_READYPAGE_WARN_LINK,
        WIZARD_COLOR_DARK_GRAY_77,
        WIZARD_COLOR_DARK_GRAY_233,
        WIZARD_COLOR_DEFAULT_BACKGROUND,
        WIZARD_COLOR_DARK_GRAY_66,
        WIZARD_COLOR_DARK_GRAY_99,
        WIZARD_COLOR_DARK_GRAY_E3,
        WIZARD_COLOR_DARK_GRAY_222,
        WIZARD_COLOR_DARK_GRAY_AA,
        WIZARD_COLOR_DARK_GRAY_AD;

    }

    public static enum UIIcon {
        ICON_MANAGER,
        ICON_UNINSTALLER,
        ICON_LOGIN,
        ICON_DIRECTORY_OPEN,
        ICON_UPDATE,
        ICON_INSTALL_NORMAL,
        ICON_INSTALL_HOVER,
        ICON_INSTALL_PUSH,
        ICON_INSTALL_DISABLED,
        ICON_UNINSTALL_NORMAL,
        ICON_UNINSTALL_HOVER,
        ICON_UNINSTALL_PUSH,
        ICON_UNINSTALL_DISABLED,
        ICON_TYPE_MOBILE,
        ICON_TYPE_TV,
        ICON_TYPE_WEARABLE,
        ICON_TYPE_RT,
        ICON_TYPE_TOOL,
        ICON_TYPE_MOBILE_DONE,
        ICON_TYPE_TV_DONE,
        ICON_TYPE_WEARABLE_DONE,
        ICON_TYPE_RT_DONE,
        ICON_TYPE_TOOL_DONE,
        ICON_CANCEL_NORMAL,
        ICON_CANCEL_HOVER,
        ICON_CANCEL_PUSH,
        ICON_CANCEL_DISABLED,
        ICON_RETRY_NORMAL,
        ICON_RETRY_HOVER,
        ICON_RETRY_PUSH,
        ICON_RETRY_DISABLED,
        ICON_FAIL_MESSAGE_NORMAL,
        ICON_FAIL_MESSAGE_HOVER,
        ICON_FAIL_MESSAGE_PUSH,
        ICON_FAIL_MESSAGE_DISABLED,
        ICON_CANCEL_MESSAGE_NORMAL,
        ICON_CANCEL_MESSAGE_HOVER,
        ICON_CANCEL_MESSAGE_PUSH,
        ICON_CANCEL_MESSAGE_DISABLED,
        ICON_LICENSE_NORMAL,
        ICON_LICENSE_HOVER,
        ICON_LICENSE_DISABLED,
        ICON_LICENSE_SEL,
        ICON_ACCEPT_LICENSE_CHECKED_NORMAL,
        ICON_ACCEPT_LICENSE_CHECKED_HOVER,
        ICON_ACCEPT_LICENSE_CHECKED_DISABLED,
        ICON_ACCEPT_LICENSE_UNCHECKED_NORMAL,
        ICON_ACCEPT_LICENSE_UNCHECKED_HOVER,
        ICON_ACCEPT_LICENSE_UNCHECKED_DISABLED,
        ICON_KEY_NORMAL,
        ICON_KEY_HOVER,
        ICON_KEY_PUSH,
        ICON_REMOVE_NORMAL,
        ICON_REMOVE_HOVER,
        ICON_REMOVE_PUSH,
        ICON_REMOVE_DISABLED,
        ICON_BTN_CHECKED_NORMAL,
        ICON_BTN_CHECKED_HOVER,
        ICON_BTN_CHECKED_DISABLED,
        ICON_BTN_UNCHECKED_NORMAL,
        ICON_BTN_UNCHECKED_HOVER,
        ICON_BTN_UNCHECKED_DISABLED,
        ICON_FAIL,
        ICON_FAIL_SMALL,
        ICON_STATUS_INSTALLED,
        ICON_STATUS_INSTALLING,
        ICON_STATUS_REMOVING,
        ICON_STATUS_UPDATE,
        ICON_STATUS_UPDATING,
        ICON_PROGRESS_INSTALLING,
        ICON_PROGRESS_UPDATING,
        ICON_PROGRESS_REMOVING,
        ICON_TITLE_TREE_EXPANDED,
        ICON_TITLE_TREE_CLOSED,
        ICON_BACK,
        ICON_SEARCH,
        ICON_NOTIFY_SUCCESS,
        ICON_NOTIFY_FAIL,
        ICON_CLOSE_NORMAL,
        ICON_CLOSE_HOVER,
        ICON_CLOSE_PUSH,
        ICON_NOTIFY_BG,
        ICON_DISCONNECTION,
        WIZARD_IMAGE_MANAGER_BUTTON_INSATLL_NOR,
        WIZARD_IMAGE_MANAGER_BUTTON_INSATLL_OVER,
        WIZARD_IMAGE_MANAGER_BUTTON_INSATLL_SEL,
        WIZARD_IMAGE_MANAGER_BUTTON_INSATLL_DIS,
        WIZARD_IMAGE_MANAGER_BUTTON_REMOVE_NOR,
        WIZARD_IMAGE_MANAGER_BUTTON_REMOVE_OVER,
        WIZARD_IMAGE_MANAGER_BUTTON_REMOVE_SEL,
        WIZARD_IMAGE_MANAGER_BUTTON_REMOVE_DIS,
        WIZARD_IMAGE_MANAGER_ICON_CAUTION_NORAML,
        WIZARD_IMAGE_MANAGER_ICON_CAUTION_SELECT,
        WIZARD_IMAGE_MANAGER_ICON_CAUTION_OVER,
        WIZARD_IMAGE_MANAGER_ICON_RESTART_NORAML,
        WIZARD_IMAGE_MANAGER_ICON_RESTART_SELECT,
        WIZARD_IMAGE_MANAGER_ICON_RESTART_OVER,
        WIZARD_IMAGE_MANAGER_ICON_CANCEL_NORAML,
        WIZARD_IMAGE_MANAGER_ICON_CANCEL_SELECT,
        WIZARD_IMAGE_MANAGER_ICON_CANCEL_OVER,
        WIZARD_IMAGE_MANAGER_CONFIG_EXT_ACTIVE_ON,
        WIZARD_IMAGE_MANAGER_CONFIG_EXT_ACTIVE_OFF,
        WIZARD_IMAGE_MANAGER_ICON_LICENSE_NORMAL,
        WIZARD_IMAGE_MANAGER_ICON_LICENSE_HOVER,
        WIZARD_IMAGE_MANAGER_ICON_LICENSE_SEL,
        WIZARD_IMAGE_MANAGER_ICON_UPDATE_NORMAL,
        WIZARD_IMAGE_MANAGER_ICON_UPDATE_HOVER,
        WIZARD_IMAGE_MANAGER_ICON_UPDATE_SEL,
        ICON_CAUTION,
        WIZARD_ICON_MANAGER_WARNING,
        WIZARD_ICON_MANAGER_ARROW_NORMAL,
        WIZARD_ICON_MANAGER_ARROW_SEL;

    }

    public static enum UIImage {
        IMAGE_DEFAULT_BI,
        IMAGE_INFO,
        IMAGE_TAB_INSTALLED_NORMAL,
        IMAGE_TAB_INSTALLED_HOVER,
        IMAGE_TAB_INSTALLED_PUSH,
        IMAGE_TAB_INSTALLED_SELECTED,
        IMAGE_TAB_INSTALLED_DISABLED,
        IMAGE_TAB_ALL_NORMAL,
        IMAGE_TAB_ALL_HOVER,
        IMAGE_TAB_ALL_PUSH,
        IMAGE_TAB_ALL_SELECTED,
        IMAGE_TAB_ALL_DISABLED,
        IMAGE_TAB_PROGRESS_NORMAL,
        IMAGE_TAB_PROGRESS_HOVER,
        IMAGE_TAB_PROGRESS_PUSH,
        IMAGE_TAB_PROGRESS_SELECTED,
        IMAGE_TAB_PROGRESS_DISABLED,
        IMAGE_TAB_0_PROGRESS_NORMAL,
        IMAGE_TAB_0_PROGRESS_HOVER,
        IMAGE_TAB_0_PROGRESS_PUSH,
        IMAGE_TAB_0_PROGRESS_SELECTED,
        IMAGE_TAB_0_PROGRESS_DISABLED,
        IMAGE_BTN_CONFIGURATION_NORMAL,
        IMAGE_BTN_CONFIGURATION_HOVER,
        IMAGE_BTN_CONFIGURATION_PUSH,
        IMAGE_BTN_CONFIGURATION_DISABLED,
        IMAGE_BTN_INFO_NORMAL,
        IMAGE_BTN_INFO_HOVER,
        IMAGE_BTN_INFO_PUSH,
        IMAGE_BTN_INFO_DISABLED,
        IMAGE_BTN_TROUBLE_SHOOTING_NORMAL,
        IMAGE_BTN_TROUBLE_SHOOTING_HOVER,
        IMAGE_BTN_TROUBLE_SHOOTING_PUSH,
        IMAGE_BTN_TROUBLE_SHOOTING_DISABLED,
        IMAGE_BTN_LICENSE_NORMAL,
        IMAGE_BTN_LICENSE_HOVER,
        IMAGE_BTN_LICENSE_DISABLED,
        IMAGE_BTN_ACCEPT_ALL_UNCHECKED_NORMAL,
        IMAGE_BTN_ACCEPT_ALL_UNCHECKED_HOVER,
        IMAGE_BTN_ACCEPT_ALL_UNCHECKED_DISABLED,
        IMAGE_BTN_ACCEPT_ALL_CHECKED_NORMAL,
        IMAGE_BTN_ACCEPT_ALL_CHECKED_HOVER,
        IMAGE_BTN_ACCEPT_ALL_CHECKED_DISABLED,
        IMAGE_BTN_UPDATE_ALL_NORMAL,
        IMAGE_BTN_UPDATE_ALL_HOVER,
        IMAGE_BTN_UPDATE_ALL_PUSH,
        IMAGE_BTN_UPDATE_ALL_DISABLED,
        IMAGE_BTN_UPDATE_NORMAL,
        IMAGE_BTN_UPDATE_HOVER,
        IMAGE_BTN_UPDATE_PUSH,
        IMAGE_BTN_UPDATE_DISABLED,
        IMAGE_FILTER_MOBILE_UNCHECKED_NORMAL,
        IMAGE_FILTER_MOBILE_UNCHECKED_HOVER,
        IMAGE_FILTER_MOBILE_UNCHECKED_DISABLED,
        IMAGE_FILTER_MOBILE_CHECKED_NORMAL,
        IMAGE_FILTER_MOBILE_CHECKED_HOVER,
        IMAGE_FILTER_MOBILE_CHECKED_DISABLED,
        IMAGE_FILTER_TV_UNCHECKED_NORMAL,
        IMAGE_FILTER_TV_UNCHECKED_HOVER,
        IMAGE_FILTER_TV_UNCHECKED_DISABLED,
        IMAGE_FILTER_TV_CHECKED_NORMAL,
        IMAGE_FILTER_TV_CHECKED_HOVER,
        IMAGE_FILTER_TV_CHECKED_DISABLED,
        IMAGE_FILTER_WEARABLE_UNCHECKED_NORMAL,
        IMAGE_FILTER_WEARABLE_UNCHECKED_HOVER,
        IMAGE_FILTER_WEARABLE_UNCHECKED_DISABLED,
        IMAGE_FILTER_WEARABLE_CHECKED_NORMAL,
        IMAGE_FILTER_WEARABLE_CHECKED_HOVER,
        IMAGE_FILTER_WEARABLE_CHECKED_DISABLED,
        IMAGE_FILTER_RT_UNCHECKED_NORMAL,
        IMAGE_FILTER_RT_UNCHECKED_HOVER,
        IMAGE_FILTER_RT_UNCHECKED_DISABLED,
        IMAGE_FILTER_RT_CHECKED_NORMAL,
        IMAGE_FILTER_RT_CHECKED_HOVER,
        IMAGE_FILTER_RT_CHECKED_DISABLED,
        IMAGE_FILTER_ADVANCED_UNCHECKED_NORMAL,
        IMAGE_FILTER_ADVANCED_UNCHECKED_HOVER,
        IMAGE_FILTER_ADVANCED_UNCHECKED_DISABLED,
        IMAGE_FILTER_ADVANCED_CHECKED_NORMAL,
        IMAGE_FILTER_ADVANCED_CHECKED_HOVER,
        IMAGE_FILTER_ADVANCED_CHECKED_DISABLED,
        IMAGE_LICENSE_BG_TOP,
        IMAGE_BTN_LICENSE_LEFT_NORMAL,
        IMAGE_BTN_LICENSE_LEFT_HOVER,
        IMAGE_BTN_LICENSE_LEFT_DISABLED,
        IMAGE_BTN_LICENSE_LEFT_PUSH,
        IMAGE_BTN_LICENSE_RIGHT_NORMAL,
        IMAGE_BTN_LICENSE_RIGHT_HOVER,
        IMAGE_BTN_LICENSE_RIGHT_DISABLED,
        IMAGE_BTN_LICENSE_RIGHT_PUSH,
        IMAGE_INFORMATION_BG_TOP,
        IMAGE_FAIL,
        IMAGE_CANCELLED,
        CONF_INSTALL_OPTION_NORMAL,
        CONF_INSTALL_OPTION_HOVER,
        CONF_INSTALL_OPTION_PUSH,
        CONF_INSTALL_OPTION_SELECTED,
        CONF_PROXY_NORMAL,
        CONF_PROXY_HOVER,
        CONF_PROXY_PUSH,
        CONF_PROXY_SELECTED,
        CONF_EXTRA_NORMAL,
        CONF_EXTRA_HOVER,
        CONF_EXTRA_PUSH,
        CONF_EXTRA_SELECTED,
        IMAGE_UNINSTALLER_READYPAGE_BACKGROUND,
        IMAGE_UNINSTALLER_READYPAGE_BUTTON_NORMAL,
        IMAGE_UNINSTALLER_READYPAGE_BUTTON_HOVER,
        IMAGE_UNINSTALLER_READYPAGE_BUTTON_DISABLE,
        IMAGE_UNINSTALLER_INFO_BUTTON_NORMAL,
        IMAGE_UNINSTALLER_INFO_BUTTON_HOVER,
        IMAGE_UNINSTALLER_INFO_BUTTON_DISABLE,
        IMAGE_UNINSTALLER_INFO_BUTTON_PUSH,
        IMAGE_UNINSTALLER_UNINSTALLINGPAGE_PREPARING,
        IMAGE_UNINSTALLER_UNINSTALLINGPAGE_UNINSTALLING,
        IMAGE_UNINSTALLER_UNINSTALLINGPAGE_COMPLETING,
        IMAGE_UNINSTALLER_PROGRESS_BG,
        IMAGE_UNINSTALLER_PROGRESS_START,
        IMAGE_UNINSTALLER_PROGRESS_ROTATE,
        IMAGE_UNINSTALLER_COMPLETEDPAGE_BACKGROUND,
        IMAGE_UNINSTALLER_INFO_DIALOG_BG_TOP,
        WIZARD_IMAGE_TOP_BACKGROUND,
        WIZARD_IMAGE_TOOLTIP_ICON_NORMAL,
        WIZARD_IMAGE_TOOLTIP_ICON_FOCUS,
        WIZARD_IMAGE_INSTALL_IC_SDK,
        WIZARD_IMAGE_ROTATE,
        WIZARD_IMAGE_ROTATE_GROUP,
        WIZARD_IMAGE_ROTATE_BG,
        WIZARD_IMAGE_CHECK_NORMAL,
        WIZARD_IMAGE_CHECK_SEL,
        WIZARD_IMAGE_TOOLTIP_BG_LEFT,
        WIZARD_IMAGE_TOOLTIP_BG_CENTER,
        WIZARD_IMAGE_TOOLTIP_BG_RIGHT,
        WIZARD_IMAGE_MSGBOX_BACKGROUND,
        WIZARD_IMAGE_INFO_ICON,
        WIZARD_IMAGE_WARNING_ICON,
        WIZARD_IMAGE_QEUSTION_ICON,
        WIZARD_IMAGE_MANAGER_TITLE_BACKGROUND,
        WIZARD_IMAGE_MANAGER_ICON_HELP_NOR,
        WIZARD_IMAGE_MANAGER_ICON_HELP_OVER,
        WIZARD_IMAGE_MANAGER_ICON_HELP_SEL,
        WIZARD_IMAGE_MANAGER_ICON_HELP_DIS,
        WIZARD_IMAGE_MANAGER_ICON_SETTING_NOR,
        WIZARD_IMAGE_MANAGER_ICON_SETTING_OVER,
        WIZARD_IMAGE_MANAGER_ICON_SETTING_SEL,
        WIZARD_IMAGE_MANAGER_ICON_SETTING_DIS,
        WIZARD_IMAGE_MANAGER_ICON_INFO_NOR,
        WIZARD_IMAGE_MANAGER_ICON_INFO_OVER,
        WIZARD_IMAGE_MANAGER_ICON_INFO_SEL,
        WIZARD_IMAGE_MANAGER_ICON_INFO_DIS,
        WIZARD_IMAGE_MANAGER_FILTER_ICON_MOBILE_UNSEL_NOR,
        WIZARD_IMAGE_MANAGER_FILTER_ICON_MOBILE_UNSEL_OVER,
        WIZARD_IMAGE_MANAGER_FILTER_ICON_MOBILE_UNSEL_DIS,
        WIZARD_IMAGE_MANAGER_FILTER_ICON_MOBILE_SEL_NOR,
        WIZARD_IMAGE_MANAGER_FILTER_ICON_MOBILE_SEL_OVER,
        WIZARD_IMAGE_MANAGER_FILTER_ICON_MOBILE_SEL_DIS,
        WIZARD_IMAGE_MANAGER_FILTER_ICON_WEARABLE_UNSEL_NOR,
        WIZARD_IMAGE_MANAGER_FILTER_ICON_WEARABLE_UNSEL_OVER,
        WIZARD_IMAGE_MANAGER_FILTER_ICON_WEARABLE_UNSEL_DIS,
        WIZARD_IMAGE_MANAGER_FILTER_ICON_WEARABLE_SEL_NOR,
        WIZARD_IMAGE_MANAGER_FILTER_ICON_WEARABLE_SEL_OVER,
        WIZARD_IMAGE_MANAGER_FILTER_ICON_WEARABLE_SEL_DIS,
        WIZARD_IMAGE_MANAGER_FILTER_ICON_TV_UNSEL_NOR,
        WIZARD_IMAGE_MANAGER_FILTER_ICON_TV_UNSEL_OVER,
        WIZARD_IMAGE_MANAGER_FILTER_ICON_TV_UNSEL_DIS,
        WIZARD_IMAGE_MANAGER_FILTER_ICON_TV_SEL_NOR,
        WIZARD_IMAGE_MANAGER_FILTER_ICON_TV_SEL_OVER,
        WIZARD_IMAGE_MANAGER_FILTER_ICON_TV_SEL_DIS,
        WIZARD_IMAGE_MANAGER_FILTER_ICON_RT_UNSEL_NOR,
        WIZARD_IMAGE_MANAGER_FILTER_ICON_RT_UNSEL_OVER,
        WIZARD_IMAGE_MANAGER_FILTER_ICON_RT_UNSEL_DIS,
        WIZARD_IMAGE_MANAGER_FILTER_ICON_RT_SEL_NOR,
        WIZARD_IMAGE_MANAGER_FILTER_ICON_RT_SEL_OVER,
        WIZARD_IMAGE_MANAGER_FILTER_ICON_RT_SEL_DIS,
        WIZARD_IMAGE_MANAGER_TOGGLE_STATUS_ALL,
        WIZARD_IMAGE_MANAGER_TOGGLE_STATUS_INSTALLED,
        WIZARD_IMAGE_MANAGER_ICON_TYPE_MOBILE,
        WIZARD_IMAGE_MANAGER_ICON_TYPE_MOBILE_NORMAL,
        WIZARD_IMAGE_MANAGER_ICON_TYPE_MOBILE_SELECT,
        WIZARD_IMAGE_MANAGER_ICON_TYPE_MOBILE_OVER,
        WIZARD_IMAGE_MANAGER_ICON_TYPE_WEARABLE,
        WIZARD_IMAGE_MANAGER_ICON_TYPE_WEARABLE_NORMAL,
        WIZARD_IMAGE_MANAGER_ICON_TYPE_WEARABLE_SELECT,
        WIZARD_IMAGE_MANAGER_ICON_TYPE_WEARABLE_OVER,
        WIZARD_IMAGE_MANAGER_ICON_TYPE_TV,
        WIZARD_IMAGE_MANAGER_ICON_TYPE_TV_NORMAL,
        WIZARD_IMAGE_MANAGER_ICON_TYPE_TV_SELECT,
        WIZARD_IMAGE_MANAGER_ICON_TYPE_TV_OVER,
        WIZARD_IMAGE_MANAGER_ICON_TYPE_RT,
        WIZARD_IMAGE_MANAGER_ICON_TYPE_RT_NORMAL,
        WIZARD_IMAGE_MANAGER_ICON_TYPE_RT_SELECT,
        WIZARD_IMAGE_MANAGER_ICON_TYPE_RT_OVER,
        WIZARD_IMAGE_MANAGER_ANIMATION_PROGRESS_BG,
        WIZARD_IMAGE_MANAGER_ICON_TYPE_TOOL,
        WIZARD_IMAGE_MANAGER_ICON_TYPE_TOOL_NORMAL,
        WIZARD_IMAGE_MANAGER_ICON_TYPE_TOOL_SELECT,
        WIZARD_IMAGE_MANAGER_ICON_TYPE_TOOL_OVER,
        WIZARD_IMAGE_MANAGER_UPDATE_BUTTON_NORMAL,
        WIZARD_IMAGE_MANAGER_UPDATE_BUTTON_OVER,
        WIZARD_IMAGE_MANAGER_UPDATE_BUTTON_SEL,
        WIZARD_IMAGE_MANAGER_UPDATE_BUTTON_DIS,
        WIZARD_IMAGE_MANAGER_TOGGLE_ALL_SEL,
        WIZARD_IMAGE_MANAGER_TOGGLE_ALL_SEL_OVER,
        WIZARD_IMAGE_MANAGER_TOGGLE_ALL_NO_SEL,
        WIZARD_IMAGE_MANAGER_TOGGLE_INSTALLED_SEL,
        WIZARD_IMAGE_MANAGER_TOGGLE_INSTALLED_SEL_OVER,
        WIZARD_IMAGE_MANAGER_TOGGLE_INSTALLED_NO_SEL,
        WIZARD_IMAGE_MANAGER_CONFIG_EXT_ADD_NORMAL,
        WIZARD_IMAGE_MANAGER_CONFIG_EXT_ADD_OVER,
        WIZARD_IMAGE_MANAGER_CONFIG_EXT_ADD_SEL,
        WIZARD_IMAGE_MANAGER_CONFIG_EXT_ADD_DIS,
        WIZARD_IMAGE_MANAGER_CONFIG_EXT_EDIT_NORMAL,
        WIZARD_IMAGE_MANAGER_CONFIG_EXT_EDIT_OVER,
        WIZARD_IMAGE_MANAGER_CONFIG_EXT_EDIT_SEL,
        WIZARD_IMAGE_MANAGER_CONFIG_EXT_EDIT_DIS,
        WIZARD_IMAGE_MANAGER_CONFIG_EXT_REMOVE_NORMAL,
        WIZARD_IMAGE_MANAGER_CONFIG_EXT_REMOVE_OVER,
        WIZARD_IMAGE_MANAGER_CONFIG_EXT_REMOVE_SEL,
        WIZARD_IMAGE_MANAGER_CONFIG_EXT_REMOVE_DIS,
        WIZARD_IMAGE_MANAGER_CONFIG_EXT_ARROW_NORMAL,
        WIZARD_IMAGE_MANAGER_CONFIG_EXT_ARROW_OVER,
        WIZARD_IMAGE_MANAGER_CONFIG_EXT_ARROW_SEL,
        WIZARD_IMAGE_MANAGER_CONFIG_EXT_ARROW_DIS,
        WIZARD_IMAGE_MANAGER_CHECK_NORMAL,
        WIZARD_IMAGE_MANAGER_CHECK_NORMAL_DISABLE,
        WIZARD_IMAGE_MANAGER_CHECK_SEL,
        WIZARD_IMAGE_MANAGER_CHECK_SEL_DISABLE,
        WIZARD_IMAGE_MANAGER_RADIO_NORMAL,
        WIZARD_IMAGE_MANAGER_RADIO_NORMAL_DISABLE,
        WIZARD_IMAGE_MANAGER_RADIO_SEL,
        WIZARD_IMAGE_MANAGER_RADIO_SEL_DISABLE,
        WIZARD_IMAGE_MANAGER_ICON_NETWORK_DISCONNECTED,
        WIZARD_IMAGE_MANAGER_CONFIG_IC_LOCATION_NORMAL,
        WIZARD_IMAGE_MANAGER_CONFIG_IC_LOCATION_OVER,
        WIZARD_IMAGE_MANAGER_CONFIG_IC_LOCATION_SEL,
        WIZARD_IMAGE_MANAGER_CONFIG_IC_LOCATION_DIS,
        WIZARD_IMAGE_MANAGER_ARROW_DOWN_NOR,
        WIZARD_IMAGE_MANAGER_ARROW_DOWN_SEL,
        WIZARD_IMAGE_MANAGER_ARROW_UP_NOR,
        WIZARD_IMAGE_MANAGER_ARROW_UP_SEL,
        WIZARD_IMAGE_MANAGER_INFO_TITLE_BACKGROUND;

    }

    public static enum UISize {
        WINDOW_SIZE,
        SIZE_TAB_BUTTONS,
        CONFIGURATION_DIALOG_SIZE,
        CONF_MENU_AREA,
        CONF_MENU_INSTALL_AREA,
        CONF_MENU_PROXY_AREA,
        CONF_MENU_EXTRA_AREA,
        CONF_CUSTOM_AREA,
        SIZE_UNINSTALLER_BASE_WINDOW,
        SIZE_UNINSTALLER_LEFT_BACKGROUND,
        SIZE_UNINSTALLER_RIGHT_BACKGROUND,
        SIZE_UNINSTALLER_READYPAGE_UNINSTALL_LOCATION,
        SIZE_UNINSTALLER_READYPAGE_UNINSTALL_LOCATION_VALUE,
        SIZE_UNINSTALLER_READYPAGE_DATA_LOCATION,
        SIZE_UNINSTALLER_READYPAGE_DATA_LOCATION_VALUE,
        SIZE_UNINSTALLER_READYPAGE_UNINSTALL_BUTTON,
        SIZE_UNINSTALLER_QUIT_BUTTON,
        SIZE_UNINSTALLER_INFO_BUTTON,
        SIZE_UNINSTALLER_UNINSTALLPAGE_PERCENT,
        SIZE_UNINSTALLER_UNINSTALLPAGE_MESSAGE,
        SIZE_UNINSTALLER_UNINSTALLPAGE_UNINSTALLING_PROGRESS,
        WIZARD_SIZE_MANAGER_BASIC,
        WIZARD_SIZE_MANAGER_TITLE_BASIC,
        WIZARD_SIZE_MANAGER_TITLE_TEXT,
        WIZARD_SIZE_MANAGER_TITLE_SUB_TEXT,
        WIZARD_SIZE_MANAGER_SPLITER,
        WIZARD_SIZE_MANAGER_TOOLBAR,
        WIZARD_SIZE_MANAGER_TITLE_HELP_BUTTON,
        WIZARD_SIZE_MANAGER_TITLE_SETTING_BUTTON,
        WIZARD_SIZE_MANAGER_TITLE_INFO_BUTTON,
        WIZARD_SIZE_MANAGER_TITLE_NETWORK_INFO,
        WIZARD_SIZE_MANAGER_TITLE_PROGRESS_BAR,
        WIZARD_SIZE_MANAGER_TITLE_MAIN_BUTTON,
        WIZARD_SIZE_MANAGER_TITLE_EXT_BUTTON,
        WIZARD_SIZE_MANAGER_TITLE_PROGRESS_BUTTON,
        WIZARD_SIZE_MANAGER_TAB_VIEW,
        WIZARD_SIZE_MANAGER_TAB_VIEW_TOP,
        WIZARD_SIZE_MANAGER_MARGIN_DEVICE_FILTER,
        WIZARD_SIZE_MANAGER_UPDATE_BUTTON,
        WIZARD_SIZE_MANAGER_MARGIN_INSTALLED_FILTER,
        WIZARD_SIZE_MANAGER_TAB_VIEW_MAIN,
        WIZARD_SIZE_MANAGER_MARGIN_TAB_VIEW_MAIN,
        WIZARD_SIZE_MANAGER_TAB_VIEW_BOTTOM,
        WIZARD_SIZE_MANAGER_MARGIN_TAB_VIEW_BOTTOM,
        WIZARD_SIZE_MANAGER_TREE,
        WIZARD_SIZE_MANAGER_PROGRESS_TOP,
        WIZARD_SIZE_MANAGER_PROGRESS_MARGIN_TOP,
        WIZARD_SIZE_MANAGER_PROGRESS_TOP_PROGRESS,
        WIZARD_SIZE_MANAGER_PROGRESS_TOP_PROGRESS_STRING,
        WIZARD_SIZE_MANAGER_PROGRESS_TOP_TIME,
        WIZARD_SIZE_MANAGER_PROGRESS_MAIN,
        WIZARD_SIZE_MANAGER_PROGRESS_MARGIN_MAIN,
        WIZARD_SIZE_MANAGER_PROGRESS_MAIN_COLUMN_NAME,
        WIZARD_SIZE_MANAGER_PROGRESS_MAIN_COLUMN_MARGIN_NAME,
        WIZARD_SIZE_MANAGER_PROGRESS_MAIN_COLUMN_STATUS,
        WIZARD_SIZE_MANAGER_PROGRESS_MAIN_COLUMN_PROGRESS,
        WIZARD_SIZE_MANAGER_PROGRESS_MAIN_COLUMN_PROGRESS_PROGRESS,
        WIZARD_SIZE_MANAGER_PROGRESS_MAIN_COLUMN_CANCEL,
        WIZARD_SIZE_BASIC,
        WIZARD_SIZE_TOP,
        WIZARD_SIZE_CENTER,
        WIZARD_SIZE_SPLITTER,
        WIZARD_SIZE_BOTTOM,
        WIZARD_SIZE_TITLE_MAIN,
        WIZARD_SIZE_TITLE_INFO,
        WIZARD_SIZE_INFO_BUTTON,
        WIZARD_SIZE_INFO_TOOLTIP,
        WIZARD_SIZE_BOTTOM_BUTTON,
        WIZARD_SIZE_BOTTOM_BUTTON_MARGIN,
        WIZARD_SIZE_INSTALL_IC_SDK,
        WIZARD_SIZE_INSTALL_IC_STROKE,
        WIZARD_SIZE_UNINSTALLATION_LOCATION,
        WIZARD_SIZE_UNINSTALLATION_LOCATION_LABEL,
        WIZARD_SIZE_UNINSTALLATION_LOCATION_EMPTY_SPACE,
        WIZARD_SIZE_UNINSTALLATION_LOCATION_VALUE,
        WIZARD_SIZE_UNINSTALLATION_SELECT_COMPONENT,
        WIZARD_SIZE_UNINSTALLATION_SELECT_COMPONENT_MARGIN,
        WIZARD_SIZE_UNINSTALLATION_SELECT_COMPONENT_LABEL,
        WIZARD_SIZE_UNINSTALLATION_SELECT_COMPONENT_CHECKBOX,
        WIZARD_SIZE_UNINSTALLATION_SELECT_COMPONENT_CHECKBOX_MARGIN,
        WIZARD_SIZE_UNINSTALLATION_SELECT_COMPONENT_DESC,
        WIZARD_SIZE_UNINSTALLATION_SELECT_COMPONENT_DESC_MARGIN,
        WIZARD_SIZE_COMPLETE_CONFIRM_MESSAGE,
        WIZARD_SIZE_UNINSTALLING_LOCATION,
        WIZARD_SIZE_MESSAGEBOX_DIALOG,
        WIZARD_SIZE_MESSAGEBOX_DIALOG_CONTENT,
        WIZARD_SIZE_MESSAGEBOX_DIALOG_CONTENT_ICON,
        WIZARD_SIZE_MESSAGEBOX_DIALOG_CONTENT_TEXT,
        WIZARD_SIZE_MESSAGEBOX_DIALOG_LINE,
        WIZARD_SIZE_MESSAGEBOX_DIALOG_OK_BUTTON,
        WIZARD_SIZE_MESSAGEBOX_DIALOG_CANCEL_BUTTON,
        WIZARD_CONF_DIALOG_SIZE,
        WIZARD_CONF_TAB_AREA,
        WIZARD_CONF_MENU_AREA,
        WIZARD_CONF_CUSTOM_AREA,
        WIZARD_CONF_BOTTOM_AREA,
        WIZARD_CONF_TAB_INSTALL_OPTION_BUTTON,
        WIZARD_CONF_TAB_NETWORK_OPTION_BUTTON,
        WIZARD_CONF_MENU_INSTALL_AREA,
        WIZARD_CONF_MENU_PROXY_AREA,
        WIZARD_CONF_MENU_EXTRA_AREA,
        WIZARD_CONF_ERROR_LABEL_SIZE,
        WIZARD_CONF_BUTTON_SIZE,
        WIZARD_CONF_INSTALL_OPTION_AREA,
        WIZARD_CONF_INSTALL_OPTION_AREA_MARGIN,
        WIZARD_CONF_INSTALL_OPTION_MAINSDK_LABEL,
        WIZARD_CONF_INSTALL_OPTION_GROUP_MARGIN,
        WIZARD_CONF_INSTALL_OPTION_RADIO,
        WIZARD_CONF_INSTALL_OPTION_RADIO_BUTTON,
        WIZARD_CONF_INSTALL_OPTION_PKGSERVER_LABEL,
        WIZARD_CONF_INSTALL_OPTION_PKGSERVER_ERROR_LABEL,
        WIZARD_CONF_INSTALL_OPTION_PKGSERVER_COMBO,
        WIZARD_CONF_INSTALL_OPTION_PKGSERVER_BROWSE,
        WIZARD_CONF_INSTALL_OPTION_PKGSERVER_APPLY,
        WIZARD_CONF_INSTALL_OPTION_PKGSERVER_SDKIMAGE,
        WIZARD_CONF_INSTALL_OPTION_PKGSERVER_SDKIMAGE_INPUT,
        WIZARD_CONF_INSTALL_OPTION_PKGSERVER_SDKIMAGE_INPUT_INNER_MARGIN,
        WIZARD_CONF_INSTALL_OPTION_PKGSERVER_SDKIMAGE_BROWSE,
        WIZARD_CONF_INSTALL_OPTION_PKGSERVER_SDKIMAGE_INFO,
        WIZARD_CONF_INSTALL_OPTION_PKGSERVER_SDKIMAGE_INFO_MARGIN,
        WIZARD_CONF_INSTALL_OPTION_DIST_GRID,
        WIZARD_CONF_INSTALL_OPTION_DIST_LABEL,
        WIZARD_CONF_INSTALL_OPTION_DIST_COMBO,
        WIZARD_CONF_INSTALL_OPTION_DIST_CHECKBOX,
        WIZARD_CONF_INSTALL_OPTION_DIST_SNAPSHOT_CHECKBOX,
        WIZARD_CONF_INSTALL_OPTION_DIST_SNAPSHOT,
        WIZARD_CONF_INSTALL_OPTION_DIST_SNAPSHOT_COLUMN,
        WIZARD_CONF_INSTALL_OPTION_EXT_ARROW_BUTTON,
        WIZARD_CONF_INSTALL_OPTION_EXT_TABLE_COLUMN,
        WIZARD_CONF_INSTALL_OPTION_EXT_GROUP_MARGIN,
        WIZARD_CONF_INSTALL_OPTION_EXT_GRID,
        WIZARD_CONF_INSTALL_OPTION_EXT_IMG_BUTTON,
        WIZARD_CONF_INSTALL_OPTION_EXT_TABLE,
        WIZARD_CONF_INSTALL_OPTION_EXT_INFO_BOX,
        WIZARD_CONF_INSTALL_OPTION_EXT_INFO_BOX_MARGIN,
        WIZARD_CONF_INSTALL_OPTION_EXT_INFO_BOX_TEXT,
        WIZARD_CONF_INSTALL_OPTION_EXT_ADD_DIALOG,
        WIZARD_CONF_INSTALL_OPTION_EXT_ADD_DIALOG_CONTENT_MARGIN,
        WIZARD_CONF_INSTALL_OPTION_EXT_ADD_DIALOG_BOTTOM_MARGIN,
        WIZARD_CONF_INSTALL_OPTION_EXT_ADD_DIALOG_BOTTOM_BUTTON,
        WIZARD_CONF_INSTALL_OPTION_EXT_ADD_DIALOG_NAME,
        WIZARD_CONF_INSTALL_OPTION_EXT_ADD_DIALOG_REPOSITORY,
        WIZARD_CONF_INSTALL_OPTION_EXT_ADD_DIALOG_TEXT_MARGIN,
        WIZARD_PROXY_DIALOG_SIZE,
        WIZARD_PROXY_DIALOG_CONTENT_AREA,
        WIZARD_PROXY_DIALOG_BOTTOM_AREA,
        WIZARD_PROXY_BUTTON_SIZE,
        WIZARD_CONF_NETWORK_AREA,
        WIZARD_CONF_NETWORK_AREA_GRID,
        WIZARD_CONF_NETWORK_AREA_MARGIN,
        WIZARD_CONF_NETWORK_GROUP_MARGIN,
        WIZARD_CONF_NETWORK_RADIO,
        WIZARD_CONF_NETWORK_MANUAL_INPUT,
        WIZARD_CONF_NETWORK_MANUAL_INPUT_WIDTH,
        WIZARD_CONF_NETWORK_MANUAL_INPUT_INNER_MARGIN,
        WIZARD_CONF_NETWORK_APPLY_BUTTON,
        WIZARD_NOTI_DAILOG_AREA,
        WIZARD_NOTI_DAILOG_LOCATION_MARGIN,
        WIZARD_NOTI_DAILOG_BG_IMAGE,
        WIZARD_NOTI_DAILOG_INNER_MARGIN,
        WIZARD_INFO_DAILOG_SIZE,
        WIZARD_INFO_DAILOG_TOP_SIZE,
        WIZARD_INFO_DAILOG_MID_SIZE,
        WIZARD_INFO_DAILOG_BOTTOM_SIZE,
        WIZARD_INFO_DAILOG_TOP_MARGIN,
        WIZARD_INFO_DAILOG_TITLE,
        WIZARD_INFO_DAILOG_SUB_TITLE,
        WIZARD_INFO_DAILOG_BOTTOM_MARGIN,
        WIZARD_INFO_DAILOG_BUTTON,
        WIZARD_INFO_DAILOG_MID_MARGIN,
        WIZARD_INFO_DAILOG_MID_GRID_MARGIN,
        WIZARD_INFO_DAILOG_CONTENT;

    }

    public static enum UITerms {
        MANAGER_TITLE,
        CONFIGURATION_DIALOG_TITLE,
        UNINSTALLER_TITLE;

    }
}

