/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.ContentProvider;
import org.tizen.manager.core.ValidationResult;
import org.tizen.manager.core.config.Config;
import org.tizen.manager.core.config.ConfigFile;
import org.tizen.manager.core.model.ExtensionInformation;
import org.tizen.manager.core.model.ExtensionRoot;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.pkg.PackageManager;
import org.tizen.manager.util.DownloadProgressMonitor;
import org.tizen.manager.util.Downloader;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.NetworkUtil;
import org.tizen.manager.util.PathUtil;
import org.tizen.manager.util.ZipLibrary;

public class ExtRepositoryManager
implements Cloneable {
    private static final Logger logger = Log.getLogger(ExtRepositoryManager.class);
    private static final String LOCAL_XML_FILE_NAME = "ext-repo-info.xml";
    private static String LOCAL_XML_FILE_PATH;
    public static final String EXT_REPO_FILE_EXTENSION = ".zip";
    private ArrayList<ExtensionInformation> remoteExtensions;
    private ArrayList<ExtensionInformation> localExtensions;
    private ArrayList<ExtensionInformation> currentExtensions;
    private ContentProvider contentProvier;

    public ExtRepositoryManager(ContentProvider contentProvier) {
        this.contentProvier = contentProvier;
        this.remoteExtensions = new ArrayList();
        this.localExtensions = new ArrayList();
        this.currentExtensions = new ArrayList();
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public ExtRepositoryManager clone(ContentProvider contentProvider) throws CloneNotSupportedException {
        int i;
        ExtRepositoryManager extRepoMgr = (ExtRepositoryManager)this.clone();
        extRepoMgr.remoteExtensions = new ArrayList();
        for (i = 0; i < this.remoteExtensions.size(); ++i) {
            extRepoMgr.remoteExtensions.add(i, (ExtensionInformation)this.remoteExtensions.get(i).clone());
        }
        extRepoMgr.localExtensions = new ArrayList();
        for (i = 0; i < this.localExtensions.size(); ++i) {
            extRepoMgr.localExtensions.add(i, (ExtensionInformation)this.localExtensions.get(i).clone());
        }
        extRepoMgr.currentExtensions = new ArrayList();
        for (i = 0; i < this.currentExtensions.size(); ++i) {
            extRepoMgr.currentExtensions.add(i, (ExtensionInformation)this.currentExtensions.get(i).clone());
        }
        extRepoMgr.contentProvier = contentProvider;
        return extRepoMgr;
    }

    public void init(boolean ignoreError) throws UMException {
        this.init(ignoreError, false);
    }

    public void initOption(boolean ignoreError, boolean option) throws UMException {
        this.init(ignoreError, option);
    }

    private void init(boolean ignoreError, boolean onlyRemote) throws UMException {
        block6: {
            block5: {
                LOCAL_XML_FILE_PATH = PathUtil.getFromInstalledPath(this.contentProvier.getSDKInfo(), ".info", LOCAL_XML_FILE_NAME);
                this.remoteExtensions = new ArrayList();
                this.localExtensions = new ArrayList();
                this.currentExtensions = new ArrayList();
                try {
                    this.loadRemoteExtensionInfo();
                }
                catch (UMException e) {
                    logger.error(e.getMessage());
                    if (ignoreError) break block5;
                    throw e;
                }
            }
            if (!onlyRemote) {
                try {
                    this.loadLocalExtensionInfo();
                }
                catch (UMException e) {
                    logger.throwing(e);
                    if (ignoreError) break block6;
                    throw e;
                }
            }
        }
        this.makeCurrentExtensionInfo();
    }

    public ArrayList<ExtensionInformation> getCurrentExtensions() {
        return this.currentExtensions;
    }

    public ExtensionInformation getExtensionInfoById(String repoId) {
        for (ExtensionInformation extInfo : this.currentExtensions) {
            if (repoId == null || !extInfo.getId().equals(repoId)) continue;
            return extInfo;
        }
        return null;
    }

    public void updateRepositories(ArrayList<ExtensionInformation> newRepositories) {
        this.currentExtensions = newRepositories;
        ExtensionRoot extRoot = ExtensionRoot.getInstance();
        extRoot.setExtensions(this.currentExtensions);
    }

    public void writeToFile() {
        ExtensionRoot extRoot = ExtensionRoot.getInstance();
        extRoot.setExtensions(this.currentExtensions);
        this.objectToXml(extRoot);
    }

    public void writeToFile(ArrayList<ExtensionInformation> extensions) {
        ExtensionRoot extRoot = ExtensionRoot.getInstance();
        extRoot.setExtensions(extensions);
        this.objectToXml(extRoot);
    }

    public ValidationResult validateRepository(String repoURL, String repoId) throws UMException {
        ValidationResult result = new ValidationResult(null, null);
        if (!NetworkUtil.isURL(repoURL)) {
            throw new UMException(ErrorController.ErrorCode.INVALID_INPUT_URL_FORMAT);
        }
        if (repoURL != null && repoURL.endsWith(EXT_REPO_FILE_EXTENSION)) {
            result = this.downloadToCacheDir(repoURL, repoId);
            this.validateExtensionRepoFile(result.getCachePath());
        } else {
            File downloaded = this.downloadPackageListToTempDirectory(repoURL);
            if (downloaded == null) {
                throw new UMException(ErrorController.ErrorCode.UNAVAILABLE_EXT_REP_URL, repoURL);
            }
        }
        return result;
    }

    private void loadRemoteExtensionInfo() throws UMException {
        ConfigFile configFile = this.contentProvier.getConfig().getConfigFile();
        assert (configFile != null);
        String repository = NetworkUtil.getURL(configFile.getRepository(), configFile.getDistribution());
        ArrayList<ExtensionInformation> result = this.readExtensionXmlFromRepository(repository);
        for (ExtensionInformation extInfo : result) {
            extInfo.setRepository(NetworkUtil.normalizeURL(extInfo.getRepository()));
            extInfo.setDefaultExtension(true);
        }
        this.remoteExtensions.addAll(result);
    }

    public boolean isRemoteExtensionRepository(String repoId) {
        for (ExtensionInformation extRepo : this.remoteExtensions) {
            if (!extRepo.getId().equals(repoId)) continue;
            return true;
        }
        return false;
    }

    public boolean isLocalFileExtRepo(ExtensionInformation extInfo) {
        URL url = null;
        try {
            url = new URL(extInfo.getRepository());
        }
        catch (MalformedURLException e) {
            logger.throwing(e);
            return false;
        }
        return extInfo.getRepotype().equals("file") && url.getProtocol().equals("file");
    }

    private void loadLocalExtensionInfo() throws UMException {
        File xmlFile = new File(LOCAL_XML_FILE_PATH);
        assert (xmlFile == null);
        if (xmlFile.exists()) {
            this.localExtensions.addAll(this.xmlToObject(xmlFile));
        }
    }

    private void makeCurrentExtensionInfo() {
        for (ExtensionInformation remote : this.remoteExtensions) {
            this.updateToCurrentExtensions(remote);
        }
        for (ExtensionInformation local : this.localExtensions) {
            this.updateToCurrentExtensions(local);
        }
    }

    public String getExtCacheDirBySDK() {
        String hashCode = Long.toString((long)this.contentProvier.getSDKInfo().getInstalledPath().hashCode() & 0xFFFFFFFFL);
        return PathUtil.get(Config.getManagerConfigHome(), "extension-cache", hashCode);
    }

    public String getExtCacheDir(String repoID) {
        String hashCode = Long.toString((long)this.contentProvier.getSDKInfo().getInstalledPath().hashCode() & 0xFFFFFFFFL);
        return NetworkUtil.getURL(NetworkUtil.getFileURL(Config.getManagerConfigHome()), "extension-cache", hashCode, repoID);
    }

    public void removeFromCache(String repoId) {
        try {
            URL url = new URL(this.getExtCacheDir(repoId));
            PathUtil.remove(url.getPath());
        }
        catch (MalformedURLException e) {
            logger.throwing(e);
            logger.warn("Cannot remove extension cache. : " + repoId);
        }
    }

    private ValidationResult downloadToCacheDir(String repoURL, String repoID) throws UMException {
        String targetFilePath = null;
        String lastModified = null;
        try {
            Downloader downloader;
            long size;
            URL zipURL = new URL(repoURL);
            String tmp = zipURL.toString();
            String[] splits = tmp.split("/");
            String fileName = splits[splits.length - 1];
            String hashCode = Long.toString((long)this.contentProvier.getSDKInfo().getInstalledPath().hashCode() & 0xFFFFFFFFL);
            targetFilePath = PathUtil.get(Config.getManagerConfigHome(), "extension-cache", hashCode, repoID, fileName);
            File targetFile = new File(targetFilePath);
            if (zipURL.getProtocol().equals("file") && NetworkUtil.isSameURL(repoURL, NetworkUtil.getFileURL(targetFilePath))) {
                if (!targetFile.exists()) {
                    throw new UMException(ErrorController.ErrorCode.INVALID_EXT_REPO_CACHE, repoURL);
                }
                return new ValidationResult(targetFilePath, null);
            }
            if (targetFile.exists()) {
                ExtensionInformation extRepo = this.getExtensionInfoById(repoID);
                if (extRepo != null && !this.isExtRepositoryUpdated(extRepo, zipURL, targetFile)) {
                    return new ValidationResult(targetFilePath, null);
                }
                PathUtil.remove(targetFile);
            }
            if ((size = (downloader = new Downloader(this.contentProvier.getConfig(), zipURL)).download(targetFilePath, new DownloadProgressMonitor())) < 0L || !new File(targetFilePath).exists()) {
                throw new UMException(ErrorController.ErrorCode.CANNOT_DOWNLOAD_FILE, repoURL);
            }
            lastModified = downloader.getURLConnection() != null ? new Date(downloader.getURLConnection().getLastModified()).toString() : new Date(new File(targetFilePath).lastModified()).toString();
        }
        catch (MalformedURLException e) {
            logger.throwing(e);
            throw new UMException(ErrorController.ErrorCode.CANNOT_DOWNLOAD_FILE, (Throwable)e);
        }
        return new ValidationResult(targetFilePath, lastModified);
    }

    private boolean isExtRepositoryUpdated(ExtensionInformation extRepo, URL repoURL, File targetFile) {
        try {
            URLConnection conn = this.contentProvier.getConfig().getProxyConfig().connectWithConfiguration(repoURL, 0L, -1, -1);
            if (conn != null) {
                String lastModifiedDate = new Date(conn.getLastModified()).toString();
                return (long)conn.getContentLength() != targetFile.length() || !extRepo.getLastModifiedDate().equals(lastModifiedDate);
            }
            return true;
        }
        catch (UMException e) {
            logger.throwing(e);
            return true;
        }
    }

    public void unzipNeededFiles(File zipFile, String repoId) throws UMException {
        logger.trace("\tPackage list file found in SDK image => " + zipFile.getAbsolutePath());
        String hashCode = Long.toString((long)this.contentProvier.getSDKInfo().getInstalledPath().hashCode() & 0xFFFFFFFFL);
        String unzipTargetDir = PathUtil.get(Config.getManagerConfigHome(), "extension-cache", hashCode, repoId);
        ZipLibrary zlpLibrary = null;
        try {
            zlpLibrary = new ZipLibrary(zipFile.getAbsolutePath(), null);
            ArrayList<String> fileNames = new ArrayList<String>();
            fileNames.add(PackageManager.getPackageListFileName());
            zlpLibrary.unzipSelectedList(unzipTargetDir, fileNames);
        }
        catch (Exception e) {
            logger.throwing(e);
            throw new UMException(ErrorController.ErrorCode.FAIL_TO_EXTRACT_EXTENSION_FILE, (Throwable)e);
        }
        finally {
            if (zlpLibrary != null) {
                zlpLibrary.close();
            }
        }
    }

    private void updateToCurrentExtensions(ExtensionInformation addItem) {
        for (ExtensionInformation extInfo : this.currentExtensions) {
            if (!extInfo.getId().equals(addItem.getId())) continue;
            extInfo.setActivateStatus(addItem.getActivateStatus());
            if (addItem.getLastModifiedDate() != null) {
                extInfo.setLastModifiedDate(addItem.getLastModifiedDate());
            }
            return;
        }
        this.currentExtensions.add(addItem);
    }

    private File downloadPackageListToTempDirectory(String repoURL) {
        long size;
        URL serverUrl = null;
        try {
            serverUrl = new URL(NetworkUtil.getURL(repoURL, PackageManager.getPackageListFileName()));
        }
        catch (MalformedURLException e) {
            logger.throwing(e);
        }
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("extra_pkg", ".list");
            tmpFile.deleteOnExit();
        }
        catch (IOException e) {
            logger.error("Cannot create temporary file to cache extra package list.");
            logger.throwing(e);
            return null;
        }
        try {
            Downloader dl = new Downloader(this.contentProvier.getConfig(), serverUrl);
            size = dl.download(tmpFile.getAbsolutePath(), new DownloadProgressMonitor());
        }
        catch (UMException e) {
            logger.error("Fail to download extra package list from ==> " + serverUrl);
            logger.throwing(e);
            return null;
        }
        if (size > 0L) {
            logger.trace("\tSuccess to download extra package list. ==> " + tmpFile.getAbsolutePath());
            return tmpFile;
        }
        logger.error("Fail to download extra package list. ==> " + tmpFile.getAbsolutePath());
        return null;
    }

    private ArrayList<ExtensionInformation> readExtensionXmlFromRepository(String repoBaseURL) throws UMException {
        ArrayList<ExtensionInformation> result = new ArrayList();
        File tmp = null;
        try {
            tmp = File.createTempFile("ext-repo-info", ".xml");
            tmp.deleteOnExit();
        }
        catch (IOException e) {
            logger.throwing(e);
            throw new UMException(ErrorController.ErrorCode.CANNOT_CREATE_TEMP_FILE, (Throwable)e);
        }
        URL xmlInfoFileUrl = this.getExtXmlFileURL(repoBaseURL);
        if (xmlInfoFileUrl == null) {
            throw new UMException(ErrorController.ErrorCode.INVALID_REPO_URL_FORMAT, repoBaseURL);
        }
        try {
            Downloader downloader = new Downloader(this.contentProvier.getConfig(), xmlInfoFileUrl);
            long size = downloader.download(tmp.getAbsolutePath(), new DownloadProgressMonitor());
            if (size < 0L) {
                throw new UMException(ErrorController.ErrorCode.CANNOT_DOWNLOAD_FILE);
            }
        }
        catch (UMException e) {
            logger.error("[" + repoBaseURL + "] " + e.getMessage());
            throw new UMException(ErrorController.ErrorCode.FAILED_TO_DOWNLOAD_REPO_CONFIG_FILE, xmlInfoFileUrl.toString(), e);
        }
        result = this.xmlToObject(tmp);
        if (tmp.exists() && !tmp.delete()) {
            logger.error("Fail to delete file ==> " + tmp);
        }
        return result;
    }

    private URL getExtXmlFileURL(String repoBaseURL) {
        String extXmlFilePath = NetworkUtil.getURL(repoBaseURL, "extension_info.xml");
        try {
            return new URL(extXmlFilePath);
        }
        catch (MalformedURLException e) {
            logger.error("Cannot connect extension information xml file in repository(" + extXmlFilePath + ")");
            return null;
        }
    }

    private ArrayList<ExtensionInformation> xmlToObject(File xmlFile) throws UMException {
        ArrayList<ExtensionInformation> extInfos = new ArrayList();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ExtensionRoot.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            ExtensionRoot extRoot = (ExtensionRoot)jaxbUnmarshaller.unmarshal(xmlFile.toURI().toURL());
            extInfos = extRoot.getExtensions();
        }
        catch (JAXBException e) {
            logger.throwing(e);
            throw new UMException(ErrorController.ErrorCode.INVALID_EXT_INFO_XML_FILE, (Throwable)e);
        }
        catch (IOException e) {
            logger.throwing(e);
            throw new UMException(ErrorController.ErrorCode.INVALID_EXT_INFO_XML_FILE, (Throwable)e);
        }
        return extInfos;
    }

    private void objectToXml(ExtensionRoot extRoot) {
        File xmlFile = null;
        try {
            if (LOCAL_XML_FILE_PATH != null && !LOCAL_XML_FILE_PATH.isEmpty()) {
                xmlFile = new File(LOCAL_XML_FILE_PATH);
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ExtensionRoot.class});
                Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
                jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
                jaxbMarshaller.marshal((Object)extRoot, xmlFile);
            }
        }
        catch (JAXBException e) {
            xmlFile.delete();
            e.printStackTrace();
        }
    }

    public void validateExtensionRepoFile(String repoFilePath) throws UMException {
        ZipFile zipFile = null;
        ZipEntry entry = null;
        try {
            zipFile = new ZipFile(repoFilePath);
            String packageList = PackageManager.getPackageListFileName();
            entry = zipFile.getEntry(packageList);
            if (entry == null) {
                throw new UMException(ErrorController.ErrorCode.INVALID_EXT_REPO_FILE, "The package information file('" + packageList + "') not found.");
            }
        }
        catch (IOException e) {
            logger.throwing(e);
            throw new UMException(ErrorController.ErrorCode.INVALID_EXT_REPO_FILE, (Throwable)e);
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException e) {
                logger.throwing(e);
            }
        }
    }

    public static ExtensionInformation createNewRepository(String repoId, String repoName, String repoURL, boolean isActive, String lastModified) {
        if (repoURL != null && repoURL.endsWith(EXT_REPO_FILE_EXTENSION)) {
            return new ExtensionInformation(repoId, repoName, repoURL, isActive, "file", lastModified);
        }
        return new ExtensionInformation(repoId, repoName, repoURL, isActive, "server", lastModified);
    }

    public String getExtensionFileName(String repoId) {
        String fileName = null;
        for (ExtensionInformation extInfo : this.currentExtensions) {
            if (!extInfo.getId().equals(repoId)) continue;
            URL url = null;
            try {
                url = new URL(extInfo.getRepository());
                if (url == null) break;
                String filePath = url.toString();
                String[] split = filePath.split("/");
                fileName = split[split.length - 1];
            }
            catch (Exception e) {
                logger.error(e);
            }
            break;
        }
        return fileName;
    }
}

