/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.pkg;

import java.util.ArrayList;
import java.util.Collection;
import org.tizen.manager.exception.ProgressLog;
import org.tizen.manager.pkg.Package;
import org.tizen.manager.pkg.PackageManager;
import org.tizen.manager.pkg.PackageSet;

public class Component
implements Comparable<Component> {
    private Package repoPackage;
    private Package installedPackage;
    private Package recentPackage;
    private Component parent = null;
    private ArrayList<Component> children;
    private ArrayList<Component> selGroupChildren;
    private InstallState installState = InstallState.INSTALL;
    private Exception error = null;
    private boolean isConflict = false;
    private boolean isLicenseAgreed = false;
    private ArrayList<ProgressLog> logs;
    private PackageManager pkgmgr;

    public Component(PackageManager pkgmgr, Package repoPkg, Package installedPackage, InstallState state) {
        this.pkgmgr = pkgmgr;
        this.repoPackage = repoPkg;
        this.installedPackage = installedPackage;
        this.recentPackage = null;
        this.installState = state;
        this.children = new ArrayList();
        this.selGroupChildren = new ArrayList();
        this.logs = new ArrayList();
        this.updateRecentPackage();
    }

    public String getDisplayName() {
        return this.recentPackage.getLabel();
    }

    public String getPackageName() {
        return this.recentPackage.getPackageName();
    }

    public String getLatestVersion() {
        return this.recentPackage.getVersion().toString();
    }

    public String getInstalledVersion() {
        if (this.installedPackage != null) {
            return this.installedPackage.getVersion().toString();
        }
        return "";
    }

    public Long getInstallSize() {
        if (this.pkgmgr == null) {
            return 0L;
        }
        long size = 0L;
        Collection<String> dependentPackageNames = this.recentPackage.getDependentPackageNames();
        PackageSet packagesByNames = this.pkgmgr.getPackagesByNames(dependentPackageNames);
        size = this.pkgmgr.getTotalSizeOfInstallablePackages(packagesByNames, true);
        return size;
    }

    public Long getUninstallSize() {
        if (this.pkgmgr == null) {
            return 0L;
        }
        long size = 0L;
        Collection<String> dependentPackageNames = this.getInstalledPackage().getDependentPackageNames();
        PackageSet packagesByNames = this.pkgmgr.getPackagesByNames(dependentPackageNames);
        size = this.pkgmgr.getTotalSizeOfRemovablePackages(packagesByNames);
        return size;
    }

    public void addChildItem(Component item) {
        this.children.add(item);
    }

    public ArrayList<Component> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return !this.getChildren().isEmpty();
    }

    public Component getParent() {
        return this.parent;
    }

    public Component getRootComponent() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRootComponent();
    }

    public void setRepoPackage(Package pkg) {
        this.repoPackage = pkg;
        this.updateRecentPackage();
    }

    public Package getRepoPackage() {
        return this.repoPackage;
    }

    public synchronized void setInstalledPackage(Package pkg) {
        this.installedPackage = pkg;
        this.updateRecentPackage();
    }

    public synchronized Package getInstalledPackage() {
        return this.installedPackage;
    }

    private void updateRecentPackage() {
        this.recentPackage = this.repoPackage != null ? (this.installedPackage != null ? (this.repoPackage.getVersion().compareTo(this.installedPackage.getVersion()) > 0 ? this.repoPackage : this.installedPackage) : this.repoPackage) : this.installedPackage;
    }

    public synchronized Package getRecentPackage() {
        return this.recentPackage;
    }

    public void setParent(Component parentItem) {
        this.parent = parentItem;
    }

    public void setDependentComponents(ArrayList<Component> children) {
        this.selGroupChildren = children;
    }

    public ArrayList<Component> getDependentComponents() {
        return this.selGroupChildren;
    }

    public void setInstallState(InstallState state) {
        this.installState = state;
    }

    public InstallState getInstallState() {
        return this.installState;
    }

    public int getOrder() {
        if (this.repoPackage != null) {
            return this.repoPackage.getOrder();
        }
        return 0;
    }

    public String getInstallStateMessage() {
        if (this.hasChildren() || this.getParent() == null) {
            return "";
        }
        return this.installState.getMessage();
    }

    public ArrayList<Component> getLeafDecendents() {
        ArrayList<Component> result = new ArrayList<Component>();
        for (Component subComponent : this.getChildren()) {
            if (subComponent.hasChildren()) {
                result.addAll(subComponent.getLeafDecendents());
                continue;
            }
            result.add(subComponent);
        }
        return result;
    }

    public boolean hasInstallingLeafDecendents() {
        for (Component leafComp : this.getLeafDecendents()) {
            if (leafComp.getInstallState() != InstallState.INSTALLING && leafComp.getInstallState() != InstallState.UPDATING) continue;
            return true;
        }
        return false;
    }

    public boolean hasUninstallingLeafDecendents() {
        for (Component leafComp : this.getLeafDecendents()) {
            if (leafComp.getInstallState() != InstallState.UNINSTALLING && leafComp.getInstallState() != InstallState.UPDATING) continue;
            return true;
        }
        return false;
    }

    public boolean hasInstallableLeafDecendents() {
        for (Component leafComp : this.getLeafDecendents()) {
            if (leafComp.getInstallState() != InstallState.INSTALL) continue;
            return true;
        }
        return false;
    }

    public boolean hasUninstallableLeafDecendents() {
        for (Component leafComp : this.getLeafDecendents()) {
            if (leafComp.getInstallState() != InstallState.UNINSTALL && leafComp.getInstallState() != InstallState.UPDATE) continue;
            return true;
        }
        return false;
    }

    public boolean hasUpdatableLeafDecendents() {
        for (Component leafComp : this.getLeafDecendents()) {
            if (leafComp.getInstallState() != InstallState.UPDATE) continue;
            return true;
        }
        return false;
    }

    public void setConflict(boolean isConflict) {
        this.isConflict = isConflict;
    }

    public boolean isConflict() {
        return this.isConflict;
    }

    public String toString() {
        if (this.getParent() == null) {
            return this.getPackageName() + "(" + this.getLatestVersion() + ")";
        }
        return this.getParent().toString() + " / " + this.getPackageName();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Component other = (Component)obj;
        if (other.toString() != null) {
            return false;
        }
        return this.toString().equals(other.toString());
    }

    public boolean hasPopup() {
        Package recentPkg = this.recentPackage;
        if (recentPkg.hasPopup()) {
            return true;
        }
        PackageSet installedPackages = this.pkgmgr.getInstalledPackages();
        for (Package pkg : this.pkgmgr.getAllDependentPackages(recentPkg)) {
            if (!pkg.hasPopup() || installedPackages == null || !installedPackages.contains(pkg)) continue;
            return true;
        }
        if (this.children != null && !this.children.isEmpty()) {
            ArrayList clone = (ArrayList)this.children.clone();
            for (Component component : clone) {
                if (component.hasPopup() && installedPackages != null && !installedPackages.contains(component.getRecentPackage())) {
                    return true;
                }
                Package recentPackage2 = component.getRecentPackage();
                for (Package pkg : this.pkgmgr.getAllDependentPackages(recentPackage2)) {
                    if (!pkg.hasPopup() || installedPackages == null || installedPackages.contains(pkg)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String getPopupString() {
        String result = "";
        PackageSet pkgs = new PackageSet();
        Package recentPkg = this.recentPackage;
        pkgs.add(recentPkg);
        pkgs.addAll(this.pkgmgr.getAllDependentPackages(recentPkg));
        PackageSet installedPackages = this.pkgmgr.getInstalledPackages();
        if (this.children != null && !this.children.isEmpty()) {
            ArrayList clone = (ArrayList)this.children.clone();
            for (Component component : clone) {
                if (component.hasPopup() && installedPackages != null && !installedPackages.contains(component.getRecentPackage())) {
                    pkgs.add(component.getRecentPackage());
                }
                Package recentPackage2 = component.getRecentPackage();
                for (Package pkg : this.pkgmgr.getAllDependentPackages(recentPackage2)) {
                    if (!pkg.hasPopup() || installedPackages == null || installedPackages.contains(pkg)) continue;
                    pkgs.add(pkg);
                }
            }
        }
        for (Package pkg : pkgs) {
            if (!pkg.hasPopup()) continue;
            result = pkg.getPopup() + "\n\n";
        }
        return result;
    }

    public boolean hasLicense() {
        Package recentPkg = this.recentPackage;
        if (recentPkg.hasLicense()) {
            return true;
        }
        PackageSet installedPackages = this.pkgmgr.getInstalledPackages();
        for (Package pkg : this.pkgmgr.getAllDependentPackages(recentPkg)) {
            if (!pkg.hasLicense() || installedPackages == null || installedPackages.contains(pkg)) continue;
            return true;
        }
        if (this.children != null && !this.children.isEmpty()) {
            ArrayList clone = (ArrayList)this.children.clone();
            for (Component component : clone) {
                if (component.hasLicense() && installedPackages != null && !installedPackages.contains(component.getRecentPackage())) {
                    return true;
                }
                Package recentPackage2 = component.getRecentPackage();
                for (Package pkg : this.pkgmgr.getAllDependentPackages(recentPackage2)) {
                    if (!pkg.hasLicense() || installedPackages == null || installedPackages.contains(pkg)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String getLicense() {
        StringBuilder result = new StringBuilder("");
        PackageSet pkgs = new PackageSet();
        Package recentPkg = this.repoPackage;
        pkgs.add(recentPkg);
        pkgs.addAll(this.pkgmgr.getAllDependentPackages(recentPkg));
        PackageSet installedPackages = this.pkgmgr.getInstalledPackages();
        if (this.children != null && !this.children.isEmpty()) {
            ArrayList clone = (ArrayList)this.children.clone();
            for (Component component : clone) {
                if (component.hasLicense() && installedPackages != null && !installedPackages.contains(component.getRecentPackage())) {
                    pkgs.add(component.getRecentPackage());
                }
                Package recentPackage2 = component.getRecentPackage();
                for (Package pkg : this.pkgmgr.getAllDependentPackages(recentPackage2)) {
                    if (!pkg.hasLicense() || installedPackages == null || installedPackages.contains(pkg)) continue;
                    pkgs.add(pkg);
                }
            }
        }
        for (Package pkg : pkgs) {
            if (!pkg.hasLicense()) continue;
            result.append(pkg.getLicense()).append("\n\n");
        }
        return result.toString();
    }

    public boolean isLicenseAgreed() {
        if (this.isLicenseAgreed) {
            return true;
        }
        for (Package pkg : this.pkgmgr.getInstallablePackages(this.recentPackage)) {
            if (!pkg.hasLicense()) continue;
            return false;
        }
        return true;
    }

    public void setLicenseAgreed(boolean val) {
        this.isLicenseAgreed = val;
    }

    public void setError(Exception err) {
        this.error = err;
    }

    public Exception getError() {
        return this.error;
    }

    @Override
    public int compareTo(Component item) {
        int order = item.getOrder();
        if (order > this.getOrder()) {
            return -1;
        }
        if (order == this.getOrder()) {
            return this.getDisplayName().compareTo(item.getDisplayName());
        }
        if (order < this.getOrder()) {
            return 1;
        }
        return 0;
    }

    public ArrayList<String> getSelectedGroupNames() {
        return this.recentPackage.getSelectedGroupNames();
    }

    public void resetProgressLogs() {
        this.logs = new ArrayList();
    }

    public void addProgressLog(String logMsg, ProgressLog.LogType logType) {
        this.logs.add(new ProgressLog(logMsg, logType));
    }

    public ArrayList<ProgressLog> getProgressLogs() {
        return this.logs;
    }

    public Package.ProfileType getProfileType() {
        return this.recentPackage.getProfileType();
    }

    public boolean isAdvanced() {
        return this.recentPackage.isAdvanced();
    }

    public String getExtensionParent() {
        return this.recentPackage.getExtensionParent();
    }

    public String getPreventInstall() {
        return this.recentPackage.getPrevenInstall();
    }

    public boolean isVirtual() {
        return this.recentPackage == null || this.recentPackage.isMeta() && this.recentPackage.getPackageSize() == 0L && this.recentPackage.getVersion().toString().equals("0.0.0");
    }

    public static enum InstallState {
        INSTALL("Not installed"),
        UPDATE("Update"),
        UNINSTALL("Installed"),
        INSTALLING("Installing"),
        UPDATING("Updating"),
        UNINSTALLING("Uninstalling");

        private String msg = "";

        private InstallState(String message) {
            this.msg = message;
        }

        public String getMessage() {
            return this.msg;
        }
    }
}

