/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoAttribute;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ToolTip
extends Widget {
    Shell parent;
    String text;
    String message;
    TrayItem item;
    int x;
    int y;
    int timerId;
    int layoutText = 0;
    int layoutMessage = 0;
    int[] borderPolygon;
    boolean spikeAbove;
    boolean autohide;
    static final int BORDER = 5;
    static final int PADDING = 5;
    static final int INSET = 4;
    static final int TIP_HEIGHT = 20;
    static final int IMAGE_SIZE = 16;
    static final int DELAY = 8000;

    public ToolTip(Shell shell, int n) {
        super(shell, ToolTip.checkStyle(n));
        this.parent = shell;
        this.createWidget(0);
        shell.addToolTip(this);
    }

    static int checkStyle(int n) {
        int n2 = 11;
        if ((n & n2) == 0) {
            return n;
        }
        return ToolTip.checkBits(n, 2, 8, 1, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void configure() {
        int[] nArray;
        int n;
        int n2 = OS.gdk_screen_get_default();
        OS.gtk_widget_realize(this.handle);
        int n3 = OS.gdk_screen_get_monitor_at_window(n2, OS.GTK_WIDGET_WINDOW(this.handle));
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gdk_screen_get_monitor_geometry(n2, n3, gdkRectangle);
        Point point = this.getSize(gdkRectangle.width / 4);
        int n4 = point.x;
        int n5 = point.y;
        point = this.getLocation();
        int n6 = point.x;
        int n7 = point.y;
        OS.gtk_window_resize(this.handle, n4, n5 + 20);
        boolean bl = this.spikeAbove = gdkRectangle.height >= n7 + n5 + 20;
        if (gdkRectangle.width >= n6 + n4) {
            if (gdkRectangle.height >= n7 + n5 + 20) {
                n = 20;
                int[] nArray2 = new int[68];
                nArray2[1] = 5 + n;
                nArray2[2] = 1;
                nArray2[3] = 5 + n;
                nArray2[4] = 1;
                nArray2[5] = 3 + n;
                nArray2[6] = 3;
                nArray2[7] = 1 + n;
                nArray2[8] = 5;
                nArray2[9] = 1 + n;
                nArray2[10] = 5;
                nArray2[11] = n;
                nArray2[12] = 16;
                nArray2[13] = n;
                nArray2[14] = 16;
                nArray2[16] = 35;
                nArray2[17] = n;
                nArray2[18] = n4 - 5;
                nArray2[19] = n;
                nArray2[20] = n4 - 5;
                nArray2[21] = 1 + n;
                nArray2[22] = n4 - 3;
                nArray2[23] = 1 + n;
                nArray2[24] = n4 - 1;
                nArray2[25] = 3 + n;
                nArray2[26] = n4 - 1;
                nArray2[27] = 5 + n;
                nArray2[28] = n4;
                nArray2[29] = 5 + n;
                nArray2[30] = n4;
                nArray2[31] = n5 - 5 + n;
                nArray2[32] = n4 - 1;
                nArray2[33] = n5 - 5 + n;
                nArray2[34] = n4 - 1;
                nArray2[35] = n5 - 3 + n;
                nArray2[36] = n4 - 2;
                nArray2[37] = n5 - 3 + n;
                nArray2[38] = n4 - 2;
                nArray2[39] = n5 - 2 + n;
                nArray2[40] = n4 - 3;
                nArray2[41] = n5 - 2 + n;
                nArray2[42] = n4 - 3;
                nArray2[43] = n5 - 1 + n;
                nArray2[44] = n4 - 5;
                nArray2[45] = n5 - 1 + n;
                nArray2[46] = n4 - 5;
                nArray2[47] = n5 + n;
                nArray2[48] = 5;
                nArray2[49] = n5 + n;
                nArray2[50] = 5;
                nArray2[51] = n5 - 1 + n;
                nArray2[52] = 3;
                nArray2[53] = n5 - 1 + n;
                nArray2[54] = 3;
                nArray2[55] = n5 - 2 + n;
                nArray2[56] = 2;
                nArray2[57] = n5 - 2 + n;
                nArray2[58] = 2;
                nArray2[59] = n5 - 3 + n;
                nArray2[60] = 1;
                nArray2[61] = n5 - 3 + n;
                nArray2[62] = 1;
                nArray2[63] = n5 - 5 + n;
                nArray2[65] = n5 - 5 + n;
                nArray2[67] = 5 + n;
                nArray = nArray2;
                int[] nArray3 = new int[56];
                nArray3[1] = 5 + n;
                nArray3[2] = 1;
                nArray3[3] = 4 + n;
                nArray3[4] = 1;
                nArray3[5] = 3 + n;
                nArray3[6] = 3;
                nArray3[7] = 1 + n;
                nArray3[8] = 4;
                nArray3[9] = 1 + n;
                nArray3[10] = 5;
                nArray3[11] = n;
                nArray3[12] = 16;
                nArray3[13] = n;
                nArray3[14] = 16;
                nArray3[15] = 1;
                nArray3[16] = 35;
                nArray3[17] = n;
                nArray3[18] = n4 - 6;
                nArray3[19] = 0 + n;
                nArray3[20] = n4 - 5;
                nArray3[21] = 1 + n;
                nArray3[22] = n4 - 4;
                nArray3[23] = 1 + n;
                nArray3[24] = n4 - 2;
                nArray3[25] = 3 + n;
                nArray3[26] = n4 - 2;
                nArray3[27] = 4 + n;
                nArray3[28] = n4 - 1;
                nArray3[29] = 5 + n;
                nArray3[30] = n4 - 1;
                nArray3[31] = n5 - 6 + n;
                nArray3[32] = n4 - 2;
                nArray3[33] = n5 - 5 + n;
                nArray3[34] = n4 - 2;
                nArray3[35] = n5 - 4 + n;
                nArray3[36] = n4 - 4;
                nArray3[37] = n5 - 2 + n;
                nArray3[38] = n4 - 5;
                nArray3[39] = n5 - 2 + n;
                nArray3[40] = n4 - 6;
                nArray3[41] = n5 - 1 + n;
                nArray3[42] = 5;
                nArray3[43] = n5 - 1 + n;
                nArray3[44] = 4;
                nArray3[45] = n5 - 2 + n;
                nArray3[46] = 3;
                nArray3[47] = n5 - 2 + n;
                nArray3[48] = 1;
                nArray3[49] = n5 - 4 + n;
                nArray3[50] = 1;
                nArray3[51] = n5 - 5 + n;
                nArray3[53] = n5 - 6 + n;
                nArray3[55] = 5 + n;
                this.borderPolygon = nArray3;
                if ((this.parent.style & 0x8000000) != 0) {
                    n6 -= n4 - 36;
                    nArray[12] = n4 - 36;
                    nArray[14] = n4 - 16;
                    nArray[16] = n4 - 15;
                    this.borderPolygon[12] = n4 - 35;
                    this.borderPolygon[14] = this.borderPolygon[16] = n4 - 16;
                }
                OS.gtk_window_move(this.handle, Math.max(0, n6 - 17), n7);
            } else {
                int[] nArray4 = new int[68];
                nArray4[1] = 5;
                nArray4[2] = 1;
                nArray4[3] = 5;
                nArray4[4] = 1;
                nArray4[5] = 3;
                nArray4[6] = 3;
                nArray4[7] = 1;
                nArray4[8] = 5;
                nArray4[9] = 1;
                nArray4[10] = 5;
                nArray4[12] = n4 - 5;
                nArray4[14] = n4 - 5;
                nArray4[15] = 1;
                nArray4[16] = n4 - 3;
                nArray4[17] = 1;
                nArray4[18] = n4 - 1;
                nArray4[19] = 3;
                nArray4[20] = n4 - 1;
                nArray4[21] = 5;
                nArray4[22] = n4;
                nArray4[23] = 5;
                nArray4[24] = n4;
                nArray4[25] = n5 - 5;
                nArray4[26] = n4 - 1;
                nArray4[27] = n5 - 5;
                nArray4[28] = n4 - 1;
                nArray4[29] = n5 - 3;
                nArray4[30] = n4 - 2;
                nArray4[31] = n5 - 3;
                nArray4[32] = n4 - 2;
                nArray4[33] = n5 - 2;
                nArray4[34] = n4 - 3;
                nArray4[35] = n5 - 2;
                nArray4[36] = n4 - 3;
                nArray4[37] = n5 - 1;
                nArray4[38] = n4 - 5;
                nArray4[39] = n5 - 1;
                nArray4[40] = n4 - 5;
                nArray4[41] = n5;
                nArray4[42] = 35;
                nArray4[43] = n5;
                nArray4[44] = 16;
                nArray4[45] = n5 + 20;
                nArray4[46] = 16;
                nArray4[47] = n5;
                nArray4[48] = 5;
                nArray4[49] = n5;
                nArray4[50] = 5;
                nArray4[51] = n5 - 1;
                nArray4[52] = 3;
                nArray4[53] = n5 - 1;
                nArray4[54] = 3;
                nArray4[55] = n5 - 2;
                nArray4[56] = 2;
                nArray4[57] = n5 - 2;
                nArray4[58] = 2;
                nArray4[59] = n5 - 3;
                nArray4[60] = 1;
                nArray4[61] = n5 - 3;
                nArray4[62] = 1;
                nArray4[63] = n5 - 5;
                nArray4[65] = n5 - 5;
                nArray4[67] = 5;
                nArray = nArray4;
                int[] nArray5 = new int[56];
                nArray5[1] = 5;
                nArray5[2] = 1;
                nArray5[3] = 4;
                nArray5[4] = 1;
                nArray5[5] = 3;
                nArray5[6] = 3;
                nArray5[7] = 1;
                nArray5[8] = 4;
                nArray5[9] = 1;
                nArray5[10] = 5;
                nArray5[12] = n4 - 6;
                nArray5[14] = n4 - 5;
                nArray5[15] = 1;
                nArray5[16] = n4 - 4;
                nArray5[17] = 1;
                nArray5[18] = n4 - 2;
                nArray5[19] = 3;
                nArray5[20] = n4 - 2;
                nArray5[21] = 4;
                nArray5[22] = n4 - 1;
                nArray5[23] = 5;
                nArray5[24] = n4 - 1;
                nArray5[25] = n5 - 6;
                nArray5[26] = n4 - 2;
                nArray5[27] = n5 - 5;
                nArray5[28] = n4 - 2;
                nArray5[29] = n5 - 4;
                nArray5[30] = n4 - 4;
                nArray5[31] = n5 - 2;
                nArray5[32] = n4 - 5;
                nArray5[33] = n5 - 2;
                nArray5[34] = n4 - 6;
                nArray5[35] = n5 - 1;
                nArray5[36] = 35;
                nArray5[37] = n5 - 1;
                nArray5[38] = 17;
                nArray5[39] = n5 + 20 - 2;
                nArray5[40] = 17;
                nArray5[41] = n5 - 1;
                nArray5[42] = 5;
                nArray5[43] = n5 - 1;
                nArray5[44] = 4;
                nArray5[45] = n5 - 2;
                nArray5[46] = 3;
                nArray5[47] = n5 - 2;
                nArray5[48] = 1;
                nArray5[49] = n5 - 4;
                nArray5[50] = 1;
                nArray5[51] = n5 - 5;
                nArray5[53] = n5 - 6;
                nArray5[55] = 5;
                this.borderPolygon = nArray5;
                if ((this.parent.style & 0x8000000) != 0) {
                    n6 -= n4 - 36;
                    nArray[42] = nArray[44] = n4 - 16;
                    nArray[46] = n4 - 35;
                    this.borderPolygon[36] = this.borderPolygon[38] = n4 - 17;
                    this.borderPolygon[40] = n4 - 35;
                }
                OS.gtk_window_move(this.handle, Math.max(0, n6 - 17), n7 - n5 - 20);
            }
        } else if (gdkRectangle.height >= n7 + n5 + 20) {
            n = 20;
            int[] nArray6 = new int[68];
            nArray6[1] = 5 + n;
            nArray6[2] = 1;
            nArray6[3] = 5 + n;
            nArray6[4] = 1;
            nArray6[5] = 3 + n;
            nArray6[6] = 3;
            nArray6[7] = 1 + n;
            nArray6[8] = 5;
            nArray6[9] = 1 + n;
            nArray6[10] = 5;
            nArray6[11] = n;
            nArray6[12] = n4 - 35;
            nArray6[13] = n;
            nArray6[14] = n4 - 16;
            nArray6[16] = n4 - 16;
            nArray6[17] = n;
            nArray6[18] = n4 - 5;
            nArray6[19] = n;
            nArray6[20] = n4 - 5;
            nArray6[21] = 1 + n;
            nArray6[22] = n4 - 3;
            nArray6[23] = 1 + n;
            nArray6[24] = n4 - 1;
            nArray6[25] = 3 + n;
            nArray6[26] = n4 - 1;
            nArray6[27] = 5 + n;
            nArray6[28] = n4;
            nArray6[29] = 5 + n;
            nArray6[30] = n4;
            nArray6[31] = n5 - 5 + n;
            nArray6[32] = n4 - 1;
            nArray6[33] = n5 - 5 + n;
            nArray6[34] = n4 - 1;
            nArray6[35] = n5 - 3 + n;
            nArray6[36] = n4 - 2;
            nArray6[37] = n5 - 3 + n;
            nArray6[38] = n4 - 2;
            nArray6[39] = n5 - 2 + n;
            nArray6[40] = n4 - 3;
            nArray6[41] = n5 - 2 + n;
            nArray6[42] = n4 - 3;
            nArray6[43] = n5 - 1 + n;
            nArray6[44] = n4 - 5;
            nArray6[45] = n5 - 1 + n;
            nArray6[46] = n4 - 5;
            nArray6[47] = n5 + n;
            nArray6[48] = 5;
            nArray6[49] = n5 + n;
            nArray6[50] = 5;
            nArray6[51] = n5 - 1 + n;
            nArray6[52] = 3;
            nArray6[53] = n5 - 1 + n;
            nArray6[54] = 3;
            nArray6[55] = n5 - 2 + n;
            nArray6[56] = 2;
            nArray6[57] = n5 - 2 + n;
            nArray6[58] = 2;
            nArray6[59] = n5 - 3 + n;
            nArray6[60] = 1;
            nArray6[61] = n5 - 3 + n;
            nArray6[62] = 1;
            nArray6[63] = n5 - 5 + n;
            nArray6[65] = n5 - 5 + n;
            nArray6[67] = 5 + n;
            nArray = nArray6;
            int[] nArray7 = new int[56];
            nArray7[1] = 5 + n;
            nArray7[2] = 1;
            nArray7[3] = 4 + n;
            nArray7[4] = 1;
            nArray7[5] = 3 + n;
            nArray7[6] = 3;
            nArray7[7] = 1 + n;
            nArray7[8] = 4;
            nArray7[9] = 1 + n;
            nArray7[10] = 5;
            nArray7[11] = n;
            nArray7[12] = n4 - 35;
            nArray7[13] = n;
            nArray7[14] = n4 - 17;
            nArray7[15] = 2;
            nArray7[16] = n4 - 17;
            nArray7[17] = n;
            nArray7[18] = n4 - 6;
            nArray7[19] = n;
            nArray7[20] = n4 - 5;
            nArray7[21] = 1 + n;
            nArray7[22] = n4 - 4;
            nArray7[23] = 1 + n;
            nArray7[24] = n4 - 2;
            nArray7[25] = 3 + n;
            nArray7[26] = n4 - 2;
            nArray7[27] = 4 + n;
            nArray7[28] = n4 - 1;
            nArray7[29] = 5 + n;
            nArray7[30] = n4 - 1;
            nArray7[31] = n5 - 6 + n;
            nArray7[32] = n4 - 2;
            nArray7[33] = n5 - 5 + n;
            nArray7[34] = n4 - 2;
            nArray7[35] = n5 - 4 + n;
            nArray7[36] = n4 - 4;
            nArray7[37] = n5 - 2 + n;
            nArray7[38] = n4 - 5;
            nArray7[39] = n5 - 2 + n;
            nArray7[40] = n4 - 6;
            nArray7[41] = n5 - 1 + n;
            nArray7[42] = 5;
            nArray7[43] = n5 - 1 + n;
            nArray7[44] = 4;
            nArray7[45] = n5 - 2 + n;
            nArray7[46] = 3;
            nArray7[47] = n5 - 2 + n;
            nArray7[48] = 1;
            nArray7[49] = n5 - 4 + n;
            nArray7[50] = 1;
            nArray7[51] = n5 - 5 + n;
            nArray7[53] = n5 - 6 + n;
            nArray7[55] = 5 + n;
            this.borderPolygon = nArray7;
            if ((this.parent.style & 0x8000000) != 0) {
                n6 += n4 - 35;
                nArray[14] = 16;
                nArray[12] = 16;
                nArray[16] = 35;
                this.borderPolygon[14] = 16;
                this.borderPolygon[12] = 16;
                this.borderPolygon[16] = 35;
            }
            OS.gtk_window_move(this.handle, Math.min(gdkRectangle.width - n4, n6 - n4 + 17), n7);
        } else {
            int[] nArray8 = new int[68];
            nArray8[1] = 5;
            nArray8[2] = 1;
            nArray8[3] = 5;
            nArray8[4] = 1;
            nArray8[5] = 3;
            nArray8[6] = 3;
            nArray8[7] = 1;
            nArray8[8] = 5;
            nArray8[9] = 1;
            nArray8[10] = 5;
            nArray8[12] = n4 - 5;
            nArray8[14] = n4 - 5;
            nArray8[15] = 1;
            nArray8[16] = n4 - 3;
            nArray8[17] = 1;
            nArray8[18] = n4 - 1;
            nArray8[19] = 3;
            nArray8[20] = n4 - 1;
            nArray8[21] = 5;
            nArray8[22] = n4;
            nArray8[23] = 5;
            nArray8[24] = n4;
            nArray8[25] = n5 - 5;
            nArray8[26] = n4 - 1;
            nArray8[27] = n5 - 5;
            nArray8[28] = n4 - 1;
            nArray8[29] = n5 - 3;
            nArray8[30] = n4 - 2;
            nArray8[31] = n5 - 3;
            nArray8[32] = n4 - 2;
            nArray8[33] = n5 - 2;
            nArray8[34] = n4 - 3;
            nArray8[35] = n5 - 2;
            nArray8[36] = n4 - 3;
            nArray8[37] = n5 - 1;
            nArray8[38] = n4 - 5;
            nArray8[39] = n5 - 1;
            nArray8[40] = n4 - 5;
            nArray8[41] = n5;
            nArray8[42] = n4 - 16;
            nArray8[43] = n5;
            nArray8[44] = n4 - 16;
            nArray8[45] = n5 + 20;
            nArray8[46] = n4 - 35;
            nArray8[47] = n5;
            nArray8[48] = 5;
            nArray8[49] = n5;
            nArray8[50] = 5;
            nArray8[51] = n5 - 1;
            nArray8[52] = 3;
            nArray8[53] = n5 - 1;
            nArray8[54] = 3;
            nArray8[55] = n5 - 2;
            nArray8[56] = 2;
            nArray8[57] = n5 - 2;
            nArray8[58] = 2;
            nArray8[59] = n5 - 3;
            nArray8[60] = 1;
            nArray8[61] = n5 - 3;
            nArray8[62] = 1;
            nArray8[63] = n5 - 5;
            nArray8[65] = n5 - 5;
            nArray8[67] = 5;
            nArray = nArray8;
            int[] nArray9 = new int[56];
            nArray9[1] = 5;
            nArray9[2] = 1;
            nArray9[3] = 4;
            nArray9[4] = 1;
            nArray9[5] = 3;
            nArray9[6] = 3;
            nArray9[7] = 1;
            nArray9[8] = 4;
            nArray9[9] = 1;
            nArray9[10] = 5;
            nArray9[12] = n4 - 6;
            nArray9[14] = n4 - 5;
            nArray9[15] = 1;
            nArray9[16] = n4 - 4;
            nArray9[17] = 1;
            nArray9[18] = n4 - 2;
            nArray9[19] = 3;
            nArray9[20] = n4 - 2;
            nArray9[21] = 4;
            nArray9[22] = n4 - 1;
            nArray9[23] = 5;
            nArray9[24] = n4 - 1;
            nArray9[25] = n5 - 6;
            nArray9[26] = n4 - 2;
            nArray9[27] = n5 - 5;
            nArray9[28] = n4 - 2;
            nArray9[29] = n5 - 4;
            nArray9[30] = n4 - 4;
            nArray9[31] = n5 - 2;
            nArray9[32] = n4 - 5;
            nArray9[33] = n5 - 2;
            nArray9[34] = n4 - 6;
            nArray9[35] = n5 - 1;
            nArray9[36] = n4 - 17;
            nArray9[37] = n5 - 1;
            nArray9[38] = n4 - 17;
            nArray9[39] = n5 + 20 - 2;
            nArray9[40] = n4 - 36;
            nArray9[41] = n5 - 1;
            nArray9[42] = 5;
            nArray9[43] = n5 - 1;
            nArray9[44] = 4;
            nArray9[45] = n5 - 2;
            nArray9[46] = 3;
            nArray9[47] = n5 - 2;
            nArray9[48] = 1;
            nArray9[49] = n5 - 4;
            nArray9[50] = 1;
            nArray9[51] = n5 - 5;
            nArray9[53] = n5 - 6;
            nArray9[55] = 5;
            this.borderPolygon = nArray9;
            if ((this.parent.style & 0x8000000) != 0) {
                n6 += n4 - 35;
                nArray[42] = 35;
                nArray[46] = 16;
                nArray[44] = 16;
                this.borderPolygon[36] = 35;
                this.borderPolygon[40] = 17;
                this.borderPolygon[38] = 17;
            }
            OS.gtk_window_move(this.handle, Math.min(gdkRectangle.width - n4, n6 - n4 + 17), n7 - n5 - 20);
        }
        n = OS.gdk_region_polygon(nArray, nArray.length / 2, 0);
        OS.gtk_widget_realize(this.handle);
        int n8 = OS.GTK_WIDGET_WINDOW(this.handle);
        OS.gdk_window_shape_combine_region(n8, n, 0, 0);
        OS.gdk_region_destroy(n);
    }

    void createHandle(int n) {
        this.state |= 8;
        if ((this.style & 0x1000) != 0) {
            this.handle = OS.gtk_window_new(1);
            Color color = this.display.getSystemColor(29);
            OS.gtk_widget_modify_bg(this.handle, 0, color.handle);
            OS.gtk_widget_set_app_paintable(this.handle, true);
            OS.gtk_window_set_type_hint(this.handle, 10);
        } else {
            this.handle = OS.gtk_tooltips_new();
            if (this.handle == 0) {
                this.error(2);
            }
            if (OS.GTK_VERSION >= OS.VERSION(2, 2, 1)) {
                OS.gtk_tooltips_force_window(this.handle);
            }
            OS.g_object_ref(this.handle);
            OS.gtk_object_sink(this.handle);
        }
    }

    void createWidget(int n) {
        super.createWidget(n);
        this.text = "";
        this.message = "";
        this.y = -1;
        this.x = -1;
        this.autohide = true;
    }

    void deregister() {
        int n;
        super.deregister();
        if ((this.style & 0x1000) == 0 && (n = OS.GTK_TOOLTIPS_TIP_WINDOW(this.handle)) != 0) {
            this.display.removeWidget(n);
        }
    }

    void destroyWidget() {
        int n = this.topHandle();
        if (this.parent != null) {
            this.parent.removeTooTip(this);
        }
        this.releaseHandle();
        if (n != 0 && (this.state & 8) != 0) {
            if ((this.style & 0x1000) != 0) {
                OS.gtk_widget_destroy(n);
            } else {
                OS.g_object_unref(n);
            }
        }
    }

    public boolean getAutoHide() {
        this.checkWidget();
        return this.autohide;
    }

    Point getLocation() {
        Object object;
        int n = this.x;
        int n2 = this.y;
        if (this.item != null) {
            int n3 = this.item.handle;
            if (OS.GTK_VERSION >= OS.VERSION(2, 10, 0)) {
                object = new GdkRectangle();
                OS.gtk_status_icon_get_geometry(n3, 0, (GdkRectangle)object, 0);
                n = object.x + object.width / 2;
                n2 = object.y + object.height / 2;
            } else {
                OS.gtk_widget_realize(n3);
                int n4 = OS.GTK_WIDGET_WINDOW(n3);
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                OS.gdk_window_get_origin(n4, nArray, nArray2);
                n = nArray[0] + OS.GTK_WIDGET_WIDTH(n3) / 2;
                n2 = nArray2[0] + OS.GTK_WIDGET_HEIGHT(n3) / 2;
            }
        }
        if (n == -1 || n2 == -1) {
            int[] nArray = new int[1];
            object = new int[1];
            OS.gdk_window_get_pointer(0, nArray, object, null);
            n = nArray[0];
            n2 = object[0];
        }
        return new Point(n, n2);
    }

    public String getMessage() {
        this.checkWidget();
        return this.message;
    }

    String getNameText() {
        return this.getText();
    }

    public Shell getParent() {
        this.checkWidget();
        return this.parent;
    }

    Point getSize(int n) {
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (this.layoutText != 0) {
            OS.pango_layout_set_width(this.layoutText, -1);
            OS.pango_layout_get_size(this.layoutText, nArray, nArray2);
            n2 = OS.PANGO_PIXELS(nArray[0]);
        }
        if (this.layoutMessage != 0) {
            OS.pango_layout_set_width(this.layoutMessage, -1);
            OS.pango_layout_get_size(this.layoutMessage, nArray, nArray2);
            n3 = OS.PANGO_PIXELS(nArray[0]);
        }
        int n4 = 28;
        boolean bl = this.layoutText != 0 && (this.style & 0xB) != 0;
        int n5 = n4 + (bl ? 16 : 0);
        int n6 = Math.min(n, Math.max(n2 + n5, n3 + n4));
        int n7 = 0;
        int n8 = 0;
        if (this.layoutText != 0) {
            OS.pango_layout_set_width(this.layoutText, (n - n5) * 1024);
            OS.pango_layout_get_size(this.layoutText, nArray, nArray2);
            n7 = OS.PANGO_PIXELS(nArray2[0]);
        }
        if (this.layoutMessage != 0) {
            OS.pango_layout_set_width(this.layoutMessage, (n - n4) * 1024);
            OS.pango_layout_get_size(this.layoutMessage, nArray, nArray2);
            n8 = OS.PANGO_PIXELS(nArray2[0]);
        }
        int n9 = 20 + n8;
        if (this.layoutText != 0) {
            n9 += Math.max(16, n7) + 10;
        }
        return new Point(n6, n9);
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean getVisible() {
        this.checkWidget();
        if ((this.style & 0x1000) != 0) {
            return OS.GTK_WIDGET_VISIBLE(this.handle);
        }
        int n = OS.GTK_TOOLTIPS_TIP_WINDOW(this.handle);
        return OS.GTK_WIDGET_VISIBLE(n);
    }

    int gtk_button_press_event(int n, int n2) {
        this.sendSelectionEvent(13, null, true);
        this.setVisible(false);
        return 0;
    }

    int gtk_expose_event(int n, int n2) {
        Object object;
        if ((this.state & 0x40) != 0) {
            return 0;
        }
        int n3 = OS.GTK_WIDGET_WINDOW(this.handle);
        int n4 = OS.gdk_gc_new(n3);
        OS.gdk_draw_polygon(n3, n4, 0, this.borderPolygon, this.borderPolygon.length / 2);
        int n5 = 10;
        int n6 = 10;
        if (this.spikeAbove) {
            n6 += 20;
        }
        if (this.layoutText != 0) {
            object = null;
            int n7 = this.style & 0xB;
            switch (n7) {
                case 1: {
                    object = Converter.wcsToMbcs(null, "gtk-dialog-error", true);
                    break;
                }
                case 2: {
                    object = Converter.wcsToMbcs(null, "gtk-dialog-info", true);
                    break;
                }
                case 8: {
                    object = Converter.wcsToMbcs(null, "gtk-dialog-warning", true);
                }
            }
            if (object != null) {
                int n8 = OS.gtk_widget_get_default_style();
                int n9 = OS.gtk_icon_set_render_icon(OS.gtk_icon_factory_lookup_default((byte[])object), n8, 0, 0, 1, 0, 0);
                OS.gdk_draw_pixbuf(n3, n4, n9, 0, 0, n5, n6, 16, 16, 1, 0, 0);
                OS.g_object_unref(n9);
                n5 += 16;
            }
            Color color = this.display.getSystemColor(28);
            OS.gdk_gc_set_foreground(n4, color.handle);
            OS.gdk_draw_layout(n3, n4, n5 += 4, n6, this.layoutText);
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.pango_layout_get_size(this.layoutText, nArray, nArray2);
            n6 += 10 + Math.max(16, OS.PANGO_PIXELS(nArray2[0]));
        }
        if (this.layoutMessage != 0) {
            n5 = 14;
            object = this.display.getSystemColor(28);
            OS.gdk_gc_set_foreground(n4, ((Color)object).handle);
            OS.gdk_draw_layout(n3, n4, n5, n6, this.layoutMessage);
        }
        OS.g_object_unref(n4);
        return 0;
    }

    int gtk_size_allocate(int n, int n2) {
        Point point = this.getLocation();
        int n3 = point.x;
        int n4 = point.y;
        int n5 = OS.gdk_screen_get_default();
        OS.gtk_widget_realize(n);
        int n6 = OS.gdk_screen_get_monitor_at_window(n5, OS.GTK_WIDGET_WINDOW(n));
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gdk_screen_get_monitor_geometry(n5, n6, gdkRectangle);
        int n7 = OS.GTK_WIDGET_WIDTH(n);
        int n8 = OS.GTK_WIDGET_HEIGHT(n);
        if (gdkRectangle.height < n4 + n8) {
            n4 -= n8;
        }
        if (gdkRectangle.width < n3 + n7) {
            n3 -= n7;
        }
        OS.gtk_window_move(n, n3, n4);
        return 0;
    }

    void hookEvents() {
        if ((this.style & 0x1000) != 0) {
            OS.g_signal_connect_closure(this.handle, OS.expose_event, this.display.closures[18], false);
            OS.gtk_widget_add_events(this.handle, 256);
            OS.g_signal_connect_closure(this.handle, OS.button_press_event, this.display.closures[2], false);
        } else {
            int n = OS.GTK_TOOLTIPS_TIP_WINDOW(this.handle);
            if (n != 0) {
                OS.g_signal_connect_closure(n, OS.size_allocate, this.display.closures[47], false);
                OS.gtk_widget_add_events(n, 256);
                OS.g_signal_connect_closure(n, OS.button_press_event, this.display.closures[2], false);
            }
        }
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    void register() {
        int n;
        super.register();
        if ((this.style & 0x1000) == 0 && (n = OS.GTK_TOOLTIPS_TIP_WINDOW(this.handle)) != 0) {
            this.display.addWidget(n, this);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.setVisible(false);
        if (this.layoutText != 0) {
            OS.g_object_unref(this.layoutText);
        }
        this.layoutText = 0;
        if (this.layoutMessage != 0) {
            OS.g_object_unref(this.layoutMessage);
        }
        this.layoutMessage = 0;
        if (this.timerId != 0) {
            OS.g_source_remove(this.timerId);
        }
        this.timerId = 0;
        this.text = null;
        this.message = null;
        this.borderPolygon = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setAutoHide(boolean bl) {
        this.checkWidget();
        this.autohide = bl;
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        this.x = n;
        this.y = n2;
        if ((this.style & 0x1000) != 0) {
            if (OS.GTK_WIDGET_VISIBLE(this.handle)) {
                this.configure();
            }
        } else {
            int n3 = OS.GTK_TOOLTIPS_TIP_WINDOW(this.handle);
            if (OS.GTK_WIDGET_VISIBLE(n3)) {
                OS.gtk_window_move(n3, n, n2);
            }
        }
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setLocation(point.x, point.y);
    }

    public void setMessage(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.message = string;
        if ((this.style & 0x1000) == 0) {
            return;
        }
        if (this.layoutMessage != 0) {
            OS.g_object_unref(this.layoutMessage);
        }
        this.layoutMessage = 0;
        if (this.message.length() != 0) {
            byte[] byArray = Converter.wcsToMbcs(null, this.message, true);
            this.layoutMessage = OS.gtk_widget_create_pango_layout(this.handle, byArray);
            if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
                OS.pango_layout_set_auto_dir(this.layoutMessage, false);
            }
            OS.pango_layout_set_wrap(this.layoutMessage, 2);
        }
        if (OS.GTK_WIDGET_VISIBLE(this.handle)) {
            this.configure();
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
        if ((this.style & 0x1000) == 0) {
            return;
        }
        if (this.layoutText != 0) {
            OS.g_object_unref(this.layoutText);
        }
        this.layoutText = 0;
        if (this.text.length() != 0) {
            byte[] byArray = Converter.wcsToMbcs(null, this.text, true);
            this.layoutText = OS.gtk_widget_create_pango_layout(this.handle, byArray);
            if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
                OS.pango_layout_set_auto_dir(this.layoutText, false);
            }
            int n = OS.pango_attr_weight_new(700);
            PangoAttribute pangoAttribute = new PangoAttribute();
            OS.memmove(pangoAttribute, n, PangoAttribute.sizeof);
            pangoAttribute.start_index = 0;
            pangoAttribute.end_index = byArray.length;
            OS.memmove(n, pangoAttribute, PangoAttribute.sizeof);
            int n2 = OS.pango_attr_list_new();
            OS.pango_attr_list_insert(n2, n);
            OS.pango_layout_set_attributes(this.layoutText, n2);
            OS.pango_attr_list_unref(n2);
            OS.pango_layout_set_wrap(this.layoutText, 2);
        }
        if (OS.GTK_WIDGET_VISIBLE(this.handle)) {
            this.configure();
        }
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (this.timerId != 0) {
            OS.g_source_remove(this.timerId);
        }
        this.timerId = 0;
        if (bl) {
            if ((this.style & 0x1000) != 0) {
                this.configure();
                OS.gtk_widget_show(this.handle);
            } else {
                int n = this.parent.vboxHandle;
                StringBuffer stringBuffer = new StringBuffer(this.text);
                if (this.text.length() > 0) {
                    stringBuffer.append("\n\n");
                }
                stringBuffer.append(this.message);
                byte[] byArray = Converter.wcsToMbcs(null, stringBuffer.toString(), true);
                if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0)) {
                    OS.gtk_widget_set_tooltip_text(n, byArray);
                } else {
                    OS.gtk_tooltips_set_tip(this.handle, n, byArray, null);
                    int n2 = OS.gtk_tooltips_data_get(n);
                    OS.GTK_TOOLTIPS_SET_ACTIVE(this.handle, n2);
                    OS.gtk_tooltips_set_tip(this.handle, n, byArray, null);
                }
            }
            if (this.autohide) {
                this.timerId = OS.g_timeout_add(8000, this.display.windowTimerProc, this.handle);
            }
        } else if ((this.style & 0x1000) != 0) {
            OS.gtk_widget_hide(this.handle);
        } else {
            int n = this.parent.vboxHandle;
            byte[] byArray = Converter.wcsToMbcs(null, "", true);
            if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0)) {
                OS.gtk_widget_set_tooltip_text(n, byArray);
            } else {
                OS.gtk_tooltips_set_tip(this.handle, n, byArray, null);
            }
        }
    }

    int timerProc(int n) {
        if ((this.style & 0x1000) != 0) {
            OS.gtk_widget_hide(this.handle);
        } else {
            int n2 = OS.GTK_TOOLTIPS_TIP_WINDOW(this.handle);
            OS.gtk_widget_hide(n2);
        }
        return 0;
    }
}

