/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.page.custom;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.packagemanager.ui.page.custom.CallableWithMonitor;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

public class CustomProgressDialog
extends Dialog
implements IProgressMonitor {
    private static final int ANIMATION_SLEEP = 50;
    private static Logger logger = null;
    private Display display = null;
    private Shell shell = null;
    private WizardUIResourceHandler uiRsrcHandler;
    private Label nameLabel = null;
    private int imageCount = 0;
    ArrayList<Image> loadingImages = new ArrayList();
    private boolean isCloseByDone = false;
    private IProgressMonitor monitor = null;
    private String title = "";
    private Composite bufferedComposite;
    private Image img = null;

    public CustomProgressDialog(Shell parent, String title) {
        super(parent, 0x20000000);
        this.init(parent, title, false);
    }

    public CustomProgressDialog(Shell parent, String title, boolean isUninstaller) {
        super(parent, 0x20000000);
        this.init(parent, title, isUninstaller);
    }

    private void init(Shell parent, String title, boolean isUninstaller) {
        logger = Log.getLogger(CustomProgressDialog.class);
        this.uiRsrcHandler = WizardUIResourceHandler.getInstance();
        this.display = this.getParent().getDisplay();
        if (isUninstaller) {
            parent.getShell().setImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIIcon.ICON_UNINSTALLER));
        } else {
            parent.getShell().setImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIIcon.ICON_MANAGER));
        }
        this.title = title;
    }

    public <T1> T1 run(final CallableWithMonitor<T1> callable) throws UMException {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        this.monitor = this;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future future = executor.submit(new Callable<T1>(){

            @Override
            public T1 call() throws Exception {
                Object result = callable.call(CustomProgressDialog.this.monitor);
                if (!CustomProgressDialog.this.isCloseByDone) {
                    CustomProgressDialog.this.finish();
                }
                return result;
            }
        });
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        T1 result = null;
        try {
            result = (T1)future.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof UMException) {
                throw (UMException)e.getCause();
            }
            logger.throwing(e);
        }
        catch (InterruptedException e) {
            logger.throwing(e);
        }
        executor.shutdown();
        return result;
    }

    private void createContents() {
        this.shell = PlatformUtil.isWindows() ? new Shell(this.getParent(), 84192) : new Shell(this.getParent(), 67680);
        this.shell.setSize(300, 130);
        int delta = this.shell.getSize().x - this.shell.getClientArea().width;
        this.shell.setSize(300 + delta, 130);
        if (this.title != null && !this.title.isEmpty()) {
            this.shell.setText(this.title);
        } else {
            this.shell.setText("Package Manager");
        }
        this.shell.setImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIIcon.ICON_MANAGER));
        Monitor monitor = this.display.getPrimaryMonitor();
        Rectangle monitorRect = monitor.getBounds();
        Rectangle shellRect = this.shell.getBounds();
        int centerX = monitorRect.x + (monitorRect.width - shellRect.width) / 2;
        int centerY = monitorRect.y + (monitorRect.height - shellRect.height) / 2;
        this.shell.setLocation(centerX, centerY);
        Composite temp = new Composite(this.shell, 0);
        this.bufferedComposite = new Composite(temp, 0);
        this.loadingImages = this.uiRsrcHandler.getAnimatingImages(WizardUIResourceHandler.UIAnimatingImage.IMAGE_ANIMATION_LOADING_NEW);
        this.img = this.loadingImages.get(this.imageCount);
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        while (!CustomProgressDialog.this.nameLabel.isDisposed()) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            if (CustomProgressDialog.this.display.isDisposed()) continue;
                            CustomProgressDialog.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!CustomProgressDialog.this.nameLabel.isDisposed()) {
                                        CustomProgressDialog.this.imageCount++;
                                        if (CustomProgressDialog.this.imageCount > CustomProgressDialog.this.loadingImages.size() - 1) {
                                            CustomProgressDialog.this.imageCount = 0;
                                        }
                                        int count = CustomProgressDialog.this.imageCount;
                                        CustomProgressDialog.this.img = CustomProgressDialog.this.loadingImages.get(count > CustomProgressDialog.this.loadingImages.size() - 1 ? 0 : count);
                                        CustomProgressDialog.this.shell.redraw();
                                    }
                                }
                            });
                        }
                    }
                });
                t.start();
            }
        });
        this.shell.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent event) {
                Rectangle rect = new Rectangle(0, 50, 276, 22);
                Image bufferedImage = new Image((Device)CustomProgressDialog.this.bufferedComposite.getDisplay(), rect);
                GC gc = new GC(bufferedImage);
                gc.drawImage(CustomProgressDialog.this.img, 0, 0);
                gc.setAntialias(1);
                event.gc.drawImage(bufferedImage, 12, 50);
                bufferedImage.dispose();
                gc.dispose();
            }
        });
        this.nameLabel = new Label(this.shell, 0x1000004);
        this.nameLabel.setBounds(25, 17, 250, 32);
        this.nameLabel.setText("");
        this.nameLabel.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_SMALL));
        this.shell.addListener(21, new Listener(){

            @Override
            public void handleEvent(Event event) {
                if (!CustomProgressDialog.this.isCloseByDone) {
                    event.doit = false;
                }
            }
        });
    }

    private void updateName(final String taskName) {
        if (!this.display.isDisposed()) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!CustomProgressDialog.this.nameLabel.isDisposed()) {
                        String value = taskName;
                        GC gc = new GC(CustomProgressDialog.this.nameLabel);
                        Point textExtent = gc.textExtent(value);
                        while (textExtent.x > ((CustomProgressDialog)CustomProgressDialog.this).nameLabel.getSize().x) {
                            value = value.substring(0, value.length() - 3);
                            textExtent = gc.textExtent(value);
                        }
                        value = value.substring(0, value.length() - 3);
                        value = value + "...";
                        gc.dispose();
                        CustomProgressDialog.this.nameLabel.setText(value);
                        CustomProgressDialog.this.nameLabel.setFont(CustomProgressDialog.this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_SMALL));
                    }
                }
            });
        }
    }

    private void finish() {
        if (this.shell == null || this.shell.isDisposed()) {
            return;
        }
        this.isCloseByDone = true;
        if (!this.display.isDisposed()) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    CustomProgressDialog.this.shell.close();
                }
            });
        }
    }

    @Override
    public void beginTask(String task, int totalwork) {
        this.updateName(task);
    }

    @Override
    public void done() {
        this.finish();
    }

    @Override
    public void internalWorked(double arg0) {
    }

    @Override
    public boolean isCanceled() {
        return false;
    }

    @Override
    public void setCanceled(boolean arg0) {
    }

    @Override
    public void setTaskName(String arg0) {
    }

    @Override
    public void subTask(String name) {
        this.updateName("This process can take some time ...\n" + name);
    }

    @Override
    public void worked(int arg0) {
    }
}

