/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.awt;

import java.awt.AWTEvent;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SWT_AWT {
    public static String embeddedFrameClass;
    static String EMBEDDED_FRAME_KEY;
    static boolean loaded;
    static boolean swingInitialized;

    static {
        EMBEDDED_FRAME_KEY = "org.eclipse.swt.awt.SWT_AWT.embeddedFrame";
    }

    static final native long getAWTHandle(Object var0);

    static final native void setDebug(Frame var0, boolean var1);

    static synchronized void loadLibrary() {
        if (loaded) {
            return;
        }
        loaded = true;
        try {
            System.loadLibrary("jawt");
        }
        catch (Throwable throwable) {}
        Library.loadLibrary("swt-awt");
    }

    static synchronized void initializeSwing() {
        if (swingInitialized) {
            return;
        }
        swingInitialized = true;
        OS.gdk_error_trap_push();
        try {
            Class[] classArray = new Class[]{};
            Object[] objectArray = new Object[]{};
            Class<?> clazz = Class.forName("javax.swing.UIManager");
            Method method = clazz.getMethod("getDefaults", classArray);
            if (method != null) {
                method.invoke(clazz, objectArray);
            }
        }
        catch (Throwable throwable) {}
    }

    public static Frame getFrame(Composite composite) {
        if (composite == null) {
            SWT.error(4);
        }
        if ((composite.getStyle() & 0x1000000) == 0) {
            return null;
        }
        return (Frame)composite.getData(EMBEDDED_FRAME_KEY);
    }

    public static Frame new_Frame(final Composite composite) {
        Object object;
        String string;
        if (composite == null) {
            SWT.error(4);
        }
        if ((composite.getStyle() & 0x1000000) == 0) {
            SWT.error(5);
        }
        long l = composite.embeddedHandle;
        Class<?> clazz = null;
        try {
            string = embeddedFrameClass != null ? embeddedFrameClass : "sun.awt.X11.XEmbeddedFrame";
            clazz = Class.forName(string);
        }
        catch (Throwable throwable) {
            SWT.error(20, throwable, " [need JDK 1.5 or greater]");
        }
        SWT_AWT.initializeSwing();
        string = null;
        Constructor<?> constructor = null;
        try {
            constructor = clazz.getConstructor(Integer.TYPE, Boolean.TYPE);
            string = constructor.newInstance(new Integer((int)l), Boolean.TRUE);
        }
        catch (Throwable throwable) {
            try {
                constructor = clazz.getConstructor(Long.TYPE, Boolean.TYPE);
                string = constructor.newInstance(new Long(l), Boolean.TRUE);
            }
            catch (Throwable throwable2) {
                SWT.error(20, throwable2);
            }
        }
        final Frame frame = (Frame)((Object)string);
        composite.setData(EMBEDDED_FRAME_KEY, frame);
        if (Device.DEBUG) {
            SWT_AWT.loadLibrary();
            SWT_AWT.setDebug(frame, true);
        }
        try {
            object = clazz.getMethod("registerListeners", null);
            if (object != null) {
                ((Method)object).invoke((Object)string, null);
            }
        }
        catch (Throwable throwable) {}
        object = new AWTEventListener(){

            public void eventDispatched(AWTEvent aWTEvent) {
                Window window;
                if (aWTEvent.getID() == 200 && (window = (Window)aWTEvent.getSource()).getParent() == frame) {
                    composite.getDisplay().asyncExec(new Runnable(this, composite, window){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ Composite val$parent;
                        private final /* synthetic */ Window val$window;
                        {
                            this.this$1 = var1_1;
                            this.val$parent = composite;
                            this.val$window = window;
                        }

                        public void run() {
                            if (this.val$parent.isDisposed()) {
                                return;
                            }
                            Shell shell = this.val$parent.getShell();
                            SWT_AWT.loadLibrary();
                            long l = SWT_AWT.getAWTHandle(this.val$window);
                            if (l == 0L) {
                                return;
                            }
                            long l2 = OS.gdk_x11_drawable_get_xid(OS.GTK_WIDGET_WINDOW(OS.gtk_widget_get_toplevel(shell.handle)));
                            OS.XSetTransientForHint(OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default()), l, l2);
                        }
                    });
                }
            }
        };
        frame.getToolkit().addAWTEventListener((AWTEventListener)object, 64L);
        final Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 20: {
                        EventQueue.invokeLater(new Runnable(this, frame){
                            final /* synthetic */ 3 this$1;
                            private final /* synthetic */ Frame val$frame;
                            {
                                this.this$1 = var1_1;
                                this.val$frame = frame;
                            }

                            public void run() {
                                this.val$frame.dispatchEvent(new WindowEvent(this.val$frame, 204));
                            }
                        });
                        break;
                    }
                    case 19: {
                        EventQueue.invokeLater(new Runnable(this, frame){
                            final /* synthetic */ 3 this$1;
                            private final /* synthetic */ Frame val$frame;
                            {
                                this.this$1 = var1_1;
                                this.val$frame = frame;
                            }

                            public void run() {
                                this.val$frame.dispatchEvent(new WindowEvent(this.val$frame, 203));
                            }
                        });
                    }
                }
            }
        };
        Shell shell = composite.getShell();
        shell.addListener(20, listener);
        shell.addListener(19, listener);
        Listener listener2 = new Listener((AWTEventListener)object){
            private final /* synthetic */ AWTEventListener val$awtListener;
            {
                this.val$awtListener = aWTEventListener;
            }

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        Shell shell = composite.getShell();
                        shell.removeListener(20, listener);
                        shell.removeListener(19, listener);
                        composite.setVisible(false);
                        EventQueue.invokeLater(new Runnable(this, frame, this.val$awtListener){
                            final /* synthetic */ 6 this$1;
                            private final /* synthetic */ Frame val$frame;
                            private final /* synthetic */ AWTEventListener val$awtListener;
                            {
                                this.this$1 = var1_1;
                                this.val$frame = frame;
                                this.val$awtListener = aWTEventListener;
                            }

                            public void run() {
                                this.val$frame.getToolkit().removeAWTEventListener(this.val$awtListener);
                                this.val$frame.dispose();
                            }
                        });
                        break;
                    }
                    case 11: {
                        if (Library.JAVA_VERSION < Library.JAVA_VERSION(1, 6, 0)) break;
                        Rectangle rectangle = composite.getClientArea();
                        EventQueue.invokeLater(new Runnable(this, frame, rectangle){
                            final /* synthetic */ 6 this$1;
                            private final /* synthetic */ Frame val$frame;
                            private final /* synthetic */ Rectangle val$clientArea;
                            {
                                this.this$1 = var1_1;
                                this.val$frame = frame;
                                this.val$clientArea = rectangle;
                            }

                            public void run() {
                                this.val$frame.setSize(this.val$clientArea.width, this.val$clientArea.height);
                            }
                        });
                    }
                }
            }
        };
        composite.addListener(12, listener2);
        composite.addListener(11, listener2);
        composite.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (composite.isDisposed()) {
                    return;
                }
                Rectangle rectangle = composite.getClientArea();
                EventQueue.invokeLater(new Runnable(this, frame, rectangle){
                    final /* synthetic */ 9 this$1;
                    private final /* synthetic */ Frame val$frame;
                    private final /* synthetic */ Rectangle val$clientArea;
                    {
                        this.this$1 = var1_1;
                        this.val$frame = frame;
                        this.val$clientArea = rectangle;
                    }

                    public void run() {
                        this.val$frame.setSize(this.val$clientArea.width, this.val$clientArea.height);
                        this.val$frame.validate();
                    }
                });
            }
        });
        return frame;
    }

    public static Shell new_Shell(final Display display, final Canvas canvas) {
        if (display == null) {
            SWT.error(4);
        }
        if (canvas == null) {
            SWT.error(4);
        }
        long l = 0L;
        try {
            SWT_AWT.loadLibrary();
            l = SWT_AWT.getAWTHandle(canvas);
        }
        catch (Throwable throwable) {
            SWT.error(20, throwable);
        }
        if (l == 0L) {
            SWT.error(5, null, " [peer not created]");
        }
        final Shell shell = Shell.gtk_new(display, l);
        final ComponentAdapter componentAdapter = new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                display.syncExec(new Runnable(this, shell, canvas){
                    final /* synthetic */ 11 this$1;
                    private final /* synthetic */ Shell val$shell;
                    private final /* synthetic */ Canvas val$parent;
                    {
                        this.this$1 = var1_1;
                        this.val$shell = shell;
                        this.val$parent = canvas;
                    }

                    public void run() {
                        if (this.val$shell.isDisposed()) {
                            return;
                        }
                        Dimension dimension = this.val$parent.getSize();
                        this.val$shell.setSize(dimension.width, dimension.height);
                    }
                });
            }
        };
        canvas.addComponentListener(componentAdapter);
        shell.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                canvas.removeComponentListener(componentAdapter);
            }
        });
        shell.setVisible(true);
        return shell;
    }
}

