/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.uninstaller.ui.wizard;

import java.io.File;
import org.apache.logging.log4j.Logger;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.tizen.manager.core.ContentProvider;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;
import org.tizen.uninstaller.ui.dialog.IMButton;
import org.tizen.uninstaller.ui.wizard.WizardPageMaster;

public class WizardCommonPage
extends Composite {
    private static final Logger logger = Log.getLogger(WizardCommonPage.class);
    protected Composite topContainer;
    protected Composite centerContainer;
    protected Composite splitterContainer;
    protected Composite bottomContainer;
    protected WizardUIResourceHandler uiResource;
    protected Composite parent;
    protected Label infoLabel;
    private Label toolTiplabel;
    protected IMButton infoButton;
    protected Button firstButton;
    protected Button secondButton;
    private Image infoButtonImageNormal;
    private Image infoButtonImageHover;
    private Image titleBG;
    private Image toolTipLeft;
    private Image toolTipMiddle;
    private Image toolTipRight;
    private String format;
    private int versionInfoTextSize = 0;
    protected WizardPageMaster wizardPageMaster;
    protected static UninstallContext uninstallContext;
    protected Rectangle baseMargin;
    private ContentProvider contentProvider;

    public WizardCommonPage(ContentProvider contentProvider, Composite parent, int options, WizardUIResourceHandler uiResource, WizardPageMaster wizardPageMaster) {
        super(parent, options);
        logger.trace(WizardCommonPage.class.getName() + " constructor start.");
        this.contentProvider = contentProvider;
        this.uiResource = uiResource;
        this.parent = parent;
        this.wizardPageMaster = wizardPageMaster;
        this.setBackgroundMode(2);
        if (uninstallContext == null) {
            uninstallContext = new UninstallContext();
        }
        this.setDefaultSetting(this);
        this.topContainer = new Composite(this, 0x20000000);
        this.centerContainer = new Composite(this, 0x20000000);
        this.splitterContainer = new Composite(this, 0x20000000);
        this.bottomContainer = new Composite(this, 0);
        try {
            this.loadImages();
        }
        catch (UMException e) {
            logger.throwing(e);
        }
        this.createBaseComponent(this, this.topContainer, this.centerContainer, this.bottomContainer);
        this.createTopContainer();
        this.createBottomContainer();
        this.handleBottomEvent();
        logger.trace(WizardCommonPage.class.getName() + " constructor end.");
    }

    private void setDefaultSetting(Composite page) {
        Rectangle point = this.parent.getBounds();
        FormData fd = new FormData(point.width, point.height);
        fd.left = new FormAttachment(point.x, 0x1000000);
        fd.top = new FormAttachment(point.y, 0x1000000);
        fd.width = point.width;
        fd.height = point.height;
        page.setLayoutData(fd);
        FormLayout formLayout = new FormLayout();
        formLayout.marginBottom = 0;
        formLayout.marginTop = 0;
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        formLayout.marginLeft = 0;
        formLayout.marginRight = 0;
        page.setLayout(formLayout);
    }

    private void loadImages() throws UMException {
        this.titleBG = this.uiResource.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_TOP_BACKGROUND);
        this.infoButtonImageNormal = this.uiResource.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_TOOLTIP_ICON_NORMAL);
        this.infoButtonImageHover = this.uiResource.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_TOOLTIP_ICON_FOCUS);
    }

    private void createBaseComponent(Composite page, Composite topContainer, Composite centerContainer, Composite bottomContainer) {
        Rectangle boundsTop = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_TOP);
        Rectangle boundsCenter = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_CENTER);
        Rectangle boundsSplitter = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_SPLITTER);
        Rectangle boundsBottom = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_BOTTOM);
        FormData topFormData = new FormData();
        topFormData.left = new FormAttachment(page, 0, 16384);
        topFormData.top = new FormAttachment(page, 0, 16384);
        topFormData.width = boundsTop.width;
        topFormData.height = boundsTop.height;
        topContainer.setLayoutData(topFormData);
        topContainer.setLayout(new FormLayout());
        FormData centerFormData = new FormData();
        centerFormData.left = new FormAttachment(page, 0, 16384);
        centerFormData.top = new FormAttachment(page, boundsTop.height, 16384);
        centerFormData.width = boundsCenter.width;
        centerFormData.height = boundsCenter.height;
        centerContainer.setLayoutData(centerFormData);
        centerContainer.setLayout(new FormLayout());
        centerContainer.setBackground(this.uiResource.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        FormData splitterFormData = new FormData();
        splitterFormData.left = new FormAttachment(page, 0, 16384);
        splitterFormData.top = new FormAttachment(page, boundsTop.height + boundsCenter.height, 16384);
        splitterFormData.width = boundsSplitter.width;
        splitterFormData.height = boundsSplitter.height;
        this.splitterContainer.setLayoutData(splitterFormData);
        this.splitterContainer.setLayout(new FormLayout());
        this.splitterContainer.setBackground(this.uiResource.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_LINE_SPLITTER));
        FormData bottomFormData = new FormData();
        bottomFormData.left = new FormAttachment(page, 0, 16384);
        bottomFormData.top = new FormAttachment(page, boundsTop.height + boundsCenter.height - 3, 16384);
        bottomFormData.width = boundsBottom.width;
        bottomFormData.height = boundsBottom.height - 1;
        bottomContainer.setLayoutData(bottomFormData);
        bottomContainer.setLayout(new FormLayout());
        bottomContainer.setBackground(this.uiResource.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
    }

    private void createTopContainer() {
        this.topContainer.setBackgroundImage(this.titleBG);
        Composite mainContainer = new Composite(this.topContainer, 0);
        Rectangle point = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_TOP);
        FormData formData = new FormData();
        formData.left = new FormAttachment(this.parent, 0, 16384);
        formData.top = new FormAttachment(this.parent, 0, 16384);
        formData.width = point.width;
        formData.height = point.height;
        mainContainer.setLayoutData(formData);
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 0;
        layout.marginLeft = 28;
        mainContainer.setLayout(layout);
        this.createTop(mainContainer, formData.width, point.height);
    }

    private void createTop(Composite mainContainer, int width, int height) {
        Rectangle boundsTitle = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_TITLE_MAIN);
        Rectangle boundsInfo = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_TITLE_INFO);
        GridData gd = null;
        Label title = new Label(mainContainer, 0);
        title.setText("TIZEN STUDIO");
        title.setForeground(this.uiResource.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        title.setFont(this.uiResource.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_20PX, WizardUIResourceHandler.FontType.WIZARD_FONT_TYPE_REGULAR, 0));
        GC gc = new GC(title);
        int textHeight = 0;
        textHeight = PlatformUtil.isMacOS() ? gc.getFontMetrics().getHeight() + gc.getFontMetrics().getDescent() : gc.textExtent((String)title.getText()).y;
        gc.dispose();
        gd = new GridData(16384, 1024, true, true);
        gd.widthHint = boundsTitle.width;
        gd.heightHint = textHeight - 2;
        title.setLayoutData(gd);
        this.infoLabel = new Label(mainContainer, 0);
        this.infoLabel.setText("Ready for uninstallation");
        this.infoLabel.setForeground(this.uiResource.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.infoLabel.setFont(this.uiResource.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_36PX, WizardUIResourceHandler.FontType.WIZARD_FONT_TYPE_BOLD, 1));
        gc = new GC(this.infoLabel);
        textHeight = 0;
        textHeight = PlatformUtil.isMacOS() ? gc.getFontMetrics().getHeight() + gc.getFontMetrics().getDescent() : gc.textExtent((String)this.infoLabel.getText()).y;
        gc.dispose();
        gd = new GridData(16384, 128, true, true);
        gd.widthHint = boundsInfo.width;
        gd.heightHint = textHeight;
        this.infoLabel.setLayoutData(gd);
    }

    private void createBottomContainer() {
        Composite mainContainer = new Composite(this.bottomContainer, 0);
        Rectangle point = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_BOTTOM);
        FormData formData = new FormData();
        formData.left = new FormAttachment(this.parent, 0, 16384);
        formData.top = new FormAttachment(this.parent, 0, 16384);
        formData.width = point.width - this.uiResource.getRect((WizardUIResourceHandler.UISize)WizardUIResourceHandler.UISize.WIZARD_SIZE_BOTTOM_BUTTON_MARGIN).width;
        formData.height = point.height;
        mainContainer.setLayoutData(formData);
        GridLayout layout = new GridLayout(5, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        mainContainer.setLayout(layout);
        this.createBottom(mainContainer, formData.width, point.height);
    }

    private void createBottom(Composite mainContainer, int width, int height) {
        Rectangle point = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_BOTTOM_BUTTON);
        Rectangle infoButtonSize = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_INFO_BUTTON);
        Rectangle infoToolTipBound = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_INFO_TOOLTIP);
        Rectangle buttonMargin = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_BOTTOM_BUTTON_MARGIN);
        int buttonWidth = point.width;
        int buttonHeight = point.height;
        int verticalIndent = infoButtonSize.y;
        GridData gd = null;
        this.infoButton = new IMButton(mainContainer, 8);
        this.infoButton.setImage(this.infoButtonImageNormal, this.infoButtonImageHover);
        Rectangle infoImageBounds = this.infoButtonImageNormal.getBounds();
        this.infoButton.setSize(infoImageBounds.width, infoImageBounds.height);
        gd = new GridData(infoImageBounds.width, infoImageBounds.height);
        gd.verticalAlignment = 1;
        gd.horizontalIndent = infoButtonSize.x;
        gd.verticalIndent = verticalIndent + infoButtonSize.height / 2 - infoImageBounds.height / 2;
        this.infoButton.setLayoutData(gd);
        this.infoButton.setBackgroundMode(2);
        this.toolTipLeft = this.uiResource.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_TOOLTIP_BG_LEFT);
        this.toolTipMiddle = this.uiResource.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_TOOLTIP_BG_CENTER);
        this.toolTipRight = this.uiResource.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_TOOLTIP_BG_RIGHT);
        this.toolTiplabel = new Label(mainContainer, 0);
        this.toolTiplabel.setFont(this.uiResource.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        GC tempGC = new GC(this.toolTiplabel);
        this.format = String.format("Uninstaller Version %s", this.contentProvider.getConfig().getManagerVersion());
        this.versionInfoTextSize = tempGC.textExtent((String)this.format).x;
        tempGC.dispose();
        this.toolTiplabel.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent arg0) {
                GC gc = arg0.gc;
                gc.setFont(WizardCommonPage.this.uiResource.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
                gc.drawImage(WizardCommonPage.this.toolTipLeft, 0, 0);
                gc.drawImage(WizardCommonPage.this.toolTipRight, ((WizardCommonPage)WizardCommonPage.this).toolTipLeft.getBounds().width + WizardCommonPage.this.versionInfoTextSize, 0);
                for (int i = 0; i < WizardCommonPage.this.versionInfoTextSize; ++i) {
                    gc.drawImage(WizardCommonPage.this.toolTipMiddle, ((WizardCommonPage)WizardCommonPage.this).toolTipLeft.getBounds().width + i, 0);
                }
                gc.setForeground(WizardCommonPage.this.uiResource.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_72));
                gc.drawText(WizardCommonPage.this.format, ((WizardCommonPage)WizardCommonPage.this).toolTipLeft.getBounds().width, ((WizardCommonPage)WizardCommonPage.this).toolTipLeft.getBounds().height / 2 - gc.textExtent((String)((WizardCommonPage)WizardCommonPage.this).format).y / 2 - 2);
                gc.dispose();
            }
        });
        int toolTipWidth = this.toolTipLeft.getBounds().width + this.toolTipRight.getBounds().width + this.versionInfoTextSize;
        gd = new GridData(toolTipWidth, this.toolTipLeft.getBounds().height);
        gd.verticalAlignment = 1;
        gd.horizontalIndent = infoToolTipBound.x;
        gd.verticalIndent = infoToolTipBound.y;
        this.toolTiplabel.setLayoutData(gd);
        this.toolTiplabel.setVisible(false);
        Composite dummy = new Composite(mainContainer, 0);
        gd = new GridData();
        gd.widthHint = width - buttonWidth * 2 - infoButtonSize.width - infoButtonSize.x - buttonMargin.x * 2 - (this.toolTipLeft.getBounds().width + this.toolTipRight.getBounds().width + this.versionInfoTextSize) - infoToolTipBound.x;
        gd.heightHint = height;
        dummy.setLayoutData(gd);
        this.firstButton = new Button(mainContainer, 8);
        this.firstButton.setText("Uninstall");
        this.firstButton.setFont(this.uiResource.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.firstButton.setSize(buttonWidth, buttonHeight);
        gd = new GridData(buttonWidth, buttonHeight);
        gd.verticalAlignment = 0x1000000;
        this.firstButton.setLayoutData(gd);
        this.secondButton = new Button(mainContainer, 8);
        this.secondButton.setText("Cancel");
        this.secondButton.setFont(this.uiResource.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        gd = new GridData(buttonWidth, buttonHeight);
        gd.verticalAlignment = 0x1000000;
        gd.horizontalIndent = buttonMargin.x;
        this.secondButton.setLayoutData(gd);
    }

    private void handleBottomEvent() {
        this.infoButton.addMouseTrackListener(new MouseTrackListener(){

            @Override
            public void mouseHover(MouseEvent arg0) {
                WizardCommonPage.this.toolTiplabel.setVisible(true);
            }

            @Override
            public void mouseExit(MouseEvent arg0) {
                WizardCommonPage.this.toolTiplabel.setVisible(false);
            }

            @Override
            public void mouseEnter(MouseEvent arg0) {
                WizardCommonPage.this.toolTiplabel.setVisible(true);
            }
        });
    }

    protected class UninstallContext {
        private Boolean deleteSDKData;
        private Boolean deleteKeystore;
        private Boolean keystoreExists;
        private String keystorePath;

        public UninstallContext() {
            this.setDeleteSDKData(true);
            this.setDeleteKeystore(false);
            this.keystorePath = WizardCommonPage.this.contentProvider.getSDKInfo().getSdkDataPath() + File.separator + "keystore";
            File keystore = new File(this.keystorePath);
            if (keystore.exists()) {
                this.setKeystoreExists(true);
            } else {
                this.setKeystoreExists(false);
            }
        }

        public String getKeystorePath() {
            return this.keystorePath;
        }

        public Boolean shouldDeleteKeystore() {
            return this.deleteKeystore;
        }

        public void setDeleteKeystore(Boolean deleteKeystore) {
            this.deleteKeystore = deleteKeystore;
        }

        public Boolean isKeystoreExist() {
            return this.keystoreExists;
        }

        public void setKeystoreExists(Boolean keystoreExists) {
            this.keystoreExists = keystoreExists;
        }

        public Boolean shouldDeleteSDKData() {
            return this.deleteSDKData;
        }

        public void setDeleteSDKData(Boolean deleteSDKData) {
            this.deleteSDKData = deleteSDKData;
        }
    }
}

