/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class PreferenceNode
implements IPreferenceNode {
    private IPreferencePage page;
    private List<IPreferenceNode> subNodes;
    private String classname;
    private String id;
    private String label;
    private ImageDescriptor imageDescriptor;
    private Image image;

    public PreferenceNode(String id2) {
        Assert.isNotNull(id2);
        this.id = id2;
    }

    public PreferenceNode(String id2, String label, ImageDescriptor image, String className) {
        this(id2);
        this.imageDescriptor = image;
        Assert.isNotNull(label);
        this.label = label;
        this.classname = className;
    }

    public PreferenceNode(String id2, IPreferencePage preferencePage) {
        this(id2);
        Assert.isNotNull(preferencePage);
        this.page = preferencePage;
    }

    @Override
    public void add(IPreferenceNode node) {
        if (this.subNodes == null) {
            this.subNodes = new ArrayList<IPreferenceNode>();
        }
        this.subNodes.add(node);
    }

    private Object createObject(String className) {
        Assert.isNotNull(className);
        try {
            Class<?> cl = Class.forName(className);
            if (cl != null) {
                return cl.newInstance();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return null;
        }
        return null;
    }

    @Override
    public void createPage() {
        this.page = (IPreferencePage)this.createObject(this.classname);
        if (this.getLabelImage() != null) {
            this.page.setImageDescriptor(this.imageDescriptor);
        }
        this.page.setTitle(this.label);
    }

    @Override
    public void disposeResources() {
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        if (this.page != null) {
            this.page.dispose();
            this.page = null;
        }
    }

    @Override
    public IPreferenceNode findSubNode(String id2) {
        Assert.isNotNull(id2);
        Assert.isTrue(id2.length() > 0);
        if (this.subNodes == null) {
            return null;
        }
        int size = this.subNodes.size();
        int i = 0;
        while (i < size) {
            IPreferenceNode node = this.subNodes.get(i);
            if (id2.equals(node.getId())) {
                return node;
            }
            ++i;
        }
        return null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    protected ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    @Override
    public Image getLabelImage() {
        if (this.image == null && this.imageDescriptor != null) {
            this.image = this.imageDescriptor.createImage();
        }
        return this.image;
    }

    @Override
    public String getLabelText() {
        if (this.page != null) {
            return this.page.getTitle();
        }
        return this.label;
    }

    @Override
    public IPreferencePage getPage() {
        return this.page;
    }

    @Override
    public IPreferenceNode[] getSubNodes() {
        if (this.subNodes == null) {
            return new IPreferenceNode[0];
        }
        return this.subNodes.toArray(new IPreferenceNode[this.subNodes.size()]);
    }

    @Override
    public IPreferenceNode remove(String id2) {
        IPreferenceNode node = this.findSubNode(id2);
        if (node != null) {
            this.remove(node);
        }
        return node;
    }

    @Override
    public boolean remove(IPreferenceNode node) {
        if (this.subNodes == null) {
            return false;
        }
        return this.subNodes.remove(node);
    }

    public void setPage(IPreferencePage newPage) {
        this.page = newPage;
    }
}

