/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.net.TcpSocketManager;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.util.Strings;

public class SslSocketManager
extends TcpSocketManager {
    public static final int DEFAULT_PORT = 6514;
    private static final SslSocketManagerFactory FACTORY = new SslSocketManagerFactory();
    private final SslConfiguration sslConfig;

    public SslSocketManager(String name, OutputStream os, Socket sock, SslConfiguration sslConfig, InetAddress inetAddress, String host, int port, int delay, boolean immediateFail, Layout<? extends Serializable> layout) {
        super(name, os, sock, inetAddress, host, port, delay, immediateFail, layout);
        this.sslConfig = sslConfig;
    }

    public static SslSocketManager getSocketManager(SslConfiguration sslConfig, String host, int port, int delay, boolean immediateFail, Layout<? extends Serializable> layout) {
        if (Strings.isEmpty(host)) {
            throw new IllegalArgumentException("A host name is required");
        }
        if (port <= 0) {
            port = 6514;
        }
        if (delay == 0) {
            delay = 30000;
        }
        return (SslSocketManager)SslSocketManager.getManager("TLS:" + host + ':' + port, new SslFactoryData(sslConfig, host, port, delay, immediateFail, layout), FACTORY);
    }

    @Override
    protected Socket createSocket(String host, int port) throws IOException {
        SSLSocketFactory socketFactory = SslSocketManager.createSslSocketFactory(this.sslConfig);
        return socketFactory.createSocket(host, port);
    }

    private static SSLSocketFactory createSslSocketFactory(SslConfiguration sslConf) {
        SSLSocketFactory socketFactory = sslConf != null ? sslConf.getSslSocketFactory() : (SSLSocketFactory)SSLSocketFactory.getDefault();
        return socketFactory;
    }

    private static class SslSocketManagerFactory
    implements ManagerFactory<SslSocketManager, SslFactoryData> {
        private SslSocketManagerFactory() {
        }

        @Override
        public SslSocketManager createManager(String name, SslFactoryData data) {
            InetAddress inetAddress = null;
            OutputStream os = null;
            Socket socket = null;
            try {
                inetAddress = this.resolveAddress(data.host);
                socket = this.createSocket(data);
                os = socket.getOutputStream();
                this.checkDelay(data.delay, os);
            }
            catch (IOException e) {
                LOGGER.error("SslSocketManager ({})", name, e);
                os = new ByteArrayOutputStream();
            }
            catch (TlsSocketManagerFactoryException e) {
                LOGGER.catching(Level.DEBUG, e);
                return null;
            }
            return this.createManager(name, os, socket, data.sslConfig, inetAddress, data.host, data.port, data.delay, data.immediateFail, data.layout);
        }

        private InetAddress resolveAddress(String hostName) throws TlsSocketManagerFactoryException {
            InetAddress address;
            try {
                address = InetAddress.getByName(hostName);
            }
            catch (UnknownHostException ex) {
                LOGGER.error("Could not find address of {}", hostName, ex);
                throw new TlsSocketManagerFactoryException();
            }
            return address;
        }

        private void checkDelay(int delay, OutputStream os) throws TlsSocketManagerFactoryException {
            if (delay == 0 && os == null) {
                throw new TlsSocketManagerFactoryException();
            }
        }

        private Socket createSocket(SslFactoryData data) throws IOException {
            SSLSocketFactory socketFactory = SslSocketManager.createSslSocketFactory(data.sslConfig);
            SSLSocket socket = (SSLSocket)socketFactory.createSocket(data.host, data.port);
            return socket;
        }

        private SslSocketManager createManager(String name, OutputStream os, Socket socket, SslConfiguration sslConfig, InetAddress inetAddress, String host, int port, int delay, boolean immediateFail, Layout<? extends Serializable> layout) {
            return new SslSocketManager(name, os, socket, sslConfig, inetAddress, host, port, delay, immediateFail, layout);
        }

        private class TlsSocketManagerFactoryException
        extends Exception {
            private static final long serialVersionUID = 1L;

            private TlsSocketManagerFactoryException() {
            }
        }
    }

    private static class SslFactoryData {
        protected SslConfiguration sslConfig;
        private final String host;
        private final int port;
        private final int delay;
        private final boolean immediateFail;
        private final Layout<? extends Serializable> layout;

        public SslFactoryData(SslConfiguration sslConfig, String host, int port, int delay, boolean immediateFail, Layout<? extends Serializable> layout) {
            this.host = host;
            this.port = port;
            this.delay = delay;
            this.immediateFail = immediateFail;
            this.layout = layout;
            this.sslConfig = sslConfig;
        }
    }
}

