/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.gtest.testexplorer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IFunction;
import org.eclipse.cdt.core.model.INamespace;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IVariable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.ProjectUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.tizenunittest.gtest.UnitTestPlugin;
import org.tizen.tizenunittest.gtest.common.UnitTestMessages;
import org.tizen.tizenunittest.gtest.gtest.testexplorer.TXContentProvider;
import org.tizen.tizenunittest.gtest.gtest.testexplorer.TXLabelProvider;
import org.tizen.tizenunittest.gtest.gtest.testexplorer.TestPData;
import org.tizen.tizenunittest.gtest.gtest.testexplorer.TypeInstantiationData;
import org.tizen.tizenunittest.gtest.gtest.testexplorer.TypedTestPData;
import org.tizen.tizenunittest.gtest.gtest.testexplorer.ValueInstantiationData;
import org.tizen.tizenunittest.gtest.model.TestSession;
import org.tizen.tizenunittest.gtest.model.listener.ISessionListener;
import org.tizen.tizenunittest.gtest.testexplorer.model.TXNodeStatus;
import org.tizen.tizenunittest.gtest.testexplorer.model.TXTestCase;
import org.tizen.tizenunittest.gtest.testexplorer.model.TXTestNode;
import org.tizen.tizenunittest.gtest.testexplorer.model.TXTestRoot;
import org.tizen.tizenunittest.gtest.testexplorer.model.TXTestSuite;
import org.tizen.tizenunittest.gtest.testexplorer.model.TXTestType;
import org.tizen.tizenunittest.gtest.testexplorer.toolbaraction.CheckFailedAction;
import org.tizen.tizenunittest.gtest.testexplorer.toolbaraction.CheckTreeAction;
import org.tizen.tizenunittest.gtest.testexplorer.toolbaraction.RefreshAction;
import org.tizen.tizenunittest.gtest.testexplorer.toolbaraction.ReplaceLaunchAction;
import org.tizen.tizenunittest.gtest.testexplorer.toolbaraction.RerunLastTestActionTX;
import org.tizen.tizenunittest.gtest.testexplorer.toolbaraction.TreeControlAction;
import org.tizen.tizenunittest.gtest.testexplorer.viewmenuaction.GTestOptionCheckAction;
import org.tizen.tizenunittest.gtest.testexplorer.viewmenuaction.GTestOptionCheckActionXML;

public class TXView
extends ViewPart
implements ISessionListener {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static String NOT_SUPPORT_PROJECT_VERSION = "3.0";
    private final String RUN_DISABLED_TEST_ACTION_TEXT = UnitTestMessages.TXVIEW_LABEL_DISABLED_TEST;
    private final String SHUFFLE_TEST_ACTION_TEXT = UnitTestMessages.TXVIEW_LABEL_SHUFFLE_TEST;
    private final String DONT_PRINT_ELAPSED_TIME_ACTION_TEXT = UnitTestMessages.TXVIEW_LABEL_DONT_PRINT_ELAPSED;
    private final String GENERATE_XML_REPORT_ACTION_TEXT = UnitTestMessages.TXVIEW_LABEL_XML_REPORT;
    private final String DISABLED_PREFIX = "DISABLED_";
    private Composite parent;
    private String projectName;
    private static TXView txViewPart;
    private TXTestRoot testRoot;
    private CheckboxTreeViewer treeViewer;
    private ScrolledComposite scrolledComposite;
    private Composite treeComposite;
    private Vector<String> checkedTestNames;
    private Map<String, ArrayList<TestPData>> testPDataMap;
    private Map<String, ArrayList<ValueInstantiationData>> valueInstantiationDataMap;
    private Map<String, ArrayList<TypedTestPData>> typedTestPDataMap;
    private Map<String, ArrayList<TypeInstantiationData>> typeInstantiationDataMap;
    private IActionBars actionBars;
    private IToolBarManager toolBar;
    private RefreshAction refreshAction;
    private TreeControlAction expandAllAction;
    private CheckTreeAction checkAllAction;
    private CheckFailedAction checkFailedAction;
    private RerunLastTestActionTX rerunLastTestActionTX;
    private ReplaceLaunchAction replaceLaunchAction;
    private GTestOptionCheckAction runDisabledTestAction;
    private GTestOptionCheckAction shuffleTestAction;
    private GTestOptionCheckAction dontPrintElapsedTimeAction;
    private GTestOptionCheckActionXML generateXMLReportAction;

    public TXView() {
        txViewPart = this;
        UnitTestPlugin.getModel().addListener(this);
    }

    public void createPartControl(final Composite composite) {
        this.parent = composite;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.parent, "org.tizen.ide.native.unittest_context");
        this.scrolledComposite = new ScrolledComposite(this.parent, 0);
        this.treeComposite = new Composite((Composite)this.scrolledComposite, 0);
        this.treeComposite.setLayout((Layout)new FillLayout());
        this.scrolledComposite.setContent((Control)this.treeComposite);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setBackground(new Color(null, 255, 255, 255));
        this.testRoot = new TXTestRoot();
        this.valueInstantiationDataMap = new HashMap<String, ArrayList<ValueInstantiationData>>();
        this.testPDataMap = new HashMap<String, ArrayList<TestPData>>();
        this.typeInstantiationDataMap = new HashMap<String, ArrayList<TypeInstantiationData>>();
        this.typedTestPDataMap = new HashMap<String, ArrayList<TypedTestPData>>();
        this.treeViewer = new CheckboxTreeViewer(this.treeComposite, 0);
        this.treeViewer.setContentProvider((IContentProvider)new TXContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TXLabelProvider());
        this.treeViewer.setAutoExpandLevel(-1);
        this.treeViewer.setSorter(new ViewerSorter());
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                TreeSelection treeSelection;
                IWorkbenchWindow iWorkbenchWindow;
                if (doubleClickEvent.getSelection() instanceof TreeSelection && (iWorkbenchWindow = UnitTestPlugin.getActiveWorkbenchWindow()) != null && (treeSelection = (TreeSelection)doubleClickEvent.getSelection()).getFirstElement() instanceof TXTestNode) {
                    TXTestNode tXTestNode = (TXTestNode)treeSelection.getFirstElement();
                    IFile iFile = tXTestNode.getFile();
                    if (!iFile.exists()) {
                        DialogUtil.openErrorDialog((Shell)composite.getShell(), (String)"Error", (String)NLS.bind((String)UnitTestMessages.RESULTVIEW_CANNOT_FIND_FILE, (Object)iFile.getName()));
                        return;
                    }
                    IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                    if (iWorkbenchPage != null) {
                        try {
                            IEditorPart iEditorPart = iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), TXView.this.getEditorId(iFile));
                            IEditorInput iEditorInput = iEditorPart.getEditorInput();
                            ITextEditor iTextEditor = (ITextEditor)iEditorPart;
                            IDocumentProvider iDocumentProvider = iTextEditor.getDocumentProvider();
                            iDocumentProvider.connect((Object)iEditorInput);
                            IDocument iDocument = iDocumentProvider.getDocument((Object)iEditorInput);
                            IRegion iRegion = iDocument.getLineInformation(tXTestNode.getLineNumber() - 1);
                            iTextEditor.selectAndReveal(iRegion.getOffset(), iRegion.getLength());
                        }
                        catch (PartInitException partInitException) {
                            partInitException.printStackTrace();
                        }
                        catch (BadLocationException badLocationException) {
                            badLocationException.printStackTrace();
                        }
                        catch (CoreException coreException) {
                            coreException.printStackTrace();
                        }
                    }
                }
            }
        });
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                if (checkStateChangedEvent.getElement() instanceof TXTestSuite) {
                    TXTestSuite tXTestSuite = (TXTestSuite)checkStateChangedEvent.getElement();
                    TXView.this.treeViewer.setSubtreeChecked((Object)tXTestSuite, checkStateChangedEvent.getChecked());
                } else {
                    TXTestCase tXTestCase = (TXTestCase)checkStateChangedEvent.getElement();
                    TXTestSuite tXTestSuite = tXTestCase.getParent();
                    if (checkStateChangedEvent.getChecked()) {
                        boolean bl = true;
                        for (TXTestCase tXTestCase2 : tXTestSuite.getElements()) {
                            if (TXView.this.treeViewer.getChecked((Object)tXTestCase2)) continue;
                            bl = false;
                            break;
                        }
                        if (bl) {
                            TXView.this.treeViewer.setChecked((Object)tXTestSuite, true);
                        }
                    } else {
                        TXView.this.treeViewer.setChecked((Object)tXTestSuite, false);
                    }
                }
                if (TXView.this.treeViewer.getCheckedElements().length == 0) {
                    TXView.this.rerunLastTestActionTX.setEnabled(false);
                } else {
                    TXView.this.rerunLastTestActionTX.setEnabled(true);
                }
            }
        });
        this.actionBars = this.getViewSite().getActionBars();
        this.toolBar = this.actionBars.getToolBarManager();
        this.runDisabledTestAction = new GTestOptionCheckAction(this.RUN_DISABLED_TEST_ACTION_TEXT, " --gtest_also_run_disabled_tests", "org.tizen.tizenunittest.gtest.launch.RUN_DISABLE_ATTR");
        this.shuffleTestAction = new GTestOptionCheckAction(this.SHUFFLE_TEST_ACTION_TEXT, " --gtest_shuffle", "org.tizen.tizenunittest.gtest.launch.SHUFLE_TEST_ATTR");
        this.dontPrintElapsedTimeAction = new GTestOptionCheckAction(this.DONT_PRINT_ELAPSED_TIME_ACTION_TEXT, " --gtest_print_time=0", "org.tizen.tizenunittest.gtest.launch.ELAPSED_TIME_ATTR");
        this.generateXMLReportAction = new GTestOptionCheckActionXML(this.GENERATE_XML_REPORT_ACTION_TEXT, " --gtest_output=xml", this.parent.getShell());
        Vector<GTestOptionCheckAction> vector = new Vector<GTestOptionCheckAction>();
        vector.add(this.runDisabledTestAction);
        vector.add(this.shuffleTestAction);
        vector.add(this.dontPrintElapsedTimeAction);
        vector.add(this.generateXMLReportAction);
        IMenuManager iMenuManager = this.actionBars.getMenuManager();
        iMenuManager.add((IAction)this.runDisabledTestAction);
        iMenuManager.add((IAction)this.shuffleTestAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.dontPrintElapsedTimeAction);
        iMenuManager.add((IAction)this.generateXMLReportAction);
        iMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(TXView.this.projectName);
                if (iProject != null && NOT_SUPPORT_PROJECT_VERSION.equals(ProjectUtil.getTizenProjectDescription((IProject)iProject).getProfileInfo().getLatestPlatformVersion())) {
                    TXView.this.dontPrintElapsedTimeAction.setEnabled(false);
                }
            }
        });
        this.checkedTestNames = new Vector();
        this.refreshAction = new RefreshAction(this);
        this.expandAllAction = new TreeControlAction(this.treeViewer);
        this.replaceLaunchAction = new ReplaceLaunchAction(this.parent.getShell(), this);
        this.rerunLastTestActionTX = new RerunLastTestActionTX(this.treeViewer, vector, this.checkedTestNames, this.parent.getShell(), this.replaceLaunchAction);
        this.checkAllAction = new CheckTreeAction(this.treeViewer, this.rerunLastTestActionTX);
        this.checkFailedAction = new CheckFailedAction(this.treeViewer, this.rerunLastTestActionTX);
        this.toolBar.add((IAction)this.refreshAction);
        this.toolBar.add((IContributionItem)new Separator());
        this.toolBar.add((IAction)this.expandAllAction);
        this.toolBar.add((IContributionItem)new Separator());
        this.toolBar.add((IAction)this.checkAllAction);
        this.toolBar.add((IAction)this.checkFailedAction);
        this.toolBar.add((IContributionItem)new Separator());
        this.toolBar.add((IAction)this.rerunLastTestActionTX);
    }

    private String getEditorId(IFile iFile) {
        IWorkbench iWorkbench = UnitTestPlugin.getDefault().getWorkbench();
        IEditorDescriptor iEditorDescriptor = iWorkbench.getEditorRegistry().getDefaultEditor(iFile.getName(), this.getFileContentType(iFile));
        if (iEditorDescriptor == null) {
            iEditorDescriptor = iWorkbench.getEditorRegistry().findEditor("org.eclipse.ui.systemExternalEditor");
        }
        return iEditorDescriptor.getId();
    }

    private IContentType getFileContentType(IFile iFile) {
        try {
            IContentDescription iContentDescription = iFile.getContentDescription();
            if (iContentDescription != null) {
                return iContentDescription.getContentType();
            }
        }
        catch (CoreException coreException) {
            this.logger.error(coreException.getMessage(), (Throwable)coreException);
        }
        return null;
    }

    public void setFocus() {
        if (this.parent != null) {
            this.parent.setFocus();
        }
    }

    public static TXView getTXViewPart() {
        return txViewPart;
    }

    public boolean isCreated() {
        return this.treeViewer != null;
    }

    private void makeRoot(String string, String string2, IFile iFile, IFile iFile2, int n, int n2, TXTestType tXTestType) {
        TXTestCase tXTestCase = string.startsWith("DISABLED_") || string2.startsWith("DISABLED_") ? new TXTestCase(string2, TXNodeStatus.disabled, iFile, n) : new TXTestCase(string2, iFile, n);
        if (this.testRoot.contains(string)) {
            int n3 = this.testRoot.getChildNodeIndex(string);
            TXTestSuite tXTestSuite = (TXTestSuite)this.testRoot.getChildNode(n3);
            tXTestSuite.addTestNode(tXTestCase);
            if (tXTestSuite.getStatus().ordinal() < tXTestCase.getStatus().ordinal()) {
                tXTestSuite.setStatus(tXTestCase.getStatus());
            }
        } else {
            TXTestSuite tXTestSuite = new TXTestSuite(string, tXTestType, iFile2, n2);
            tXTestSuite.addTestNode(tXTestCase);
            if (tXTestSuite.getStatus().ordinal() < tXTestCase.getStatus().ordinal()) {
                tXTestSuite.setStatus(tXTestCase.getStatus());
            }
            this.testRoot.addTestNode(tXTestSuite);
        }
    }

    public void initializeTX(String string) {
        this.projectName = string;
        this.refreshAction.setEnabled(true);
        this.refreshAction.setToolTipText(String.valueOf(this.refreshAction.getActionName()) + ":\r" + string);
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string);
        this.testRoot.clear();
        this.valueInstantiationDataMap.clear();
        this.testPDataMap.clear();
        this.typeInstantiationDataMap.clear();
        this.typedTestPDataMap.clear();
        try {
            iProject.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy iResourceProxy) throws CoreException {
                    if (iResourceProxy.getType() == 1 && iResourceProxy.requestFullPath().segment(1).equals("src") && (iResourceProxy.getName().endsWith(".h") || iResourceProxy.getName().endsWith(".cpp"))) {
                        IFile iFile = (IFile)iResourceProxy.requestResource();
                        ITranslationUnit iTranslationUnit = (ITranslationUnit)CoreModel.getDefault().create(iFile);
                        ICElement[] iCElementArray = iTranslationUnit.getChildren();
                        int n = iCElementArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ArrayList arrayList;
                            ArrayList arrayList2;
                            TestPData testPData;
                            int n3;
                            ISourceRange iSourceRange;
                            String string;
                            String string2;
                            String string3;
                            StringTokenizer stringTokenizer;
                            String string4;
                            IStructure iStructure;
                            ICElement iCElement = iCElementArray[n2];
                            int n4 = iCElement.getElementType();
                            if (n4 == 65 || n4 == 83) {
                                iStructure = (IStructure)iCElement;
                                string4 = iStructure.getSource().trim();
                                stringTokenizer = new StringTokenizer(string4, " (,)\n\t");
                                string3 = stringTokenizer.nextToken();
                                if (string3.equals("TEST") || string3.equals("TEST_F")) {
                                    string2 = stringTokenizer.nextToken();
                                    string = stringTokenizer.nextToken();
                                    iSourceRange = iStructure.getSourceRange();
                                    n3 = iSourceRange.getStartLine();
                                    TXView.this.makeRoot(string2, string, iFile, null, n3, 0, TXTestType.TEST);
                                } else if (string3.equals("TEST_P")) {
                                    string2 = stringTokenizer.nextToken();
                                    string = stringTokenizer.nextToken();
                                    iSourceRange = iStructure.getSourceRange();
                                    n3 = iSourceRange.getStartLine();
                                    testPData = new TestPData(string, iFile, n3);
                                    arrayList2 = (ArrayList)TXView.this.testPDataMap.get(string2);
                                    if (arrayList2 == null) {
                                        arrayList = new ArrayList();
                                        arrayList.add(testPData);
                                        TXView.this.testPDataMap.put(string2, arrayList);
                                    } else {
                                        arrayList2.add(testPData);
                                    }
                                    arrayList = (ArrayList)TXView.this.valueInstantiationDataMap.get(string2);
                                    if (arrayList != null) {
                                        for (TestPData testPData2 : arrayList) {
                                            TXView.this.makeRoot(String.valueOf(testPData2.getStringData()) + "/" + string2, String.valueOf(string) + "/*", iFile, testPData2.getFile(), n3, testPData2.getLineNumber(), TXTestType.TEST_P);
                                        }
                                    }
                                } else if (string3.equals("TYPED_TEST")) {
                                    string2 = stringTokenizer.nextToken();
                                    string = stringTokenizer.nextToken();
                                    iSourceRange = iStructure.getSourceRange();
                                    n3 = iSourceRange.getStartLine();
                                    TXView.this.makeRoot(String.valueOf(string2) + "/*", string, iFile, null, n3, 0, TXTestType.TYPED_TEST);
                                }
                            } else if (n4 == 74) {
                                iStructure = (IFunction)iCElement;
                                string4 = iStructure.getSource().trim();
                                stringTokenizer = new StringTokenizer(string4, " (,)\n\t");
                                string3 = stringTokenizer.nextToken();
                                if (string3.equals("INSTANTIATE_TEST_CASE_P")) {
                                    string2 = stringTokenizer.nextToken();
                                    string = stringTokenizer.nextToken();
                                    iSourceRange = iStructure.getSourceRange();
                                    n3 = iSourceRange.getStartLine();
                                    testPData = new ValueInstantiationData(string2, iFile, n3);
                                    arrayList2 = (ArrayList)TXView.this.valueInstantiationDataMap.get(string);
                                    if (arrayList2 == null) {
                                        arrayList = new ArrayList();
                                        arrayList.add(testPData);
                                        TXView.this.valueInstantiationDataMap.put(string, arrayList);
                                    } else {
                                        arrayList2.add(testPData);
                                    }
                                    arrayList = (ArrayList)TXView.this.testPDataMap.get(string);
                                    if (arrayList != null) {
                                        for (TestPData testPData2 : arrayList) {
                                            TXView.this.makeRoot(String.valueOf(string2) + "/" + string, String.valueOf(testPData2.getStringData()) + "/*", testPData2.getFile(), iFile, testPData2.getLineNumber(), n3, TXTestType.TEST_P);
                                        }
                                    }
                                }
                            } else if (n4 == 61) {
                                iStructure = (INamespace)iCElement;
                                string4 = iStructure.getSource().trim();
                                stringTokenizer = new StringTokenizer(string4, " (,)\n\t");
                                string3 = stringTokenizer.nextToken();
                                if (string3.equals("TYPED_TEST_P")) {
                                    string2 = stringTokenizer.nextToken();
                                    string = stringTokenizer.nextToken();
                                    iSourceRange = iStructure.getSourceRange();
                                    n3 = iSourceRange.getStartLine();
                                    testPData = new TypedTestPData(string, iFile, n3);
                                    arrayList2 = (ArrayList)TXView.this.typedTestPDataMap.get(string2);
                                    if (arrayList2 == null) {
                                        arrayList = new ArrayList();
                                        arrayList.add(testPData);
                                        TXView.this.typedTestPDataMap.put(string2, arrayList);
                                    } else {
                                        arrayList2.add(testPData);
                                    }
                                    arrayList = (ArrayList)TXView.this.typeInstantiationDataMap.get(string2);
                                    if (arrayList != null) {
                                        for (TestPData testPData2 : arrayList) {
                                            TXView.this.makeRoot(String.valueOf(testPData2.getStringData()) + "/" + string2 + "/*", string, iFile, testPData2.getFile(), n3, testPData2.getLineNumber(), TXTestType.TYPED_TEST_P);
                                        }
                                    }
                                }
                            } else if (n4 == 76 && (string3 = (stringTokenizer = new StringTokenizer(string4 = (iStructure = (IVariable)iCElement).getSource().trim(), " (,)\n\t")).nextToken()).equals("INSTANTIATE_TYPED_TEST_CASE_P")) {
                                string2 = stringTokenizer.nextToken();
                                string = stringTokenizer.nextToken();
                                iSourceRange = iStructure.getSourceRange();
                                n3 = iSourceRange.getStartLine();
                                testPData = new TypeInstantiationData(string2, iFile, n3);
                                arrayList2 = (ArrayList)TXView.this.typeInstantiationDataMap.get(string);
                                if (arrayList2 == null) {
                                    arrayList = new ArrayList();
                                    arrayList.add(testPData);
                                    TXView.this.typeInstantiationDataMap.put(string, arrayList);
                                } else {
                                    arrayList2.add(testPData);
                                }
                                arrayList = (ArrayList)TXView.this.typedTestPDataMap.get(string);
                                if (arrayList != null) {
                                    for (TestPData testPData2 : arrayList) {
                                        TXView.this.makeRoot(String.valueOf(string2) + "/" + string + "/*", testPData2.getStringData(), testPData2.getFile(), iFile, testPData2.getLineNumber(), n3, TXTestType.TYPED_TEST_P);
                                    }
                                }
                            }
                            ++n2;
                        }
                    }
                    return true;
                }
            }, 0);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        this.treeViewer.setInput((Object)this.testRoot);
        for (String string2 : this.checkedTestNames) {
            TXTestSuite tXTestSuite;
            String string3;
            String[] stringArray = string2.split("\\.");
            if (stringArray.length == 1) {
                string3 = stringArray[0];
                int n = this.testRoot.getChildNodeIndex(string3);
                if (n == -1) continue;
                TXTestSuite tXTestSuite2 = (TXTestSuite)this.testRoot.getChildNode(n);
                this.treeViewer.setChecked((Object)tXTestSuite2, true);
                continue;
            }
            string3 = stringArray[0];
            String string4 = stringArray[1];
            int n = this.testRoot.getChildNodeIndex(string3);
            if (n == -1 || (n = (tXTestSuite = (TXTestSuite)this.testRoot.getChildNode(n)).getChildNodeIndex(string4)) == -1) continue;
            TXTestCase tXTestCase = (TXTestCase)tXTestSuite.getChildNode(n);
            this.treeViewer.setChecked((Object)tXTestCase, true);
        }
        this.checkedTestNames.clear();
    }

    public void statusUpdate(String string, String string2, TXNodeStatus tXNodeStatus, String string3) {
        if (!this.testRoot.contains(string)) {
            String[] stringArray = string.split("/");
            switch (stringArray.length) {
                case 2: {
                    string = String.valueOf(stringArray[0]) + "/*";
                    break;
                }
                case 3: {
                    string = String.valueOf(stringArray[0]) + "/" + stringArray[1] + "/*";
                }
            }
        }
        int n = this.testRoot.getChildNodeIndex(string);
        TXTestSuite tXTestSuite = (TXTestSuite)this.testRoot.getChildNode(n);
        int n2 = 0;
        TXTestType tXTestType = tXTestSuite.getTestType();
        if (tXTestType == TXTestType.TEST) {
            n2 = tXTestSuite.getChildNodeIndex(string2);
        } else if (tXTestType == TXTestType.TEST_P) {
            string2 = String.valueOf(string2.split("/")[0]) + "/*";
            n2 = tXTestSuite.getChildNodeIndex(string2);
        } else {
            n2 = tXTestSuite.getChildNodeIndex(string2);
        }
        TXTestCase tXTestCase = (TXTestCase)tXTestSuite.getChildNode(n2);
        if (tXTestCase.getStatus().ordinal() < tXNodeStatus.ordinal()) {
            tXTestCase.setStatus(tXNodeStatus);
            if (tXTestCase.getStatus() == TXNodeStatus.abnormal) {
                tXTestCase.setReason(string3);
            }
            if (tXTestSuite.getStatus().ordinal() < tXNodeStatus.ordinal()) {
                tXTestSuite.setStatus(tXNodeStatus);
            }
        }
    }

    public void refreshTX() {
        this.treeViewer.refresh();
    }

    @Override
    public void sessionStarted(TestSession testSession) {
        ILaunch iLaunch = testSession.getLaunch();
        this.rerunLastTestActionTX.setLaunchConfig(iLaunch.getLaunchConfiguration(), iLaunch.getLaunchMode());
        this.rerunLastTestActionTX.setEnabled(false);
    }

    @Override
    public void sessionFinished(TestSession testSession) {
        SWTUtil.syncExec((Display)UnitTestPlugin.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (TXView.this.treeViewer.getCheckedElements().length > 0) {
                    TXView.this.rerunLastTestActionTX.setEnabled(true);
                }
                TXView.this.setCaption(txViewPart.getProjectName());
            }
        });
    }

    private void setCaption(String string) {
        txViewPart.setContentDescription(string);
    }

    public CheckTreeAction getCheckTreeAction() {
        return this.checkAllAction;
    }

    public RerunLastTestActionTX getRerunLastTestActionTX() {
        return this.rerunLastTestActionTX;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public TXTestRoot getTXTestRoot() {
        return this.testRoot;
    }
}

