/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.wizards.newWizard;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.ui.wizards.ManagedBuildWizard;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.templateengine.IWizardDataPage;
import org.eclipse.cdt.ui.templateengine.Template;
import org.eclipse.cdt.ui.wizards.CNewWizard;
import org.eclipse.cdt.ui.wizards.EntryDescriptor;
import org.eclipse.cdt.ui.wizards.IWizardItemsListListener;
import org.eclipse.cdt.ui.wizards.IWizardWithMemory;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.ProjectContentsLocationArea;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ITizenProject;
import org.tizen.common.TizenProjectType;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.ui.wizards.PlatformTemplateLoader;
import org.tizen.common.util.CollectionUtil;
import org.tizen.common.util.ProjectUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.nativeappcommon.wizards.Messages;
import org.tizen.nativeappcommon.wizards.TizenMainWizardPage;
import org.tizen.nativeappcommon.wizards.model.TizenNativeTemplateModel;
import org.tizen.nativecommon.unittest.IUnitTestHandler;
import org.tizen.nativecommon.unittest.UnitTestProjectInfo;
import org.tizen.nativecommon.unittest.UnitTestRegistry;
import org.tizen.nativecore.wizards.TizenCoreMainWizardPage;
import org.tizen.tizenunittest.gtest.common.UnitTestMessages;
import org.tizen.tizenunittest.gtest.wizards.newWizard.TemplateListAndLabelProvider;

public class UnitTestWizardPage
extends TizenMainWizardPage
implements IWizardDataPage,
ISelectionChangedListener {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Text projectNameField;
    private Boolean projectNameFieldDirtyKey;
    private Boolean projectNameFieldDirtyMouse;
    private Text selectionDescription;
    private TreeViewer selectionTreeViewer;
    private Button tmplBtn;
    private IWizardPage nextPage;
    private IProject currentProjectSelection;
    private ProjectContentsLocationArea locationArea;
    Composite composite;
    public Composite mParent;
    private Map<ProfileInfo, List<EntryDescriptor>> tizenTemplateMap = new HashMap<ProfileInfo, List<EntryDescriptor>>();
    private List<TizenNativeTemplateModel> templateModelList = new ArrayList<TizenNativeTemplateModel>();
    private Template currentTemplateSelection;

    public UnitTestWizardPage(String string, TemplateListAndLabelProvider templateListAndLabelProvider) {
        super(string);
        this.setPageComplete(false);
        this.nextPage = null;
        this.currentTemplateSelection = templateListAndLabelProvider.getTemplates()[0];
    }

    public Composite getParent() {
        return this.mParent;
    }

    public void createControl(Composite composite) {
        this.mParent = composite;
        this.composite = new Composite(composite, 0);
        this.composite.setFont(composite.getFont());
        this.initializeDialogUnits((Control)composite);
        this.composite.setLayout((Layout)new GridLayout());
        this.composite.setLayoutData((Object)new GridData(1808));
        this.createProjectNameGroup(this.composite);
        this.locationArea = new ProjectContentsLocationArea(this.getErrorReporter(), this.composite);
        this.createTargetProjectViwers(this.composite);
        this.setPageComplete(this.validatePage());
        this.setMessage(null);
        this.setControl((Control)this.composite);
    }

    public boolean validatePage() {
        IWizardWithMemory iWizardWithMemory;
        IProject iProject;
        block11: {
            this.setMessage(null);
            String string = TizenCoreMainWizardPage.validateProjectName((String)this.getProjectName(), (IWorkspace)ResourcesPlugin.getWorkspace());
            if (!StringUtil.isEmpty((CharSequence)string)) {
                this.setErrorMessage(string);
                return false;
            }
            boolean bl = true;
            iProject = this.getProjectHandle();
            if (iProject.exists()) {
                if (this.getWizard() instanceof IWizardWithMemory && (iWizardWithMemory = (IWizardWithMemory)this.getWizard()).getLastProjectName() != null && iWizardWithMemory.getLastProjectName().equals(this.getProjectName())) {
                    bl = false;
                }
                if (bl) {
                    this.setErrorMessage("A project with that name already exists in the workspace.");
                    return false;
                }
            }
            if (bl) {
                try {
                    URI uRI = this.getProjectLocationURI();
                    if (uRI == null) {
                        iWizardWithMemory = EFS.getStore((URI)ResourcesPlugin.getWorkspace().getRoot().getLocationURI());
                        iWizardWithMemory = iWizardWithMemory.getChild(this.getProjectName());
                    } else {
                        iWizardWithMemory = EFS.getStore((URI)uRI);
                    }
                    IFileInfo iFileInfo = iWizardWithMemory.fetchInfo();
                    if (!iFileInfo.exists()) break block11;
                    if (iFileInfo.isDirectory()) {
                        this.setMessage("Directory with specified name already exists.", 2);
                        break block11;
                    }
                    this.setErrorMessage("File with specified name already exists.");
                    return false;
                }
                catch (CoreException coreException) {
                    CUIPlugin.log((IStatus)coreException.getStatus());
                }
            }
        }
        if (!this.useDefaults() && !(iWizardWithMemory = ResourcesPlugin.getWorkspace().validateProjectLocationURI(iProject, this.locationArea.getProjectLocationURI())).isOK()) {
            this.setErrorMessage(iWizardWithMemory.getMessage());
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public boolean useDefaults() {
        return this.locationArea.isDefault();
    }

    private final void createProjectNameGroup(Composite composite) {
        Composite composite2 = this.newHBox(composite, 2);
        Label label = new Label(composite2, 0);
        label.setText(IDEWorkbenchMessages.WizardNewProjectCreationPage_nameLabel);
        label.setFont(composite.getFont());
        this.projectNameField = new Text(composite2, 2048);
        this.projectNameFieldDirtyKey = false;
        this.projectNameFieldDirtyMouse = false;
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.projectNameField.setLayoutData((Object)gridData);
        this.projectNameField.setFont(composite.getFont());
        this.projectNameField.setText("untitled");
        this.projectNameField.setSelection(0, this.projectNameField.getText().length());
        this.projectNameField.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (!UnitTestWizardPage.this.projectNameFieldDirtyMouse.booleanValue()) {
                    UnitTestWizardPage.this.projectNameFieldDirtyKey = true;
                }
                UnitTestWizardPage.this.projectNameFieldDirtyMouse = false;
                UnitTestWizardPage.this.setPageComplete(UnitTestWizardPage.this.validatePage());
                UnitTestWizardPage.this.locationArea.updateProjectName(UnitTestWizardPage.this.projectNameField.getText().trim());
            }
        });
    }

    private Composite newHBox(Composite composite, int n) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        return composite2;
    }

    private Composite newVBox(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite2.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        return composite2;
    }

    private final void createTargetProjectViwers(Composite composite) {
        Composite composite2 = this.newVBox(composite);
        SashForm sashForm = new SashForm(composite2, 512);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        sashForm.setLayoutData((Object)gridData);
        SashForm sashForm2 = new SashForm((Composite)sashForm, 256);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        sashForm2.setLayoutData((Object)gridData);
        this.createTargetProjectListViewer((Composite)sashForm2);
        this.selectionDescription = new Text((Composite)sashForm, 2634);
        sashForm.setWeights(new int[]{75, 25});
    }

    private final void createTargetProjectListViewer(Composite composite) {
        Composite composite2 = this.newVBox(composite);
        Label label = new Label(composite2, 0);
        label.setText(UnitTestMessages.WIZARD_LABEL_SELECT_TARGET);
        label.setFont(composite.getFont());
        this.selectionTreeViewer = new TreeViewer(composite2, 2564);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.heightHint = 200;
        this.selectionTreeViewer.getControl().setLayoutData((Object)gridData);
        this.selectionTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.selectionTreeViewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.selectionTreeViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.selectionTreeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
        this.selectionTreeViewer.setSorter(new ViewerSorter());
        this.selectionTreeViewer.refresh();
        this.selectionTreeViewer.expandAll();
    }

    protected IStructuredContentProvider getContentProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object object) {
                if (!(object instanceof IWorkspace)) {
                    return new Object[0];
                }
                IProject[] iProjectArray = ((IWorkspace)object).getRoot().getProjects();
                ArrayList<IProject> arrayList = new ArrayList<IProject>();
                IProject[] iProjectArray2 = iProjectArray;
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IManagedProject iManagedProject;
                    IConfiguration iConfiguration;
                    IManagedBuildInfo iManagedBuildInfo;
                    IProject iProject = iProjectArray2[n2];
                    if (iProject.isOpen() && (iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject)) != null && (iConfiguration = iManagedBuildInfo.getDefaultConfiguration()) != null && (iManagedProject = iConfiguration.getManagedProject()) != null) {
                        String string = iManagedProject.getName();
                        UnitTestProjectInfo unitTestProjectInfo = UnitTestRegistry.getUnitTestProjectInfo((IProject)iProject);
                        TizenProjectType tizenProjectType = ProjectUtil.getTizenProjectType((IProject)iProject);
                        if (UnitTestWizardPage.this.unitTestSupported(tizenProjectType) && unitTestProjectInfo != null && !"Tizen Unit Test".equals(string) && UnitTestWizardPage.this.containsTizenTemplate(iProject)) {
                            arrayList.add(iProject);
                        }
                    }
                    ++n2;
                }
                return arrayList.toArray();
            }
        };
    }

    private boolean unitTestSupported(TizenProjectType tizenProjectType) {
        return tizenProjectType.isNativeSharedLibraryProject() || tizenProjectType.isNativeStaticLibraryProject() || tizenProjectType.equals((Object)TizenProjectType.TIZEN_C_SERVICE_APPLICATION) || tizenProjectType.equals((Object)TizenProjectType.TIZEN_C_UI_APPLICATION);
    }

    private final void createTargetProjectIconViewer(Composite composite) {
        Composite composite2 = this.newVBox(composite);
        Label label = new Label(composite2, 0);
        label.setText(UnitTestMessages.WIZARD_LABEL_TARGET_ICON);
        label.setFont(composite.getFont());
        Composite composite3 = new Composite(composite2, 2048);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite3.setLayoutData((Object)gridData);
        composite3.setBackground(new Color(null, 255, 255, 255));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        this.tmplBtn = new Button(composite3, 8);
        GridData gridData2 = new GridData(0x1000000, 0x1000000, true, true);
        gridData2.heightHint = 115;
        gridData2.widthHint = 115;
        this.tmplBtn.setLayoutData((Object)gridData2);
    }

    public boolean canFlipToNextPage() {
        if (this.isPageComplete()) {
            if (this.nextPage != null) {
                return true;
            }
            if (super.getNextPage() != null) {
                return true;
            }
        }
        return false;
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        Object var2_2 = null;
        Iterator iterator = ((IStructuredSelection)selectionChangedEvent.getSelection()).iterator();
        if (iterator.hasNext()) {
            var2_2 = iterator.next();
            if (var2_2 instanceof IProject) {
                this.currentProjectSelection = var2_2;
                String string = UnitTestRegistry.getUnitTestHandler((IProject)this.currentProjectSelection).getProjectSuffix();
                this.getSelectedTemplate();
                if (!this.projectNameFieldDirtyKey.booleanValue()) {
                    this.projectNameFieldDirtyMouse = true;
                    this.projectNameField.setText(String.valueOf(this.currentProjectSelection.getName()) + string);
                }
            } else {
                this.currentProjectSelection = null;
            }
        }
        if (this.currentProjectSelection == null) {
            this.selectionDescription.setText("");
        } else {
            this.selectionDescription.setText(UnitTestMessages.WIZARD_TEXT_UNITTEST_TEMPLATE);
        }
        this.setPageComplete(this.validatePage());
        this.projectNameField.setFocus();
    }

    protected List<EntryDescriptor> updateData(Composite composite, IWizardItemsListListener iWizardItemsListListener, IWizard iWizard) {
        EntryDescriptor entryDescriptor;
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.ui.CDTWizard");
        if (iExtensionPoint == null) {
            return null;
        }
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        if (iExtensionArray == null) {
            return null;
        }
        List<Object> list = new ArrayList<EntryDescriptor>();
        int n = 0;
        while (n < iExtensionArray.length) {
            EntryDescriptor entryDescriptor2 = entryDescriptor = iExtensionArray[n].getConfigurationElements();
            int n2 = ((IConfigurationElement[])entryDescriptor2).length;
            int n3 = 0;
            while (n3 < n2) {
                EntryDescriptor entryDescriptor3 = entryDescriptor2[n3];
                if (entryDescriptor3.getName().equals("wizard")) {
                    CNewWizard cNewWizard = null;
                    try {
                        cNewWizard = (CNewWizard)entryDescriptor3.createExecutableExtension("class");
                    }
                    catch (CoreException coreException) {
                        this.logger.error(Messages.EXCEPTION_WHILE_PROJECT_CREATION_2, (Throwable)coreException);
                    }
                    if (cNewWizard == null) {
                        return null;
                    }
                    if (cNewWizard instanceof ManagedBuildWizard) {
                        cNewWizard.setDependentControl(composite, iWizardItemsListListener);
                        EntryDescriptor[] entryDescriptorArray = cNewWizard.createItems(true, iWizard);
                        int n4 = entryDescriptorArray.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            EntryDescriptor entryDescriptor4 = entryDescriptorArray[n5];
                            list.add(entryDescriptor4);
                            ++n5;
                        }
                    }
                }
                ++n3;
            }
            ++n;
        }
        n = 0;
        while (n < list.size()) {
            entryDescriptor = (EntryDescriptor)list.get(n);
            if (entryDescriptor.isDefaultForCategory()) {
                list.remove(n);
                --n;
            }
            ++n;
        }
        if (iWizardItemsListListener != null) {
            list = iWizardItemsListListener.filterItems(list);
        }
        return list;
    }

    private boolean containsTizenTemplate(IProject iProject) {
        ITizenProject iTizenProject = ProjectUtil.getTizenProject((IProject)iProject);
        if (iTizenProject == null || iTizenProject.getDescription() == null) {
            return false;
        }
        ProfileInfo profileInfo = iTizenProject.getDescription().getProfileInfo();
        if (profileInfo == null || profileInfo.getLatestPlatformPath() == null) {
            return false;
        }
        profileInfo.getLatestPlatformName();
        Set<ProfileInfo> set = this.tizenTemplateMap.keySet();
        if (CollectionUtil.isEmpty(set)) {
            List<EntryDescriptor> list = this.loadTizenTemplate(iProject, profileInfo);
            if (list.isEmpty()) {
                return false;
            }
            this.tizenTemplateMap.put(profileInfo, list);
            return true;
        }
        return true;
    }

    private List<EntryDescriptor> loadTizenTemplate(IProject iProject, ProfileInfo profileInfo) {
        IUnitTestHandler iUnitTestHandler = UnitTestRegistry.getUnitTestHandler((IProject)iProject);
        String string = iUnitTestHandler.getSampleDirectory();
        PlatformTemplateLoader platformTemplateLoader = new PlatformTemplateLoader(string, "sample.xml");
        ArrayList<EntryDescriptor> arrayList = new ArrayList<EntryDescriptor>();
        platformTemplateLoader.loadPlatformSamples(profileInfo);
        EntryDescriptor entryDescriptor = null;
        new Path(InstallPathConfig.getSamplesPath((ProfileInfo)profileInfo, null)).append("Template/NativeTest");
        Path path = new Path("tizen/test");
        String string2 = path.removeLastSegments(1).lastSegment();
        entryDescriptor = new EntryDescriptor(iUnitTestHandler.getTemplateId(), iUnitTestHandler.getTemplateParentID(), string2, false, null, null);
        entryDescriptor.setPath("unittest");
        arrayList.add(entryDescriptor);
        return arrayList;
    }

    protected void createTemplateModel(List<EntryDescriptor> list) {
        Set<ProfileInfo> set = this.tizenTemplateMap.keySet();
        List<EntryDescriptor> list2 = null;
        boolean bl = false;
        for (ProfileInfo profileInfo : set) {
            list2 = this.tizenTemplateMap.get(profileInfo);
            block1: for (EntryDescriptor entryDescriptor : list2) {
                for (EntryDescriptor entryDescriptor2 : list) {
                    bl = false;
                    String string = entryDescriptor.getPath();
                    if (entryDescriptor2.getId().equals(entryDescriptor.getParentId())) {
                        bl = true;
                        entryDescriptor.setParentId(null);
                        entryDescriptor.setPath(String.valueOf(entryDescriptor2.getId()) + "/" + entryDescriptor.getId());
                        entryDescriptor.setParent(entryDescriptor2);
                        if (entryDescriptor2.getHandler() == null || !entryDescriptor2.getHandler().isApplicable(entryDescriptor)) continue block1;
                        entryDescriptor.setHandler(entryDescriptor2.getHandler());
                    }
                    if (!bl) continue;
                    IPath iPath = this.getTemplatePath(profileInfo).append(string);
                    IPath iPath2 = iPath.append("sample.xml");
                    TizenNativeTemplateModel tizenNativeTemplateModel = new TizenNativeTemplateModel(profileInfo, entryDescriptor.getName(), entryDescriptor, iPath, iPath2, null, null);
                    this.templateModelList.add(tizenNativeTemplateModel);
                }
            }
        }
    }

    private IPath getTemplatePath(ProfileInfo profileInfo) {
        return new Path(InstallPathConfig.getSamplesPath((ProfileInfo)profileInfo, (String)profileInfo.getLatestPlatformVersion())).append("Template/NativeTest");
    }

    public String getProjectName() {
        return this.projectNameField.getText().trim();
    }

    public IProject getSelectedProject() {
        return this.currentProjectSelection;
    }

    public IPath getProjectLocationPath() {
        return this.useDefaults() ? null : new Path(this.locationArea.getProjectLocation());
    }

    public URI getProjectLocationURI() {
        return this.useDefaults() ? null : this.locationArea.getProjectLocationURI();
    }

    public TizenNativeTemplateModel getSelectedTemplate() {
        Iterator<TizenNativeTemplateModel> iterator;
        Object object;
        if (this.templateModelList.isEmpty() && (object = this.updateData(new Composite(this.getParent(), 0), (IWizardItemsListListener)this, this.getWizard())) != null) {
            this.createTemplateModel((List<EntryDescriptor>)object);
        }
        if ((object = ProjectUtil.getTizenProject((IProject)this.currentProjectSelection)) == null || object.getDescription() == null) {
            return null;
        }
        ProfileInfo profileInfo = object.getDescription().getProfileInfo();
        if (profileInfo != null && (iterator = this.templateModelList.iterator()).hasNext()) {
            TizenNativeTemplateModel tizenNativeTemplateModel = iterator.next();
            this.switchTo(tizenNativeTemplateModel.getEntryDescriptor().getHandler(), tizenNativeTemplateModel.getEntryDescriptor());
            return tizenNativeTemplateModel;
        }
        return null;
    }

    public Template getCurrentSelectedTemplate() {
        return this.currentTemplateSelection;
    }

    public Map<String, String> getPageData() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = this.getProjectName();
        hashMap.put("projectName", string);
        hashMap.put("baseName", this.getBaseName(string));
        hashMap.put("baseNameUpper", string.toUpperCase());
        return hashMap;
    }

    private String getBaseName(String string) {
        String string2 = string;
        int n = string2.lastIndexOf(46);
        if (n != -1) {
            string2 = string2.substring(n + 1);
        }
        if ((n = string2.indexOf(32)) != -1) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    public void setNextPage(IWizardPage iWizardPage) {
        this.nextPage = iWizardPage;
    }

    private ProjectContentsLocationArea.IErrorMessageReporter getErrorReporter() {
        return new ProjectContentsLocationArea.IErrorMessageReporter(){

            public void reportError(String string, boolean bl) {
                boolean bl2;
                if (bl) {
                    UnitTestWizardPage.this.setMessage(string, 1);
                    UnitTestWizardPage.this.setErrorMessage(null);
                } else {
                    UnitTestWizardPage.this.setErrorMessage(string);
                }
                boolean bl3 = bl2 = string == null;
                if (bl2) {
                    bl2 = UnitTestWizardPage.this.validatePage();
                }
                UnitTestWizardPage.this.setPageComplete(bl2);
            }
        };
    }

    public void setVisible(boolean bl) {
        this.composite.setVisible(bl);
    }

    public IPath getLocationPath() {
        return new Path(this.locationArea.getProjectLocation());
    }

    public IPath getSelectedSampleLocation() {
        return this.getSelectedTemplate().getSpecXmlPath();
    }

    public boolean isPageComplete() {
        if (this.currentProjectSelection == null) {
            return false;
        }
        return this.validatePage();
    }
}

