/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.builder;

import java.util.ArrayList;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectResource {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ICSourceEntry[] targetSrcEntries;
    private ArrayList<IResource> targetBuildResources;
    IProject project;

    public ProjectResource(IProject iProject) {
        this.project = iProject;
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IConfiguration iConfiguration = iManagedBuildInfo.getDefaultConfiguration();
        this.targetSrcEntries = iConfiguration.getSourceEntries();
    }

    protected boolean isTargetSource(IPath iPath) {
        return !CDataUtil.isExcluded((IPath)iPath, (ICSourceEntry[])this.targetSrcEntries);
    }

    protected void targetAppendBuildResource(IResource iResource) {
        if (this.targetBuildResources == null) {
            this.targetBuildResources = new ArrayList();
        }
        this.targetBuildResources.add(iResource);
    }

    public boolean isGeneratedResource(IResource iResource) {
        String[] stringArray;
        IPath iPath = iResource.getProjectRelativePath();
        String[] stringArray2 = stringArray = ManagedBuildManager.getBuildInfo((IResource)this.project).getConfigurationNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            Path path = new Path(string);
            if (path.isPrefixOf(iPath)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isTargetGeneratedResource(IResource iResource) {
        String[] stringArray;
        IPath iPath = iResource.getProjectRelativePath();
        String[] stringArray2 = stringArray = ManagedBuildManager.getBuildInfo((IResource)this.project).getConfigurationNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            Path path = new Path(string);
            if (path.isPrefixOf(iPath)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public ArrayList<IResource> getTargetBuildResources() {
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)this.project);
        IConfiguration iConfiguration = iManagedBuildInfo.getDefaultConfiguration();
        TargetResourceProxyVisitor targetResourceProxyVisitor = new TargetResourceProxyVisitor(iConfiguration);
        try {
            this.project.accept((IResourceProxyVisitor)targetResourceProxyVisitor, 0);
        }
        catch (CoreException coreException) {
            this.logger.error("Failed to get a target configuration", (Throwable)coreException);
        }
        return this.targetBuildResources;
    }

    protected class TargetResourceProxyVisitor
    implements IResourceProxyVisitor {
        private final IConfiguration config;

        public TargetResourceProxyVisitor(IManagedBuildInfo iManagedBuildInfo) {
            this.config = iManagedBuildInfo.getDefaultConfiguration();
        }

        public TargetResourceProxyVisitor(IConfiguration iConfiguration) {
            this.config = iConfiguration;
        }

        public boolean visit(IResourceProxy iResourceProxy) throws CoreException {
            IResource iResource = iResourceProxy.requestResource();
            boolean bl = ProjectResource.this.isTargetSource(iResource.getProjectRelativePath());
            if (iResourceProxy.getType() == 1) {
                IResourceInfo iResourceInfo = this.config.getResourceInfo(iResource.getProjectRelativePath(), false);
                if (bl) {
                    boolean bl2 = false;
                    if (iResourceInfo instanceof IFolderInfo) {
                        String string = iResource.getFileExtension();
                        if (((IFolderInfo)iResourceInfo).buildsFileType(string) && !ProjectResource.this.isTargetGeneratedResource(iResource)) {
                            bl2 = true;
                        }
                    } else {
                        bl2 = true;
                    }
                    if (bl2) {
                        ProjectResource.this.targetAppendBuildResource(iResource);
                    }
                }
                return false;
            }
            if (iResourceProxy.getType() == 2) {
                return bl && !ProjectResource.this.isGeneratedResource(iResource);
            }
            return true;
        }
    }
}

