/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.properties;

import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.MultiConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativecommon.build.CommonBuildMessages;
import org.tizen.nativecommon.build.ui.AbstractDynamicAnalysisPropertyTab;
import org.tizen.nativecommon.unittest.IUnitTestHandler;
import org.tizen.nativecommon.unittest.UnitTestRegistry;
import org.tizen.tizenunittest.gtest.common.UnitTestXml;

public class UnitTestDynamicAnalysisPropertyTab
extends AbstractDynamicAnalysisPropertyTab {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected boolean checked;
    private Label messageLabel;
    private Label messageImageLabel;

    public void createDynamicAnalysisComposite(Composite composite) {
        IProject iProject = this.getTargetProject();
        final IUnitTestHandler iUnitTestHandler = UnitTestRegistry.getUnitTestHandler((IProject)iProject);
        GridLayout gridLayout = new GridLayout(1, false);
        composite.setLayout((Layout)gridLayout);
        this.checkDynamicAnalysis = new Button(composite, 32);
        this.checkDynamicAnalysis.setText(CommonBuildMessages.CODE_COVERAGE_LABEL_CHECKBOX);
        this.checkDynamicAnalysis.setSelection(this.checkSetDynamicAnalysisOption());
        this.checkDynamicAnalysis.setEnabled(this.checkTargetSetDynamicAnalysisOption(iProject));
        this.checkDynamicAnalysis.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                if (button.getSelection()) {
                    iUnitTestHandler.setDynamicAnalysisOption(UnitTestDynamicAnalysisPropertyTab.this.getCfg(), "-fprofile-arcs -ftest-coverage");
                    UnitTestDynamicAnalysisPropertyTab.this.checked = true;
                } else {
                    iUnitTestHandler.setDynamicAnalysisOption(UnitTestDynamicAnalysisPropertyTab.this.getCfg(), "");
                    UnitTestDynamicAnalysisPropertyTab.this.checked = false;
                }
            }
        });
        String string = UnitTestRegistry.getUnitTestProjectInfo((IProject)iProject).getTargetProjectType();
        if ("static".equals(string) || "share".equals(string)) {
            return;
        }
        if (!this.checkDynamicAnalysis.getEnabled()) {
            Composite composite2 = new Composite(composite, 0);
            composite2.setFont(composite.getFont());
            composite2.setLayout((Layout)new GridLayout(2, false));
            this.messageImageLabel = new Label(composite2, 1);
            this.messageImageLabel.setImage(JFaceResources.getImage((String)"dialog_messasge_info_image"));
            this.messageLabel = new Label(composite2, 512);
            this.messageLabel.setText("To activate this option, enable code coverage option of \"" + iProject.getName() + "\".");
            this.messageLabel.setVisible(true);
        }
    }

    protected boolean checkTargetSetDynamicAnalysisOption(IProject iProject) {
        IConfiguration[] iConfigurationArray;
        IUnitTestHandler iUnitTestHandler = UnitTestRegistry.getUnitTestHandler((IProject)iProject);
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IConfiguration[] iConfigurationArray2 = iConfigurationArray = iManagedBuildInfo.getDefaultConfiguration().getManagedProject().getConfigurations();
        int n = iConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration iConfiguration = iConfigurationArray2[n2];
            if (iConfiguration.getName().equals(this.getCfg().getName())) {
                String string = iUnitTestHandler.getDynamicAnalysisOption(iConfiguration);
                return string.equals("-fprofile-arcs -ftest-coverage");
            }
            ++n2;
        }
        return false;
    }

    public boolean checkSetDynamicAnalysisOption() {
        IProject iProject = this.getTargetProject();
        IUnitTestHandler iUnitTestHandler = UnitTestRegistry.getUnitTestHandler((IProject)iProject);
        String string = UnitTestRegistry.getUnitTestProjectInfo((IProject)iProject).getTargetProjectType();
        if ("static".equals(string) || "share".equals(string)) {
            String string2 = iUnitTestHandler.getDynamicAnalysisOption(this.getCfg());
            return string2.equals("-fprofile-arcs -ftest-coverage");
        }
        if (!this.checkTargetSetDynamicAnalysisOption(iProject)) {
            return false;
        }
        String string3 = iUnitTestHandler.getDynamicAnalysisOption(this.getCfg());
        return string3.equals("-fprofile-arcs -ftest-coverage");
    }

    protected IProject getTargetProject() {
        UnitTestXml unitTestXml = new UnitTestXml(this.getResDesc().getConfiguration().getProjectDescription().getProject());
        IProject iProject = null;
        try {
            iProject = unitTestXml.getTargetProject();
        }
        catch (Exception exception) {
            this.logger.error("Failed to get a target project", (Throwable)exception);
        }
        return iProject;
    }

    public boolean canBeVisible() {
        IProject iProject = this.getTargetProject();
        String string = UnitTestRegistry.getUnitTestProjectInfo((IProject)iProject).getTargetProjectType();
        if ("static".equals(string) || "share".equals(string)) {
            return false;
        }
        IManagedProject iManagedProject = this.getCfg().getManagedProject();
        String string2 = iManagedProject.getName();
        return string2.equals("Tizen Unit Test");
    }

    public void performOK() {
        IUnitTestHandler iUnitTestHandler = UnitTestRegistry.getUnitTestHandler((IProject)this.getTargetProject());
        if (this.getCfg() instanceof MultiConfiguration) {
            Object[] objectArray = ((MultiConfiguration)this.getCfg()).getItems();
            IConfiguration[] iConfigurationArray = (IConfiguration[])objectArray;
            int n = iConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration iConfiguration = iConfigurationArray[n2];
                if (this.checked) {
                    iUnitTestHandler.setDynamicAnalysisOption(iConfiguration, "-fprofile-arcs -ftest-coverage");
                } else {
                    iUnitTestHandler.setDynamicAnalysisOption(iConfiguration, "");
                }
                ++n2;
            }
        }
    }
}

