/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.testexplorer.toolbaraction;

import java.util.Vector;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.util.DeviceUtil;
import org.tizen.tizenunittest.gtest.GlobalValues;
import org.tizen.tizenunittest.gtest.UnitTestPlugin;
import org.tizen.tizenunittest.gtest.common.UnitTestMessages;
import org.tizen.tizenunittest.gtest.gtest.testexplorer.TXView;
import org.tizen.tizenunittest.gtest.testexplorer.model.TXTestCase;
import org.tizen.tizenunittest.gtest.testexplorer.model.TXTestNode;
import org.tizen.tizenunittest.gtest.testexplorer.model.TXTestSuite;
import org.tizen.tizenunittest.gtest.testexplorer.toolbaraction.ReplaceLaunchAction;
import org.tizen.tizenunittest.gtest.testexplorer.viewmenuaction.GTestOptionCheckAction;

public class RerunLastTestActionTX
extends Action
implements IMenuCreator {
    protected static final Logger logger = LoggerFactory.getLogger(RerunLastTestActionTX.class);
    protected final String ACTIONNAME = UnitTestMessages.TXVIEW_TOOLTIP_RUN_CHECK;
    protected final String TXDIALOG_TITLE = UnitTestMessages.TXVIEW_RUN_CHECK_TITLE;
    protected final String TXDIALOG_BODYTEXT = UnitTestMessages.TXVIEW_RUN_CHECK_BODY;
    protected final String TXDIALOG_RADIOGROUPTEXT = UnitTestMessages.TXVIEW_RUN_CHECK_RADIO_GROUP;
    protected final String TXDIALOG_RADIONAME_RUN = UnitTestMessages.TXVIEW_RUN_CHECK_RADIO_RUN;
    protected final String TXDIALOG_RADIONAME_DEBUG = UnitTestMessages.TXVIEW_RUN_CHECK_RADIO_DEBUG;
    private final String TXDIALOG_BUTTONNAME_RUN = UnitTestMessages.TXVIEW_RUN_CHECK_BUTTON_RUN;
    protected final String TXDIALOG_BUTTONNAME_CANCEL = UnitTestMessages.TXVIEW_RUN_CHECK_BUTTON_CANCEL;
    protected final int DIALOGSIZE_X = 500;
    protected final int DIALOGSIZE_Y = 300;
    private CheckboxTreeViewer treeViewer;
    private Vector<GTestOptionCheckAction> gTestOptionCheckActions;
    private Vector<String> checkedTestNames;
    protected Shell shell;
    private ILaunchConfiguration launchConfiguration;
    private String launchMode;
    private ReplaceLaunchAction replaceLaunchAction;
    private Menu childMenu;

    public RerunLastTestActionTX() {
    }

    public RerunLastTestActionTX(CheckboxTreeViewer checkboxTreeViewer, Vector<GTestOptionCheckAction> vector, Vector<String> vector2, Shell shell, ReplaceLaunchAction replaceLaunchAction) {
        super(null, 4);
        this.treeViewer = checkboxTreeViewer;
        this.gTestOptionCheckActions = vector;
        this.checkedTestNames = vector2;
        this.shell = shell;
        this.replaceLaunchAction = replaceLaunchAction;
        this.setToolTipText(this.ACTIONNAME);
        this.setImageDescriptor(UnitTestPlugin.getImageDescriptor("elcl18/runchecked.png"));
        this.setDisabledImageDescriptor(UnitTestPlugin.getImageDescriptor("dlcl18/runchecked.png"));
        this.setEnabled(false);
        this.setMenuCreator(this);
    }

    public void run() {
        if (this.launchConfiguration != null) {
            IDevice iDevice = ConnectionPlugin.getDefault().getCurrentDevice();
            if (DeviceUtil.isOnline((IDevice)iDevice)) {
                this.rerunTestRun();
            }
        } else {
            TXDialog tXDialog = new TXDialog(this.shell, 0);
            tXDialog.open();
        }
    }

    private void rerunTestRun() {
        GlobalValues.RERUNED = true;
        try {
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = this.launchConfiguration.getWorkingCopy();
            iLaunchConfigurationWorkingCopy.setAttribute("org.tizen.tizenunittest.gtest.launch.TX_OPTIONS_ATTR", this.makeArgument(""));
            this.launchConfiguration = iLaunchConfigurationWorkingCopy.doSave();
            DebugUITools.launch((ILaunchConfiguration)this.launchConfiguration, (String)this.launchMode);
        }
        catch (CoreException coreException) {
            logger.error(coreException.getMessage(), (Throwable)coreException);
        }
    }

    private String makeArgument(String string) {
        String string2 = "";
        String string3 = "";
        Object[] objectArray = this.treeViewer.getCheckedElements();
        if (objectArray.length > 0) {
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                TXTestNode tXTestNode;
                Object object = objectArray2[n2];
                if (object instanceof TXTestCase) {
                    tXTestNode = (TXTestCase)object;
                    if (!this.treeViewer.getChecked((Object)((TXTestCase)tXTestNode).getParent())) {
                        string2 = String.valueOf(string2) + ":" + ((TXTestCase)tXTestNode).getParent().getName() + "." + tXTestNode.getName();
                    }
                    this.checkedTestNames.add(String.valueOf(((TXTestCase)tXTestNode).getParent().getName()) + "." + tXTestNode.getName());
                } else if (object instanceof TXTestSuite) {
                    tXTestNode = (TXTestSuite)object;
                    string2 = String.valueOf(string2) + ":" + tXTestNode.getName() + ".*";
                    this.checkedTestNames.add(tXTestNode.getName());
                }
                ++n2;
            }
            string3 = " --gtest_filter=" + string2;
        } else {
            string3 = string;
        }
        return string3;
    }

    public void setLaunchConfig(ILaunchConfiguration iLaunchConfiguration, String string) {
        this.launchConfiguration = iLaunchConfiguration;
        this.launchMode = string;
        if (iLaunchConfiguration != null) {
            this.setToolTipText(String.valueOf(this.ACTIONNAME) + ":\r" + iLaunchConfiguration.getName());
        } else {
            this.setToolTipText(this.ACTIONNAME);
        }
        for (GTestOptionCheckAction gTestOptionCheckAction : this.gTestOptionCheckActions) {
            gTestOptionCheckAction.init(iLaunchConfiguration);
        }
    }

    public ILaunchConfiguration getLaunchConfig() {
        return this.launchConfiguration;
    }

    public void dispose() {
        if (this.childMenu != null) {
            this.childMenu.dispose();
            this.childMenu = null;
        }
    }

    public Menu getMenu(Control control) {
        if (this.childMenu != null) {
            this.childMenu.dispose();
        }
        this.childMenu = new Menu(control);
        ActionContributionItem actionContributionItem = new ActionContributionItem((IAction)this.replaceLaunchAction);
        actionContributionItem.fill(this.childMenu, -1);
        return this.childMenu;
    }

    public Menu getMenu(Menu menu) {
        return null;
    }

    protected class TXDialog
    extends Dialog {
        private Button buttonRun;
        private Button radioRun;
        private Button radioDebug;

        public TXDialog(Shell shell, int n) {
            super(shell, n);
            this.buttonRun = null;
            this.radioRun = null;
            this.radioDebug = null;
        }

        public void open() {
            ILaunchConfiguration iLaunchConfiguration;
            Group group;
            String string;
            Vector<ILaunchConfiguration> vector = new Vector<ILaunchConfiguration>();
            ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
            final Shell shell = new Shell(this.getParent(), 67616);
            shell.setSize(500, 300);
            shell.setText(RerunLastTestActionTX.this.TXDIALOG_TITLE);
            shell.setLayout((Layout)new GridLayout(3, true));
            Label label = new Label((Composite)shell, 0);
            label.setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
            label.setText(RerunLastTestActionTX.this.TXDIALOG_BODYTEXT);
            ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)shell, 0);
            scrolledComposite.setLayout((Layout)new GridLayout());
            scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            Composite composite = new Composite((Composite)scrolledComposite, 0);
            composite.setLayout((Layout)new FillLayout());
            scrolledComposite.setContent((Control)composite);
            scrolledComposite.setExpandHorizontal(true);
            scrolledComposite.setExpandVertical(true);
            final TableViewer tableViewer = new TableViewer(composite, 2048);
            tableViewer.getTable().setBackground(this.getParent().getDisplay().getSystemColor(22));
            tableViewer.setContentProvider((IContentProvider)new TXDialogContentProvider());
            tableViewer.setLabelProvider((IBaseLabelProvider)new TXDialogLabelProvider());
            try {
                string = TXView.getTXViewPart().getProjectName();
                Group group2 = group = iLaunchManager.getLaunchConfigurations();
                int n = ((ILaunchConfiguration[])group2).length;
                int n2 = 0;
                while (n2 < n) {
                    iLaunchConfiguration = group2[n2];
                    String string2 = CDebugUtils.getProjectName((ILaunchConfiguration)iLaunchConfiguration);
                    if (iLaunchConfiguration.getType().getIdentifier().equals("org.tizen.tizenunittest.launchConfigTypeId") && string2.equals(string)) {
                        vector.add(iLaunchConfiguration);
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {
                logger.error(coreException.getMessage(), (Throwable)coreException);
            }
            tableViewer.setInput(vector);
            tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                    TXDialog.this.buttonRun.setEnabled(true);
                }
            });
            string = new Composite((Composite)shell, 0);
            string.setLayout((Layout)new GridLayout());
            string.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            group = new Group((Composite)string, 16);
            group.setText(RerunLastTestActionTX.this.TXDIALOG_RADIOGROUPTEXT);
            group.setLayout((Layout)new RowLayout(512));
            this.radioRun = new Button((Composite)group, 16);
            this.radioRun.setText(RerunLastTestActionTX.this.TXDIALOG_RADIONAME_RUN);
            this.radioRun.setSelection(true);
            this.radioDebug = new Button((Composite)group, 16);
            this.radioDebug.setText(RerunLastTestActionTX.this.TXDIALOG_RADIONAME_DEBUG);
            this.buttonRun = new Button((Composite)string, 8);
            this.buttonRun.setText(RerunLastTestActionTX.this.TXDIALOG_BUTTONNAME_RUN);
            this.buttonRun.setEnabled(false);
            this.buttonRun.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent mouseEvent) {
                    StructuredSelection structuredSelection = (StructuredSelection)tableViewer.getSelection();
                    RerunLastTestActionTX.this.launchConfiguration = (ILaunchConfiguration)structuredSelection.getFirstElement();
                    if (TXDialog.this.radioRun.getSelection()) {
                        RerunLastTestActionTX.this.launchMode = "run";
                    } else {
                        RerunLastTestActionTX.this.launchMode = "debug";
                    }
                    if (RerunLastTestActionTX.this.treeViewer.getCheckedElements().length == 0) {
                        RerunLastTestActionTX.this.setEnabled(false);
                    }
                    shell.dispose();
                }
            });
            iLaunchConfiguration = new Button((Composite)string, 8);
            iLaunchConfiguration.setText(RerunLastTestActionTX.this.TXDIALOG_BUTTONNAME_CANCEL);
            iLaunchConfiguration.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent mouseEvent) {
                    shell.dispose();
                }
            });
            shell.open();
            Display display = this.getParent().getDisplay();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            if (RerunLastTestActionTX.this.launchConfiguration != null) {
                RerunLastTestActionTX.this.rerunTestRun();
            }
        }
    }

    protected class TXDialogContentProvider
    implements IStructuredContentProvider {
        protected TXDialogContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public Object[] getElements(Object object) {
            if (object instanceof Vector) {
                return ((Vector)object).toArray();
            }
            return null;
        }
    }

    protected class TXDialogLabelProvider
    implements ILabelProvider {
        private Image unitTestImage = UnitTestPlugin.getImageDescriptor("wizard/obj16/native_unittest_project.png").createImage();

        protected TXDialogLabelProvider() {
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object object, String string) {
            return false;
        }

        public Image getImage(Object object) {
            return this.unitTestImage;
        }

        public String getText(Object object) {
            if (object instanceof ILaunchConfiguration) {
                return ((ILaunchConfiguration)object).getName();
            }
            return null;
        }
    }
}

