/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.testexplorer.event;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.swt.widgets.Display;
import org.tizen.tizenunittest.gtest.UnitTestPlugin;
import org.tizen.tizenunittest.gtest.event.AbnormalDefectEvent;
import org.tizen.tizenunittest.gtest.event.SessionEndEvent;
import org.tizen.tizenunittest.gtest.event.TestErrorEvent;
import org.tizen.tizenunittest.gtest.event.TestEvent;
import org.tizen.tizenunittest.gtest.event.TestEventHandler;
import org.tizen.tizenunittest.gtest.event.TestFailureEvent;
import org.tizen.tizenunittest.gtest.event.TestStartEvent;
import org.tizen.tizenunittest.gtest.event.TestSuccessEvent;
import org.tizen.tizenunittest.gtest.gtest.testexplorer.TXView;
import org.tizen.tizenunittest.gtest.testexplorer.model.TXNodeStatus;

public class TXEventHandler
extends TestEventHandler {
    private static TXEventHandler uniqueInstance = null;
    private static ILaunchConfiguration launchConfiguration;
    private String argument;
    private boolean needClear;

    public static TXEventHandler getInstance(ILaunchConfiguration iLaunchConfiguration) {
        if (uniqueInstance == null) {
            uniqueInstance = new TXEventHandler(iLaunchConfiguration);
        } else {
            launchConfiguration = iLaunchConfiguration;
        }
        return uniqueInstance;
    }

    private TXEventHandler(ILaunchConfiguration iLaunchConfiguration) {
        launchConfiguration = iLaunchConfiguration;
        this.needClear = false;
        try {
            this.argument = iLaunchConfiguration.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", "");
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    @Override
    public void handle(TestEvent testEvent) {
        if (testEvent instanceof TestSuccessEvent) {
            this.handleSuccess((TestSuccessEvent)testEvent);
        } else if (testEvent instanceof TestFailureEvent) {
            this.handleFailure((TestFailureEvent)testEvent);
        } else if (testEvent instanceof TestErrorEvent) {
            this.handleError((TestErrorEvent)testEvent);
        } else if (testEvent instanceof AbnormalDefectEvent) {
            this.handleAbnormalDefect((AbnormalDefectEvent)testEvent);
        } else if (testEvent instanceof SessionEndEvent) {
            this.handleSessionEnd();
        }
    }

    @Override
    protected void handleSuiteBeginning(String string, int n) {
    }

    protected void handleTestStart(TestStartEvent testStartEvent) {
    }

    protected void handleError(TestErrorEvent testErrorEvent) {
        String string = testErrorEvent.suiteName;
        String string2 = testErrorEvent.testName;
        TXView tXView = TXView.getTXViewPart();
        tXView.statusUpdate(string, string2, TXNodeStatus.error, null);
    }

    protected void handleSuccess(TestSuccessEvent testSuccessEvent) {
        String string = testSuccessEvent.suiteName;
        String string2 = testSuccessEvent.testName;
        TXView tXView = TXView.getTXViewPart();
        tXView.statusUpdate(string, string2, TXNodeStatus.successed, null);
    }

    @Override
    protected void handleSuiteEnding(String string) {
    }

    protected void handleFailure(TestFailureEvent testFailureEvent) {
        String string = testFailureEvent.suiteName;
        String string2 = testFailureEvent.testName;
        TXView tXView = TXView.getTXViewPart();
        tXView.statusUpdate(string, string2, TXNodeStatus.failed, null);
    }

    protected void handleAbnormalDefect(AbnormalDefectEvent abnormalDefectEvent) {
        String string = abnormalDefectEvent.suiteName;
        String string2 = abnormalDefectEvent.testName;
        TXView tXView = TXView.getTXViewPart();
        tXView.statusUpdate(string, string2, TXNodeStatus.abnormal, abnormalDefectEvent.getReason());
    }

    @Override
    public void handleSessionEnd() {
        Display display = UnitTestPlugin.getDisplay();
        final TXView tXView = TXView.getTXViewPart();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                tXView.refreshTX();
            }
        });
    }

    public void setArgument(String string) {
        this.argument = string;
        this.needClear = true;
    }

    @Override
    protected void handleTestStart(String string) {
    }

    @Override
    protected void handleSuccess(String string, String string2) {
    }

    @Override
    public void handleSessionStart() {
    }

    @Override
    protected void handleFailure(String string, String string2, String string3, String string4) {
    }

    @Override
    protected void handleError(String string, String string2) {
    }
}

