/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.wizards.newWizard;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.StringUtil;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.nativecommon.build.CommonProjectDependentBuilder;
import org.tizen.nativecommon.build.ProjectTypeManager;
import org.tizen.nativecommon.build.exception.SBIException;
import org.tizen.nativecommon.unittest.IUnitTestHandler;
import org.tizen.nativecommon.unittest.UnitTestProjectInfo;
import org.tizen.nativecommon.unittest.UnitTestRegistry;
import org.tizen.nativecore.build.makefile.NativeCoreNinjaFileGenerator;
import org.tizen.tizenunittest.gtest.common.UnitTestCommon;
import org.tizen.tizenunittest.gtest.common.UnitTestMessages;
import org.tizen.tizenunittest.gtest.common.UnitTestXml;
import org.xml.sax.SAXException;

public class UnitTestNinjaGenerator
extends NativeCoreNinjaFileGenerator {
    private static final Logger logger = LoggerFactory.getLogger(UnitTestNinjaGenerator.class);
    public boolean projectBuild = false;
    public boolean deleteFile = false;
    public boolean chUIThread = true;
    protected IProject targetProject;
    protected IProject testProject;

    public MultiStatus generateMakefiles(IResourceDelta iResourceDelta) throws CoreException {
        return this.regenerateMakefiles();
    }

    private List<String> getTargetObjectFileList(IProject iProject, IProject iProject2) throws ParserConfigurationException, SAXException {
        UnitTestCommon unitTestCommon = new UnitTestCommon();
        IUnitTestHandler iUnitTestHandler = UnitTestRegistry.getUnitTestHandler((IProject)iProject2);
        ArrayList arrayList = iUnitTestHandler.getBuildObjectFiles(iProject2);
        ArrayList arrayList2 = iUnitTestHandler.getBuildSources(iProject2);
        ArrayList<IFile> arrayList3 = null;
        try {
            arrayList3 = unitTestCommon.divideCFile(arrayList2, iProject, iProject2, null);
        }
        catch (CoreException coreException) {
            logger.error("Failed to divide a file", (Throwable)coreException);
        }
        catch (IOException iOException) {
            logger.error("Failed to divide a file", (Throwable)iOException);
        }
        ArrayList<String> arrayList4 = new ArrayList<String>();
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            int n3 = arrayList3.size();
            int n4 = 0;
            while (n4 < n3) {
                if (((IPath)arrayList.get(n2)).removeFileExtension().lastSegment().equals(((IFile)arrayList3.get(n4)).getFullPath().removeFileExtension().lastSegment())) {
                    if (!new File(((IPath)arrayList.get(n2)).toString()).exists()) break;
                    arrayList4.add(((IPath)arrayList.get(n2)).toString());
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        return arrayList4;
    }

    private void setObjectPathToLinker(IProject iProject, List<String> list) throws ParserConfigurationException, SAXException, IOException {
        List<String> list2 = this.getTargetProjectObjectListOld(iProject);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list2 != null) {
            for (String object2 : list2) {
                if (list.contains(object2)) continue;
                arrayList.add(object2);
            }
        }
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IConfiguration iConfiguration = iManagedBuildInfo.getDefaultConfiguration();
        this.removeTargetProjectObject(iProject, arrayList);
        this.setTargetProjectObjectList(iProject, list);
        IConfiguration[] iConfigurationArray = iConfiguration.getManagedProject().getConfigurations();
        int n = iConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration iConfiguration2 = iConfigurationArray[n2];
            for (String string : arrayList) {
                CommonConfigurationManager.removeOtherObjectFromLinker((IConfiguration)iConfiguration2, (String)UnitTestCommon.makePropertyOption(string));
            }
            ++n2;
        }
        for (String string : list) {
            CommonConfigurationManager.appendOtherObjectToLinker((IConfiguration)iConfiguration, (String)UnitTestCommon.makePropertyOption(string));
        }
        ManagedBuildManager.saveBuildInfo((IProject)iProject, (boolean)true);
    }

    protected MultiStatus preRegenerateMakefiles() throws CoreException {
        this.testProject = this.getTestProject(this.getTopBuildDir());
        this.targetProject = this.getTargetProject(this.testProject);
        if (this.targetProject == null) {
            return new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 4, UnitTestMessages.WIZARD_ERROR_UNITTEST_XML, null);
        }
        if (!this.targetProject.exists() || !this.targetProject.isOpen()) {
            return new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 4, NLS.bind((String)UnitTestMessages.BUILD_ERROR_TARGET_EXISTS, (Object)this.targetProject.getName()), null);
        }
        UnitTestProjectInfo unitTestProjectInfo = UnitTestRegistry.getUnitTestProjectInfo((IProject)this.targetProject);
        MultiStatus multiStatus = null;
        if ("share".equals(unitTestProjectInfo.getTargetProjectType())) {
            multiStatus = this.checkTargetStatus(false);
            if (multiStatus.getCode() == 4) {
                return multiStatus;
            }
            try {
                this.copyLibraryFile(this.testProject, this.targetProject);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 4, NLS.bind((String)UnitTestMessages.WIZARD_ERROR_TARGET_LIBRARY, (Object)this.targetProject.getName()), null);
            }
            return multiStatus;
        }
        if ("static".equals(unitTestProjectInfo.getTargetProjectType())) {
            multiStatus = this.checkTargetStatus(false);
            return multiStatus;
        }
        multiStatus = this.checkTargetStatus(true);
        if (multiStatus.getCode() == 4) {
            return multiStatus;
        }
        try {
            List<String> list = this.getTargetObjectFileList(this.testProject, this.targetProject);
            this.setObjectPathToLinker(this.testProject, list);
        }
        catch (Exception exception) {
            return new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 4, UnitTestMessages.WIZARD_ERROR_UNITTEST_XML, null);
        }
        return multiStatus;
    }

    private boolean copyLibraryFile(IProject iProject, IProject iProject2) throws CoreException, FileNotFoundException {
        Display display;
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject2);
        IConfiguration iConfiguration = iManagedBuildInfo.getDefaultConfiguration();
        IFile iFile = iProject2.getFile(String.valueOf(iConfiguration.getName()) + "/" + ProjectUtil.getBinaryName((IProject)iProject2));
        if (!iFile.exists()) {
            throw new FileNotFoundException();
        }
        File file = new File(iProject.getFile("/lib/" + iFile.getName()).getLocation().toString());
        if (file.exists()) {
            display = PlatformUI.getWorkbench().getDisplay();
            display.syncExec((Runnable)new YesNoDialogRunnable(display, NLS.bind((String)UnitTestMessages.WIZARD_WARNING_OVERWRITE, (Object)file.getName())));
            if (!this.deleteFile) {
                return false;
            }
            file.delete();
        }
        display = iProject.getFile("/lib/" + iFile.getName());
        UnitTestCommon.fileCopy(iFile.getLocation().toString(), (IFile)display);
        return true;
    }

    public MultiStatus regenerateMakefiles() throws CoreException {
        MultiStatus multiStatus = this.preRegenerateMakefiles();
        if (multiStatus.getCode() == 0) {
            return super.regenerateMakefiles();
        }
        return multiStatus;
    }

    protected IProject getTestProject(IPath iPath) {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot iWorkspaceRoot = iWorkspace.getRoot();
        IProject iProject = iWorkspaceRoot.getProject(iPath.segment(iPath.segmentCount() - 2));
        return iProject;
    }

    protected IProject getTargetProject(IProject iProject) throws CoreException {
        IProject iProject2;
        try {
            iProject2 = this.createXml(iProject).getTargetProject();
        }
        catch (Exception exception) {
            String string = iProject.getDescription().getComment();
            if (StringUtil.isEmpty((CharSequence)string)) {
                return null;
            }
            String string2 = iProject.getDescription().getComment().substring(12);
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot iWorkspaceRoot = iWorkspace.getRoot();
            iProject2 = iWorkspaceRoot.getProject(string2);
        }
        return iProject2;
    }

    protected void removeTargetProjectObject(IProject iProject, List<String> list) {
        UnitTestXml unitTestXml = this.createXml(iProject);
        for (String string : list) {
            try {
                unitTestXml.removeTargetObjectFile(string);
            }
            catch (Exception exception) {
                logger.error("Failed to remove a target object file", (Throwable)exception);
            }
        }
    }

    protected List<String> getTargetProjectObjectListOld(IProject iProject) throws ParserConfigurationException, SAXException, IOException {
        UnitTestXml unitTestXml = this.createXml(iProject);
        return unitTestXml.getTargetObjectFile();
    }

    protected void setTargetProjectObjectList(IProject iProject, List<String> list) {
        UnitTestXml unitTestXml = this.createXml(iProject);
        try {
            for (String string : list) {
                unitTestXml.setTargetObjectFile(string);
            }
        }
        catch (Exception exception) {
            logger.error("Failed to set a target object file", (Throwable)exception);
        }
    }

    protected UnitTestXml createXml(IProject iProject) {
        return new UnitTestXml(iProject);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isBuildSuccess(IProject iProject) {
        try {
            IMarker[] iMarkerArray;
            IMarker[] iMarkerArray2 = iMarkerArray = iProject.findMarkers("org.eclipse.cdt.core.problem", true, 2);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                IMarker iMarker = iMarkerArray2[n2];
                if (2 == iMarker.getAttribute("severity", 0)) {
                    return false;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            logger.error("Cannot read problem marker of " + iProject, (Throwable)coreException);
            return false;
        }
    }

    protected MultiStatus checkTargetStatus(Boolean bl) throws CoreException {
        MultiStatus multiStatus = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, new String(), null);
        String string = "";
        if (!this.isBuildSuccess(this.targetProject)) {
            string = NLS.bind((String)UnitTestMessages.ERROR_TARGET_BUILD_FAILURE, (Object)this.targetProject.getName());
        } else if (!UnitTestCommon.equalsTargetBuildName(this.testProject, this.targetProject)) {
            string = NLS.bind((String)UnitTestMessages.WIZARD_ERROR_CONF_MISS, (Object)this.targetProject.getName());
        } else if (!UnitTestCommon.equalsArch(this.testProject, this.targetProject)) {
            string = NLS.bind((String)UnitTestMessages.WIZARD_ERROR_ARCH_MISS, (Object)this.targetProject.getName());
        } else if (bl.booleanValue() && !this.setDynamicAnalysisOption(this.testProject, this.targetProject)) {
            string = NLS.bind((String)UnitTestMessages.WIZARD_ERROR_GCOV_OPTION_MISS, (Object)this.targetProject.getName());
        }
        if (!string.isEmpty()) {
            multiStatus = this.buildWarning(this.testProject, string);
        }
        return multiStatus;
    }

    public boolean setDynamicAnalysisOption(IProject iProject, IProject iProject2) {
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject2);
        IConfiguration[] iConfigurationArray = iManagedBuildInfo.getDefaultConfiguration().getManagedProject().getConfigurations();
        IConfiguration iConfiguration = ManagedBuildManager.getBuildInfo((IResource)iProject).getDefaultConfiguration();
        IUnitTestHandler iUnitTestHandler = UnitTestRegistry.getUnitTestHandler((IProject)iProject2);
        IConfiguration[] iConfigurationArray2 = iConfigurationArray;
        int n = iConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration iConfiguration2 = iConfigurationArray2[n2];
            if (iConfiguration2.getName().equals(iConfiguration.getName())) {
                String string = iUnitTestHandler.getDynamicAnalysisOption(iConfiguration2);
                if (!string.equals("-fprofile-arcs -ftest-coverage") && iUnitTestHandler.getDynamicAnalysisOption(iConfiguration).equals("-fprofile-arcs -ftest-coverage")) {
                    iUnitTestHandler.setDynamicAnalysisOption(iConfiguration, "");
                    ManagedBuildManager.saveBuildInfo((IProject)iProject, (boolean)true);
                    CommonProjectDependentBuilder commonProjectDependentBuilder = ProjectTypeManager.getProjectBuilderInstance((IProject)iProject);
                    try {
                        commonProjectDependentBuilder.make_clean();
                    }
                    catch (SBIException sBIException) {
                        logger.error("Failed to make clean", (Throwable)sBIException);
                    }
                }
                return string.equals(iUnitTestHandler.getDynamicAnalysisOption(iConfiguration));
            }
            ++n2;
        }
        return false;
    }

    private MultiStatus buildWarning(IProject iProject, String string) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec((Runnable)new MessageBoxRunnable(display, string));
        try {
            IMarker[] iMarkerArray = iProject.findMarkers("org.eclipse.cdt.core.problem", true, 2);
            int n = iMarkerArray.length;
            while (n > 0) {
                iMarkerArray[n - 1].delete();
                --n;
            }
            IMarker iMarker = iProject.createMarker("org.eclipse.cdt.core.problem");
            iMarker.setAttribute("priority", 1);
            iMarker.setAttribute("severity", 2);
            iMarker.setAttribute("message", (Object)string);
        }
        catch (CoreException coreException) {
            logger.error("cannot create problem marker: " + string, (Throwable)coreException);
        }
        return new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 4, new String(), null);
    }

    class MessageBoxRunnable
    implements Runnable {
        private Display display;
        private String message;

        public MessageBoxRunnable(Display display, String string) {
            this.display = display;
            this.message = string;
        }

        @Override
        public void run() {
            UnitTestNinjaGenerator.this.projectBuild = false;
            Shell[] shellArray = this.display.getShells();
            Shell shell = shellArray[0];
            int n = 0;
            while (n < shellArray.length) {
                if (shellArray[n].getText().equals("Build Project")) {
                    shell = shellArray[n];
                    break;
                }
                ++n;
            }
            MessageBox messageBox = new MessageBox(shell, 65537);
            messageBox.setText("Error");
            messageBox.setMessage(this.message);
            messageBox.open();
            UnitTestNinjaGenerator.this.chUIThread = false;
        }
    }

    class YesNoDialogRunnable
    implements Runnable {
        private Display display;
        private String message;

        public YesNoDialogRunnable(Display display, String string) {
            this.display = display;
            this.message = string;
        }

        @Override
        public void run() {
            UnitTestNinjaGenerator.this.projectBuild = false;
            Shell[] shellArray = this.display.getShells();
            Shell shell = shellArray[0];
            int n = 0;
            while (n < shellArray.length) {
                if (shellArray[n].getText().equals("Build Project")) {
                    shell = shellArray[n];
                    break;
                }
                ++n;
            }
            MessageBox messageBox = new MessageBox(shell, 192);
            messageBox.setText(UnitTestMessages.WIZARD_LABEL_ERROR);
            messageBox.setMessage(this.message);
            int n2 = messageBox.open();
            if (n2 == 64) {
                UnitTestNinjaGenerator.this.deleteFile = true;
            } else if (n2 == 128) {
                UnitTestNinjaGenerator.this.deleteFile = false;
            }
        }
    }
}

