/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.event;

import org.tizen.tizenunittest.gtest.event.SessionEndEvent;
import org.tizen.tizenunittest.gtest.event.SessionStartEvent;
import org.tizen.tizenunittest.gtest.event.SuiteBeginEvent;
import org.tizen.tizenunittest.gtest.event.SuiteEndEvent;
import org.tizen.tizenunittest.gtest.event.TestErrorEvent;
import org.tizen.tizenunittest.gtest.event.TestEvent;
import org.tizen.tizenunittest.gtest.event.TestFailureEvent;
import org.tizen.tizenunittest.gtest.event.TestStartEvent;
import org.tizen.tizenunittest.gtest.event.TestSuccessEvent;

public abstract class TestEventHandler {
    public void handle(TestEvent testEvent) {
        if (testEvent instanceof TestStartEvent) {
            TestStartEvent testStartEvent = (TestStartEvent)testEvent;
            this.handleTestStart(testStartEvent.testName);
        } else if (testEvent instanceof TestSuccessEvent) {
            TestSuccessEvent testSuccessEvent = (TestSuccessEvent)testEvent;
            this.handleSuccess(testSuccessEvent.testName, testSuccessEvent.msg);
        } else if (testEvent instanceof TestFailureEvent) {
            TestFailureEvent testFailureEvent = (TestFailureEvent)testEvent;
            this.handleFailure(testFailureEvent.testName, testFailureEvent.fileName, testFailureEvent.lineNo, testFailureEvent.reason);
        } else if (testEvent instanceof TestErrorEvent) {
            TestErrorEvent testErrorEvent = (TestErrorEvent)testEvent;
            this.handleError(testErrorEvent.testName, testErrorEvent.msg);
        } else if (testEvent instanceof SuiteBeginEvent) {
            SuiteBeginEvent suiteBeginEvent = (SuiteBeginEvent)testEvent;
            this.handleSuiteBeginning(suiteBeginEvent.suiteName, suiteBeginEvent.suiteSize);
        } else if (testEvent instanceof SuiteEndEvent) {
            SuiteEndEvent suiteEndEvent = (SuiteEndEvent)testEvent;
            this.handleSuiteEnding(suiteEndEvent.suitename);
        } else if (testEvent instanceof SessionStartEvent) {
            this.handleSessionStart();
        } else if (testEvent instanceof SessionEndEvent) {
            this.handleSessionEnd();
        }
    }

    protected abstract void handleSuiteBeginning(String var1, int var2);

    protected abstract void handleTestStart(String var1);

    protected abstract void handleError(String var1, String var2);

    protected abstract void handleSuccess(String var1, String var2);

    protected abstract void handleSuiteEnding(String var1);

    protected abstract void handleFailure(String var1, String var2, String var3, String var4);

    public abstract void handleSessionStart();

    public abstract void handleSessionEnd();
}

