/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.ui.console.FileLink;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.TextConsole;
import org.tizen.tizenunittest.gtest.event.ConsoleLinkEvent;
import org.tizen.tizenunittest.gtest.event.TestEvent;
import org.tizen.tizenunittest.gtest.event.TestEventHandler;

public class ConsoleLinkHandler
extends TestEventHandler {
    private TextConsole console;
    private IPath rtPath;

    public ConsoleLinkHandler(IPath iPath, TextConsole textConsole) {
        this.rtPath = iPath;
        this.console = textConsole;
    }

    @Override
    public void handle(TestEvent testEvent) {
        if (testEvent instanceof ConsoleLinkEvent) {
            ConsoleLinkEvent consoleLinkEvent = (ConsoleLinkEvent)testEvent;
            this.handleConsoleLink(consoleLinkEvent.reg, consoleLinkEvent.fileName, consoleLinkEvent.lineNo);
        }
    }

    public void handleConsoleLink(IRegion iRegion, String string, String string2) {
        IPath iPath = this.rtPath.removeLastSegments(1).append(string);
        try {
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(iPath);
            int n = Integer.parseInt(string2);
            FileLink fileLink = new FileLink(iFile, null, -1, -1, n);
            this.console.addHyperlink((IHyperlink)fileLink, iRegion.getOffset(), iRegion.getLength());
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    @Override
    public void handleSuiteBeginning(String string, int n) {
    }

    @Override
    public void handleSuiteEnding(String string) {
    }

    @Override
    public void handleError(String string, String string2) {
    }

    @Override
    public void handleSuccess(String string, String string2) {
    }

    @Override
    public void handleFailure(String string, String string2, String string3, String string4) {
    }

    @Override
    public void handleTestStart(String string) {
    }

    @Override
    public void handleSessionEnd() {
    }

    @Override
    public void handleSessionStart() {
    }
}

