/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.event.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.text.IRegion;
import org.tizen.tizenunittest.gtest.UnitTestPlugin;
import org.tizen.tizenunittest.gtest.event.TestEvent;

public abstract class ConsoleEventParser {
    protected List<TestEvent> testEvents;
    protected static ILaunchConfiguration config;

    public ConsoleEventParser(ILaunchConfiguration iLaunchConfiguration) {
        config = iLaunchConfiguration;
    }

    public abstract String getComprehensiveLinePattern();

    public abstract String getLineQualifier();

    protected abstract void extractTestEventsFor(IRegion var1, String var2) throws CoreException;

    public List<TestEvent> eventsFrom(IRegion iRegion, String string) {
        this.freshTestEventCollection();
        try {
            this.extractTestEventsFor(iRegion, string);
        }
        catch (CoreException coreException) {
            UnitTestPlugin.getDefault().getLog().log(coreException.getStatus());
            this.throwLineParsingException(iRegion, string, (Exception)((Object)coreException));
        }
        catch (Exception exception) {
            this.throwLineParsingException(iRegion, string, exception);
        }
        return this.testEvents;
    }

    protected void freshTestEventCollection() {
        this.testEvents = new ArrayList<TestEvent>();
    }

    protected void addNewEvent(TestEvent testEvent) {
        this.testEvents.add(testEvent);
    }

    protected void throwLineParsingException(IRegion iRegion, String string, Exception exception) {
        throw new RuntimeException("Failure parsing console event {<line=" + string + ">, <Reg=" + iRegion + ">} into TestEvent.  Check log for more information.", exception);
    }

    protected Matcher matcherFor(Pattern pattern, String string) throws CoreException {
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new CoreException((IStatus)new Status(4, "org.tizen.tizenunittest.gtest", 1, "Pattern doesn't match", null));
        }
        return matcher;
    }

    protected static String regExUnion(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append("|");
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    protected static String escapeForRegex(String string) {
        return string.replace("]", "\\]").replace("[", "\\[");
    }
}

