/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.model;

import java.util.Vector;
import org.eclipse.debug.core.ILaunch;
import org.tizen.tizenunittest.gtest.model.ITestComposite;
import org.tizen.tizenunittest.gtest.model.TestCase;
import org.tizen.tizenunittest.gtest.model.TestElement;
import org.tizen.tizenunittest.gtest.model.TestStatus;
import org.tizen.tizenunittest.gtest.model.listener.ITestCompositeListener;

public class TestSession
implements ITestComposite {
    private Vector<TestElement> rootElements = new Vector();
    private Vector<ITestCompositeListener> listeners = new Vector();
    private ILaunch launch;

    public TestSession(ILaunch iLaunch) {
        this.launch = iLaunch;
    }

    public Vector<TestElement> getRootElements() {
        return this.rootElements;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    @Override
    public void addTestElement(TestElement testElement) {
        this.rootElements.add(testElement);
        testElement.setParent(this);
        for (ITestCompositeListener iTestCompositeListener : this.listeners) {
            iTestCompositeListener.newTestElement(this, testElement);
        }
    }

    public Vector<TestElement> getElements() {
        return this.rootElements;
    }

    @Override
    public int getAbnormalDefects() {
        int n = 0;
        for (TestElement testElement : this.rootElements) {
            Object object;
            if (testElement instanceof ITestComposite) {
                object = (ITestComposite)((Object)testElement);
                n += object.getAbnormalDefects();
                continue;
            }
            if (!(testElement instanceof TestCase) || ((TestCase)(object = (TestCase)testElement)).getStatus() != TestStatus.abnormal) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int getFailure() {
        int n = 0;
        for (TestElement testElement : this.rootElements) {
            Object object;
            if (testElement instanceof ITestComposite) {
                object = (ITestComposite)((Object)testElement);
                n += object.getFailure();
                continue;
            }
            if (!(testElement instanceof TestCase) || ((TestCase)(object = (TestCase)testElement)).getStatus() != TestStatus.failure) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int getRun() {
        int n = 0;
        for (TestElement testElement : this.rootElements) {
            Object object;
            if (testElement instanceof ITestComposite) {
                object = (ITestComposite)((Object)testElement);
                n += object.getRun();
                continue;
            }
            if (!(testElement instanceof TestCase) || ((TestCase)(object = (TestCase)testElement)).getStatus() != TestStatus.error && ((TestCase)object).getStatus() != TestStatus.failure && ((TestCase)object).getStatus() != TestStatus.success) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int getSuccess() {
        int n = 0;
        for (TestElement testElement : this.rootElements) {
            Object object;
            if (testElement instanceof ITestComposite) {
                object = (ITestComposite)((Object)testElement);
                n += object.getSuccess();
                continue;
            }
            if (!(testElement instanceof TestCase) || ((TestCase)(object = (TestCase)testElement)).getStatus() != TestStatus.success) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int getTotalTests() {
        int n = 0;
        for (TestElement testElement : this.rootElements) {
            if (testElement instanceof ITestComposite) {
                ITestComposite iTestComposite = (ITestComposite)((Object)testElement);
                n += iTestComposite.getTotalTests();
                continue;
            }
            if (!(testElement instanceof TestCase)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public boolean hasManagedErrorOrFailure() {
        return this.getFailure() + this.getAbnormalDefects() > 0;
    }

    @Override
    public void addListener(ITestCompositeListener iTestCompositeListener) {
        if (!this.listeners.contains(iTestCompositeListener)) {
            this.listeners.add(iTestCompositeListener);
        }
    }

    @Override
    public void removeListener(ITestCompositeListener iTestCompositeListener) {
        this.listeners.remove(iTestCompositeListener);
    }
}

