/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.resultview;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.tizen.tizenunittest.gtest.UnitTestPlugin;
import org.tizen.tizenunittest.gtest.model.TestCase;
import org.tizen.tizenunittest.gtest.model.TestElement;
import org.tizen.tizenunittest.gtest.model.TestSuite;

public class CuteTestLabelProvider
extends LabelProvider {
    private Image testRun = UnitTestPlugin.getImageDescriptor("obj16/not_run.png").createImage();
    private Image testOk = UnitTestPlugin.getImageDescriptor("obj16/result_success.png").createImage();
    private Image testFail = UnitTestPlugin.getImageDescriptor("obj16/failed.png").createImage();
    private Image testManaged = UnitTestPlugin.getImageDescriptor("obj16/result_abnormal.png").createImage();
    private Image testTimeOut = UnitTestPlugin.getImageDescriptor("obj16/timeout.png").createImage();
    private Image testAbnormalTermitaion = UnitTestPlugin.getImageDescriptor("obj16/result_abnormal_term.png").createImage();
    private Image testError = UnitTestPlugin.getImageDescriptor("obj16/result_error.png").createImage();

    public Image getImage(Object object) {
        switch (((TestElement)object).getStatus()) {
            case running: {
                return this.testRun;
            }
            case success: {
                return this.testOk;
            }
            case failure: {
                return this.testFail;
            }
            case abnormal: {
                if (object instanceof TestSuite) {
                    return this.testManaged;
                }
                TestCase testCase = (TestCase)object;
                String string = testCase.getResult().getMsg().trim();
                if (string.equals("Test time out")) {
                    return this.testTimeOut;
                }
                return this.testAbnormalTermitaion;
            }
            case error: {
                return this.testError;
            }
        }
        throw new IllegalArgumentException(String.valueOf(object));
    }

    public String getText(Object object) {
        return object.toString();
    }

    public void dispose() {
    }
}

