/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.gtest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.text.IRegion;
import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.sdblib.IDevice;
import org.tizen.tizenunittest.gtest.event.AbnormalDefectEvent;
import org.tizen.tizenunittest.gtest.event.ConsoleLinkEvent;
import org.tizen.tizenunittest.gtest.event.NonEvent;
import org.tizen.tizenunittest.gtest.event.SessionStartEvent;
import org.tizen.tizenunittest.gtest.event.SuiteBeginEvent;
import org.tizen.tizenunittest.gtest.event.SuiteEndEvent;
import org.tizen.tizenunittest.gtest.event.TestErrorEvent;
import org.tizen.tizenunittest.gtest.event.TestFailureEvent;
import org.tizen.tizenunittest.gtest.event.TestStartEvent;
import org.tizen.tizenunittest.gtest.event.TestSuccessEvent;
import org.tizen.tizenunittest.gtest.event.parser.ConsoleEventParser;
import org.tizen.tizenunittest.gtest.gtest.testexplorer.TXView;
import org.tizen.tizenunittest.gtest.testexplorer.model.TXTestCase;
import org.tizen.tizenunittest.gtest.testexplorer.model.TXTestRoot;
import org.tizen.tizenunittest.gtest.testexplorer.model.TXTestSuite;

public class GTestConsoleEventParser
extends ConsoleEventParser {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String LINE_QUALIFIER = "";
    private static final int LINEPREFIXLENGTH = "".length();
    private static final String ERROR_backwardCompatible = "exception of unknown type";
    private static final String SESSIONSTART = "[==========] Running";
    private static final String SESSIONEND = "_uNitTeSt_fIniShed_";
    private static final int TEST_SUCCESSED = 1;
    private static final int TEST_FAILED = 2;
    private static final int TEST_ERROR = 3;
    private static final int CONSOLE_LINK = 4;
    private static final int ABNORMAL_DEFECT = 5;
    private static final String ABNORMAL_TERMITATION = "Abnormal termination";
    private static final String TEST_TIME_OUT = "Test time out";
    private boolean needDownloadXML;
    private String targetXMLPath;
    private String destXMLPath;
    private String currentSuiteName;
    private String currentTestName;
    private RunningTestOutput runningTestOutput = new RunningTestOutput();
    private SuiteBeginEvent pendingSuiteBeginEvent;
    private IDevice runDevice;
    private static IProject project;
    HashMap<String, IRegion> regMap = new HashMap();
    Vector<String> suiteOrder = new Vector();
    private static GTestConsoleEventParser uniqueInstance;

    static {
        uniqueInstance = null;
    }

    public void setDevice(IDevice iDevice) {
        this.runDevice = iDevice;
    }

    public static GTestConsoleEventParser getInstance(IProject iProject, ILaunchConfiguration iLaunchConfiguration) {
        if (uniqueInstance == null) {
            uniqueInstance = new GTestConsoleEventParser(iProject, iLaunchConfiguration);
        } else {
            config = iLaunchConfiguration;
            if (iProject != null) {
                project = iProject;
            }
        }
        return uniqueInstance;
    }

    private GTestConsoleEventParser(IProject iProject, ILaunchConfiguration iLaunchConfiguration) {
        super(iLaunchConfiguration);
        project = iProject;
        this.needDownloadXML = false;
    }

    @Override
    public String getLineQualifier() {
        return GTestConsoleEventParser.escapeForRegex(LINE_QUALIFIER);
    }

    @Override
    public final String getComprehensiveLinePattern() {
        return "(.*)(.*)(\\n)";
    }

    @Override
    protected void extractTestEventsFor(IRegion iRegion, String string) throws CoreException {
        if (this.sessionStarting(string)) {
            this.sessionStarted();
        } else if (this.isTestFailed(string)) {
            this.saveRegOfFailedConsoleOutput(iRegion, string);
        } else if (this.sessionEnding(string)) {
            this.sessionEnded(iRegion);
        } else if (this.suiteStarting(string)) {
            this.saveSuiteOrder(string);
        }
    }

    private boolean collectingSuiteName() {
        return this.pendingSuiteBeginEvent != null;
    }

    private void testStarted(String string) throws CoreException {
        this.postSuiteBeginEventIfNecesary();
        this.currentTestName = string;
        TestStartEvent testStartEvent = new TestStartEvent(this.currentTestName);
        this.testEvents.add(testStartEvent);
    }

    private void postSuiteBeginEventIfNecesary() {
        if (!this.collectingSuiteName()) {
            return;
        }
        this.testEvents.add(this.pendingSuiteBeginEvent);
        this.pendingSuiteBeginEvent = null;
    }

    private void testMayHaveEnded(int n, String string, String string2, String string3) throws CoreException {
        if (n == 1) {
            this.testEvents.add(new TestSuccessEvent(this.currentSuiteName, this.currentTestName, "OK"));
        } else if (n == 2) {
            this.testFailure(string, string2, string3);
        } else if (n == 3) {
            this.testError();
        } else if (n == 4) {
            String[] stringArray = string.split("/");
            String string4 = stringArray[stringArray.length - 1];
            IRegion iRegion = this.regMap.get(String.valueOf(string4) + ":" + string2);
            this.addNewEvent(new ConsoleLinkEvent(iRegion, string, string2));
        } else if (n == 5) {
            this.testAbnormalDefect(string3);
        } else {
            this.testEvents.add(new NonEvent());
            return;
        }
        this.runningTestOutput = new RunningTestOutput();
    }

    private void testError() {
        Pattern pattern = Pattern.compile("Exception thrown (.*).");
        Matcher matcher = pattern.matcher(this.runningTestOutput.lineAt(1));
        String string = ERROR_backwardCompatible;
        if (matcher.matches()) {
            string = matcher.group(1);
        }
        this.testEvents.add(new TestErrorEvent(this.currentSuiteName, this.currentTestName, string));
    }

    private void testFailure(String string, String string2, String string3) {
        if (string == null || string2 == null) {
            TXTestRoot tXTestRoot = TXView.getTXViewPart().getTXTestRoot();
            TXTestSuite tXTestSuite = (TXTestSuite)tXTestRoot.getChildNode(tXTestRoot.getChildNodeIndex(this.currentSuiteName));
            TXTestCase tXTestCase = (TXTestCase)tXTestSuite.getChildNode(tXTestSuite.getChildNodeIndex(this.currentTestName));
            if (string == null) {
                string = tXTestCase.getFile().getLocation().toString().substring(project.getLocation().toString().length());
            }
            if (string2 == null) {
                string2 = new Integer(tXTestCase.getLineNumber()).toString();
            }
        }
        this.addNewEvent(new TestFailureEvent(this.currentSuiteName, this.currentTestName, string, string2, string3));
    }

    private void testAbnormalDefect(String string) {
        TXTestRoot tXTestRoot = TXView.getTXViewPart().getTXTestRoot();
        TXTestSuite tXTestSuite = (TXTestSuite)tXTestRoot.getChildNode(tXTestRoot.getChildNodeIndex(this.currentSuiteName));
        TXTestCase tXTestCase = (TXTestCase)tXTestSuite.getChildNode(tXTestSuite.getChildNodeIndex(this.currentTestName));
        String string2 = tXTestCase.getFile().getLocation().toString().split(project.getLocation().toString())[1];
        String string3 = new Integer(tXTestCase.getLineNumber()).toString();
        this.addNewEvent(new AbnormalDefectEvent(this.currentSuiteName, this.currentTestName, string2, string3, string));
    }

    private void suiteEnded() {
        this.postSuiteBeginEventIfNecesary();
        this.testEvents.add(new SuiteEndEvent(this.currentSuiteName));
        this.currentSuiteName = null;
    }

    private boolean suiteStarting(String string) {
        return string.startsWith("[----------] ");
    }

    private void saveSuiteOrder(String string) {
        String[] stringArray = string.split("[0-9]+ test[s]? from ");
        if (stringArray.length < 2) {
            return;
        }
        String string2 = stringArray[1];
        string2 = string2.split(",")[0];
        if (!this.suiteOrder.contains(string2 = string2.split(" \\(.*\\)")[0])) {
            this.suiteOrder.add(string2);
        }
    }

    private void suiteStarted(String string, int n) throws CoreException {
        if (this.currentSuiteName != null) {
            this.suiteEnded();
        }
        this.currentSuiteName = string;
        this.pendingSuiteBeginEvent = new SuiteBeginEvent(this.currentSuiteName, n);
    }

    private boolean isTestFailed(String string) {
        return string.matches(".*\\.cpp:[0-9]+: Failure");
    }

    private void saveRegOfFailedConsoleOutput(IRegion iRegion, String string) {
        String[] stringArray = string.split("/");
        String string2 = null;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].matches(".*\\.cpp:[0-9]+: Failure")) {
                string2 = stringArray[n];
                break;
            }
            ++n;
        }
        if (string2 != null) {
            string2 = string2.split(": Failure")[0];
            this.regMap.put(string2, iRegion);
        }
    }

    private boolean sessionStarting(String string) {
        return string.startsWith(SESSIONSTART, LINEPREFIXLENGTH);
    }

    private void sessionStarted() {
        this.testEvents.add(new SessionStartEvent(config));
        this.regMap.clear();
        this.suiteOrder.clear();
    }

    private boolean sessionEnding(String string) {
        return string.endsWith(SESSIONEND);
    }

    /*
     * Exception decompiling
     */
    private void sessionEnded(IRegion var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int runCount(Element element) {
        List list = element.getChildren();
        int n = 0;
        int n2 = 0;
        while (n2 < list.size()) {
            Element element2 = (Element)list.get(n2);
            if (element2.getAttributeValue("status").equals("run")) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private Element[] getTestedSuites(List<Element> list) {
        return list.toArray(new Element[list.size()]);
    }

    public void setXMLPath(String string, String string2) {
        this.targetXMLPath = string;
        this.destXMLPath = string2;
        this.needDownloadXML = true;
    }

    private class RunningTestOutput {
        private ArrayList<String> lines = new ArrayList();

        private RunningTestOutput() {
        }

        public String lineAt(int n) {
            return this.lines.get(n);
        }
    }
}

