/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.ui.IWorkbenchPart;
import org.tizen.tizenunittest.gtest.UnitTestPlugin;
import org.tizen.tizenunittest.gtest.event.AbnormalDefectEvent;
import org.tizen.tizenunittest.gtest.event.SessionEndEvent;
import org.tizen.tizenunittest.gtest.event.SessionStartEvent;
import org.tizen.tizenunittest.gtest.event.SuiteBeginEvent;
import org.tizen.tizenunittest.gtest.event.SuiteEndEvent;
import org.tizen.tizenunittest.gtest.event.TestErrorEvent;
import org.tizen.tizenunittest.gtest.event.TestEvent;
import org.tizen.tizenunittest.gtest.event.TestEventHandler;
import org.tizen.tizenunittest.gtest.event.TestFailureEvent;
import org.tizen.tizenunittest.gtest.event.TestStartEvent;
import org.tizen.tizenunittest.gtest.event.TestSuccessEvent;
import org.tizen.tizenunittest.gtest.gtest.testexplorer.TXView;
import org.tizen.tizenunittest.gtest.model.CuteModel;
import org.tizen.tizenunittest.gtest.model.TestCase;
import org.tizen.tizenunittest.gtest.model.TestStatus;
import org.tizen.tizenunittest.gtest.model.TestSuite;
import org.tizen.tizenunittest.gtest.resultview.TestResultView;

public class ModelBuilder
extends TestEventHandler {
    private CuteModel model = UnitTestPlugin.getModel();
    private IPath rtPath;
    private TestCase currentTestCase;
    private ILaunch launch;

    public ModelBuilder(IPath iPath, ILaunch iLaunch) {
        this.rtPath = iPath;
        this.launch = iLaunch;
    }

    public ModelBuilder(IPath iPath) {
        this(iPath, null);
    }

    @Override
    public void handle(TestEvent testEvent) {
        if (testEvent instanceof TestStartEvent) {
            TestStartEvent testStartEvent = (TestStartEvent)testEvent;
            this.handleTestStart(testStartEvent.testName);
        } else if (testEvent instanceof TestSuccessEvent) {
            TestSuccessEvent testSuccessEvent = (TestSuccessEvent)testEvent;
            this.handleSuccess(testSuccessEvent.testName, testSuccessEvent.msg);
        } else if (testEvent instanceof TestFailureEvent) {
            TestFailureEvent testFailureEvent = (TestFailureEvent)testEvent;
            this.handleFailure(testFailureEvent.testName, testFailureEvent.fileName, testFailureEvent.lineNo, testFailureEvent.reason);
        } else if (testEvent instanceof AbnormalDefectEvent) {
            AbnormalDefectEvent abnormalDefectEvent = (AbnormalDefectEvent)testEvent;
            this.handleAbnormalDefect(abnormalDefectEvent.testName, abnormalDefectEvent.fileName, abnormalDefectEvent.lineNo, abnormalDefectEvent.reason);
        } else if (testEvent instanceof TestErrorEvent) {
            TestErrorEvent testErrorEvent = (TestErrorEvent)testEvent;
            this.handleError(testErrorEvent.testName, testErrorEvent.msg);
        } else if (testEvent instanceof SuiteBeginEvent) {
            SuiteBeginEvent suiteBeginEvent = (SuiteBeginEvent)testEvent;
            this.handleSuiteBeginning(suiteBeginEvent.suiteName, suiteBeginEvent.suiteSize);
        } else if (testEvent instanceof SuiteEndEvent) {
            SuiteEndEvent suiteEndEvent = (SuiteEndEvent)testEvent;
            this.handleSuiteEnding(suiteEndEvent.suitename);
        } else if (testEvent instanceof SessionStartEvent) {
            this.handleSessionStart();
        } else if (testEvent instanceof SessionEndEvent) {
            this.handleSessionEnd();
        }
    }

    @Override
    public void handleError(String string, String string2) {
        this.model.endCurrentTestCase(null, -1, string2, TestStatus.error, this.currentTestCase);
    }

    @Override
    public void handleSuccess(String string, String string2) {
        this.model.endCurrentTestCase(null, -1, string2, TestStatus.success, this.currentTestCase);
    }

    @Override
    public void handleSuiteEnding(String string) {
        this.model.endSuite();
    }

    @Override
    public void handleSuiteBeginning(String string, int n) {
        this.model.startSuite(new TestSuite(string, n, TestStatus.running));
    }

    @Override
    public void handleFailure(String string, String string2, String string3, String string4) {
        IPath iPath = this.rtPath.removeLastSegments(1).append(string2);
        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(iPath);
        int n = Integer.parseInt(string3);
        this.model.endCurrentTestCase(iFile, n, string4, TestStatus.failure, this.currentTestCase);
    }

    public void handleAbnormalDefect(String string, String string2, String string3, String string4) {
        IPath iPath = this.rtPath.removeLastSegments(1).append(string2);
        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(iPath);
        int n = Integer.parseInt(string3);
        this.model.endCurrentTestCase(iFile, n, string4, TestStatus.abnormal, this.currentTestCase);
    }

    @Override
    public void handleTestStart(String string) {
        this.currentTestCase = new TestCase(string);
        this.model.addTest(this.currentTestCase);
    }

    @Override
    public void handleSessionEnd() {
        this.model.endSession();
        UnitTestPlugin.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TXView tXView = TXView.getTXViewPart();
                TestResultView testResultView = TestResultView.getTestResultViewPart();
                tXView.getSite().getPage().bringToTop((IWorkbenchPart)tXView);
                testResultView.getSite().getPage().bringToTop((IWorkbenchPart)testResultView);
            }
        });
    }

    @Override
    public void handleSessionStart() {
        this.model.startSession(this.launch);
    }
}

