/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.resultview;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.tizen.tizenunittest.gtest.common.UnitTestMessages;
import org.tizen.tizenunittest.gtest.model.TestCase;
import org.tizen.tizenunittest.gtest.model.TestFailure;
import org.tizen.tizenunittest.gtest.model.TestResult;
import org.tizen.tizenunittest.gtest.resultview.CuteTextMergeViewer;

public class CuteCompareResultDialog
extends TrayDialog {
    private final String LABEL_EXPECTED = UnitTestMessages.RESULTVIEW_LABEL_EXPECTED;
    private final String LABEL_ACTUAL = UnitTestMessages.RESULTVIEW_LABEL_ACTUAL;
    private final String RESULTCOMPARISONSHELLTEXT = UnitTestMessages.RESULTVIEW_SHELL_TEXT;
    private CuteTextMergeViewer compareViewer;
    private TestCase test;

    public CuteCompareResultDialog(Shell shell, TestCase testCase) {
        super(shell);
        this.test = testCase;
        this.setHelpAvailable(false);
        this.setShellStyle(3184);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        ViewForm viewForm = new ViewForm(composite2, 0x800800);
        Control control = this.createCompareViewer(viewForm);
        GridData gridData = new GridData(1808);
        gridData.widthHint = this.convertWidthInCharsToPixels(120);
        gridData.heightHint = this.convertHeightInCharsToPixels(13);
        viewForm.setLayoutData((Object)gridData);
        ToolBar toolBar = new ToolBar((Composite)viewForm, 0x800800);
        ToolBarManager toolBarManager = new ToolBarManager(toolBar);
        toolBarManager.update(true);
        viewForm.setTopRight((Control)toolBar);
        viewForm.setContent(control);
        GridData gridData2 = new GridData(1808);
        control.setLayoutData((Object)gridData2);
        return composite2;
    }

    private Control createCompareViewer(ViewForm viewForm) {
        final CompareConfiguration compareConfiguration = new CompareConfiguration();
        compareConfiguration.setLeftLabel(this.LABEL_EXPECTED);
        compareConfiguration.setLeftEditable(false);
        compareConfiguration.setRightLabel(this.LABEL_ACTUAL);
        compareConfiguration.setRightEditable(false);
        compareConfiguration.setProperty("IGNORE_WHITESPACE", (Object)Boolean.FALSE);
        this.compareViewer = new CuteTextMergeViewer((Composite)viewForm, 0, compareConfiguration);
        this.setCompareViewerInput(this.test);
        Control control = this.compareViewer.getControl();
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                compareConfiguration.dispose();
            }
        });
        return control;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, "OK", true);
    }

    public void setCompareViewerInput(TestCase testCase) {
        TestResult testResult;
        this.test = testCase;
        if (!this.compareViewer.getControl().isDisposed() && (testResult = testCase.getResult()) instanceof TestFailure) {
            TestFailure testFailure = (TestFailure)testResult;
            CompareElement compareElement = new CompareElement(testFailure.getExpected());
            CompareElement compareElement2 = new CompareElement(testFailure.getActual());
            this.compareViewer.setInput(new DiffNode((ITypedElement)compareElement, (ITypedElement)compareElement2));
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.RESULTCOMPARISONSHELLTEXT);
    }

    public void refresh() {
        this.compareViewer.refresh();
    }

    private static class CompareElement
    implements ITypedElement,
    IEncodedStreamContentAccessor {
        private String fContent;

        public CompareElement(String string) {
            this.fContent = string == null ? "no Data" : string;
        }

        public String getName() {
            return "<no name>";
        }

        public Image getImage() {
            return null;
        }

        public String getType() {
            return "txt";
        }

        public InputStream getContents() {
            try {
                return new ByteArrayInputStream(this.fContent.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new ByteArrayInputStream(this.fContent.getBytes());
            }
        }

        public String getCharset() throws CoreException {
            return "UTF-8";
        }
    }
}

