/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.resultview;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;
import org.tizen.tizenunittest.gtest.UnitTestPlugin;
import org.tizen.tizenunittest.gtest.model.ITestComposite;
import org.tizen.tizenunittest.gtest.model.NotifyEvent;
import org.tizen.tizenunittest.gtest.model.TestElement;
import org.tizen.tizenunittest.gtest.model.TestSession;
import org.tizen.tizenunittest.gtest.model.listener.ISessionListener;
import org.tizen.tizenunittest.gtest.model.listener.ITestCompositeListener;
import org.tizen.tizenunittest.gtest.model.listener.ITestElementListener;

public class CuteProgressBar
extends Canvas
implements ITestElementListener,
ISessionListener,
ITestCompositeListener {
    private final String UPDATEPROGRESSBAR_JOBNAME = "Update Progressbar";
    private final String RESETPROGRESSBAR_JOBNAME = "Reset Progressbar";
    private static final int DEFAULT_WIDTH = 160;
    private static final int DEFAULT_HEIGHT = 18;
    private int fCurrentTickCount = 0;
    private int fMaxTickCount = 0;
    private int fColorBarWidth = 0;
    private Color fOKColor;
    private Color fFailureColor;
    private Color fStoppedColor;
    private boolean fError;
    private boolean fStopped = false;
    private TestSession session;

    public CuteProgressBar(Composite composite) {
        super(composite, 0);
        UnitTestPlugin.getModel().addListener(this);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                CuteProgressBar.this.fColorBarWidth = CuteProgressBar.this.scale(CuteProgressBar.this.fCurrentTickCount);
                CuteProgressBar.this.redraw();
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                CuteProgressBar.this.paint(paintEvent);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                CuteProgressBar.this.fFailureColor.dispose();
                CuteProgressBar.this.fOKColor.dispose();
                CuteProgressBar.this.fStoppedColor.dispose();
                UnitTestPlugin.getModel().removeListener(CuteProgressBar.this);
            }
        });
        Display display = composite.getDisplay();
        this.fFailureColor = new Color((Device)display, 159, 63, 63);
        this.fOKColor = new Color((Device)display, 95, 191, 95);
        this.fStoppedColor = new Color((Device)display, 120, 120, 120);
    }

    public void setMaximum(int n) {
        this.fMaxTickCount = n;
    }

    private void reset() {
        this.fError = false;
        this.fStopped = false;
        this.fCurrentTickCount = this.session.getRun();
        this.fMaxTickCount = this.session.getTotalTests();
        this.fColorBarWidth = 0;
        this.redraw();
    }

    private void paintStep(int n, int n2) {
        GC gC = new GC((Drawable)this);
        this.setStatusColor(gC);
        Rectangle rectangle = this.getClientArea();
        n = Math.max(1, n);
        gC.fillRectangle(n, 1, n2 - n, rectangle.height - 2);
        gC.dispose();
    }

    private void setStatusColor(GC gC) {
        if (this.fStopped) {
            gC.setBackground(this.fStoppedColor);
        } else if (this.fError) {
            gC.setBackground(this.fFailureColor);
        } else {
            gC.setBackground(this.fOKColor);
        }
    }

    public void stopped() {
        this.fStopped = true;
        this.redraw();
    }

    private int scale(int n) {
        if (this.fMaxTickCount > 0) {
            Rectangle rectangle = this.getClientArea();
            if (rectangle.width != 0) {
                return Math.max(0, n * (rectangle.width - 2) / this.fMaxTickCount);
            }
        }
        return n;
    }

    private void drawBevelRect(GC gC, int n, int n2, int n3, int n4, Color color, Color color2) {
        gC.setForeground(color);
        gC.drawLine(n, n2, n + n3 - 1, n2);
        gC.drawLine(n, n2, n, n2 + n4 - 1);
        gC.setForeground(color2);
        gC.drawLine(n + n3, n2, n + n3, n2 + n4);
        gC.drawLine(n, n2 + n4, n + n3, n2 + n4);
    }

    private void paint(PaintEvent paintEvent) {
        GC gC = paintEvent.gc;
        Display display = this.getDisplay();
        Rectangle rectangle = this.getClientArea();
        gC.fillRectangle(rectangle);
        this.drawBevelRect(gC, rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, display.getSystemColor(18), display.getSystemColor(20));
        this.setStatusColor(gC);
        this.fColorBarWidth = Math.min(rectangle.width - 2, this.fColorBarWidth);
        gC.fillRectangle(1, 1, this.fColorBarWidth, rectangle.height - 2);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        Point point = new Point(160, 18);
        if (n != -1) {
            point.x = n;
        }
        if (n2 != -1) {
            point.y = n2;
        }
        return point;
    }

    private void update(int n, int n2) {
        this.fCurrentTickCount = n;
        int n3 = this.fColorBarWidth;
        this.fColorBarWidth = this.scale(this.fCurrentTickCount);
        if (!this.fError && n2 > 0) {
            this.fError = true;
            n3 = 1;
        }
        if (this.fCurrentTickCount == this.fMaxTickCount) {
            this.fColorBarWidth = this.getClientArea().width - 1;
        }
        this.paintStep(n3, this.fColorBarWidth);
    }

    private void update(int n, int n2, int n3) {
        this.fCurrentTickCount = n;
        this.fMaxTickCount = n3;
        this.fColorBarWidth = this.scale(this.fCurrentTickCount);
        if (!this.fError && n2 > 0) {
            this.fError = true;
        }
        if (this.fCurrentTickCount == this.fMaxTickCount) {
            this.fColorBarWidth = this.getClientArea().width - 1;
        }
        this.redraw();
    }

    public void refresh(boolean bl) {
        this.fError = bl;
        this.redraw();
    }

    @Override
    public void modelChanged(TestElement testElement, NotifyEvent notifyEvent) {
        if (notifyEvent.getType() == NotifyEvent.EventType.testFinished || notifyEvent.getType() == NotifyEvent.EventType.suiteFinished) {
            UIJob uIJob = new UIJob("Update Progressbar"){

                public boolean belongsTo(Object object) {
                    return "org.tizen.tizenunittest.gtest".equals(object);
                }

                public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                    CuteProgressBar.this.update(CuteProgressBar.this.session.getRun(), CuteProgressBar.this.session.getAbnormalDefects() + CuteProgressBar.this.session.getFailure());
                    return new Status(0, "org.tizen.tizenunittest.gtest", 0, "", null);
                }
            };
            uIJob.schedule();
        }
    }

    @Override
    public void sessionStarted(TestSession testSession) {
        this.session = testSession;
        testSession.addListener(this);
        UIJob uIJob = new UIJob("Reset Progressbar"){

            public boolean belongsTo(Object object) {
                return "org.tizen.tizenunittest.gtest".equals(object);
            }

            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                CuteProgressBar.this.reset();
                return new Status(0, "org.tizen.tizenunittest.gtest", 0, "", null);
            }
        };
        uIJob.schedule();
    }

    @Override
    public void sessionFinished(TestSession testSession) {
    }

    @Override
    public void newTestElement(ITestComposite iTestComposite, TestElement testElement) {
        testElement.addTestElementListener(this);
        UIJob uIJob = new UIJob("Update Progressbar"){

            public boolean belongsTo(Object object) {
                return "org.tizen.tizenunittest.gtest".equals(object);
            }

            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                CuteProgressBar.this.update(CuteProgressBar.this.session.getRun(), CuteProgressBar.this.session.getAbnormalDefects() + CuteProgressBar.this.session.getFailure(), CuteProgressBar.this.session.getTotalTests());
                return new Status(0, "org.tizen.tizenunittest.gtest", 0, "", null);
            }
        };
        uIJob.schedule();
    }
}

