/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest;

import java.util.List;
import java.util.Vector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;
import org.tizen.tizenunittest.gtest.event.TestEvent;
import org.tizen.tizenunittest.gtest.event.TestEventHandler;
import org.tizen.tizenunittest.gtest.event.parser.ConsoleEventParser;

public class ConsolePatternListener
implements IPatternMatchListener {
    private TextConsole console;
    private ConsoleEventParser eventParser;
    private Vector<TestEventHandler> handlers;

    public ConsolePatternListener(ConsoleEventParser consoleEventParser) {
        this.eventParser = consoleEventParser;
        this.handlers = new Vector();
    }

    public int getCompilerFlags() {
        return 1;
    }

    public String getLineQualifier() {
        return this.eventParser.getLineQualifier();
    }

    public String getPattern() {
        return this.eventParser.getComprehensiveLinePattern();
    }

    public void connect(TextConsole textConsole) {
        this.console = textConsole;
        for (TestEventHandler testEventHandler : this.handlers) {
            testEventHandler.handleSessionStart();
        }
    }

    public void disconnect() {
        for (TestEventHandler testEventHandler : this.handlers) {
            testEventHandler.handleSessionEnd();
        }
        this.console = null;
    }

    public void addHandler(TestEventHandler testEventHandler) {
        this.handlers.add(testEventHandler);
    }

    public void removeHandler(TestEventHandler testEventHandler) {
        this.handlers.remove(testEventHandler);
    }

    public void matchFound(PatternMatchEvent patternMatchEvent) {
        try {
            IDocument iDocument = this.console.getDocument();
            IRegion iRegion = iDocument.getLineInformation(iDocument.getLineOfOffset(patternMatchEvent.getOffset()));
            String string = iDocument.get(iRegion.getOffset(), iRegion.getLength());
            this.processTestEventsFrom(iRegion, string);
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException(badLocationException);
        }
    }

    private void processTestEventsFrom(IRegion iRegion, String string) {
        List<TestEvent> list = this.eventParser.eventsFrom(iRegion, string);
        for (TestEvent testEvent : list) {
            this.process(testEvent);
        }
    }

    private void process(TestEvent testEvent) {
        for (TestEventHandler testEventHandler : this.handlers) {
            testEventHandler.handle(testEvent);
        }
    }
}

