/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.event.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.text.IRegion;
import org.tizen.tizenunittest.gtest.event.SuiteBeginEvent;
import org.tizen.tizenunittest.gtest.event.SuiteEndEvent;
import org.tizen.tizenunittest.gtest.event.TestStartEvent;
import org.tizen.tizenunittest.gtest.event.parser.ConsoleEventParser;

public class CuteConsoleEventParser
extends ConsoleEventParser {
    private static final String LINE_QUALIFIER = "#";
    private static final int LINEPREFIXLENGTH = "#".length();
    private static final String BEGINNING = "beginning";
    private static final String ENDING = "ending";
    private static final String STARTTEST = "starting";
    private static final String SUCCESS = "success";
    private static final String FAILURE = "failure";
    private static final String ERROR = "error";
    private static Pattern SUITEBEGINNINGLINE = Pattern.compile("#beginning (.*) (\\d+)$");
    private static Pattern SUITEENDINGLINE = Pattern.compile("#ending (.*)$");
    private static Pattern TESTSTARTLINE = Pattern.compile("#starting (.*)$");

    public CuteConsoleEventParser(ILaunchConfiguration iLaunchConfiguration) {
        super(iLaunchConfiguration);
    }

    @Override
    public String getLineQualifier() {
        return CuteConsoleEventParser.escapeForRegex(LINE_QUALIFIER);
    }

    @Override
    public final String getComprehensiveLinePattern() {
        return String.valueOf(CuteConsoleEventParser.escapeForRegex("#(" + CuteConsoleEventParser.regExUnion(new String[]{LINE_QUALIFIER, BEGINNING, ENDING, SUCCESS, STARTTEST, FAILURE, ERROR}))) + ")(.*)(\\n)";
    }

    @Override
    protected void extractTestEventsFor(IRegion iRegion, String string) throws CoreException {
        if (this.testStarting(string)) {
            this.testStart(iRegion, string);
        } else if (this.testSucceeded(string)) {
            this.testSuccess(iRegion, string);
        } else if (this.testFailed(string)) {
            this.testFailure(iRegion, string);
        } else if (this.suiteStarting(string)) {
            this.suiteStarted(iRegion, string);
        } else if (this.suiteEnding(string)) {
            this.suiteEnded(iRegion, string);
        } else if (this.testErrored(string)) {
            this.testError(iRegion, string);
        }
    }

    private boolean testStarting(String string) {
        return string.startsWith(STARTTEST, LINEPREFIXLENGTH);
    }

    private void testStart(IRegion iRegion, String string) throws CoreException {
        Matcher matcher = this.matcherFor(TESTSTARTLINE, string);
        this.testEvents.add(new TestStartEvent(matcher.group(1)));
    }

    private boolean testSucceeded(String string) {
        return string.startsWith(SUCCESS, LINEPREFIXLENGTH);
    }

    private void testSuccess(IRegion iRegion, String string) throws CoreException {
    }

    private boolean testFailed(String string) {
        return string.startsWith(FAILURE, LINEPREFIXLENGTH);
    }

    private void testFailure(IRegion iRegion, String string) throws CoreException {
    }

    private boolean suiteStarting(String string) {
        return string.startsWith(BEGINNING, LINEPREFIXLENGTH);
    }

    private void suiteStarted(IRegion iRegion, String string) throws CoreException {
        Matcher matcher = this.matcherFor(SUITEBEGINNINGLINE, string);
        this.testEvents.add(new SuiteBeginEvent(matcher.group(1), Integer.parseInt(matcher.group(2))));
    }

    private boolean suiteEnding(String string) {
        return string.startsWith(ENDING, LINEPREFIXLENGTH);
    }

    private void suiteEnded(IRegion iRegion, String string) throws CoreException {
        Matcher matcher = this.matcherFor(SUITEENDINGLINE, string);
        this.testEvents.add(new SuiteEndEvent(matcher.group(1)));
    }

    private boolean testErrored(String string) {
        return string.startsWith(ERROR, LINEPREFIXLENGTH);
    }

    private void testError(IRegion iRegion, String string) throws CoreException {
    }
}

