/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.ImageUtil;
import org.tizen.tizenunittest.gtest.common.UnitTestMessages;

public class AdvancedTab
extends AbstractLaunchConfigurationTab {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected Button checkGenXml;
    protected Button btnGeneratedXmlBrowse;
    protected Button checkRunDisable;
    protected Button checkShuffleTests;
    protected Button checkDontPrintTime;
    protected Text txtGeneratedXml;
    private Image fImage;

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        this.createVerticalSpacer(composite2, 1);
        this.createGtestOptionGroup(composite2);
        this.createVerticalSpacer(composite2, 1);
    }

    public void createGtestOptionGroup(Composite composite) {
        Group group = new Group(composite, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 5;
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)gridLayout);
        group.setText(UnitTestMessages.LAUNCH_GTEST_OPTION_GROUP);
        this.checkGenXml = this.createCheckButton((Composite)group, UnitTestMessages.LAUNCH_GTEST_OPTION_LABEL_GEN_XML);
        this.checkGenXml.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = AdvancedTab.this.checkGenXml.getSelection();
                AdvancedTab.this.txtGeneratedXml.setEnabled(bl);
                AdvancedTab.this.btnGeneratedXmlBrowse.setEnabled(bl);
                AdvancedTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.txtGeneratedXml = new Text((Composite)group, 2052);
        this.txtGeneratedXml.setLayoutData((Object)new GridData(768));
        this.txtGeneratedXml.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                AdvancedTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.btnGeneratedXmlBrowse = this.createPushButton((Composite)group, UnitTestMessages.LAUNCH_GTEST_OPTION_BROWSE, null);
        this.btnGeneratedXmlBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AdvancedTab.this.handleXmlReportPathBrowser();
                AdvancedTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.checkRunDisable = this.createCheckButton((Composite)group, UnitTestMessages.LAUNCH_GTEST_OPTION_LABEL_RUN_DISABLE);
        this.checkShuffleTests = this.createCheckButton((Composite)group, UnitTestMessages.LAUNCH_GTEST_OPTION_LABEL_SHUFFLE_TESTS);
        this.checkDontPrintTime = this.createCheckButton((Composite)group, UnitTestMessages.LAUNCH_GTEST_OPTION_LABEL_DONT_PRINT_TIME);
        this.postProcessCheckButton(this.checkRunDisable);
        this.postProcessCheckButton(this.checkShuffleTests);
        this.postProcessCheckButton(this.checkDontPrintTime);
    }

    private void postProcessCheckButton(Button button) {
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AdvancedTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void handleXmlReportPathBrowser() {
        String string = this.txtGeneratedXml.getText();
        FileDialog fileDialog = new FileDialog(this.getShell(), 0);
        fileDialog.setFileName(string);
        String string2 = fileDialog.open();
        if (string2 != null) {
            this.txtGeneratedXml.setText(string2);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute("org.tizen.tizenunittest.gtest.launch.GEN_XML_ATTR", false);
        iLaunchConfigurationWorkingCopy.setAttribute("org.tizen.tizenunittest.gtest.launch.GEN_XML_PATH_ATTR", "");
        iLaunchConfigurationWorkingCopy.setAttribute("org.tizen.tizenunittest.gtest.launch.TX_OPTIONS_ATTR", "");
        iLaunchConfigurationWorkingCopy.setAttribute("org.tizen.tizenunittest.gtest.launch.ELAPSED_TIME_ATTR", false);
        iLaunchConfigurationWorkingCopy.setAttribute("org.tizen.tizenunittest.gtest.launch.SHUFLE_TEST_ATTR", false);
        iLaunchConfigurationWorkingCopy.setAttribute("org.tizen.tizenunittest.gtest.launch.RUN_DISABLE_ATTR", false);
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        this.updateUnitTestFromConfig(iLaunchConfiguration);
    }

    private void updateUnitTestFromConfig(ILaunchConfiguration iLaunchConfiguration) {
        boolean bl = false;
        String string = "";
        try {
            bl = iLaunchConfiguration.getAttribute("org.tizen.tizenunittest.gtest.launch.GEN_XML_ATTR", false);
            string = iLaunchConfiguration.getAttribute("org.tizen.tizenunittest.gtest.launch.GEN_XML_PATH_ATTR", "");
            this.checkDontPrintTime.setSelection(iLaunchConfiguration.getAttribute("org.tizen.tizenunittest.gtest.launch.ELAPSED_TIME_ATTR", false));
            this.checkRunDisable.setSelection(iLaunchConfiguration.getAttribute("org.tizen.tizenunittest.gtest.launch.RUN_DISABLE_ATTR", false));
            this.checkShuffleTests.setSelection(iLaunchConfiguration.getAttribute("org.tizen.tizenunittest.gtest.launch.SHUFLE_TEST_ATTR", false));
        }
        catch (CoreException coreException) {
            this.logger.error(coreException.getMessage(), (Throwable)coreException);
            return;
        }
        if (this.checkGenXml != null) {
            this.checkGenXml.setSelection(bl);
        }
        if (this.txtGeneratedXml != null) {
            this.txtGeneratedXml.setText(string);
            this.txtGeneratedXml.setEnabled(bl);
        }
        if (this.btnGeneratedXmlBrowse != null) {
            this.btnGeneratedXmlBrowse.setEnabled(bl);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute("org.tizen.tizenunittest.gtest.launch.GEN_XML_ATTR", this.checkGenXml.getSelection());
        iLaunchConfigurationWorkingCopy.setAttribute("org.tizen.tizenunittest.gtest.launch.GEN_XML_PATH_ATTR", this.txtGeneratedXml.getText());
        iLaunchConfigurationWorkingCopy.setAttribute("org.tizen.tizenunittest.gtest.launch.ELAPSED_TIME_ATTR", this.checkDontPrintTime.getSelection());
        iLaunchConfigurationWorkingCopy.setAttribute("org.tizen.tizenunittest.gtest.launch.RUN_DISABLE_ATTR", this.checkRunDisable.getSelection());
        iLaunchConfigurationWorkingCopy.setAttribute("org.tizen.tizenunittest.gtest.launch.SHUFLE_TEST_ATTR", this.checkShuffleTests.getSelection());
    }

    public boolean canSave() {
        boolean bl = super.canSave();
        if (!bl) {
            return false;
        }
        return this.isValid();
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        boolean bl = super.isValid(iLaunchConfiguration);
        if (!bl) {
            return false;
        }
        return this.isValid();
    }

    private boolean isValid() {
        if (this.checkGenXml.getSelection() && "".equals(this.txtGeneratedXml.getText())) {
            this.setErrorMessage(UnitTestMessages.LAUNCH_ADVANCED_TAB_ERROR_XML_PATH);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public String getName() {
        return UnitTestMessages.LAUNCH_ADVANCED_TAB_LABEL;
    }

    public Image getImage() {
        if (this.fImage == null) {
            this.fImage = ImageUtil.getImage((String)"org.tizen.tizenunittest.gtest", (String)"/icons/obj16/launch_configuration.png");
        }
        return this.fImage;
    }

    public void dispose() {
        super.dispose();
        if (this.fImage != null) {
            this.fImage.dispose();
        }
        if (this.txtGeneratedXml != null) {
            this.txtGeneratedXml.dispose();
        }
        if (this.btnGeneratedXmlBrowse != null) {
            this.btnGeneratedXmlBrowse.dispose();
        }
        if (this.checkGenXml != null) {
            this.checkGenXml.dispose();
        }
        if (this.checkRunDisable != null) {
            this.checkRunDisable.dispose();
        }
        if (this.checkShuffleTests != null) {
            this.checkShuffleTests.dispose();
        }
        if (this.checkDontPrintTime != null) {
            this.checkDontPrintTime.dispose();
        }
    }
}

