/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.resultview.listener;

import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.tizenunittest.gtest.UnitTestPlugin;
import org.tizen.tizenunittest.gtest.common.UnitTestMessages;
import org.tizen.tizenunittest.gtest.model.TestCase;
import org.tizen.tizenunittest.gtest.model.TestSession;
import org.tizen.tizenunittest.gtest.model.TestStatus;

public class CuteTestDClickListener
implements IDoubleClickListener {
    private TestSession session = null;

    public CuteTestDClickListener(TestSession testSession) {
        this.session = testSession;
    }

    public void doubleClick(DoubleClickEvent doubleClickEvent) {
        TreeSelection treeSelection;
        if (doubleClickEvent.getSelection() instanceof TreeSelection && (treeSelection = (TreeSelection)doubleClickEvent.getSelection()).getFirstElement() instanceof TestCase) {
            TestCase testCase = (TestCase)treeSelection.getFirstElement();
            if (testCase.getStatus() == TestStatus.failure || testCase.getStatus() == TestStatus.abnormal) {
                this.openEditor(testCase.getFile(), testCase.getLineNumber(), false);
            } else {
                this.openEditorForNonFailingTestCase(testCase.getName());
            }
        }
    }

    public void setSession(TestSession testSession) {
        this.session = testSession;
    }

    private void openEditorForNonFailingTestCase(String string) {
        try {
            ICProject[] iCProjectArray = CoreModel.getDefault().getCModel().getCProjects();
            int n = 0;
            while (n < iCProjectArray.length) {
                if (iCProjectArray[n].getElementName().equals(this.session.getLaunch().getLaunchConfiguration().getName())) {
                    IIndex iIndex = CCorePlugin.getIndexManager().getIndex(iCProjectArray[n]);
                    Pattern pattern = Pattern.compile(string);
                    IIndexBinding[] iIndexBindingArray = iIndex.findBindings(pattern, false, IndexFilter.ALL, (IProgressMonitor)new NullProgressMonitor());
                    int n2 = 0;
                    while (iIndexBindingArray != null && n2 < iIndexBindingArray.length) {
                        IIndexName[] iIndexNameArray;
                        IIndexBinding iIndexBinding = iIndexBindingArray[n2];
                        if (iIndexBinding != null && (iIndexNameArray = iIndex.findDefinitions((IBinding)iIndex.adaptBinding((IBinding)iIndexBinding))) != null && iIndexNameArray.length != 0) {
                            IASTFileLocation iASTFileLocation = iIndexNameArray[0].getFileLocation();
                            Path path = new Path(iASTFileLocation.getFileName());
                            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
                            if (iFile != null) {
                                this.openEditor(iFile, iASTFileLocation.getNodeOffset(), true);
                                return;
                            }
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        catch (CModelException cModelException) {
            UnitTestPlugin.log(cModelException);
        }
        catch (CoreException coreException) {
            UnitTestPlugin.log(coreException);
        }
    }

    private void openEditor(IFile iFile, int n, boolean bl) {
        block8: {
            IWorkbenchPage iWorkbenchPage;
            IWorkbenchWindow iWorkbenchWindow = UnitTestPlugin.getActiveWorkbenchWindow();
            if (!iFile.exists()) {
                Shell shell = SWTUtil.getActiveShell();
                DialogUtil.openErrorDialog((Shell)shell, (String)"Error", (String)NLS.bind((String)UnitTestMessages.RESULTVIEW_CANNOT_FIND_FILE, (Object)iFile.getName()));
                return;
            }
            if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
                try {
                    IEditorPart iEditorPart = iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), this.getEditorId(iFile), false);
                    if (n <= 0 || !(iEditorPart instanceof ITextEditor)) break block8;
                    ITextEditor iTextEditor = (ITextEditor)iEditorPart;
                    IEditorInput iEditorInput = iEditorPart.getEditorInput();
                    IDocumentProvider iDocumentProvider = iTextEditor.getDocumentProvider();
                    try {
                        iDocumentProvider.connect((Object)iEditorInput);
                    }
                    catch (CoreException coreException) {
                        UnitTestPlugin.log(coreException);
                        return;
                    }
                    IDocument iDocument = iDocumentProvider.getDocument((Object)iEditorInput);
                    try {
                        IRegion iRegion = bl ? iDocument.getLineInformationOfOffset(n) : iDocument.getLineInformation(n - 1);
                        iTextEditor.selectAndReveal(iRegion.getOffset(), iRegion.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        UnitTestPlugin.log(badLocationException);
                    }
                    iDocumentProvider.disconnect((Object)iEditorInput);
                }
                catch (PartInitException partInitException) {
                    UnitTestPlugin.log(partInitException);
                }
            }
        }
    }

    private String getEditorId(IFile iFile) {
        IWorkbench iWorkbench = UnitTestPlugin.getDefault().getWorkbench();
        IEditorDescriptor iEditorDescriptor = iWorkbench.getEditorRegistry().getDefaultEditor(iFile.getName(), this.getFileContentType(iFile));
        if (iEditorDescriptor == null) {
            iEditorDescriptor = iWorkbench.getEditorRegistry().findEditor("org.eclipse.ui.systemExternalEditor");
        }
        return iEditorDescriptor.getId();
    }

    private IContentType getFileContentType(IFile iFile) {
        try {
            IContentDescription iContentDescription = iFile.getContentDescription();
            if (iContentDescription != null) {
                return iContentDescription.getContentType();
            }
        }
        catch (CoreException coreException) {}
        return null;
    }
}

