/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.launch;

import java.io.IOException;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.TextConsole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.TizenProjectType;
import org.tizen.common.sdb.command.SdbCommand;
import org.tizen.common.ui.view.console.ConsoleManager;
import org.tizen.common.ui.view.console.ITizenConsoleManager;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.launch.IProjectLaunchCommand;
import org.tizen.nativecommon.launch.TizenLaunchDelegate;
import org.tizen.nativecommon.launch.TizenLaunchMessages;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.tizenunittest.gtest.ConsoleLinkHandler;
import org.tizen.tizenunittest.gtest.ConsolePatternListener;
import org.tizen.tizenunittest.gtest.ShowViews;
import org.tizen.tizenunittest.gtest.gtest.GTestConsoleEventParser;
import org.tizen.tizenunittest.gtest.launch.GtestOption;
import org.tizen.tizenunittest.gtest.model.ModelBuilder;
import org.tizen.tizenunittest.gtest.testexplorer.event.TXEventHandler;

public class UnitTestLaunchDelegate
extends TizenLaunchDelegate {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String TIZEN_LAUNCH_ENV = "TIZEN_LAUNCH_MODE";
    private ConsoleManager conManager = null;
    private Process processForLaunch;

    public void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        super.launch(iLaunchConfiguration, string, iLaunch, iProgressMonitor);
        ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfiguration.getWorkingCopy();
        iLaunchConfigurationWorkingCopy.setAttribute("org.tizen.tizenunittest.gtest.launch.TX_OPTIONS_ATTR", "");
        iLaunchConfigurationWorkingCopy.doSave();
    }

    public void launchApplication(ILaunchConfiguration iLaunchConfiguration, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        Object object;
        IProject iProject = ProjectUtil.getProject((ILaunchConfiguration)iLaunchConfiguration);
        GtestOption gtestOption = new GtestOption(iLaunchConfiguration, iProject, this.currentDevice);
        GTestConsoleEventParser.getInstance(null, iLaunchConfiguration).setDevice(this.currentDevice);
        this.addXmlOption(iLaunchConfiguration, gtestOption);
        final String string = CDebugUtils.verifyProgramPath((ILaunchConfiguration)iLaunchConfiguration).toFile().getName();
        try {
            object = ProjectUtil.getXmlStore((IProject)iProject);
            object.setProject(iProject);
            object.loadXml();
            TizenProjectType tizenProjectType = ProjectUtil.getTizenProjectType((IProject)iProject);
            String string2 = tizenProjectType.getAppIdForLaunch(object.getXMLDataId());
            SmartDevelopmentBridge smartDevelopmentBridge = SmartDevelopmentBridge.getBridge();
            String string3 = smartDevelopmentBridge.getSdbOsLocation();
            String string4 = gtestOption.getArguments();
            if (!this.currentDevice.isSupportShell()) {
                this.newCoreException("This platform is not support shell, Use appcmd", null);
            }
            String[] stringArray = new String[]{string3, "-s", this.currentDevice.getSerialNumber(), "shell", "launch_app", string2, "__AUL_SDK__", "UNIT_TEST", "__LAUNCH_APP_MODE__", "SYNC", "__DLP_UNIT_TEST_ARG__", string4, ";", "echo", "_uNitTeSt_fIniShed_"};
            this.processForLaunch = Runtime.getRuntime().exec(stringArray);
        }
        catch (IOException iOException) {
            this.newCoreException(TizenLaunchMessages.CANNOT_LAUNCH, iOException);
        }
        object = new Thread(){

            @Override
            public void run() {
                UnitTestLaunchDelegate.this.conManager = new ConsoleManager(string, true);
                UnitTestLaunchDelegate.this.conManager.printProcessStreams(UnitTestLaunchDelegate.this.processForLaunch);
            }
        };
        ((Thread)object).start();
        try {
            do {
                Thread.sleep(100L);
                if (!iProgressMonitor.isCanceled()) continue;
                throw new InterruptedException();
            } while (!((Thread)object).getState().equals((Object)Thread.State.TERMINATED));
        }
        catch (InterruptedException interruptedException) {
            this.processForLaunch.destroy();
            this.processForLaunch = null;
        }
        if (!iProgressMonitor.isCanceled()) {
            this.runLocalApplication(iLaunchConfiguration, iLaunch, this.conManager.getConsole());
        }
    }

    protected String getArguments(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        String string = null;
        string = iLaunchConfiguration.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", "");
        return string;
    }

    protected Process launchApplicationWithGDBServerForUnitTest(ILaunch iLaunch, ILaunchConfiguration iLaunchConfiguration, IProgressMonitor iProgressMonitor) throws CoreException {
        Process process = null;
        try {
            try {
                iProgressMonitor.beginTask(TizenLaunchMessages.LAUNCH_APPLICATION_WITH_GDBSERVER, 1);
                iProgressMonitor.subTask(TizenLaunchMessages.LAUNCH_APPLICATION_WITH_GDBSERVER);
                IProject iProject = ProjectUtil.getProject((ILaunchConfiguration)iLaunchConfiguration);
                IProjectLaunchCommand iProjectLaunchCommand = ProjectUtil.getProjectManifest((IProject)iProject);
                GtestOption gtestOption = new GtestOption(iLaunchConfiguration, iProject, this.currentDevice);
                this.addXmlOption(iLaunchConfiguration, gtestOption);
                GTestConsoleEventParser.getInstance(null, iLaunchConfiguration).setDevice(this.currentDevice);
                SdbCommand sdbCommand = new SdbCommand(this.currentDevice, (ITizenConsoleManager)this.launchConsole);
                String string = String.valueOf(gtestOption.getArguments()) + " " + this.getArguments(iLaunchConfiguration);
                String string2 = null;
                string2 = String.valueOf(iProjectLaunchCommand.getLaunchCommand(iLaunchConfiguration, true, this.hasCodeCoverageFlag(iLaunchConfiguration), true, string)) + "; echo \"exit\"";
                process = sdbCommand.runLaunchCommand(string2, false);
            }
            catch (Exception exception) {
                this.logger.error(TizenLaunchMessages.CANNOT_LAUNCH_APPLICATION_WITH_GDBSERVER, (Throwable)exception);
                this.newCoreException(TizenLaunchMessages.CANNOT_LAUNCH_APPLICATION_WITH_GDBSERVER, null);
                iProgressMonitor.done();
            }
        }
        finally {
            iProgressMonitor.done();
        }
        return process;
    }

    private void runLocalApplication(ILaunchConfiguration iLaunchConfiguration, ILaunch iLaunch, IConsole iConsole) {
        block4: {
            IPath iPath = null;
            IProject iProject = null;
            try {
                iPath = this.verifyProgramPath(iLaunchConfiguration);
                iProject = ProjectUtil.getProject((ILaunchConfiguration)iLaunchConfiguration);
                if (!(iConsole instanceof TextConsole)) break block4;
                ShowViews showViews = new ShowViews();
                showViews.schedule();
                try {
                    showViews.join();
                }
                catch (InterruptedException interruptedException) {}
                TextConsole textConsole = (TextConsole)iConsole;
                iPath = this.sourcelookupPath(iLaunchConfiguration, iPath);
                ConsoleLinkHandler consoleLinkHandler = new ConsoleLinkHandler(iPath, textConsole);
                ModelBuilder modelBuilder = new ModelBuilder(iPath, iLaunch);
                TXEventHandler tXEventHandler = TXEventHandler.getInstance(iLaunch.getLaunchConfiguration());
                ConsolePatternListener consolePatternListener = new ConsolePatternListener(GTestConsoleEventParser.getInstance(iProject, iLaunchConfiguration));
                consolePatternListener.addHandler(consoleLinkHandler);
                consolePatternListener.addHandler(modelBuilder);
                consolePatternListener.addHandler(tXEventHandler);
                textConsole.addPatternMatchListener((IPatternMatchListener)consolePatternListener);
            }
            catch (CoreException coreException) {
                this.logger.error("Failed to run an application", (Throwable)coreException);
            }
        }
    }

    private IPath sourcelookupPath(ILaunchConfiguration iLaunchConfiguration, IPath iPath) {
        return iPath.removeLastSegments(1);
    }

    private void addXmlOption(ILaunchConfiguration iLaunchConfiguration, GtestOption gtestOption) {
        GTestConsoleEventParser gTestConsoleEventParser = GTestConsoleEventParser.getInstance(null, iLaunchConfiguration);
        gTestConsoleEventParser.setXMLPath(gtestOption.getTargetXmlReportPath(), gtestOption.getHostXmlReportPath());
    }

    protected String getEnvironments(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        String string = this.getCodeCoverageEnv(iLaunchConfiguration);
        string = String.valueOf(string) + this.getGtestEnv(iLaunchConfiguration);
        return string;
    }

    private String getGtestEnv(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        String string = "export LD_LIBRARY_PATH=" + TizenPlatformConstants.TOOLS_TARGET_PATH + "/gtest/usr/lib:$LD_LIBRARY_PATH && ";
        string = String.valueOf(string) + "export " + TIZEN_LAUNCH_ENV + "=" + "debug" + " && ";
        return string;
    }

    protected String getCodeCoverageEnvironmentVariable(IProject iProject) {
        String string = "export GCOV_PREFIX=" + ProjectUtil.getRootTmpDirectory((IProject)iProject) + "/data " + "&& export GCOV_PREFIX_STRIP=0 && ";
        return string;
    }

    private String getCodeCoverageEnv(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        String string = "";
        if (this.hasCodeCoverageFlag(iLaunchConfiguration)) {
            string = this.getCodeCoverageEnvironmentVariable(ProjectUtil.getProject((ILaunchConfiguration)iLaunchConfiguration));
        }
        return string;
    }
}

